/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;

public class SGDrawingElementArrow2D
extends SGDrawingElementArrow
implements SGIDrawingElementJava2D {
    protected SGDrawingElementSymbol2D mStartHead = null;
    protected SGDrawingElementSymbol2D mEndHead = null;

    public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        super.setTermPoints(sGTuple2f, sGTuple2f2);
        if (this.mStartHead != null) {
            this.mStartHead.setLocation(this.mStart);
        }
        if (this.mEndHead != null) {
            this.mEndHead.setLocation(this.mEnd);
        }
        return true;
    }

    public boolean setHeadSize(float f) {
        super.setHeadSize(f);
        if (this.mStartHead != null) {
            this.mStartHead.setSize(f);
        }
        if (this.mEndHead != null) {
            this.mEndHead.setSize(f);
        }
        return true;
    }

    public boolean setHeadEdgeLineWidth(float f) {
        super.setHeadEdgeLineWidth(f);
        if (this.mStartHead != null) {
            this.mStartHead.setLineWidth(f);
        }
        if (this.mEndHead != null) {
            this.mEndHead.setLineWidth(f);
        }
        return true;
    }

    public boolean setHeadEdgeLineColor(Color color) {
        super.setHeadEdgeLineColor(color);
        if (this.mStartHead != null) {
            this.mStartHead.setLineColor(color);
        }
        if (this.mEndHead != null) {
            this.mEndHead.setLineColor(color);
        }
        return true;
    }

    public boolean contains(int n, int n2) {
        SGDrawingElementLine2D sGDrawingElementLine2D = this.getLine();
        boolean bl = sGDrawingElementLine2D.contains(n, n2);
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.mStartHead != null) {
            bl2 = this.mStartHead.contains(n, n2);
        }
        if (this.mEndHead != null) {
            bl3 = this.mEndHead.contains(n, n2);
        }
        boolean bl4 = bl || bl2 || bl3;
        return bl4;
    }

    public Rectangle2D getElementBounds() {
        SGDrawingElementLine2D sGDrawingElementLine2D = this.getLine();
        return sGDrawingElementLine2D.getElementBounds().getBounds2D();
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        if (this.mStartHead != null) {
            this.mStartHead.setMagnification(f);
        }
        if (this.mEndHead != null) {
            this.mEndHead.setMagnification(f);
        }
        return true;
    }

    public boolean zoom(int n, int n2, float f) {
        super.zoom(f);
        if (this.mStartHead != null) {
            this.mStartHead.setMagnification(f);
        }
        if (this.mEndHead != null) {
            this.mEndHead.setMagnification(f);
        }
        return true;
    }

    private SGDrawingElementLine2D getLine() {
        SGDrawingElementLine2D sGDrawingElementLine2D = new SGDrawingElementLine2D(this.mStart, this.mEnd);
        sGDrawingElementLine2D.setLineWidth(this.mLineWidth);
        sGDrawingElementLine2D.setMagnification(this.mMagnification);
        return sGDrawingElementLine2D;
    }

    private AffineTransform getAffineTransform() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.getStart().x, this.getStart().y);
        double d = this.getLineAngle() - 1.5707963267948966;
        affineTransform.rotate(d);
        return affineTransform;
    }

    public Shape getBodyShape() {
        float f;
        float f2 = this.getMagnitude();
        Line2D.Float float_ = null;
        if (this.mStartHead == null && this.mEndHead != null) {
            f = 0.0f;
            f = this.mEndHead instanceof ArrowHead ? f2 - 0.5f * this.mMagnification * this.mHeadSize : f2;
            float_ = new Line2D.Float(0.0f, 0.0f, 0.0f, f);
        } else if (this.mStartHead != null && this.mEndHead == null) {
            f = 0.0f;
            f = this.mStartHead instanceof ArrowHead ? 0.5f * this.mMagnification * this.mHeadSize : 0.0f;
            float_ = new Line2D.Float(0.0f, f, 0.0f, f2);
        } else if (this.mStartHead != null && this.mEndHead != null) {
            f = 0.0f;
            float f3 = 0.0f;
            f3 = this.mEndHead instanceof ArrowHead ? f2 - 0.5f * this.mMagnification * this.mHeadSize : f2;
            f = this.mStartHead instanceof ArrowHead ? 0.5f * this.mMagnification * this.mHeadSize : 0.0f;
            float_ = new Line2D.Float(0.0f, f, 0.0f, f3);
        } else {
            float_ = new Line2D.Float(0.0f, 0.0f, 0.0f, f2);
        }
        AffineTransform affineTransform = this.getAffineTransform();
        Shape shape = affineTransform.createTransformedShape(float_);
        return shape;
    }

    public Shape getStartHeadShape() {
        this.createStartHead(this.mStartHeadType);
        if (this.mStartHead == null) {
            return null;
        }
        this.mStartHead.setLocation(this.mStart);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.getStart().x, this.getStart().y);
        double d = this.getLineAngle() - 1.5707963267948966;
        affineTransform.rotate(d);
        affineTransform.translate(-this.getStart().x, -this.getStart().y);
        Shape shape = affineTransform.createTransformedShape(this.mStartHead.getShape());
        return shape;
    }

    public Shape getEndHeadShape() {
        this.createEndHead(this.mEndHeadType);
        if (this.mEndHead == null) {
            return null;
        }
        this.mEndHead.setLocation(this.mEnd);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.getEnd().x, this.getEnd().y);
        double d = this.getLineAngle() + 1.5707963267948966;
        affineTransform.rotate(d);
        affineTransform.translate(-this.getEnd().x, -this.getEnd().y);
        Shape shape = affineTransform.createTransformedShape(this.mEndHead.getShape());
        return shape;
    }

    public boolean createStartHead(int n) {
        this.mStartHead = this.createHead(n);
        return true;
    }

    public boolean createEndHead(int n) {
        this.mEndHead = this.createHead(n);
        return true;
    }

    private SGDrawingElementSymbol2D createHead(int n) {
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = null;
        if (n == -1) {
            return null;
        }
        if (n == 10) {
            sGDrawingElementSymbol2D = new ArrowHead();
        } else {
            sGDrawingElementSymbol2D = new SGDrawingElementSymbol2D();
            sGDrawingElementSymbol2D.setType(n);
        }
        sGDrawingElementSymbol2D.setSize(this.mHeadSize);
        sGDrawingElementSymbol2D.setMagnification(this.mMagnification);
        sGDrawingElementSymbol2D.setColorList(this.mColorList);
        return sGDrawingElementSymbol2D;
    }

    class ArrowHead
    extends SGDrawingElementSymbol2D {
        protected ArrowHead() {
        }

        public Shape getShape() {
            float f = this.getX();
            float f2 = this.getY();
            Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f, f2), new Point2D.Float(f + this.mMagnification * SGDrawingElementArrow2D.this.mHeadSize * (float)Math.tan(SGDrawingElementArrow2D.this.mHeadOpenAngle), f2 + this.mMagnification * SGDrawingElementArrow2D.this.mHeadSize), new Point2D.Float(f, f2 + this.mMagnification * SGDrawingElementArrow2D.this.mHeadSize * (1.0f - (float)Math.tan(SGDrawingElementArrow2D.this.mHeadOpenAngle) / (float)Math.tan(SGDrawingElementArrow2D.this.mHeadCloseAngle))), new Point2D.Float(f - this.mMagnification * SGDrawingElementArrow2D.this.mHeadSize * (float)Math.tan(SGDrawingElementArrow2D.this.mHeadOpenAngle), f2 + this.mMagnification * SGDrawingElementArrow2D.this.mHeadSize)};
            Line2D[] line2DArray = new Line2D[point2DArray.length];
            for (int i = 0; i < line2DArray.length; ++i) {
                line2DArray[i] = new Line2D.Float(point2DArray[i], point2DArray[(i + 1) % point2DArray.length]);
            }
            GeneralPath generalPath = new GeneralPath();
            for (int i = 0; i < line2DArray.length; ++i) {
                generalPath.append(line2DArray[i], true);
            }
            AffineTransform affineTransform = this.getAffineTransform();
            Shape shape = affineTransform.createTransformedShape(generalPath);
            return generalPath;
        }
    }
}

