/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGStringElement;

public class SGStringElementDialog
extends SGPropertyDialog {
    public static final String TITLE = "String Element Dialog";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JButton mColorButton;
    private JComboBox mFontFamilyNameComboBox;
    private JLabel mFontFamilyNameLabel;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JComboBox mFontStyleComboBox;
    private JLabel mLeftSpaceLabel;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mTextAngleLabel;
    private SGSpinner mTextAngleSpinner;
    private JLabel mTextColorLabel;
    private JPanel mTextPanel;

    public SGStringElementDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mTextPanel = new JPanel();
        this.mFontFamilyNameLabel = new JLabel();
        this.mFontStyleComboBox = new JComboBox();
        this.mFontSizeLabel = new JLabel();
        this.mTextAngleSpinner = new SGSpinner();
        this.mTextColorLabel = new JLabel();
        this.mTextAngleLabel = new JLabel();
        this.mFontSizeSpinner = new SGSpinner();
        this.mColorButton = new JButton();
        this.mFontFamilyNameComboBox = new JComboBox();
        this.mRightSpaceLabel = new JLabel();
        this.mLeftSpaceLabel = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SGStringElementDialog.this.closeDialog(windowEvent);
            }
        });
        this.mTextPanel.setLayout(new GridBagLayout());
        this.mTextPanel.setBorder(new BevelBorder(0));
        this.mFontFamilyNameLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyNameLabel.setText("Font");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTextPanel.add((Component)this.mFontFamilyNameLabel, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SGStringElementDialog.this.mFontStyleComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 20, 5, 5);
        this.mTextPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mTextAngleSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mTextAngleSpinner, gridBagConstraints);
        this.mTextColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mTextColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTextPanel.add((Component)this.mTextColorLabel, gridBagConstraints);
        this.mTextAngleLabel.setFont(new Font("Dialog", 0, 12));
        this.mTextAngleLabel.setText("Angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTextPanel.add((Component)this.mTextAngleLabel, gridBagConstraints);
        this.mFontSizeSpinner.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mColorButton, gridBagConstraints);
        this.mFontFamilyNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTextPanel.add((Component)this.mFontFamilyNameComboBox, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mTextPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mTextPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mTextPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("MS Sans Serif", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private void mFontStyleComboBoxActionPerformed(ActionEvent actionEvent) {
    }

    private void closeDialog(WindowEvent windowEvent) {
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = SGUtility.getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontFamilyNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray2[i]);
        }
        this.pack();
        this.mFontSizeSpinner.initProperties(this.getFontSizeSpinnerNumberModel(), " pt");
        this.mTextAngleSpinner.initProperties(new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0), "\u00b0");
        this.mColorButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mColorButton;
        return true;
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public String getFontFamilyName() {
        return (String)this.mFontFamilyNameComboBox.getSelectedItem();
    }

    public int getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public ArrayList getTextColorList() {
        ArrayList<Color> arrayList = new ArrayList<Color>();
        arrayList.add(this.mColorButton.getBackground());
        return arrayList;
    }

    public Number getAngle() {
        return this.mTextAngleSpinner.getNumber();
    }

    public boolean setFontSize(float f) {
        this.mFontSizeSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFontFamilyName(String string) {
        this.mFontFamilyNameComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontStyle(int n) {
        String string = SGUtilityText.getFontStyleName(n);
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setTextColorList(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        if (arrayList.size() == 0) {
            return false;
        }
        Color color = (Color)arrayList.get(0);
        this.mColorButton.setBackground(color);
        return true;
    }

    public boolean setAngle(double d) {
        this.mTextAngleSpinner.setValue(new Double(d));
        return true;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mColorButton);
        return arrayList;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mTextAngleSpinner);
        return arrayList;
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mOKButton.addActionListener(actionListener);
        this.mCancelButton.addActionListener(actionListener);
        this.mPreviewButton.addActionListener(actionListener);
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.getFormattedTextField().addActionListener(actionListener);
        }
        return true;
    }

    public boolean removeActionListener() {
        ActionListener[] actionListenerArray = this.mOKButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mOKButton.removeActionListener(actionListenerArray[i]);
            this.mCancelButton.removeActionListener(actionListenerArray[i]);
            this.mPreviewButton.removeActionListener(actionListenerArray[i]);
            ArrayList arrayList = this.getSpinnerList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGSpinner sGSpinner = (SGSpinner)arrayList.get(j);
                sGSpinner.getFormattedTextField().removeActionListener(actionListenerArray[i]);
            }
        }
        return true;
    }

    public SGStringElement.ElementStringProperties getProperties() {
        SGStringElement.ElementStringProperties elementStringProperties = new SGStringElement.ElementStringProperties();
        Number number = this.getFontSize();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        elementStringProperties.fontSize = number.floatValue();
        elementStringProperties.fontFamilyName = this.getFontFamilyName();
        elementStringProperties.fontStyle = this.getFontStyle();
        Number number2 = this.getAngle();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        elementStringProperties.angle = number2.floatValue() * ((float)Math.PI / 180);
        elementStringProperties.colorList = this.getTextColorList();
        return elementStringProperties;
    }
}

