/*
 * SGLegendDialog.java
 *
 * Created on 2004/06/09, 14:49
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.*;
import java.awt.event.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.io.*;
import java.text.*;
import java.util.*;
import javax.swing.*;
import javax.swing.plaf.FontUIResource;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;


/**
 *
 * @author  kuromaru
 */
public class SGLegendDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Legend Dialog";


    /** Creates new form SGLegendDialog */
    public SGLegendDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }
    

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mLabelSpace1 = new javax.swing.JLabel();
        mLegendPanel = new javax.swing.JPanel();
        mLegendVisibleCheckBox = new javax.swing.JCheckBox();
        mFrameVisibleCheckBox = new javax.swing.JCheckBox();
        mFrameLabel = new javax.swing.JLabel();
        mFrameLineWidthLabel = new javax.swing.JLabel();
        mFrameLineColorLabel = new javax.swing.JLabel();
        mBackgroundColorLabel = new javax.swing.JLabel();
        mFrameLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFrameLineColorButton = new javax.swing.JButton();
        mFrameSeparator = new javax.swing.JSeparator();
        mBackgroundColorButton = new javax.swing.JButton();
        mFontLabel = new javax.swing.JLabel();
        mFontSizeLabel = new javax.swing.JLabel();
        mStringColorLabel = new javax.swing.JLabel();
        mFontFamilyNameComboBox = new javax.swing.JComboBox();
        mFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFontStyleComboBox = new javax.swing.JComboBox();
        mStringColorButton = new javax.swing.JButton();
        mStringLabel = new javax.swing.JLabel();
        mStringSeparator = new javax.swing.JSeparator();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mBackgroundLabel = new javax.swing.JLabel();
        mBackgroundTransparentCheckBox = new javax.swing.JCheckBox();
        mlButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();

        mLabelSpace1.setText("  ");

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        mLegendPanel.setLayout(new java.awt.GridBagLayout());

        mLegendPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mLegendPanel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mLegendVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLegendVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mLegendVisibleCheckBox, gridBagConstraints);

        mFrameVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        mLegendPanel.add(mFrameVisibleCheckBox, gridBagConstraints);

        mFrameLabel.setFont(new java.awt.Font("MS Sans Serif", 3, 12));
        mFrameLabel.setText("Frame");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFrameLabel, gridBagConstraints);

        mFrameLineWidthLabel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mLegendPanel.add(mFrameLineWidthLabel, gridBagConstraints);

        mFrameLineColorLabel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mLegendPanel.add(mFrameLineColorLabel, gridBagConstraints);

        mBackgroundColorLabel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mBackgroundColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mLegendPanel.add(mBackgroundColorLabel, gridBagConstraints);

        mFrameLineWidthSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mLegendPanel.add(mFrameLineWidthSpinner, gridBagConstraints);

        mFrameLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mLegendPanel.add(mFrameLineColorButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 50, 5, 5);
        mLegendPanel.add(mFrameSeparator, gridBagConstraints);

        mBackgroundColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mLegendPanel.add(mBackgroundColorButton, gridBagConstraints);

        mFontLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontLabel.setText("Font");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mLegendPanel.add(mFontLabel, gridBagConstraints);

        mFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mLegendPanel.add(mFontSizeLabel, gridBagConstraints);

        mStringColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mStringColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mLegendPanel.add(mStringColorLabel, gridBagConstraints);

        mFontFamilyNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontFamilyNameComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mFontFamilyNameComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFontFamilyNameComboBox, gridBagConstraints);

        mFontSizeSpinner.setMinimumSize(new java.awt.Dimension(25, 20));
        mFontSizeSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFontSizeSpinner, gridBagConstraints);

        mFontStyleComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mFontStyleComboBox, gridBagConstraints);

        mStringColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mStringColorButton, gridBagConstraints);

        mStringLabel.setFont(new java.awt.Font("MS Sans Serif", 3, 12));
        mStringLabel.setText("String");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mStringLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 45, 5, 5);
        mLegendPanel.add(mStringSeparator, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mLegendPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        mLegendPanel.add(mRightSpaceLabel, gridBagConstraints);

        mBackgroundLabel.setFont(new java.awt.Font("MS Sans Serif", 3, 12));
        mBackgroundLabel.setText("Background");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mLegendPanel.add(mBackgroundLabel, gridBagConstraints);

        mBackgroundTransparentCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mBackgroundTransparentCheckBox.setText("Transparency");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mLegendPanel.add(mBackgroundTransparentCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mLegendPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mOKButton.setText("OK");
        mlButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mlButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mPreviewButton.setText("Preview");
        mlButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mlButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void mFontFamilyNameComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mFontFamilyNameComboBoxActionPerformed
        // ɏR[hǉ:
    }//GEN-LAST:event_mFontFamilyNameComboBoxActionPerformed

    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        // ɏR[hǉ:
    }//GEN-LAST:event_closeDialog
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JButton mBackgroundColorButton;
    private javax.swing.JLabel mBackgroundColorLabel;
    private javax.swing.JLabel mBackgroundLabel;
    private javax.swing.JCheckBox mBackgroundTransparentCheckBox;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JComboBox mFontFamilyNameComboBox;
    private javax.swing.JLabel mFontLabel;
    private javax.swing.JLabel mFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFontSizeSpinner;
    private javax.swing.JComboBox mFontStyleComboBox;
    private javax.swing.JLabel mFrameLabel;
    private javax.swing.JButton mFrameLineColorButton;
    private javax.swing.JLabel mFrameLineColorLabel;
    private javax.swing.JLabel mFrameLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFrameLineWidthSpinner;
    private javax.swing.JSeparator mFrameSeparator;
    private javax.swing.JCheckBox mFrameVisibleCheckBox;
    private javax.swing.JLabel mLabelSpace1;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JPanel mLegendPanel;
    private javax.swing.JCheckBox mLegendVisibleCheckBox;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JButton mStringColorButton;
    private javax.swing.JLabel mStringColorLabel;
    private javax.swing.JLabel mStringLabel;
    private javax.swing.JSeparator mStringSeparator;
    private javax.swing.JPanel mlButtonPanel;
    // ϐ錾̏I//GEN-END:variables
    



	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGLegendDialog.TITLE );


		// font family name
		String fontArray[] = SGUtility.getAvailableFontFamilyNames();
		for(int ii=0 ; ii<fontArray.length ; ii++)
		{
			this.mFontFamilyNameComboBox.addItem( fontArray[ii] );
		}


		// font style
		String[] styleNameArray = {
			SGIConstants.FONT_PLAIN,
			SGIConstants.FONT_ITALIC,
			SGIConstants.FONT_BOLD,
			SGIConstants.FONT_BOLD_ITALIC
		};
		for( int ii=0; ii<styleNameArray.length; ii++ )
		{
			this.mFontStyleComboBox.addItem( styleNameArray[ii] );
		}


		this.pack();



		//
		// Xsi[f̐ݒ
		//

		// axis line width
		this.mFrameLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );

		// font size
		this.mFontSizeSpinner.initProperties(
			this.getFontSizeSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


		//
		// add an action-listener
		//

		this.mStringColorButton.addActionListener(this);
		this.mFrameLineColorButton.addActionListener(this);
		this.mBackgroundColorButton.addActionListener(this);

		this.mLegendVisibleCheckBox.addActionListener(this);
		this.mFrameVisibleCheckBox.addActionListener(this);
		this.mBackgroundTransparentCheckBox.addActionListener(this);


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mFrameLineColorButton;


		return true;

	}



	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);
		Object source = e.getSource();

		if( source.equals( this.mLegendVisibleCheckBox ) )
		{
			this.setLegendVisible( this.mLegendVisibleCheckBox.isSelected() );
//			this.setAllLegendComponentsEnabled( this.mLegendVisibleCheckBox.isSelected() );
		}
		else if( source.equals( this.mFrameVisibleCheckBox ) )
		{
			this.setFrameComponentsEnabled( this.mFrameVisibleCheckBox.isSelected() );
		}
		else if( source.equals( this.mBackgroundTransparentCheckBox ) )
		{
			this.setBackgroundComponentsEnabled(
				!this.mBackgroundTransparentCheckBox.isSelected() );
		}
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setAllLegendComponentsEnabled( final boolean b )
	{
		// String
		this.mStringLabel.setEnabled(b);
		this.setStringComponentsEnabled(b);

		// Frame
		this.mFrameLabel.setEnabled(b);
		this.mFrameVisibleCheckBox.setEnabled(b);
		final boolean bf = this.mFrameVisibleCheckBox.isSelected();
		this.setFrameComponentsEnabled( b & bf );

		// Background
		this.mBackgroundLabel.setEnabled(b);
		this.mBackgroundTransparentCheckBox.setEnabled(b);
		final boolean bb = !this.mBackgroundTransparentCheckBox.isSelected();
		this.setBackgroundComponentsEnabled( b & bb );

		return true;
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setStringComponentsEnabled( final boolean b )
	{
		this.mFontLabel.setEnabled(b);
		this.mFontFamilyNameComboBox.setEnabled(b);
		this.mFontStyleComboBox.setEnabled(b);
		this.mFontSizeLabel.setEnabled(b);
		this.mFontSizeSpinner.setEnabled(b);
		this.mStringColorLabel.setEnabled(b);
		this.mStringColorButton.setEnabled(b);

		return true;
	}




	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setFrameComponentsEnabled( final boolean b )
	{
		this.mFrameLineWidthLabel.setEnabled(b);
		this.mFrameLineWidthSpinner.setEnabled(b);
		this.mFrameLineColorLabel.setEnabled(b);
		this.mFrameLineColorButton.setEnabled(b);
		return true;
	}


	/**
	 * 
	 */
	private boolean setBackgroundComponentsEnabled( final boolean b )
	{
		this.mBackgroundColorLabel.setEnabled(b);
		this.mBackgroundColorButton.setEnabled(b);
		return true;
	}



	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{

		this.mOKButton.addActionListener(listener);
		this.mCancelButton.addActionListener(listener);
		this.mPreviewButton.addActionListener(listener);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}

		return true;
	}





	/**
	 * 
	 */
	public boolean getLegendVisible()
	{
		return this.mLegendVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public boolean getFrameVisible()
	{
		return this.mFrameVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public Number getFrameLineWidth()
	{
		return this.mFrameLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public Color getFrameLineColor()
	{
		return this.mFrameLineColorButton.getBackground();
	}


	/**
	 * 
	 */
	public Color getBackgroundColor()
	{
		return this.mBackgroundColorButton.getBackground();
	}


	/**
	 * 
	 */
	public Number getFontSize()
	{
		return this.mFontSizeSpinner.getNumber();
	}


	/**
	 * 
	 */
	public String getFontFamilyName()
	{
		return (String)this.mFontFamilyNameComboBox.getSelectedItem();
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		final String item = (String)this.mFontStyleComboBox.getSelectedItem();
		return SGUtilityText.getFontStyle(item);
	}


	/**
	 * 
	 */
	public Color getTextColor()
	{
		return this.mStringColorButton.getBackground();
	}


	/**
	 * 
	 * @param flag
	 * @return
	 */
	public boolean isLegendTransparent()
	{
		return this.mBackgroundTransparentCheckBox.isSelected();
	}



	/**
	 * 
	 */
	public boolean setLegendVisible( final boolean flag )
	{
		this.mLegendVisibleCheckBox.setSelected( flag );
		this.setAllLegendComponentsEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFrameVisible( final boolean flag )
	{
		this.mFrameVisibleCheckBox.setSelected( flag );
		this.setFrameComponentsEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFrameLineWidth( final float width )
	{
		this.mFrameLineWidthSpinner.setValue( new Float(width) );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFrameLineColor( final Color cl )
	{
		this.mFrameLineColorButton.setBackground(cl);
		return true;
	}


	/**
	 * 
	 */
	public boolean setBackgroundColor( final Color cl )
	{
		this.mBackgroundColorButton.setBackground(cl);
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontSize( final float size )
	{
		this.mFontSizeSpinner.setValue( new Double(size) );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontFamilyName( final String name )
	{
		this.mFontFamilyNameComboBox.setSelectedItem( name );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontStyle( final int style )
	{
		final String styleName = SGUtilityText.getFontStyleName( style );
		this.mFontStyleComboBox.setSelectedItem( styleName );
		return true;
	}


	/**
	 * 
	 */
	public boolean setTextColor( final Color cl )
	{
		this.mStringColorButton.setBackground(cl);
		return true;
	}


	/**
	 * 
	 * @param flag
	 * @return
	 */
	public boolean setLegendTransparent( final boolean flag )
	{
		this.mBackgroundTransparentCheckBox.setSelected(flag);
		this.setBackgroundComponentsEnabled( !flag );
		return true;
	}



	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		ArrayList list = new ArrayList();

		list.add( this.mBackgroundColorButton );
		list.add( this.mFrameLineColorButton );
		list.add( this.mStringColorButton );

		return list;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mFontSizeSpinner );
		list.add( this.mFrameLineWidthSpinner );
		return list;
	}


	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
			this.mPreviewButton.removeActionListener( array[ii] );

			final ArrayList sList = this.getSpinnerList();
			for( int jj=0; jj<sList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)sList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public SGLegendElement.LegendCommonProperties getCommonProperties()
	{

		SGLegendElement.LegendCommonProperties p
			= new SGLegendElement.LegendCommonProperties();


		// visible
		p.visible = this.getLegendVisible();


		// frame
		p.frameLineVisible = this.getFrameVisible();

		Number frameLineWidth = this.getFrameLineWidth();
		if( frameLineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.frameLineWidth = frameLineWidth.floatValue();
		}

		p.frameLineColor = this.getFrameLineColor();
		p.backgroundColor = this.getBackgroundColor();
		p.transparent = this.isLegendTransparent();


		// font
		p.fontFamilyName = this.getFontFamilyName();

		Number fontSize = this.getFontSize();
		if( fontSize==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.fontSize	= fontSize.floatValue();
		}

		p.fontStyle = this.getFontStyle();
		p.stringColor = this.getTextColor();


		return p;

	}

    
}
