/*
 * SGStringElementDialog.java
 *
 * Created on 2004/06/09, 15:05
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.util.*;
import javax.swing.*;
import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.data.*;
import jp.riken.brain.ni.samuraigraph.figure.*;

/**
 *
 * @author  kuromaru
 */
public class SGStringElementDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "String Element Dialog";


    /** Creates new form SGStringElementDialog */
    public SGStringElementDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mTextPanel = new javax.swing.JPanel();
        mFontFamilyNameLabel = new javax.swing.JLabel();
        mFontStyleComboBox = new javax.swing.JComboBox();
        mFontSizeLabel = new javax.swing.JLabel();
        mTextAngleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mTextColorLabel = new javax.swing.JLabel();
        mTextAngleLabel = new javax.swing.JLabel();
        mFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mColorButton = new javax.swing.JButton();
        mFontFamilyNameComboBox = new javax.swing.JComboBox();
        mRightSpaceLabel = new javax.swing.JLabel();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        mTextPanel.setLayout(new java.awt.GridBagLayout());

        mTextPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mFontFamilyNameLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontFamilyNameLabel.setText("Font");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTextPanel.add(mFontFamilyNameLabel, gridBagConstraints);

        mFontStyleComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontStyleComboBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mFontStyleComboBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 20, 5, 5);
        mTextPanel.add(mFontStyleComboBox, gridBagConstraints);

        mFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mFontSizeLabel, gridBagConstraints);

        mTextAngleSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mTextAngleSpinner, gridBagConstraints);

        mTextColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTextColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mTextPanel.add(mTextColorLabel, gridBagConstraints);

        mTextAngleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTextAngleLabel.setText("Angle");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mTextPanel.add(mTextAngleLabel, gridBagConstraints);

        mFontSizeSpinner.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mFontSizeSpinner, gridBagConstraints);

        mColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTextPanel.add(mColorButton, gridBagConstraints);

        mFontFamilyNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTextPanel.add(mFontFamilyNameComboBox, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTextPanel.add(mRightSpaceLabel, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTextPanel.add(mLeftSpaceLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mTextPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("MS Sans Serif", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void mFontStyleComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mFontStyleComboBoxActionPerformed
        // ɏR[hǉ:
    }//GEN-LAST:event_mFontStyleComboBoxActionPerformed

    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        // ɏR[hǉ:
    }//GEN-LAST:event_closeDialog
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JButton mColorButton;
    private javax.swing.JComboBox mFontFamilyNameComboBox;
    private javax.swing.JLabel mFontFamilyNameLabel;
    private javax.swing.JLabel mFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFontSizeSpinner;
    private javax.swing.JComboBox mFontStyleComboBox;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mTextAngleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mTextAngleSpinner;
    private javax.swing.JLabel mTextColorLabel;
    private javax.swing.JPanel mTextPanel;
    // ϐ錾̏I//GEN-END:variables



	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGStringElementDialog.TITLE );


		//
		{
			final String fontArray[] = SGUtility.getAvailableFontFamilyNames();
			for(int ii=0 ; ii<fontArray.length ; ii++)
			{
				this.mFontFamilyNameComboBox.addItem( fontArray[ii] );
			}

			final String[] styleNameArray = {
				SGIConstants.FONT_PLAIN,
				SGIConstants.FONT_ITALIC,
				SGIConstants.FONT_BOLD,
				SGIConstants.FONT_BOLD_ITALIC
			};
			for( int ii=0; ii<styleNameArray.length; ii++ )
			{
				this.mFontStyleComboBox.addItem( styleNameArray[ii] );
			}

		}

		this.pack();



		//
		// spinner model
		//

		// font size
		this.mFontSizeSpinner.initProperties(
			this.getFontSizeSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


		// angle
		this.mTextAngleSpinner.initProperties(
			new SpinnerNumberModel( 0.0, -180.0, 180.0, 1.0 ),
			SGSpinner.SPINNER_UNIT_DEGREE );


		// FύX{^ɃANVXiǉ
		this.mColorButton.addActionListener(this);


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mColorButton;


		return true;
	}



   	/**
	 * 
	 */
	public Number getFontSize()
	{
		return this.mFontSizeSpinner.getNumber();
	}


	/**
	 * 
	 */
	public String getFontFamilyName()
	{
		return (String)this.mFontFamilyNameComboBox.getSelectedItem();
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		final String item = (String)this.mFontStyleComboBox.getSelectedItem();
		return SGUtilityText.getFontStyle(item);
	}


	/**
	 * 
	 */
	public ArrayList getTextColorList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mColorButton.getBackground() );
		return list;
	}


	/**
	 * 
	 */
	public Number getAngle()
	{
		return this.mTextAngleSpinner.getNumber();
	}


	/**
	 * 
	 */
	public boolean setFontSize( final float size )
	{
		this.mFontSizeSpinner.setValue( new Double(size) );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontFamilyName( final String name )
	{
		this.mFontFamilyNameComboBox.setSelectedItem( name );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontStyle( final int style )
	{
		final String styleName = SGUtilityText.getFontStyleName( style );
		this.mFontStyleComboBox.setSelectedItem( styleName );
		return true;
	}


	/**
	 * 
	 */
	public boolean setTextColorList( final ArrayList cList )
	{
		if( cList==null )
		{
			return false;
		}
		if( cList.size()==0 )
		{
			return false;
		}
		Color cl = (Color)cList.get(0);
		this.mColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setAngle( final double angle )
	{
		this.mTextAngleSpinner.setValue( new Double(angle) );
		return true;
	}



	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		final ArrayList list = new ArrayList();
		list.add( this.mColorButton );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mFontSizeSpinner );
		list.add( this.mTextAngleSpinner );
		return list;
	}



	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{
		// OK,Cancel,Preview
		this.mOKButton.addActionListener(listener);
		this.mCancelButton.addActionListener(listener);
		this.mPreviewButton.addActionListener(listener);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}

		return true;
	}

	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
			this.mPreviewButton.removeActionListener( array[ii] );

			final ArrayList sList = this.getSpinnerList();
			for( int jj=0; jj<sList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)sList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public SGStringElement.ElementStringProperties getProperties()
	{

		SGStringElement.ElementStringProperties p
			= new SGStringElement.ElementStringProperties();


		Number fontSize = this.getFontSize();
		if( fontSize==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.fontSize = fontSize.floatValue();
		}

		p.fontFamilyName = this.getFontFamilyName();
		p.fontStyle = this.getFontStyle();

		Number angle = this.getAngle();
		if( angle==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.angle = angle.floatValue()*( (float)Math.PI/180.0f );
		}

		p.colorList = this.getTextColorList();

		return p;

	}




}
