/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisPanel;

public class SGAxisDialog
extends SGPropertyDialog {
    public static final String TITLE = "Axis Dialog";
    private JPanel mAxisCommonPanel;
    private JLabel mAxisLineLeftSpaceLabel;
    private JPanel mAxisLinePanel;
    private JLabel mAxisLineRightSpaceLabel;
    private JSeparator mAxisLineSeparator;
    private SGSpinner mAxisLineWidthSpinner;
    private JLabel mAxisWidthLabel1;
    private JLabel mAxisWidthLabel2;
    private JPanel mBottomPanel;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JButton mFontColorButton;
    private JLabel mFontColorLabel;
    private JLabel mFontFamilyLabel;
    private JLabel mFontLabel;
    private JComboBox mFontNameComboBox;
    private JSeparator mFontSeparator;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JLabel mFontStyleLabel;
    private JComboBox mFontTypeComboBox;
    private JButton mFrameColorButton;
    private JLabel mFrameLabel;
    private JLabel mFrameLineColorLabel;
    private JLabel mFrameLineWidthLabel;
    private SGSpinner mFrameLineWidthSpinner;
    private JCheckBox mFrameVisibleCheckBox;
    private JPanel mLeftPanel;
    private JButton mLineColorButton;
    private JLabel mLineColorLabel;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JPanel mRightPanel;
    private JLabel mScaleLengthLabel1;
    private JLabel mScaleLengthLabel2;
    private SGSpinner mScaleLineLengthSpinner;
    private SGSpinner mScaleLineWidthSpinner;
    private JLabel mScaleWidthLabel1;
    private JLabel mScaleWidthLabel2;
    private JTabbedPane mTabbedPane;
    private JPanel mTopPanel;

    public SGAxisDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mTabbedPane = new JTabbedPane();
        this.mBottomPanel = new JPanel();
        this.mTopPanel = new JPanel();
        this.mLeftPanel = new JPanel();
        this.mRightPanel = new JPanel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mAxisCommonPanel = new JPanel();
        this.mAxisLinePanel = new JPanel();
        this.mAxisLineSeparator = new JSeparator();
        this.mAxisWidthLabel1 = new JLabel();
        this.mAxisWidthLabel2 = new JLabel();
        this.mScaleWidthLabel1 = new JLabel();
        this.mScaleWidthLabel2 = new JLabel();
        this.mScaleLengthLabel1 = new JLabel();
        this.mScaleLengthLabel2 = new JLabel();
        this.mLineColorLabel = new JLabel();
        this.mAxisLineWidthSpinner = new SGSpinner();
        this.mScaleLineWidthSpinner = new SGSpinner();
        this.mScaleLineLengthSpinner = new SGSpinner();
        this.mLineColorButton = new JButton();
        this.mAxisLineLeftSpaceLabel = new JLabel();
        this.mAxisLineRightSpaceLabel = new JLabel();
        this.mFontSeparator = new JSeparator();
        this.mFontLabel = new JLabel();
        this.mFontFamilyLabel = new JLabel();
        this.mFontSizeLabel = new JLabel();
        this.mFontColorLabel = new JLabel();
        this.mFontTypeComboBox = new JComboBox();
        this.mFontSizeSpinner = new SGSpinner();
        this.mFontNameComboBox = new JComboBox();
        this.mFontColorButton = new JButton();
        this.mFrameLabel = new JLabel();
        this.mFrameVisibleCheckBox = new JCheckBox();
        this.mFrameLineWidthLabel = new JLabel();
        this.mFrameLineColorLabel = new JLabel();
        this.mFrameLineWidthSpinner = new SGSpinner();
        this.mFrameColorButton = new JButton();
        this.mFontStyleLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mTabbedPane.setFont(new Font("Dialog", 1, 12));
        this.mBottomPanel.setLayout(new GridBagLayout());
        this.mTabbedPane.addTab("Bottom", this.mBottomPanel);
        this.mTopPanel.setLayout(new GridBagLayout());
        this.mTopPanel.setFont(new Font("Dialog", 1, 14));
        this.mTabbedPane.addTab("Top", this.mTopPanel);
        this.mLeftPanel.setLayout(new GridBagLayout());
        this.mTabbedPane.addTab("Left", this.mLeftPanel);
        this.mRightPanel.setLayout(new GridBagLayout());
        this.mTabbedPane.addTab("Right", this.mRightPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mTabbedPane, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mAxisCommonPanel.setLayout(new GridBagLayout());
        this.mAxisLinePanel.setLayout(new GridBagLayout());
        this.mAxisLinePanel.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mAxisLineSeparator, gridBagConstraints);
        this.mAxisWidthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mAxisWidthLabel1.setText("Axis Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.mAxisLinePanel.add((Component)this.mAxisWidthLabel1, gridBagConstraints);
        this.mAxisWidthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mAxisWidthLabel2.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 15, 10, 0);
        gridBagConstraints.anchor = 13;
        this.mAxisLinePanel.add((Component)this.mAxisWidthLabel2, gridBagConstraints);
        this.mScaleWidthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mScaleWidthLabel1.setText("Tick Mark");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.mAxisLinePanel.add((Component)this.mScaleWidthLabel1, gridBagConstraints);
        this.mScaleWidthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleWidthLabel2.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 10, 5);
        this.mAxisLinePanel.add((Component)this.mScaleWidthLabel2, gridBagConstraints);
        this.mScaleLengthLabel1.setFont(new Font("Dialog", 0, 12));
        this.mScaleLengthLabel1.setText("Tick Mark");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 0, 5);
        this.mAxisLinePanel.add((Component)this.mScaleLengthLabel1, gridBagConstraints);
        this.mScaleLengthLabel2.setFont(new Font("Dialog", 0, 12));
        this.mScaleLengthLabel2.setText("Length");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 20, 10, 5);
        this.mAxisLinePanel.add((Component)this.mScaleLengthLabel2, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mAxisLinePanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mAxisLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mAxisLineWidthSpinner, gridBagConstraints);
        this.mScaleLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mScaleLineWidthSpinner, gridBagConstraints);
        this.mScaleLineLengthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mScaleLineLengthSpinner, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        this.mAxisLinePanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mAxisLineLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.mAxisLinePanel.add((Component)this.mAxisLineLeftSpaceLabel, gridBagConstraints);
        this.mAxisLineRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        this.mAxisLinePanel.add((Component)this.mAxisLineRightSpaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 50, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontSeparator, gridBagConstraints);
        this.mFontLabel.setFont(new Font("Dialog", 3, 12));
        this.mFontLabel.setText("Font");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontLabel, gridBagConstraints);
        this.mFontFamilyLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyLabel.setText("Family");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontFamilyLabel, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mFontColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontColorLabel, gridBagConstraints);
        this.mFontTypeComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontTypeComboBox, gridBagConstraints);
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mFontColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontColorButton, gridBagConstraints);
        this.mFrameLabel.setFont(new Font("Dialog", 3, 12));
        this.mFrameLabel.setText("Frame");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLabel, gridBagConstraints);
        this.mFrameVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mFrameVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameVisibleCheckBox, gridBagConstraints);
        this.mFrameLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLineWidthLabel, gridBagConstraints);
        this.mFrameLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLineColorLabel, gridBagConstraints);
        this.mFrameLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameLineWidthSpinner, gridBagConstraints);
        this.mFrameColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFrameColorButton, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mAxisLinePanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        this.mAxisCommonPanel.add((Component)this.mAxisLinePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mAxisCommonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mAxisLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        this.mScaleLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        this.mScaleLineLengthSpinner.initProperties(new SpinnerNumberModel(0.1, 0.0, 0.5, 0.05), " cm");
        this.mFontSizeSpinner.initProperties(this.getFontSizeSpinnerNumberModel(), " pt");
        this.mFrameLineWidthSpinner.initProperties(this.getLineWidthSpinnerNumberModel(), " pt");
        String[] stringArray = SGUtility.getAvailableFontNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontTypeComboBox.addItem(stringArray2[i]);
        }
        this.pack();
        this.mLineColorButton.addActionListener(this);
        this.mFontColorButton.addActionListener(this);
        this.mFrameColorButton.addActionListener(this);
        this.mFrameVisibleCheckBox.addActionListener(this);
        this.mFocusedColorSetButton = this.mLineColorButton;
        return true;
    }

    public boolean setActionListener(ActionListener actionListener) {
        this.mOKButton.addActionListener(actionListener);
        this.mCancelButton.addActionListener(actionListener);
        this.mPreviewButton.addActionListener(actionListener);
        ArrayList arrayList = this.getSpinnerList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGSpinner sGSpinner = (SGSpinner)arrayList.get(i);
            sGSpinner.getFormattedTextField().addActionListener(actionListener);
        }
        return true;
    }

    public boolean removeActionListener() {
        ActionListener[] actionListenerArray = this.mOKButton.getActionListeners();
        for (int i = 0; i < actionListenerArray.length; ++i) {
            this.mOKButton.removeActionListener(actionListenerArray[i]);
            this.mCancelButton.removeActionListener(actionListenerArray[i]);
            this.mPreviewButton.removeActionListener(actionListenerArray[i]);
            ArrayList arrayList = this.getSpinnerList();
            for (int j = 0; j < arrayList.size(); ++j) {
                SGSpinner sGSpinner = (SGSpinner)arrayList.get(j);
                sGSpinner.getFormattedTextField().removeActionListener(actionListenerArray[i]);
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mFrameVisibleCheckBox)) {
            this.setFrameLineComponentsEnabled(this.mFrameVisibleCheckBox.isSelected());
        }
    }

    private boolean setFrameLineComponentsEnabled(boolean bl) {
        this.mFrameLineWidthLabel.setEnabled(bl);
        this.mFrameLineWidthSpinner.setEnabled(bl);
        this.mFrameLineColorLabel.setEnabled(bl);
        this.mFrameColorButton.setEnabled(bl);
        return true;
    }

    public JPanel getTopAxisPanel() {
        return this.mTopPanel;
    }

    public JPanel getBottomAxisPanel() {
        return this.mBottomPanel;
    }

    public JPanel getLeftAxisPanel() {
        return this.mLeftPanel;
    }

    public JPanel getRightAxisPanel() {
        return this.mRightPanel;
    }

    public Number getAxisLineWidth() {
        return this.mAxisLineWidthSpinner.getNumber();
    }

    public Number getScaleLineWidth() {
        return this.mScaleLineWidthSpinner.getNumber();
    }

    public Number getScaleLineLength() {
        return this.mScaleLineLengthSpinner.getNumber();
    }

    public Color getLineColor() {
        return this.mLineColorButton.getBackground();
    }

    public String getFontName() {
        return this.mFontNameComboBox.getSelectedItem().toString();
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public int getFontStyle() {
        String string = (String)this.mFontTypeComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public Color getStringColor() {
        return this.mFontColorButton.getBackground();
    }

    public boolean getFrameLinesVisibleFlag() {
        return this.mFrameVisibleCheckBox.isSelected();
    }

    public Number getFrameLineWidth() {
        return this.mFrameLineWidthSpinner.getNumber();
    }

    public Color getFrameLineColor() {
        return this.mFrameColorButton.getBackground();
    }

    public boolean setLineWidth(float f) {
        this.mAxisLineWidthSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setScaleLineWidth(float f) {
        this.mScaleLineWidthSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setScaleLineLength(float f) {
        this.mScaleLineLengthSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setBackground(color);
        return true;
    }

    public boolean setFontName(String string) {
        this.mFontNameComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontSize(float f) {
        this.mFontSizeSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setStringColor(Color color) {
        this.mFontColorButton.setBackground(color);
        return true;
    }

    public boolean setFontStyle(int n) {
        String string = SGUtilityText.getFontStyleName(n);
        this.mFontTypeComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFrameVisible(boolean bl) {
        this.mFrameVisibleCheckBox.setSelected(bl);
        this.setFrameLineComponentsEnabled(bl);
        return true;
    }

    public boolean setFrameLineWidth(float f) {
        this.mFrameLineWidthSpinner.setValue(new Double(f));
        return true;
    }

    public boolean setFrameLineColor(Color color) {
        this.mFrameColorButton.setBackground(color);
        return true;
    }

    public ArrayList getColorSelectionComponentList() {
        ArrayList<JButton> arrayList = new ArrayList<JButton>();
        arrayList.add(this.mLineColorButton);
        arrayList.add(this.mFontColorButton);
        arrayList.add(this.mFrameColorButton);
        return arrayList;
    }

    public ArrayList getActiveComponentList() {
        ArrayList arrayList = this.getActiveComponentListFromSpinners();
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mAxisLineWidthSpinner);
        arrayList.add(this.mScaleLineWidthSpinner);
        arrayList.add(this.mScaleLineLengthSpinner);
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mFrameLineWidthSpinner);
        return arrayList;
    }

    public boolean setSelectedPanel(SGAxisPanel sGAxisPanel) {
        Component[] componentArray = this.mTabbedPane.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JPanel jPanel = (JPanel)componentArray[i];
            Component component = jPanel.getComponent(0);
            if (!component.equals(sGAxisPanel)) continue;
            this.mTabbedPane.setSelectedComponent(jPanel);
            break;
        }
        return true;
    }

    public SGAxisElement.AxisCommonProperties getCommonProperties() {
        SGAxisElement.AxisCommonProperties axisCommonProperties = new SGAxisElement.AxisCommonProperties();
        Number number = this.getAxisLineWidth();
        if (number == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisCommonProperties.axisLineWidth = number.floatValue();
        Number number2 = this.getScaleLineWidth();
        if (number2 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisCommonProperties.scaleLineWidth = number2.floatValue();
        Number number3 = this.getScaleLineLength();
        if (number3 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisCommonProperties.scaleLineLength = number3.floatValue() / 0.035277776f;
        axisCommonProperties.lineColor = this.getLineColor();
        axisCommonProperties.fontName = this.getFontName();
        Number number4 = this.getFontSize();
        if (number4 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisCommonProperties.fontSize = number4.floatValue();
        axisCommonProperties.fontStyle = this.getFontStyle();
        axisCommonProperties.stringColor = this.getStringColor();
        axisCommonProperties.frameLinesVisibleFlag = this.getFrameLinesVisibleFlag();
        Number number5 = this.getFrameLineWidth();
        if (number5 == null) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return null;
        }
        axisCommonProperties.frameLineWidth = number5.floatValue();
        axisCommonProperties.frameLineColor = this.getFrameLineColor();
        return axisCommonProperties;
    }
}

