/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;
import org.w3c.dom.Element;

public abstract class SGElementGroupErrorBar
extends SGElementGroupArrow {
    public static final String TAG_NAME_ERROR_BAR = "ErrorBar";
    public static final String KEY_ERROR_BAR_STYLE = "Style";
    public static final String KEY_ERROR_BAR_HEAD_TYPE = "HeadType";
    public static final int ERROR_BAR_FULL = 0;
    public static final int ERROR_BAR_UPPER_ONLY = 1;
    public static final int ERROR_BAR_LOWER_ONLY = 2;
    public static final String SHOW_FULLY = "Bothsides";
    public static final String SHOW_UPPER_ONLY = "Upside";
    public static final String SHOW_LOWER_ONLY = "Downside";
    protected int mErrorBarStyle = 0;

    public boolean setColor(Color color) {
        super.setColor(color);
        this.mHeadEdgeLineColor = color;
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
                sGDrawingElementArrow2D.setHeadEdgeLineColor(color);
            }
        }
        return true;
    }

    public boolean setColorList(ArrayList arrayList) {
        Color color;
        super.setColorList(arrayList);
        this.mHeadEdgeLineColor = color = (Color)arrayList.get(0);
        if (this.mDrawingElementArray != null) {
            for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
                SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
                sGDrawingElementArrow2D.setHeadEdgeLineColor(color);
            }
        }
        return true;
    }

    public int getErrorBarStyle() {
        return this.mErrorBarStyle;
    }

    public boolean setErrorBarStyle(int n) {
        this.mErrorBarStyle = n;
        return true;
    }

    public String getTagName() {
        return TAG_NAME_ERROR_BAR;
    }

    public boolean writeProperty(Element element) {
        String string = "cm";
        String string2 = "pt";
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        element.setAttribute(KEY_ERROR_BAR_STYLE, SGElementGroupErrorBar.getErrorBarStyleName(this.mErrorBarStyle));
        element.setAttribute("LineWidth", Float.toString(this.mLineWidth) + string2);
        element.setAttribute("HeadSize", Float.toString(this.mHeadSize * 0.035277776f) + string);
        element.setAttribute(KEY_ERROR_BAR_HEAD_TYPE, SGDrawingElementSymbol.getSymbolTypeName(this.getHeadType()));
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        return true;
    }

    public SGProperties readProperties(Element element) {
        String string = null;
        Number number = null;
        Object var7_4 = null;
        Boolean bl = null;
        ArrayList arrayList = null;
        ErrorBarProperties errorBarProperties = new ErrorBarProperties();
        string = element.getAttribute("Visible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        errorBarProperties.setVisible(bl);
        string = element.getAttribute("Color");
        if (string.length() == 0) {
            return null;
        }
        arrayList = SGUtilityText.getColorList(string);
        if (arrayList == null) {
            return null;
        }
        errorBarProperties.setColorList(arrayList);
        string = element.getAttribute("LineWidth");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "pt");
        if (number == null) {
            return null;
        }
        float f = number.floatValue();
        errorBarProperties.setLineWidth(f);
        string = element.getAttribute("HeadSize");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "cm");
        if (number == null) {
            return null;
        }
        errorBarProperties.setHeadSize(number.floatValue() / 0.035277776f);
        string = element.getAttribute(KEY_ERROR_BAR_STYLE);
        if (string.length() == 0) {
            return null;
        }
        number = SGElementGroupErrorBar.getErrorBarStyleFromName(string);
        if (number == null) {
            return null;
        }
        int n = number.intValue();
        errorBarProperties.setErrorBarStyle(n);
        string = element.getAttribute(KEY_ERROR_BAR_HEAD_TYPE);
        if (string.length() == 0) {
            return null;
        }
        Integer n2 = SGElementGroupErrorBar.getHeadTypeFromName(string);
        if (n2 == null) {
            return null;
        }
        int n3 = n2;
        switch (n) {
            case 0: {
                errorBarProperties.setStartHeadType(n3);
                errorBarProperties.setEndHeadType(n3);
                break;
            }
            case 1: {
                errorBarProperties.setStartHeadType(-1);
                errorBarProperties.setEndHeadType(n3);
                break;
            }
            case 2: {
                errorBarProperties.setStartHeadType(n3);
                errorBarProperties.setEndHeadType(-1);
                break;
            }
        }
        errorBarProperties.setLineType(1);
        errorBarProperties.setHeadLineColor((Color)arrayList.get(0));
        errorBarProperties.setHeadLineWidth(f);
        return errorBarProperties;
    }

    public static Integer getErrorBarStyleFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.equals(SHOW_FULLY)) {
            n = 0;
        } else if (string.equals(SHOW_UPPER_ONLY)) {
            n = 1;
        } else if (string.equals(SHOW_LOWER_ONLY)) {
            n = 2;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getErrorBarStyleName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = SHOW_FULLY;
                break;
            }
            case 1: {
                string = SHOW_UPPER_ONLY;
                break;
            }
            case 2: {
                string = SHOW_LOWER_ONLY;
                break;
            }
        }
        return string;
    }

    public int getHeadType() {
        int n;
        switch (this.mErrorBarStyle) {
            case 0: {
                n = this.mStartHeadType;
                break;
            }
            case 1: {
                n = this.mEndHeadType;
                break;
            }
            case 2: {
                n = this.mStartHeadType;
                break;
            }
            default: {
                throw new Error();
            }
        }
        return n;
    }

    public boolean setHeadType(int n) {
        switch (this.mErrorBarStyle) {
            case 0: {
                this.mStartHeadType = n;
                this.mEndHeadType = n;
                break;
            }
            case 1: {
                this.mStartHeadType = -1;
                this.mEndHeadType = n;
                break;
            }
            case 2: {
                this.mStartHeadType = n;
                this.mEndHeadType = -1;
                break;
            }
            default: {
                throw new Error();
            }
        }
        return true;
    }

    public static Integer getHeadTypeFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.equals("Circle")) {
            n = 0;
        } else if (string.equals("Transverse Line")) {
            n = 6;
        } else if (string.equals("No symbol")) {
            n = -1;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getHeadTypeName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Circle";
                break;
            }
            case 6: {
                string = "Transverse Line";
                break;
            }
            case -1: {
                string = "No symbol";
                break;
            }
        }
        return string;
    }

    public boolean setPropertiesOfDrawingElements() {
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementArrow2D sGDrawingElementArrow2D = (SGDrawingElementArrow2D)this.mDrawingElementArray[i];
            sGDrawingElementArrow2D.setMagnification(this.mMagnification);
            sGDrawingElementArrow2D.setColorList(this.mColorList);
            sGDrawingElementArrow2D.setLineWidth(this.mLineWidth);
            sGDrawingElementArrow2D.setLineType(this.mLineType);
            sGDrawingElementArrow2D.setStartHeadType(this.mStartHeadType);
            sGDrawingElementArrow2D.setEndHeadType(this.mEndHeadType);
            sGDrawingElementArrow2D.setHeadSize(this.mHeadSize);
            sGDrawingElementArrow2D.setHeadOpenAngle(this.mHeadOpenAngle);
            sGDrawingElementArrow2D.setHeadCloseAngle(this.mHeadCloseAngle);
        }
        return true;
    }

    protected String[] getPopupMenuCommandArray() {
        String[] stringArray = new String[]{"Circle", "Transverse Line", "No symbol", SHOW_FULLY, SHOW_UPPER_ONLY, SHOW_LOWER_ONLY};
        return stringArray;
    }

    public SGProperties getProperties() {
        ErrorBarProperties errorBarProperties = new ErrorBarProperties();
        this.getProperties(errorBarProperties);
        return errorBarProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        errorBarProperties.setErrorBarStyle(this.getErrorBarStyle());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        Integer n = errorBarProperties.getErrorBarStyle();
        if (n == null) {
            return false;
        }
        this.mErrorBarStyle = n;
        return true;
    }

    public static class ErrorBarProperties
    extends SGElementGroupArrow.ArrowProperties {
        public static final String[] keys = new String[]{"Style"};

        public ErrorBarProperties() {
            this.init();
        }

        private boolean init() {
            this.setLineType(1);
            this.setHeadOpenAngle(0.0f);
            this.setHeadCloseAngle(0.0f);
            return true;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ErrorBarProperties)) {
                return false;
            }
            boolean bl = super.equals(object);
            if (!bl) {
                return false;
            }
            ErrorBarProperties errorBarProperties = (ErrorBarProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(errorBarProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Integer getErrorBarStyle() {
            String string = this.getProperty(SGElementGroupErrorBar.KEY_ERROR_BAR_STYLE);
            return SGUtilityText.getInteger(string);
        }

        public boolean setErrorBarStyle(int n) {
            this.setProperty(SGElementGroupErrorBar.KEY_ERROR_BAR_STYLE, new Integer(n).toString());
            return true;
        }

        public String toString() {
            String string = new String("[");
            string = string + this.getProperty(SGElementGroupErrorBar.KEY_ERROR_BAR_STYLE);
            string = string + new String("]");
            return string;
        }
    }
}

