
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Font;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;


/**
 * 
 */
public class SGUtilityText
{


	/***
	 * 
	 * @param args
	 */
	public static void main(String[] args)
	{

System.out.println("<< start >>");

/*
		char[] cArray = {
			'a', 'b', 'c', '\\', '"', '\t', 'd', 'e', 'f', ' ',
			'"', 'g', 'h', 'i', ' ', 'j', 'k', 'l', '',
			' ', 'm', 'n', ' ', '"', 'o', 'p', 'q', ' ',
			'"', 'r', 's', 't', ' ', '"', 'u', '\f', 'v', 'w', '@', 'x'
		};
*/

/*
		char[] cArray = {
			'a', 'b', 'c', '"', 'd', 'e', 'f', ' ', 'g', 'h', 'i', '"'
		};
*/



/*
//		String str = "0.0   0.0    -1.0   1.0   \"a\"";
//		String str = "0.0  0.0\r1.0  1.0\n2.0  0.5\r\n3.0  2.0\r\n\r\n4.0  4.0";
//		String str = new String(cArray);
//System.out.println(str);
//System.out.println();

		StringReader sr = new StringReader(str);
		final BufferedReader br = new BufferedReader(sr);
System.out.println("*****");
		String line = null;
		while( (line=SGUtilityText.readLine(br))!=null )
		{
			System.out.println(line);
		}
System.out.println("*****");
System.out.println();
*/


/*
		ArrayList strList = new ArrayList();
		SGUtilityText.tokenize(str,strList);

System.out.println();
for( int ii=0; ii<strList.size(); ii++ )
{
	String s = (String)strList.get(ii);
//	System.out.println(ii+" *"+s+"*");
}
System.out.println(strList);
*/


/*
		String str;
		int style;

		str = SGUtilityText.getFontStyleString( Font.PLAIN );
		style = SGUtilityText.getFontStyle( str );
		System.out.println(style+"  "+str);

		str = SGUtilityText.getFontStyleString( Font.BOLD );
		style = SGUtilityText.getFontStyle( str );
		System.out.println(style+"  "+str);

		str = SGUtilityText.getFontStyleString( Font.ITALIC );
		style = SGUtilityText.getFontStyle( str );
		System.out.println(style+"  "+str);

		str = SGUtilityText.getFontStyleString( Font.BOLD | Font.ITALIC );
		style = SGUtilityText.getFontStyle( str );
		System.out.println(style+"  "+str);

		str = SGUtilityText.getFontStyleString(-10);
		style = SGUtilityText.getFontStyle(str);
		System.out.println(style+"  "+str);
*/


String str = "G^{(0)}_n(x_i,y_j) = x_i^{n-1}+y_j^n-1";

		ArrayList charList = new ArrayList();
		ArrayList superList = new ArrayList();
		ArrayList subList = new ArrayList();
		SGUtilityText.getSubscriptAndSuperscriptInfo(str,charList,superList,subList);

		if( charList.size() != superList.size() )
		{
			throw new Error();
		}
		if( superList.size()!=subList.size() )
		{
			throw new Error();
		}

System.out.println();
System.out.println(str);
System.out.println();
for( int ii=0; ii<charList.size(); ii++ )
{
	System.out.println(ii+"  "+charList.get(ii)+"  "+superList.get(ii)+"  "+subList.get(ii) );
}
System.out.println();


	}



	/**
	 * 
	 */
	public static String getSuperscriptString( final String a, final String b )
	{
		String str = a + "^{" + b + "}";
		return str;
	}



	/**
	 * 
	 */
	public static String getSubscriptString( final String a, final String b )
	{
		String str = a + "_{" + b + "}";
		return str;
	}



	/**
	 * 
	 * @param line			A line.
	 * @param charList		List of the characters.
	 * @param superList	List of superscript strings.
	 * @param subList		List of subscript strings.
	 * @return
	 */
	public static boolean getSubscriptAndSuperscriptInfo(
		final String line,
		final ArrayList charList,
		final ArrayList superList,
		final ArrayList subList )
	{

		if( line==null || charList==null || superList==null || subList==null )
		{
			return false;
		}
		if( line.length()==0 )
		{
			return true;
		}

		// mode flag
		boolean ssModeFlag = false;
		boolean stringModeFlag = false;

		// working variables
		char c;
		int cnt = 0;
		Boolean bTemp = null;
		ArrayList list = new ArrayList();

//System.out.println("length="+line.length());

		// read the input line
		while( true )
		{

			// get a character
			c = line.charAt(cnt);
//System.out.println(cnt+"  "+c);

			// outer the mode
			if( !ssModeFlag )
			{

				if( c=='^' || c=='_' )
				{

					// set the mode flag
					ssModeFlag = true;

					// if a caret or an underbar is located at the start of the line,
					// return false
					if( cnt==0 )
					{
						return false;
					}

					// set the value to the temporary variable
					if( c=='^' )
					{
						bTemp = new Boolean(true);
					}
					else if( c=='_' )
					{
						bTemp = new Boolean(false);
					}

				}
				else
				{
					charList.add( new Character(c) );
					superList.add( null );
					subList.add( null );
				}
				
			}
			// inner the mode
			else
			{

				// in the string mode
				if( stringModeFlag )
				{

					if( c == '}' )
					{
						stringModeFlag = false;

						String str = SGUtilityText.createString(list);

						if( bTemp.booleanValue() )
						{
							Object obj = superList.remove(superList.size()-1);
							if( obj != null )
							{
								String str_ = (String)obj;
								str = str_ + str;
							}
							superList.add(str);
						}
						else
						{
							Object obj = subList.remove(subList.size()-1);
							if( obj != null )
							{
								String str_ = (String)obj;
								str = str_ + str;
							}
							subList.add(str);
						}

						// break the mode
						ssModeFlag = false;

						// clear a temporary variable
						bTemp = null;

						list.clear();

					}
					else
					{
						list.add( new Character(c) );
					}
					
				}
				// outer the string mode
				else
				{

					if( c == '{' )
					{
						stringModeFlag = true;
					}
					else
					{
						ArrayList list_ = new ArrayList();
						list_.add( new Character(c) );
						String str = SGUtilityText.createString(list_);


						if( bTemp.booleanValue() )
						{
							Object obj = superList.remove(superList.size()-1);
							if( obj != null )
							{
								String str_ = (String)obj;
								str = str_ + str;
							}
							superList.add(str);
						}
						else
						{
							Object obj = subList.remove(subList.size()-1);
							if( obj != null )
							{
								String str_ = (String)obj;
								str = str_ + str;
							}
							subList.add(str);
						}

						// break the mode
						ssModeFlag = false;

						// clear a temporary variable
						bTemp = null;
					}
					
				}

				
			}


			// increment the counter
			cnt++;


			// break at the end of the line
			if( cnt == line.length() )
			{
				if( ssModeFlag )
				{
					return false;
				}

				break;
			}

		}


		return true;
	}






	/**
	 * ؂蕶(p󔒕' 'A^u'\t'As'\n'AAs'\r'A
	 * p蕶'\f')ŋ؂ꂽ𕪊B
	 * ܂A̘A_uNH[e[V}[N('"')ŋ܂ꂽ͈̈̕
	 * ݂ȂA̒ɑ݂؂蕶͋؂蕶Ƃ͉߂ɁÄꕔƂ݂ȂB
	 * A_uNH[e[V}[N͋؂蕶Ƃĉ߂B
	 * 񒆂Ƀ_uNH[e[V}[N܂߂ꍇɂ́AOɃobNXbV('\\')
	 * t \" ƂB
	 * obNXbV񒆂ɒPƂő݂ꍇɂ͖B
	 */
	public static boolean tokenize(
		final String str,
		final ArrayList strList )
	{

		if( str==null || strList==null )
		{
			return false;
		}

		if( str.length()==0 )
		{
			return true;
		}


		// get all characters
		final char[] charArray = new char[str.length()];
		for( int ii=0; ii<charArray.length; ii++ )
		{
			charArray[ii] = str.charAt(ii);
		}


		// '"'
		boolean dqModeFlag = false;
		
		// '\\'
		boolean bsModeFlag = false;



		//
		ArrayList delimiterSet = new ArrayList();
		for( int ii=0; ii<SGIConstants.DELIMITER_SET.length; ii++ )
		{
			delimiterSet.add( new Character( SGIConstants.DELIMITER_SET[ii] ) );
		}


		//
		int cnt = 0;
		final ArrayList charList = new ArrayList();	// list for temporary use
		while( true )
		{

			// get a character which the counter indicates
			char c = str.charAt(cnt);
//System.out.print(cnt+"  "+new Character(c)+"  ");


			// double quotation mark
			if( c=='"' )
			{
//System.out.print("*** dq ***");
//System.out.println("  "+dqModeFlag);

				if( bsModeFlag )
				{
					charList.add( new Character(c) );
					bsModeFlag = false;
				}
				else
				{

					if( charList.size() != 0 )
					{
						final String str_ = createString(charList);
						strList.add(str_);
						charList.clear();
					}

					// reverse the flag of double quotation mode
					dqModeFlag = !dqModeFlag;

				}

			
			}
			// back slash
			else if( c=='\\' )
			{
//System.out.print("*** \\ ***");
//System.out.println("  "+dqModeFlag);

				bsModeFlag = true;

			}
			// the delimiter set
			else if( delimiterSet.contains( new Character(c) ) )
			{
//System.out.print("*** delimiter ***");
//System.out.println("  "+dqModeFlag);

				if( dqModeFlag )
				{
//System.out.println("aaaaa");
					charList.add( new Character(c) );
				}
				else
				{
					if( charList.size() != 0 )
					{
						final String str_ = createString(charList);
						strList.add(str_);
//System.out.println("*"+str_+"*");
						charList.clear();
					}
				}

				bsModeFlag = false;

			}
			// other characters
			else
			{
//System.out.print("*** others ***");
//System.out.println("  "+dqModeFlag);

				// dqMode
				charList.add( new Character(c) );

				bsModeFlag = false;
			}


			// increment the counter
			cnt++;


			// at the end of the input string
			if( cnt == str.length() )
			{
				if( dqModeFlag )
				{
					System.out.println("̂słI");
					return false;
				}


				final String str_ = createString(charList);
				if( str_==null || str_.length()==0 )
				{
					break;
				}

				strList.add(str_);
				charList.clear();

				break;

			}

		}



		return true;

	}


	/**
	 * 
	 * @param charList
	 * @return
	 */
	public static String createString( final ArrayList charList )
	{
		final char[] cArray = new char[charList.size()];
		for( int ii=0; ii<cArray.length; ii++ )
		{
			cArray[ii] = ((Character)charList.get(ii)).charValue();
		}
		final String str = new String(cArray);
		return str;
	}



	/**
	 * 0Ŗ擾
	 */
	public static String readLine( final BufferedReader br )
	{
		String line = null;
		try
		{
			while( true )
			{
				line = br.readLine();
				if( line == null )
				{
					return null;
				}
//System.out.println(line.length());

				if( line.length()!=0 )
				{
					break;
				}
			}
		}
		catch( Exception ex )
		{
			return null;
		}

		return line;
	}




	/**
	 * "key=value"̌`ŃvpeBPso
	 */
	public static boolean writePropertyLine(
		final Writer writer, final String key, final Object value )
		throws IOException
	{

		String str;
		if( value == null )
		{
			str = "";
		}
		else
		{
			str = value.toString();
		}

		writer.write( key + "=" + str + "\n" );
		
		return true;
	}



	/**
	 * "key=(r,g,b,a)"̌`ŐF̏o
	 */
	public static boolean writeColorPropertyLine(
		final Writer writer, final String key, final Color color )
		throws IOException
	{

		final String strColor = SGUtilityText.getColorString( color );
		SGUtilityText.writePropertyLine( writer, key, strColor );

		return true;
	}



	/**
	 * "{(r1,g1,b1,a1),(r2,g2,b2,a2),...}"̌`ŐFXg̕쐬
	 */
	public static String getColorListString( final ArrayList colorList )
	{
		String str = "{";

		for( int ii=0; ii<colorList.size(); ii++ )
		{
			final Color color = (Color)colorList.get(ii);
			final String strColor = SGUtilityText.getColorString(color);
			str += strColor;
			if( ii!=colorList.size()-1 )
			{
				str += ',';
			}
			else
			{
				str += "}";
			}
		}
		
		return str;
	}



	/**
	 * "key={(r1,g1,b1,a1),(r2,g2,b2,a2),...}"̌`ŐFXg̏o
	 */
	public static boolean writeColorListPropertyLine(
		final Writer writer, final String key, final ArrayList colorList )
		throws IOException
	{
		writer.write( key + "=" );
		String str = getColorListString( colorList );
		writer.write( str + "\n" );
		return true;
	}



	/**
	 * œnꂽɃ_uNH[e[Vtďo
	 */
	public static boolean writeStringPropertyLine(
		final Writer writer, final String key, final String str )
		throws IOException
	{

		ArrayList cList = new ArrayList();
		cList.add( new Character('"') );
		for( int ii=0; ii<str.length(); ii++ )
		{
			Character c = new Character( str.charAt(ii) );
			cList.add(c);
		}
		cList.add( new Character('"') );


		char[] cArray = new char[cList.size()];
		for( int ii=0; ii<cArray.length; ii++ )
		{
			cArray[ii] = ((Character)cList.get(ii)).charValue();
		}

		String strNew = new String( cArray );
		
		
		boolean flag = SGUtilityText.writePropertyLine( writer, key, strNew );

		return flag;

	}



	/**
	 * œnꂽ̍ŏ̕當startAŌ̕當endA
	 * ŏɌŋ܂ꂽ̈̕Ԃ
	 */
	public static String getInnerString( String str, int sChar, int eChar )
	{
		if( str==null )
		{
			return null;
		}

		if( str.length() < 2 )
		{
			return null;
		}

		int start = str.indexOf(sChar) +1;
		int end = str.lastIndexOf(eChar);
		if( end <= start )
		{
			return null;
		}

		String sub = str.substring( start, end );

		return sub;

	}





	/**
	 * œnꂽ"(r,g,b,a)"̃tH[}bg̐F̕񂩂F쐬ĕԂ
	 */
	public static Color getColorFromString( final String str )
	{

		if( str == null )
		{
			return null;
		}

		String sub = SGUtilityText.getInnerString( str, '(', ')' );

		StringTokenizer st = new StringTokenizer( sub, "," );
		ArrayList strList = new ArrayList();
		while( st.hasMoreTokens() )
		{
			strList.add( st.nextToken() );
		}

		if( strList.size()!=4 )
		{
			return null;
		}


		int[] array = new int[strList.size()];

		try
		{
			for( int ii=0; ii<strList.size(); ii++ )
			{
				String sNum = (String)strList.get(ii);
				int num = Integer.valueOf( sNum ).intValue();
				if( num<0 || num>255 )
				{
					return null;
				}
				array[ii] = num;
			}
		}
		catch( Exception ex )
		{
			ex.printStackTrace();
		}


		Color color = new Color( array[0], array[1], array[2], array[3] );

		return color;
	}



	/**
	 * œnꂽF"(r,g,b,a)"̃tH[}bgŐF̕쐬ĕԂ
	 */
	public static String getColorString( final Color color )
	{

		final String strColor = new String( "("
			+ color.getRed() +","
			+ color.getGreen() +","
			+ color.getBlue() +","
			+ color.getAlpha() +")"
		);

		
		return strColor;
	}



	/**
	 * 
	 */
	public static String getPropertyFromLine( final String line, final String key )
	{

		if( line==null || key==null )
		{
			return null;
		}

		final String str = key+"=";
		if( line.startsWith( str ) )
		{
			String sub = line.substring( str.length() );
			return sub;
		}
		else
		{
			return null;
		}

	}



	/**
	 * vpeB̂PsŁA_uNH[e[Vň͂܂ꂽ񂩂璆go
	 */
	public static String getStringPropertyFromLine( final String line, final String key )
	{
		
		String sub = SGUtilityText.getPropertyFromLine( line, key );
		if( sub == null )
		{
			return null;
		}

//		String str = SGUtilityText.getInnerString( sub, '"', '"' );
		
		ArrayList list = new ArrayList();
		SGUtilityText.tokenize(sub,list);
		String str = (String)list.get(0);


		return str;
	}



	/**
	 * 
	 */
	public static Boolean getBooleanPropertyFromLine( final String line, final String key )
	{
		String sub = SGUtilityText.getPropertyFromLine( line, key );
		return getBoolean(sub);
	}




	/**
	 * 
	 * @param value
	 * @return
	 */
	public static Boolean getBoolean( final String value )
	{
		if( value==null )
		{
			return null;
		}

		Boolean b = null;
		if( Boolean.TRUE.toString().equals(value) )
		{
			b = Boolean.TRUE;
		}
		else if( Boolean.FALSE.toString().equals(value) )
		{
			b = Boolean.FALSE;
		}
		else
		{
			return null;
		}

		return b;
	}


	/**
	 * 
	 */
	public static Integer getInteger( final String value )
	{
		Number num = parse(value);
		if( num==null )
		{
			return null;
		}
		return new Integer( num.intValue() );
	}


	/**
	 * 
	 */
	public static Float getFloat( final String value )
	{
		Number num = parse(value);
		if( num==null )
		{
			return null;
		}
		return new Float( num.floatValue() );
	}


	/**
	 * 
	 */
	public static Double getDouble( final String value )
	{
		Number num = parse(value);
		if( num==null )
		{
			return null;
		}
		return new Double( num.doubleValue() );
	}



	/**
	 * 
	 */
	public static Integer getIntegerPropertyFromLine( final String line, final String key )
	{
		
		String sub = SGUtilityText.getPropertyFromLine( line, key );

		if( sub == null )
		{
			return null;
		}

		try
		{
			Integer num = Integer.valueOf( sub );
			return num;
		}
		catch( NumberFormatException ex )
		{
			return null;
		}
		
	}


	/**
	 * 
	 */
	public static Double getDoublePropertyFromLine( final String line, final String key )
	{
		
		String sub = SGUtilityText.getPropertyFromLine( line, key );

		if( sub == null )
		{
			return null;
		}

		try
		{
			Double num = Double.valueOf( sub );
			return num;		
		}
		catch( NumberFormatException ex )
		{
			return null;
		}
		
	}



	/**
	 * 
	 */
	public static Color getColorPropertyFromLine( final String line, final String key )
	{
		
		String sub = SGUtilityText.getPropertyFromLine( line, key );
		if( sub == null )
		{
			return null;
		}


		Color color = SGUtilityText.getColorFromString(sub);
		
		return color;
	}



	/**
	 * 
	 */
	public static ArrayList getColorListFromLine( final String line, final String key )
	{

		String sub = SGUtilityText.getPropertyFromLine( line, key );
		if( sub == null )
		{
			return null;
		}

		return getColorList( sub );
	}



	/**
	 * 
	 * @param line
	 * @return
	 */
	public static ArrayList getColorList( final String line )
	{
		String sub = SGUtilityText.getInnerString( line, '{', '}' );
		if( sub==null )
		{
			return null;
		}

		ArrayList strColorList = SGUtilityText.getStringListFromCommaSeparatedLine( sub );
		ArrayList colorList = new ArrayList();
		for( int ii=0; ii<strColorList.size(); ii++ )
		{
			String strColor = (String)strColorList.get(ii);
			Color color = SGUtilityText.getColorFromString(strColor);
			colorList.add(color);
		}

		return colorList;
	}






	/**
	 * (str1),(str2),...,(strN)@@񃊃Xg
	 */
	public static ArrayList getStringListFromCommaSeparatedLine( String line )
	{
//System.out.println("*** getStringListFromCommaSeparatedLine ***");

		int fromIndex = 0;
		int begin;
		int end;

		ArrayList strList = new ArrayList();
		while( true )
		{
			begin = line.indexOf( "(", fromIndex );
			end = line.indexOf( ")", fromIndex );

//System.out.println("begin="+begin+"  "+"end="+end);

			if( begin >= end )
			{
				break;
			}

			String sub = line.substring( begin, end+1 );
			if( sub==null )
			{
				break;
			}

//System.out.println(sub);

			strList.add(sub);
			fromIndex = end+1;
		}

		return strList;
	}




	/**
	 * 
	 */
	public static String getFontStyleName( final int style )
	{

		String name = null;
		switch( style )
		{

			case Font.PLAIN :
			{
				name = SGIConstants.FONT_PLAIN;
				break;
			}

			case Font.BOLD :
			{
				name = SGIConstants.FONT_BOLD;
				break;
				
			}

			case Font.ITALIC :
			{
				name = SGIConstants.FONT_ITALIC;
				break;
				
			}

			case ( Font.BOLD | Font.ITALIC ) :
			{
				name = SGIConstants.FONT_BOLD_ITALIC;
				break;
				
			}

			default :
			{
				
			}

		}

		return name;
	}


	/**
	 * 
	 */
	public static int getFontStyle( final String name )
	{

		if( name==null )
		{
			return -1;
		}

		int style;
		if( name.equals(SGIConstants.FONT_PLAIN) )
		{
			style = Font.PLAIN;
		}
		else if( name.equals(SGIConstants.FONT_BOLD) )
		{
			style = Font.BOLD;
		}
		else if( name.equals(SGIConstants.FONT_ITALIC) )
		{
			style = Font.ITALIC;
		}
		else if( name.equals(SGIConstants.FONT_BOLD_ITALIC) )
		{
			style = Font.BOLD | Font.ITALIC;
		}
		else
		{
			style = -1;
		}

		return style;
	}



	/**
	 * 
	 */
	public static Integer getFontStyleFromLine( final String line, final String key)
	{

		String sub = SGUtilityText.getPropertyFromLine( line, key );
		if( sub == null )
		{
			return null;
		}
		
		int style = SGUtilityText.getFontStyle(sub);

		return new Integer(style);
	}



	/**
	 * 
	 */
	public static String getScaleTypeName( final int type )
	{

		String name = null;
		switch( type )
		{
			case SGAxis.LINEAR_TYPE :
			{
				name = SGIConstants.SCALE_TYPE_LINEAR;
				break;
			}
			
			case SGAxis.LOG_TYPE :
			{
				name = SGIConstants.SCALE_TYPE_LOG;
				break;
			}

			default :
			{
				
			}
		}

		return name;
	}



	/**
	 * 
	 */
	public static int getScaleType( final String name )
	{
		if( name==null )
		{
			return -1;
		}

		int type;
		if( name.equals( SGIConstants.SCALE_TYPE_LINEAR ) )
		{
			type = SGAxis.LINEAR_TYPE;
		}
		else if( name.equals( SGIConstants.SCALE_TYPE_LOG ) )
		{
			type = SGAxis.LOG_TYPE;
		}
		else
		{
			type = -1;
		}

		return type;
	}





	/**
	 * 
	 */
	public static Integer getScaleTypeFromLine( final String line, final String key )
	{

		String sub = SGUtilityText.getPropertyFromLine( line, key );
		if( sub == null )
		{
			return null;
		}

		int type = SGUtilityText.getScaleType( sub );

		return new Integer(type);
	}

	

	/**
	 * 
	 * @param spec
	 * @return
	 */
	public static Document getDocument( String spec )
	{
		Document doc = null;

		// create an URL instance
		try
		{
			URL url = new URL(spec);
			doc = getDocument(url);
		}
		catch( MalformedURLException ex )
		{
			return null;
		}

		return doc;
	}



	/**
	 * 
	 * @return
	 * @throws Exception
	 */
	public static Document getDocument( URL url )
	{
		Document doc = null;
		InputStream inURL = null;
		InputStream in = null;

		try
		{
			// get input stream
			inURL = url.openStream();
			in = new BufferedInputStream( inURL );

			// parse input and create a Document object
			try
			{
				doc = DocumentBuilderFactory.newInstance()
					.newDocumentBuilder().parse( in, url.toString() );
			}
			catch( Exception ex )
			{
				return null;
			}
		}
		catch( IOException ex )
		{
			ex.printStackTrace();
			return null;
		}
		finally
		{
			// close the input streams
			try
			{
				if( in!=null )
				{
					in.close();
				}
			}
			catch( IOException ex )
			{
			}

			try
			{
				if( inURL!=null )
				{
					inURL.close();
				}
			}
			catch( IOException ex )
			{
			}
		}

		return doc;
	}


	
	/**
	 * 
	 * @param str
	 * @return
	 */
	public static Number parse( final String str )
	{
		if( str==null )
		{
			return null;
		}
		final NumberFormat nf = NumberFormat.getInstance();

		Number num = null;
		try
		{
			num = nf.parse(str);
		}
		catch( ParseException ex )
		{
			return null;
		}
		return num;
	}
	
	
	/**
	 * 
	 * @param str
	 * @param unit
	 * @return
	 */
	public static Float getFloat( final String str, final String unit )
	{
		String str_ = SGUtilityNumber.removeUnit(str,unit);
		if( str_==null )
		{
			return null;
		}
		Float num = SGUtilityText.getFloat(str_);
		if( num==null )
		{
			return null;
		}
		return num;
	}

	
	/**
	 * 
	 * @param str
	 * @param unit
	 * @return
	 */
	public static Double getDouble( final String str, final String unit )
	{
		String str_ = SGUtilityNumber.removeUnit(str,unit);
		if( str_==null )
		{
			return null;
		}
		Double num = SGUtilityText.getDouble(str_);
		if( num==null )
		{
			return null;
		}
		return num;
	}

	
	
	/**
	 * Check whether the string is valid.
	 * @param str	a string
	 * @return		whether the string is valid
	 */
	public static boolean isValidString( final String str )
	{
		if( str==null )
		{
			return false;
		}

		final int len = str.length();
		
		// if the length of the string equals to zero
		if( len==0 )
		{
			return false;
		}

		// if the string consists of spaces
		boolean flag = false;
		for( int ii=0; ii<len; ii++ )
		{
			final char c = str.charAt(ii);
			if( c!=' ' & c!='@' & c!='\t' & c!='\n' & c!='\r' & c!='\f' )
			{
				flag = true;
				break;
			}
		}
		if( !flag )
		{
			return false;
		}

		return true;
	}

	
}

