/*
 * SGWndFigureIDSelectionWizardDialog.java
 *
 * Created on 2004/06/28, 15:23
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Frame;
import javax.swing.JButton;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;


/**
 *
 * @author  kuromaru
 */
public class SGFigureIDSelectionWizardDialog extends SGWizardDialog implements CaretListener
{

	/**
	 * 
	 */
	public static final String TITLE = "Figure ID";


	/**
	 * 
	 */
	public SGFigureIDSelectionWizardDialog()
	{
		super();
		this.initComponents();
		this.initProperty();
	}


	/**
	 * 
	 * @param title
	 */
	public SGFigureIDSelectionWizardDialog(final Frame owner, final boolean modal)
	{
		super(owner,modal);
		this.initComponents();
		this.initProperty();
	}

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mButtonPanel = new javax.swing.JPanel();
        mPreviousButton = new javax.swing.JButton();
        mNextButton = new javax.swing.JButton();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPanel = new javax.swing.JPanel();
        mFigureIDLabel = new javax.swing.JLabel();
        mFigureIDTextField = new javax.swing.JTextField();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mPreviousButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviousButton.setText("<Prev");
        mButtonPanel.add(mPreviousButton);

        mNextButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.TitledBorder(null, "Input the Figure ID", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12)));
        mFigureIDLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFigureIDLabel.setText("Figure ID");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mPanel.add(mFigureIDLabel, gridBagConstraints);

        mFigureIDTextField.setColumns(3);
        mFigureIDTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mFigureIDTextField.setText("1");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 20);
        mPanel.add(mFigureIDTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        getContentPane().add(mPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mFigureIDLabel;
    protected javax.swing.JTextField mFigureIDTextField;
    private javax.swing.JButton mNextButton;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviousButton;
    // ϐ錾̏I//GEN-END:variables
    
    
    
   	/**
	 * 
	 */
	private boolean initProperty()
	{

		//
		this.setTitle( SGFigureIDSelectionWizardDialog.TITLE );

		//
		this.mFigureIDTextField.addCaretListener(this);

this.getPreviousButton().addActionListener(this);
this.getNextButton().addActionListener(this);
this.getOKButton().addActionListener(this);
this.getCancelButton().addActionListener(this);

		return true;
	}



	/**
	 * 
	 */
	public int getFigureID()
	{
		String str = this.getFigureIDString();
		Integer n = Integer.valueOf(str);
		final int id = n.intValue();
		return id;
	}


	/**
	 * 
	 */
	public String getFigureIDString()
	{
		return this.mFigureIDTextField.getText();
	}


	/**
	 * 
	 */
	public boolean setFigureID( final int id )
	{
		this.mFigureIDTextField.setText( new Integer( id ).toString() );
		return true;
	}



	/**
	 * 
	 */
	public void caretUpdate(CaretEvent e)
	{
		Object source = e.getSource();

		if( source.equals( this.mFigureIDTextField ) )
		{
			JTextComponent tf = (JTextComponent)source;
			String str = tf.getText();

			try
			{
				Integer n = Integer.valueOf(str);
				this.mNextButton.setEnabled(true);
			}
			catch( NumberFormatException ex )
			{
				System.out.println("l͂ĉB");
				this.mNextButton.setEnabled(false);
			}
			
		}

	}


	protected JButton getPreviousButton()
	{
		return this.mPreviousButton;
	}


	protected JButton getNextButton()
	{
		return this.mNextButton;
	}


	protected JButton getOKButton()
	{
		return this.mOKButton;
	}
	
	
	protected JButton getCancelButton()
	{
		return this.mCancelButton;
	}


}
