/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGIBarConstants;

public abstract class SGDrawingElementBar
extends SGDrawingElementRectangle
implements SGIBarConstants,
SGIDrawingElementConstants {
    protected double mBaselineValue;

    public double getBaselineValue() {
        return this.mBaselineValue;
    }

    public boolean setBaselineValue(double d) {
        this.mBaselineValue = d;
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementBar)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementBar sGDrawingElementBar = (SGDrawingElementBar)sGDrawingElement;
        this.setBaselineValue(sGDrawingElementBar.getBaselineValue());
        return true;
    }

    public SGProperties getProperties() {
        BarProperties barProperties = new BarProperties();
        this.getProperties(barProperties);
        return barProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        BarProperties barProperties = (BarProperties)sGProperties;
        barProperties.setBarWidth(this.getRectangleWidth());
        barProperties.setEdgeLineWidth(this.getEdgeLineWidth());
        barProperties.setEdgeLineColor(this.getEdgeLineColor());
        barProperties.setBaselineValue(this.getBaselineValue());
        return true;
    }

    public static class BarProperties
    extends SGDrawingElement.DrawingElementProperties {
        public static final String[] keys = new String[]{"Width", "EdgeLineWidth", "EdgeLineColor", "BaselineValue"};

        public boolean equals(Object object) {
            if (!(object instanceof BarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            BarProperties barProperties = (BarProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(barProperties.getProperty(keys[i]))) continue;
                return false;
            }
            return true;
        }

        public Float getBarWidth() {
            String string = this.getProperty("Width");
            return SGUtilityText.getFloat(string);
        }

        public Float getEdgeLineWidth() {
            String string = this.getProperty("EdgeLineWidth");
            return SGUtilityText.getFloat(string);
        }

        public Color getEdgeLineColor() {
            String string = this.getProperty("EdgeLineColor");
            return SGUtilityText.getColorFromString(string);
        }

        public Double getBaselineValue() {
            String string = this.getProperty("BaselineValue");
            return SGUtilityText.getDouble(string);
        }

        public boolean setBarWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("Width", new Float(f).toString());
            return true;
        }

        public boolean setBaselineValue(double d) {
            this.setProperty("BaselineValue", new Double(d).toString());
            return true;
        }

        public boolean setEdgeLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("EdgeLineWidth", new Float(f).toString());
            return true;
        }

        public boolean setEdgeLineColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty("EdgeLineColor", string);
            return true;
        }
    }
}

