/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.freehep.graphicsio.swf.FillStyle;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;

public class FillStyleArray {
    protected List fillStyles = new ArrayList();

    public FillStyleArray() {
    }

    public FillStyleArray(SWFInputStream swf, boolean isMorphStyle, boolean hasAlpha) throws IOException {
        this();
        int fillStyleCount = swf.readUnsignedByte();
        if (fillStyleCount == 255) {
            fillStyleCount = swf.readUnsignedShort();
        }
        for (int i = 0; i < fillStyleCount; ++i) {
            this.fillStyles.add(new FillStyle(swf, isMorphStyle, hasAlpha));
        }
    }

    public void add(FillStyle fillStyle) {
        this.fillStyles.add(fillStyle);
    }

    public FillStyle get(int index) {
        return (FillStyle)this.fillStyles.get(index);
    }

    public void write(SWFOutputStream swf, boolean hasAlpha) throws IOException {
        if (this.fillStyles.size() >= 255) {
            swf.writeUnsignedByte(255);
            swf.writeUnsignedShort(this.fillStyles.size());
        } else {
            swf.writeUnsignedByte(this.fillStyles.size());
        }
        Iterator i = this.fillStyles.iterator();
        while (i.hasNext()) {
            ((FillStyle)i.next()).write(swf, hasAlpha);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("  fillStyles: " + this.fillStyles.size() + "\n");
        int n = 0;
        Iterator i = this.fillStyles.iterator();
        while (i.hasNext()) {
            s.append("    " + (n + 1) + " " + i.next() + "\n");
            ++n;
        }
        return s.toString();
    }
}

