/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import org.w3c.dom.Document;

public class SGUtilityText
implements SGIConstants {
    public static void main(String[] stringArray) {
        System.out.println("<< start >>");
        String string = "G^{(0)}_n(x_i,y_j) = x_i^{n-1}+y_j^n-1";
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        SGUtilityText.getSubscriptAndSuperscriptInfo(string, arrayList, arrayList2, arrayList3);
        if (arrayList.size() != arrayList2.size()) {
            throw new Error();
        }
        if (arrayList2.size() != arrayList3.size()) {
            throw new Error();
        }
        System.out.println();
        System.out.println(string);
        System.out.println();
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println(i + "  " + arrayList.get(i) + "  " + arrayList2.get(i) + "  " + arrayList3.get(i));
        }
        System.out.println();
    }

    public static String getSuperscriptString(String string, String string2) {
        String string3 = string + "^{" + string2 + "}";
        return string3;
    }

    public static String getSubscriptString(String string, String string2) {
        String string3 = string + "_{" + string2 + "}";
        return string3;
    }

    public static boolean getSubscriptAndSuperscriptInfo(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        if (string == null || arrayList == null || arrayList2 == null || arrayList3 == null) {
            return false;
        }
        if (string.length() == 0) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        Boolean bl3 = null;
        ArrayList<Character> arrayList4 = new ArrayList<Character>();
        do {
            String string2;
            String string3;
            String string4;
            Object object;
            char c = string.charAt(n);
            if (!bl) {
                if (c == '^' || c == '_') {
                    bl = true;
                    if (n == 0) {
                        return false;
                    }
                    if (c == '^') {
                        bl3 = new Boolean(true);
                        continue;
                    }
                    if (c != '_') continue;
                    bl3 = new Boolean(false);
                    continue;
                }
                arrayList.add(new Character(c));
                arrayList2.add(null);
                arrayList3.add(null);
                continue;
            }
            if (bl2) {
                if (c == '}') {
                    bl2 = false;
                    object = SGUtilityText.createString(arrayList4);
                    if (bl3.booleanValue()) {
                        string4 = arrayList2.remove(arrayList2.size() - 1);
                        if (string4 != null) {
                            string3 = string4;
                            object = string3 + (String)object;
                        }
                        arrayList2.add(object);
                    } else {
                        string4 = arrayList3.remove(arrayList3.size() - 1);
                        if (string4 != null) {
                            string3 = string4;
                            object = string3 + (String)object;
                        }
                        arrayList3.add(object);
                    }
                    bl = false;
                    bl3 = null;
                    arrayList4.clear();
                    continue;
                }
                arrayList4.add(new Character(c));
                continue;
            }
            if (c == '{') {
                bl2 = true;
                continue;
            }
            object = new ArrayList();
            ((ArrayList)object).add(new Character(c));
            string4 = SGUtilityText.createString((ArrayList)object);
            if (bl3.booleanValue()) {
                string3 = arrayList2.remove(arrayList2.size() - 1);
                if (string3 != null) {
                    string2 = string3;
                    string4 = string2 + string4;
                }
                arrayList2.add(string4);
            } else {
                string3 = arrayList3.remove(arrayList3.size() - 1);
                if (string3 != null) {
                    string2 = string3;
                    string4 = string2 + string4;
                }
                arrayList3.add(string4);
            }
            bl = false;
            bl3 = null;
        } while (++n != string.length());
        return !bl;
    }

    public static boolean tokenize(String string, ArrayList arrayList) {
        block14: {
            String string2;
            int n;
            int n2;
            if (string == null || arrayList == null) {
                return false;
            }
            if (string.length() == 0) {
                return true;
            }
            char[] cArray = new char[string.length()];
            for (n2 = 0; n2 < cArray.length; ++n2) {
                cArray[n2] = string.charAt(n2);
            }
            n2 = 0;
            boolean bl = false;
            ArrayList<Character> arrayList2 = new ArrayList<Character>();
            for (n = 0; n < SGIConstants.DELIMITER_SET.length; ++n) {
                arrayList2.add(new Character(SGIConstants.DELIMITER_SET[n]));
            }
            n = 0;
            ArrayList<Character> arrayList3 = new ArrayList<Character>();
            do {
                char c;
                if ((c = string.charAt(n)) == '\"') {
                    if (bl) {
                        arrayList3.add(new Character(c));
                        bl = false;
                        continue;
                    }
                    if (arrayList3.size() != 0) {
                        string2 = SGUtilityText.createString(arrayList3);
                        arrayList.add(string2);
                        arrayList3.clear();
                    }
                    n2 = n2 == 0 ? 1 : 0;
                    continue;
                }
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                if (arrayList2.contains(new Character(c))) {
                    if (n2 != 0) {
                        arrayList3.add(new Character(c));
                    } else if (arrayList3.size() != 0) {
                        string2 = SGUtilityText.createString(arrayList3);
                        arrayList.add(string2);
                        arrayList3.clear();
                    }
                    bl = false;
                    continue;
                }
                arrayList3.add(new Character(c));
                bl = false;
            } while (++n != string.length());
            if (n2 != 0) {
                System.out.println("\u6587\u4f53\u304c\u4e0d\u6b63\u3067\u3059\uff01");
                return false;
            }
            string2 = SGUtilityText.createString(arrayList3);
            if (string2 == null || string2.length() == 0) break block14;
            arrayList.add(string2);
            arrayList3.clear();
        }
        return true;
    }

    public static String createString(ArrayList arrayList) {
        char[] cArray = new char[arrayList.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = ((Character)arrayList.get(i)).charValue();
        }
        String string = new String(cArray);
        return string;
    }

    public static String readLine(BufferedReader bufferedReader) {
        String string = null;
        try {
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return null;
            } while (string.length() == 0);
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    public static boolean writePropertyLine(Writer writer, String string, Object object) throws IOException {
        String string2 = object == null ? "" : object.toString();
        writer.write(string + "=" + string2 + "\n");
        return true;
    }

    public static boolean writeColorPropertyLine(Writer writer, String string, Color color) throws IOException {
        String string2 = SGUtilityText.getColorString(color);
        SGUtilityText.writePropertyLine(writer, string, string2);
        return true;
    }

    public static String getColorListString(ArrayList arrayList) {
        String string = "{";
        for (int i = 0; i < arrayList.size(); ++i) {
            Color color = (Color)arrayList.get(i);
            String string2 = SGUtilityText.getColorString(color);
            string = string + string2;
            string = i != arrayList.size() - 1 ? string + ',' : string + "}";
        }
        return string;
    }

    public static boolean writeColorListPropertyLine(Writer writer, String string, ArrayList arrayList) throws IOException {
        writer.write(string + "=");
        String string2 = SGUtilityText.getColorListString(arrayList);
        writer.write(string2 + "\n");
        return true;
    }

    public static boolean writeStringPropertyLine(Writer writer, String string, String string2) throws IOException {
        ArrayList<Character> arrayList = new ArrayList<Character>();
        arrayList.add(new Character('\"'));
        for (int i = 0; i < string2.length(); ++i) {
            Character c = new Character(string2.charAt(i));
            arrayList.add(c);
        }
        arrayList.add(new Character('\"'));
        char[] cArray = new char[arrayList.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = ((Character)arrayList.get(i)).charValue();
        }
        String string3 = new String(cArray);
        boolean bl = SGUtilityText.writePropertyLine(writer, string, string3);
        return bl;
    }

    public static String getInnerString(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return null;
        }
        int n3 = string.indexOf(n) + 1;
        int n4 = string.lastIndexOf(n2);
        if (n4 <= n3) {
            return null;
        }
        String string2 = string.substring(n3, n4);
        return string2;
    }

    public static Color getColorFromString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SGUtilityText.getInnerString(string, 40, 41);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() != 4) {
            return null;
        }
        int[] nArray = new int[arrayList.size()];
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                int n = Integer.valueOf(string3);
                if (n < 0 || n > 255) {
                    return null;
                }
                nArray[i] = n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Color color = new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
        return color;
    }

    public static String getColorString(Color color) {
        String string = new String("(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha() + ")");
        return string;
    }

    public static String getPropertyFromLine(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = string2 + "=";
        if (string.startsWith(string3)) {
            String string4 = string.substring(string3.length());
            return string4;
        }
        return null;
    }

    public static String getStringPropertyFromLine(String string, String string2) {
        String string3 = SGUtilityText.getPropertyFromLine(string, string2);
        if (string3 == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        SGUtilityText.tokenize(string3, arrayList);
        String string4 = (String)arrayList.get(0);
        return string4;
    }

    public static Boolean getBooleanPropertyFromLine(String string, String string2) {
        String string3 = SGUtilityText.getPropertyFromLine(string, string2);
        return SGUtilityText.getBoolean(string3);
    }

    public static Boolean getBoolean(String string) {
        if (string == null) {
            return null;
        }
        Boolean bl = null;
        if (Boolean.TRUE.toString().equals(string)) {
            bl = Boolean.TRUE;
        } else if (Boolean.FALSE.toString().equals(string)) {
            bl = Boolean.FALSE;
        } else {
            return null;
        }
        return bl;
    }

    public static Integer getInteger(String string) {
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return new Integer(number.intValue());
    }

    public static Float getFloat(String string) {
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return new Float(number.floatValue());
    }

    public static Double getDouble(String string) {
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return new Double(number.doubleValue());
    }

    public static Integer getIntegerPropertyFromLine(String string, String string2) {
        String string3 = SGUtilityText.getPropertyFromLine(string, string2);
        if (string3 == null) {
            return null;
        }
        try {
            Integer n = Integer.valueOf(string3);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Double getDoublePropertyFromLine(String string, String string2) {
        String string3 = SGUtilityText.getPropertyFromLine(string, string2);
        if (string3 == null) {
            return null;
        }
        try {
            Double d = Double.valueOf(string3);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Color getColorPropertyFromLine(String string, String string2) {
        String string3 = SGUtilityText.getPropertyFromLine(string, string2);
        if (string3 == null) {
            return null;
        }
        Color color = SGUtilityText.getColorFromString(string3);
        return color;
    }

    public static ArrayList getColorListFromLine(String string, String string2) {
        String string3 = SGUtilityText.getPropertyFromLine(string, string2);
        if (string3 == null) {
            return null;
        }
        return SGUtilityText.getColorList(string3);
    }

    public static ArrayList getColorList(String string) {
        String string2 = SGUtilityText.getInnerString(string, 123, 125);
        if (string2 == null) {
            return null;
        }
        ArrayList arrayList = SGUtilityText.getStringListFromCommaSeparatedLine(string2);
        ArrayList<Color> arrayList2 = new ArrayList<Color>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            Color color = SGUtilityText.getColorFromString(string3);
            arrayList2.add(color);
        }
        return arrayList2;
    }

    public static ArrayList getStringListFromCommaSeparatedLine(String string) {
        String string2;
        int n;
        int n2;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n2 = string.indexOf("(", n3)) < (n = string.indexOf(")", n3)) && (string2 = string.substring(n2, n + 1)) != null) {
            arrayList.add(string2);
            n3 = n + 1;
        }
        return arrayList;
    }

    public static String getFontStyleName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Plain";
                break;
            }
            case 1: {
                string = "Bold";
                break;
            }
            case 2: {
                string = "Italic";
                break;
            }
            case 3: {
                string = "Bold Italic";
                break;
            }
        }
        return string;
    }

    public static int getFontStyle(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.equals("Plain") ? 0 : (string.equals("Bold") ? 1 : (string.equals("Italic") ? 2 : (string.equals("Bold Italic") ? 3 : -1)));
        return n;
    }

    public static Integer getFontStyleFromLine(String string, String string2) {
        String string3 = SGUtilityText.getPropertyFromLine(string, string2);
        if (string3 == null) {
            return null;
        }
        int n = SGUtilityText.getFontStyle(string3);
        return new Integer(n);
    }

    public static String getScaleTypeName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Linear";
                break;
            }
            case 1: {
                string = "Log";
                break;
            }
        }
        return string;
    }

    public static int getScaleType(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.equals("Linear") ? 0 : (string.equals("Log") ? 1 : -1);
        return n;
    }

    public static Integer getScaleTypeFromLine(String string, String string2) {
        String string3 = SGUtilityText.getPropertyFromLine(string, string2);
        if (string3 == null) {
            return null;
        }
        int n = SGUtilityText.getScaleType(string3);
        return new Integer(n);
    }

    public static Document getDocument(String string) {
        Document document = null;
        try {
            URL uRL = new URL(string);
            document = SGUtilityText.getDocument(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static Document getDocument(URL uRL) {
        Document document;
        block27: {
            document = null;
            InputStream inputStream = null;
            BufferedInputStream bufferedInputStream = null;
            inputStream = uRL.openStream();
            bufferedInputStream = new BufferedInputStream(inputStream);
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bufferedInputStream, uRL.toString());
            }
            catch (Exception exception) {
                Document document2 = null;
                Object var7_8 = null;
                try {
                    if (bufferedInputStream != null) {
                        ((InputStream)bufferedInputStream).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return document2;
            }
            Object var7_9 = null;
            try {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block27;
            }
            catch (IOException iOException) {}
            break block27;
            {
                catch (IOException iOException) {
                    Document document3 = null;
                    Object var7_10 = null;
                    try {
                        if (bufferedInputStream != null) {
                            ((InputStream)bufferedInputStream).close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return document3;
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    if (bufferedInputStream != null) {
                        ((InputStream)bufferedInputStream).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return document;
    }

    public static Number parse(String string) {
        if (string == null) {
            return null;
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        Number number = null;
        try {
            number = numberFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
        return number;
    }

    public static Float getFloat(String string, String string2) {
        String string3 = SGUtilityNumber.removeUnit(string, string2);
        if (string3 == null) {
            return null;
        }
        Float f = SGUtilityText.getFloat(string3);
        if (f == null) {
            return null;
        }
        return f;
    }

    public static Double getDouble(String string, String string2) {
        String string3 = SGUtilityNumber.removeUnit(string, string2);
        if (string3 == null) {
            return null;
        }
        Double d = SGUtilityText.getDouble(string3);
        if (d == null) {
            return null;
        }
        return d;
    }

    public static boolean isValidString(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(c != ' ' & c != '\u3000' & c != '\t' & c != '\n' & c != '\r' & c != '\f')) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getSerialName(ArrayList arrayList, String string) {
        String string2 = string;
        int n = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (!string3.startsWith(string)) continue;
            String string4 = string3.substring(string.length());
            if (string4.startsWith("(") & string4.endsWith(")")) {
                int n2;
                String string5 = string4.substring(1, string4.length() - 1);
                Integer n3 = SGUtilityText.getInteger(string5);
                if (n3 == null || (n2 = n3.intValue()) <= n) continue;
                n = n2;
                continue;
            }
            if (!string4.equals("")) continue;
            n = 0;
        }
        if (n != -1) {
            string2 = string2 + "(" + ++n + ")";
        }
        return string2;
    }
}

