#!/bin/sh
cd `dirname $0`
PRODUCTXML=../../../web/htdocs/product.xml
CHANGELOGXSL=ChangeLog.xsl
CHANGELOGXML=ChangeLog.xml

rm -f $CHANGELOGXML

xmllint -valid -noout $PRODUCTXML
if [ $? -ne 0 ]; then
  echo "Error : $PRODUCTXML - invalid format xml file "
  exit 1
fi
xsltproc -o $CHANGELOGXML $CHANGELOGXSL $PRODUCTXML
xmllint -valid -noout $CHANGELOGXML
if [ $? -ne 0 ]; then
  echo "Error : CHANGELOGXML - invalid format xml file "
  exit 1
fi

