/*
 * SGAxisPanel.java
 *
 * Created on 2004/06/09, 15:05
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;


/**
 *
 * @author  kuromaru
 */
public class SGAxisPanel extends JPanel implements ActionListener{
    
    /** Creates new form SGAxisPanel */
    public SGAxisPanel()
    {
        initComponents();
        this.initProerty();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mScalePanel = new javax.swing.JPanel();
        mTickMarkLabel = new javax.swing.JLabel();
        mAutoScaleCheckBox = new javax.swing.JCheckBox();
        mLinearRadioButton = new javax.swing.JRadioButton();
        mScaleLineVisibleCheckBox = new javax.swing.JCheckBox();
        mManualScaleSeparator = new javax.swing.JSeparator();
        mLogRadioButton = new javax.swing.JRadioButton();
        mMinLabel = new javax.swing.JLabel();
        mMaxLabel = new javax.swing.JLabel();
        mMinValueTextField = new javax.swing.JTextField();
        mMaxValueTextField = new javax.swing.JTextField();
        mBaseTickLabel = new javax.swing.JLabel();
        mBaseTickTextField = new javax.swing.JTextField();
        mIncrementTextField = new javax.swing.JTextField();
        mIncrementLabel = new javax.swing.JLabel();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mOuterRadioButton = new javax.swing.JRadioButton();
        mInnerRadioButton = new javax.swing.JRadioButton();
        mExponentLabel = new javax.swing.JLabel();
        mIntegerCheckBox = new javax.swing.JCheckBox();
        mExponentCheckBox = new javax.swing.JCheckBox();
        mScaleExpressionVisibleCheckBox = new javax.swing.JCheckBox();
        mFormatLabel = new javax.swing.JLabel();
        mScaleExpressionSeparator = new javax.swing.JSeparator();
        mExponentSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mTitleAppearancePanel = new javax.swing.JPanel();
        mTitleVisibleCheckBox = new javax.swing.JCheckBox();
        mTitleTextField = new javax.swing.JTextField();
        mTitleLabel = new javax.swing.JLabel();
        mTitleLeftSpaceLabel = new javax.swing.JLabel();
        mTitleRightSpaceLabel = new javax.swing.JLabel();
        mAxisVisibleCheckBox = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        mScalePanel.setLayout(new java.awt.GridBagLayout());

        mScalePanel.setBorder(new javax.swing.border.TitledBorder(null, "Scale", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12)));
        mScalePanel.setFont(new java.awt.Font("SansSerif", 0, 11));
        mTickMarkLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mTickMarkLabel.setText("Tick Mark");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mTickMarkLabel, gridBagConstraints);

        mAutoScaleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mAutoScaleCheckBox.setText("Auto");
        mAutoScaleCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mAutoScaleCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 5);
        mScalePanel.add(mAutoScaleCheckBox, gridBagConstraints);

        mLinearRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mLinearRadioButton.setText("Linear");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mScalePanel.add(mLinearRadioButton, gridBagConstraints);

        mScaleLineVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleLineVisibleCheckBox.setText("Visible");
        mScaleLineVisibleCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mScaleLineVisibleCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 5);
        mScalePanel.add(mScaleLineVisibleCheckBox, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 25, 5, 5);
        mScalePanel.add(mManualScaleSeparator, gridBagConstraints);

        mLogRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mLogRadioButton.setText("Log");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mLogRadioButton, gridBagConstraints);

        mMinLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mMinLabel.setText("Min");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mScalePanel.add(mMinLabel, gridBagConstraints);

        mMaxLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mMaxLabel.setText("Max");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mScalePanel.add(mMaxLabel, gridBagConstraints);

        mMinValueTextField.setColumns(6);
        mMinValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mMinValueTextField, gridBagConstraints);

        mMaxValueTextField.setColumns(6);
        mMaxValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mMaxValueTextField, gridBagConstraints);

        mBaseTickLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mBaseTickLabel.setText("Base");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 5, 5);
        mScalePanel.add(mBaseTickLabel, gridBagConstraints);

        mBaseTickTextField.setColumns(6);
        mBaseTickTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mScalePanel.add(mBaseTickTextField, gridBagConstraints);

        mIncrementTextField.setColumns(6);
        mIncrementTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mScalePanel.add(mIncrementTextField, gridBagConstraints);

        mIncrementLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mIncrementLabel.setText("Step");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 5, 5);
        mScalePanel.add(mIncrementLabel, gridBagConstraints);

        mLeftSpaceLabel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mScalePanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mRightSpaceLabel, gridBagConstraints);

        mOuterRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mOuterRadioButton.setText("Outer");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mScalePanel.add(mOuterRadioButton, gridBagConstraints);

        mInnerRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mInnerRadioButton.setText("Inner");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 5, 5);
        mScalePanel.add(mInnerRadioButton, gridBagConstraints);

        mExponentLabel.setFont(new java.awt.Font("Dialog", 1, 14));
        mExponentLabel.setText("10");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        mScalePanel.add(mExponentLabel, gridBagConstraints);

        mIntegerCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mIntegerCheckBox.setText("Integer");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mScalePanel.add(mIntegerCheckBox, gridBagConstraints);

        mExponentCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mExponentCheckBox.setText("Exp Part");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mScalePanel.add(mExponentCheckBox, gridBagConstraints);

        mScaleExpressionVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleExpressionVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mScalePanel.add(mScaleExpressionVisibleCheckBox, gridBagConstraints);

        mFormatLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFormatLabel.setText("Format ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mScalePanel.add(mFormatLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        mScalePanel.add(mScaleExpressionSeparator, gridBagConstraints);

        mExponentSpinner.setVerifyInputWhenFocusTarget(false);
        mExponentSpinner.setFont(new java.awt.Font("MonoSpaced", 0, 10));
        mExponentSpinner.setPreferredSize(new java.awt.Dimension(40, 20));
        mExponentSpinner.setValue(new Integer(0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mScalePanel.add(mExponentSpinner, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(mScalePanel, gridBagConstraints);

        mTitleAppearancePanel.setLayout(new java.awt.GridBagLayout());

        mTitleAppearancePanel.setBorder(new javax.swing.border.TitledBorder(null, "Title", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12)));
        mTitleAppearancePanel.setFont(new java.awt.Font("SansSerif", 0, 11));
        mTitleVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mTitleVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mTitleAppearancePanel.add(mTitleVisibleCheckBox, gridBagConstraints);

        mTitleTextField.setColumns(8);
        mTitleTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 60;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTitleAppearancePanel.add(mTitleTextField, gridBagConstraints);

        mTitleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTitleLabel.setText("Label");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mTitleAppearancePanel.add(mTitleLabel, gridBagConstraints);

        mTitleLeftSpaceLabel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mTitleLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mTitleAppearancePanel.add(mTitleLeftSpaceLabel, gridBagConstraints);

        mTitleRightSpaceLabel.setFont(new java.awt.Font("MS Sans Serif", 0, 12));
        mTitleRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        mTitleAppearancePanel.add(mTitleRightSpaceLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(mTitleAppearancePanel, gridBagConstraints);

        mAxisVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mAxisVisibleCheckBox.setText("Visible Axis");
        mAxisVisibleCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mAxisVisibleCheckBoxActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 15, 5);
        add(mAxisVisibleCheckBox, gridBagConstraints);

    }//GEN-END:initComponents

    private void mScaleLineVisibleCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mScaleLineVisibleCheckBoxActionPerformed
        // ɏR[hǉ:
    }//GEN-LAST:event_mScaleLineVisibleCheckBoxActionPerformed

    private void mAutoScaleCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mAutoScaleCheckBoxActionPerformed
        // ɏR[hǉ:
    }//GEN-LAST:event_mAutoScaleCheckBoxActionPerformed

    private void mAxisVisibleCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mAxisVisibleCheckBoxActionPerformed
        // ɏR[hǉ:
    }//GEN-LAST:event_mAxisVisibleCheckBoxActionPerformed
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JCheckBox mAutoScaleCheckBox;
    private javax.swing.JCheckBox mAxisVisibleCheckBox;
    private javax.swing.JLabel mBaseTickLabel;
    private javax.swing.JTextField mBaseTickTextField;
    private javax.swing.JCheckBox mExponentCheckBox;
    private javax.swing.JLabel mExponentLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mExponentSpinner;
    private javax.swing.JLabel mFormatLabel;
    private javax.swing.JLabel mIncrementLabel;
    private javax.swing.JTextField mIncrementTextField;
    private javax.swing.JRadioButton mInnerRadioButton;
    private javax.swing.JCheckBox mIntegerCheckBox;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JRadioButton mLinearRadioButton;
    private javax.swing.JRadioButton mLogRadioButton;
    private javax.swing.JSeparator mManualScaleSeparator;
    private javax.swing.JLabel mMaxLabel;
    private javax.swing.JTextField mMaxValueTextField;
    private javax.swing.JLabel mMinLabel;
    private javax.swing.JTextField mMinValueTextField;
    private javax.swing.JRadioButton mOuterRadioButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JSeparator mScaleExpressionSeparator;
    private javax.swing.JCheckBox mScaleExpressionVisibleCheckBox;
    private javax.swing.JCheckBox mScaleLineVisibleCheckBox;
    private javax.swing.JPanel mScalePanel;
    private javax.swing.JLabel mTickMarkLabel;
    private javax.swing.JPanel mTitleAppearancePanel;
    private javax.swing.JLabel mTitleLabel;
    private javax.swing.JLabel mTitleLeftSpaceLabel;
    private javax.swing.JLabel mTitleRightSpaceLabel;
    private javax.swing.JTextField mTitleTextField;
    private javax.swing.JCheckBox mTitleVisibleCheckBox;
    // ϐ錾̏I//GEN-END:variables


   	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mMinValueTextField );
		list.add( this.mMaxValueTextField );
		list.add( this.mTitleTextField );
		list.add( this.mBaseTickTextField );
		list.add( this.mIncrementTextField );

		ArrayList spList = this.getSpinnerList();
		for( int ii=0; ii<spList.size(); ii++ )
		{
			JSpinner spinner = (JSpinner)spList.get(ii);
			final JSpinner.DefaultEditor editor
				= (JSpinner.DefaultEditor)spinner.getEditor();
			final JFormattedTextField ftf = editor.getTextField();
			list.add( ftf );
		}

		return list;
	}


	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{
		this.mMinValueTextField.addActionListener(listener);
		this.mMaxValueTextField.addActionListener(listener);
		this.mTitleTextField.addActionListener(listener);
		this.mBaseTickTextField.addActionListener(listener);
		this.mIncrementTextField.addActionListener(listener);

		ArrayList spList = this.getSpinnerList();
		for( int ii=0; ii<spList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)spList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = this.mMinValueTextField.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mMinValueTextField.removeActionListener( array[ii] );
			this.mMaxValueTextField.removeActionListener( array[ii] );
			this.mTitleTextField.removeActionListener( array[ii] );
			this.mBaseTickTextField.removeActionListener( array[ii] );
			this.mIncrementTextField.removeActionListener( array[ii] );

			ArrayList spList = this.getSpinnerList();
			for( int jj=0; jj<spList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)spList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}

		}

		return true;
	}


	/**
	 * 
	 */
	private boolean initProerty()
	{

		// create button groups
		{
			ButtonGroup group = new ButtonGroup();
			group.add( this.mLinearRadioButton );
			group.add( this.mLogRadioButton );
		}
		{
			ButtonGroup group = new ButtonGroup();
			group.add( this.mInnerRadioButton );
			group.add( this.mOuterRadioButton );
		}


		// add an action listener
		this.mAxisVisibleCheckBox.addActionListener(this);
		this.mTitleVisibleCheckBox.addActionListener(this);
		this.mScaleExpressionVisibleCheckBox.addActionListener(this);
		this.mScaleLineVisibleCheckBox.addActionListener(this);
		this.mAutoScaleCheckBox.addActionListener(this);
		this.mExponentCheckBox.addActionListener(this);


		// exponent
		this.mExponentSpinner.initProperties(
			new SpinnerNumberModel( 0, -10, 10, 1 ),
			null );
		this.mExponentSpinner.setMinimumFractionDigits(0);
		this.mExponentSpinner.setMaximumFractionDigits(0);

		return true;
	}


	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		String command = e.getActionCommand();
		Object source = e.getSource();

		if( source.equals( this.mAxisVisibleCheckBox ) )
		{
			this.setAxisPanelComponentsEnables( this.mAxisVisibleCheckBox.isSelected() );
		}
		else if( source.equals( this.mTitleVisibleCheckBox ) )
		{
			this.setTitleComponentsEnabled( this.mTitleVisibleCheckBox.isSelected() );
		}
		else if( source.equals( this.mScaleExpressionVisibleCheckBox ) )
		{
			this.setScaleNumberComponentsEnabled( this.mScaleExpressionVisibleCheckBox.isSelected() );
		}
		else if( source.equals( this.mScaleLineVisibleCheckBox ) )
		{
			this.setScaleLineComponentsEnabled( this.mScaleLineVisibleCheckBox.isSelected() );
		}
		else if( source.equals( this.mAutoScaleCheckBox ) )
		{
			final boolean flag = this.mAutoScaleCheckBox.isSelected();
			this.mIncrementTextField.setEditable(!flag);
			this.mBaseTickTextField.setEditable(!flag);
		}
		else if( source.equals( this.mExponentCheckBox ) )
		{
			this.setExponentFlag( this.mExponentCheckBox.isSelected() );
//			this.mExponentSpinner.setEnabled( this.mExponentCheckBox.isSelected() );
		}


//		repaint();

	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	protected boolean setAxisPanelComponentsEnables( final boolean b )
	{

		// title
		this.mTitleVisibleCheckBox.setEnabled(b);
		final boolean bt = this.mTitleVisibleCheckBox.isSelected();
		this.setTitleComponentsEnabled( b & bt );


		// scale
		this.setScaleComponentsEnabled(b);

		return true;
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setTitleComponentsEnabled( final boolean b )
	{
		this.mTitleLabel.setEnabled(b);
		this.mTitleTextField.setEnabled(b);
		return true;
	}


	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setScaleComponentsEnabled( final boolean b )
	{

		//
		this.mTickMarkLabel.setEnabled(b);
		this.mAutoScaleCheckBox.setEnabled(b);
		this.setManualComponentsEnabled(b);

		// scale numbers
		this.mFormatLabel.setEnabled(b);
		this.mScaleExpressionVisibleCheckBox.setEnabled(b);
		final boolean bsn = this.mScaleExpressionVisibleCheckBox.isSelected();
		this.setScaleNumberComponentsEnabled( b & bsn );

		// scale lines
		this.mScaleLineVisibleCheckBox.setEnabled(b);
		final boolean bsl = this.mScaleLineVisibleCheckBox.isSelected();
		this.setScaleLineComponentsEnabled( b & bsl );

		return true;
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setManualComponentsEnabled( final boolean b )
	{
		this.mLinearRadioButton.setEnabled(b);
		this.mLogRadioButton.setEnabled(b);
		this.mMinLabel.setEnabled(b);
		this.mMinValueTextField.setEnabled(b);
		this.mMaxLabel.setEnabled(b);
		this.mMaxValueTextField.setEnabled(b);

		this.mBaseTickLabel.setEnabled(b);
		this.mBaseTickTextField.setEnabled(b);
		this.mIncrementLabel.setEnabled(b);
		this.mIncrementTextField.setEnabled(b);

		return true;
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setScaleNumberComponentsEnabled( final boolean b )
	{
		this.mIntegerCheckBox.setEnabled(b);

		this.mExponentCheckBox.setEnabled(b);
		final boolean be = b && this.getExponentFlag();
		this.setExponentComponentEnabled(be);
		return true;
	}


	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setExponentComponentEnabled( final boolean b )
	{
		this.mExponentLabel.setEnabled(b);
		this.mExponentSpinner.setEnabled(b);
		return true;
	}



	/**
	 * 
	 * @param b
	 * @return
	 */
	private boolean setScaleLineComponentsEnabled( final boolean b )
	{
		this.mInnerRadioButton.setEnabled(b);
		this.mOuterRadioButton.setEnabled(b);
		return true;
	}




	/**
	 * 
	 */
	public int getScaleType()
	{
		int num;
		if( this.mLinearRadioButton.isSelected() )
		{
			num = SGAxis.LINEAR_TYPE;
		}
		else if( this.mLogRadioButton.isSelected() )
		{
			num = SGAxis.LOG_TYPE;
		}
		else
		{
			throw new Error();
		}

		return num;
	}


	/**
	 * 
	 */
	public SGTuple2d getScale()
	{
		final String strMin = this.mMinValueTextField.getText();
		final String strMax = this.mMaxValueTextField.getText();
		
		if( strMin.length()==0 || strMax.length()==0 )
		{
			return null;
		}

		Double dMin = null;
		Double dMax = null;
		try
		{
			dMin = Double.valueOf(strMin);
			dMax = Double.valueOf(strMax);
		}
		catch( NumberFormatException ex )
		{
System.out.println("͂ĉB");
//			ex.printStackTrace();
			return null;
		}

		final double min = dMin.doubleValue();
		final double max = dMax.doubleValue();
		if( min >= max )
		{
System.out.println("min >= max");
			return null;
		}

		//
		final SGTuple2d range = new SGTuple2d( min, max );

		return range;
	}


	/**
	 * 
	 */
	public boolean getAutoCalcFlag()
	{
		return this.mAutoScaleCheckBox.isSelected();
	}



	/**
	 * 
	 */
	public Number getIncrementValue()
	{
		String str = this.mIncrementTextField.getText();
		Number d = null;
		try
		{
			d = Double.valueOf(str);
		}
		catch( NumberFormatException ex )
		{
System.out.println("͂ĉB");
//			ex.printStackTrace();
		}
		return d;
	}


	/**
	 * 
	 */
	public Number getBaseTickValue()
	{
		String str = this.mBaseTickTextField.getText();
		Number d = null;
		try
		{
			d = Double.valueOf(str);
		}
		catch( NumberFormatException ex )
		{
System.out.println("͂ĉB");
//			ex.printStackTrace();
		}
		return d;
	}


	/**
	 * 
	 */
	public String getTitleString()
	{

		String str = this.mTitleTextField.getText();
		if( str.length() == 0 )
		{
			return null;
		}

		return str;
	}


	/**
	 * 
	 */
	public boolean getAxisGroupVisible()
	{
		return this.mAxisVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public boolean getTitleVisible()
	{
		return this.mTitleVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public boolean getScaleNumbersVisible()
	{
		return this.mScaleExpressionVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public boolean getScaleLineVisible()
	{
		return this.mScaleLineVisibleCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public boolean getScaleLineDirection()
	{
		boolean flag;
		if( this.mInnerRadioButton.isSelected() )
		{
			flag = true;
		}
		else if( this.mOuterRadioButton.isSelected() )
		{
			flag = false;
		}
		else
		{
			throw new Error();
		}

		return flag;
	}


	/**
	 * 
	 */
	public boolean getScaleNumbersInteger()
	{
		return this.mIntegerCheckBox.isSelected();
	}



	/**
	 * 
	 */
	public boolean getExponentFlag()
	{
		return this.mExponentCheckBox.isSelected();
	}


	/**
	 * 
	 */
	public Number getExponentValue()
	{
		return this.mExponentSpinner.getNumber();
	}



	/**
	 * 
	 */
	public boolean setTitleTextField( final String str )
	{
		this.mTitleTextField.setText( str );
		return true;
	}


	/**
	 * 
	 */
	public boolean setScaleType( final int type )
	{

		switch( type )
		{
			case SGAxis.LINEAR_TYPE :
			{
				this.mLinearRadioButton.setSelected(true);
				break;
			}

			case SGAxis.LOG_TYPE :
			{
				this.mLogRadioButton.setSelected(true);
				break;
			}
	
			default :
			{
				throw new IllegalArgumentException("The scale type is illegal.");
			}
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean setAxisVisible( final boolean flag )
	{
		this.mAxisVisibleCheckBox.setSelected(flag);
		this.setAxisPanelComponentsEnables( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setTitleVisible( final boolean flag )
	{
		this.mTitleVisibleCheckBox.setSelected(flag);
		this.setTitleComponentsEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setScaleLinesVisible( final boolean flag )
	{
		this.mScaleLineVisibleCheckBox.setSelected(flag);
		this.setScaleLineComponentsEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setScaleLinesInside( final boolean flag )
	{
		if( flag )
		{
			this.mInnerRadioButton.setSelected(true);
		}
		else
		{
			this.mOuterRadioButton.setSelected(true);
		}

		return true;
	}


	/**
	 * 
	 */
	public boolean setScaleNumbersVisible( final boolean flag )
	{
		this.mScaleExpressionVisibleCheckBox.setSelected(flag);
		this.setScaleNumberComponentsEnabled( flag );
		return true;
	}


	/**
	 * 
	 */
	public boolean setScaleNumbersInteger( final boolean flag )
	{
		this.mIntegerCheckBox.setSelected(flag);
		return true;
	}


	/**
	 * 
	 */
	public boolean setRange( final SGTuple2d range )
	{
		if( range==null )
		{
			return false;
		}

		this.mMinValueTextField.setText( new Double( range.x ).toString() );
		this.mMaxValueTextField.setText( new Double( range.y ).toString() );

		return true;
	}


	/**
	 * 
	 */
	public boolean setAutoCalcFlag( final boolean flag )
	{
		this.mAutoScaleCheckBox.setSelected(flag);
		this.mBaseTickTextField.setEditable(!flag);
		this.mIncrementTextField.setEditable(!flag);
		return true;
	}


	/**
	 * 
	 */
	public boolean setBaseTickValue( final double value )
	{
		this.mBaseTickTextField.setText( new Double(value).toString() );
		return true;
	}


	/**
	 * 
	 */
	public boolean setIncrementValue( final double value )
	{
		this.mIncrementTextField.setText( new Double(value).toString() );
		return true;
	}


	/**
	 * 
	 * @param b
	 * @return
	 */
	public boolean setExponentFlag( final boolean b )
	{
		this.mExponentCheckBox.setSelected(b);
		this.mExponentLabel.setEnabled(b);
		this.mExponentSpinner.setEnabled(b);
		return true;
	}



	/**
	 * 
	 * @param value
	 * @return
	 */
	public boolean setExponentValue( final int value )
	{
		this.mExponentSpinner.setValue( new Integer(value) );
		return true;
	}



	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mExponentSpinner );
		return list;
	}


	/**
	 * 
	 */
	public SGAxisElement.AxisIndividualProperties getProperties()
	{

		SGAxisElement.AxisIndividualProperties p
			= new SGAxisElement.AxisIndividualProperties();


		final int scaleType = this.getScaleType();

		SGTuple2d range = this.getScale();
		if( range==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}

		if( scaleType == SGAxis.LOG_TYPE )
		{
			if( range.x < Double.MIN_VALUE )
			{
//				SGUtility.showMessageDialog(
//					mDialog,
//					"range.x < Double.MIN_VALUE : inappropriate range for the log scale",
//					"Illegal input to the dilaog.",
//					JOptionPane.ERROR_MESSAGE
//				);
System.out.println("Inappropriate range for the log scale");
//				this.setScaleType( SGAxis.LINEAR_TYPE );
				SGUtility.showIllegalInputErrorMessageDialog( this );
				return null;
			}
		}

		p.scaleType = scaleType;
		p.minValue = range.x;
		p.maxValue = range.y;


		p.autoCalcAxisNumberFlag = this.getAutoCalcFlag();

		Number incrementValue = this.getIncrementValue();
		if( incrementValue==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.incrementValue = incrementValue.doubleValue();
			
		}

		Number baseTickValue = this.getBaseTickValue();
		if( baseTickValue==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.baseTickValue = baseTickValue.doubleValue();
		}


		p.titleString = this.getTitleString();
		p.axisVisibleFlag = this.getAxisGroupVisible();
		p.titleVisibleFlag = this.getTitleVisible();
		p.scaleLinesVisibleFlag = this.getScaleLineVisible();
		p.scaleNumbersVisibleFlag = this.getScaleNumbersVisible();
		p.scaleLinesInsideFlag = this.getScaleLineDirection();
		p.scaleNumbersIntegerFlag = this.getScaleNumbersInteger();
		p.exponentFlag = this.getExponentFlag();


		final Number exponentValue = this.getExponentValue();
		if( exponentValue==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.exponentValue = exponentValue.intValue();
		}


		return p;
	}


}
