/*
 * SGUpgradeConfirmDialog.java
 *
 * Created on 2004/11/05, 10:39
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import jp.riken.brain.ni.samuraigraph.base.SGDialog;



/**
 *
 * @author  kuromaru
 */
public class SGUpgradeConfirmDialog extends SGScrollPaneDialog
{

	public static final String TITLE = "Samurai Graph Auto Upgrade";


	/** Creates new form SGUpgradeConfirmDialog */
	public SGUpgradeConfirmDialog()
	{
		super();
		this.initProperty();
	}


    /** Creates new form SGUpgradeConfirmDialog */
    public SGUpgradeConfirmDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        this.initProperty();
    }

	/** Creates new form SGUpgradeConfirmDialog */
	public SGUpgradeConfirmDialog(java.awt.Dialog parent, boolean modal)
	{
		super(parent, modal);
		this.initProperty();
	}



	public static final String YES = SGDialog.YES_BUTTON_TEXT;
	public static final String NO = SGDialog.NO_BUTTON_TEXT;


	private boolean initProperty()
	{
		// set the title
		this.setTitle(TITLE);

		this.mOKButton.setText( YES );
		this.mCancelButton.setText( NO );
		
		this.pack();

		return true;
	}


	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		Object source = e.getSource();
		String command = e.getActionCommand();
		
		if( command.equals( YES ) )
		{
			this.onOK();
		}
		else if( command.equals( NO ) )
		{
			this.onCanceled();
		}
	}


	/**
	 * 
	 * @param t
	 * @return
	 */
	public boolean setPage( String t )
	{
//		File f;
//		try
//		{
//			f = File.createTempFile("upgrade",".html");
//		}
//		catch( IOException ex )
//		{
//			return false;
//		}

		File f = new File( TMP_DIR + FILE_SEPARATOR + "upgrade.html" );
		f.deleteOnExit();

		FileWriter fw = null;
		BufferedWriter bw = null;
		try
		{
			fw = new FileWriter(f);
			bw = new BufferedWriter(fw);
			bw.write(t);
			this.setPage( f.toURL() );
		}
		catch( Exception ex )
		{
		}
		finally
		{
			if( bw!=null )
			{
				try
				{
					bw.close();
				}
				catch( IOException ex )
				{
				}
			}
			if( fw!=null )
			{
				try
				{
					fw.close();
				}
				catch( IOException ex )
				{
				}
			}
		}

		return true;
	}

}

