
package jp.riken.brain.ni.samuraigraph.base;

import java.io.File;


/**
 * 
 */
public interface SGIConstants
{

	/**
	 * The ratio of cm to inch.
	 */
	public static final float CM_INCH_RATIO = 2.54f;


	/**
	 * The ratio of inch to point.
	 */
	public static final float INCH_POINT_RATIO = 72.0f;


	/**
	 * The ratio of cm to point.
	 */
	public static final float CM_POINT_RATIO = CM_INCH_RATIO/INCH_POINT_RATIO;


	/**
	 * The ratio of radian to degree.
	 */
	public static final float RADIAN_DEGREE_RATIO = (float)(Math.PI/180.0);


	/**
	 * The golden ratio.
	 */
	public static final float GOLDEN_RATIO = (float)( ( 1.0 + Math.sqrt(5.0) )/2.0 );


	/**
	 * Delimiter set of lines.
	 */
	public static char[] DELIMITER_SET = { ' ', '\t', '\n', '\r', '\f', ',' };


	/**
	 * The units of length.
	 */
	public static final String cm = "cm";
	public static final String mm = "mm";
	public static final String pt = "pt";
	public static final String inch = "inch";


	/**
	 * The unit of angle.
	 */
	public static final char degChar = '\u00B0';
	public static final String degree = Character.toString( degChar );


	/**
	 * The algebraic signs.
	 */
	public static final char multiplyChar = '\u00D7';
	public static final String multiply = Character.toString( multiplyChar );
	public static final char divideChar = '\u00F7';
	public static final char pmChar = '\u00B1';			// plus and minus
	public static final char mpChar = '\u2213';			// minus and plus
	public static final char neqChar = '\u2260';			// not equal


	/**
	 * Two-byte space.
	 */
	public static final char twoByteSpaceChar = '\u3000';



	/**
	 * OS name.
	 */
	public static final String OS_NAME = System.getProperty("os.name");


	/**
	 * Java home directory.
	 */
	public static final String JAVA_HOME = System.getProperty("java.home");


	/**
	 * File separator.
	 */
	public static final String FILE_SEPARATOR = File.separator;


	/**
	 * Path separator.
	 */
	public static final String PATH_SEPARATOR = File.pathSeparator;


	/**
	 * Line separator.
	 */
	public static final String LINE_SEPARATOR = System.getProperty("line.separator");


	/**
	 * User name.
	 */
	public static final String USER_NAME = System.getProperty("user.name");


	/**
	 * User home directory.
	 */
	public static final String USER_HOME = System.getProperty("user.home");


	/**
	 * Temporary directory.
	 */
	public static final String TMP_DIR = System.getProperty("java.io.tmpdir");



	/**
	 * Directory name of resources.
	 */
	public static final String RESOURCES_DIRNAME = "/resources/";


	/**
	 * A constant for the Windows systems.
	 */
	public static final String OS_NAME_WINDOWS = "windows";
	
	
	/**
	 * A constant for the Mac OS X system.
	 */
	public static final String OS_NAME_MACOSX = "mac os x";


	/**
	 * A constant for "My Documents" directory in the Windows systems.
	 */
	public static final String MY_DOCUMENTS = "My Documents";


	/**
	 * Font Style
	 */
	public static final String FONT_PLAIN = "Plain";
	public static final String FONT_ITALIC = "Italic";
	public static final String FONT_BOLD = "Bold";
	public static final String FONT_BOLD_ITALIC = "Bold Italic";



	/**
	 * Scale Type
	 */
	public static final String SCALE_TYPE_LINEAR = "Linear";
	public static final String SCALE_TYPE_LOG = "Log";




	/**
	 * Return values from class method
	 */
	public static final int SUCCESSFUL_COMPLETION = 0;
	public static final int PROPERTY_FILE_INCORRECT = 1;
	public static final int DATA_TYPE_INCORRECT = 2;
	public static final int DATA_NUMBER_SHORTAGE = 3;
	public static final int DATA_NUMBER_EXCESS = 4;
	public static final int FILE_OPEN_FAILURE = 5;


	/**
	 * Menu commands
	 */
	public static final String MENUCMD_CUT = "Cut";
	public static final String MENUCMD_COPY = "Copy";
	public static final String MENUCMD_PASTE = "Paste";
	public static final String MENUCMD_DELETE = "Delete";
	public static final String MENUCMD_DUPLICATE = "Duplicate";
	public static final String MENUCMD_MOVE_TO_FRONT = "Move to Front";
	public static final String MENUCMD_MOVE_TO_BACK = "Move to Back";
	public static final String MENUCMD_PROPERTY = "Property";


	/**
	 * Look & Feel
	 */
	public static final String LAF_METAL = "Metal";
	public static final String LAF_MOTIF = "Motif";
	public static final String LAF_WINDOWS = "Windows";
	public static final String LAF_WINDOWSCLASSIC = "Windows Classic";
	public static final String LAF_AQUA = "Aqua";

}

