
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;

/**
 * An interface to export as an image.
 */
public interface SGIImageExportManager
{
	/**
	 * Export as image the target object.
	 * @param target - target object for export
	 * @param owner - owner object
	 * @param w - width of image
	 * @param h - height of image
	 * @return true:succeeded, false:failed
	 */
	public boolean export( Component target, Frame owner, int w, int h );


	/**
	 * Preview image of the target object.
	 * @param target - target object for export
	 * @param owner - owner object
	 * @param w - width of image
	 * @param h - height of image
	 * @return true:succeeded, false:failed
	 */
//	public boolean preview( Component target, Frame owner, int w, int h );


	/**
	 * Print image of the target object.
	 * @param target - target object for export
	 * @param owner - owner object
	 * @param w - width of image
	 * @param h - height of image
	 * @return true:succeeded, false:failed
	 */
	public boolean print( Component target, Frame owner, int w, int h );


	/**
	 * @return
	 */
	public Color getBackgroundColor();


	/**
	 * @param color
	 */
	public void setBackgroundColor( Color color );


}
