/*
 * SGTimingLineDialog.java
 *
 * Created on 2004/06/09, 15:06
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;


/**
 *
 * @author  kuromaru
 */
public class SGTimingLineDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Timing Line Properties";


    /** Creates new form SGTimingLineDialog */
    public SGTimingLineDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }
    

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mTimingLinePanel = new javax.swing.JPanel();
        mTimingValueLabel = new javax.swing.JLabel();
        mLineTypeLabel = new javax.swing.JLabel();
        mLineWidthLabel = new javax.swing.JLabel();
        mColorLabel = new javax.swing.JLabel();
        mTimingValueTextField = new javax.swing.JTextField();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineColorButton = new javax.swing.JButton();
        mLineTypeComboBox = new javax.swing.JComboBox();
        mRightSpaceLabel = new javax.swing.JLabel();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mCommonPanel = new javax.swing.JPanel();
        mLeftRadioButton = new javax.swing.JRadioButton();
        mBottomRadioButton = new javax.swing.JRadioButton();
        mTopRadioButton = new javax.swing.JRadioButton();
        mRightRadioButton = new javax.swing.JRadioButton();
        mScaleReferenceLabel2 = new javax.swing.JLabel();
        mScaleReferenceLabel1 = new javax.swing.JLabel();
        mCenterLabel = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        mTimingLinePanel.setLayout(new java.awt.GridBagLayout());

        mTimingLinePanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mTimingLinePanel.setFont(new java.awt.Font("MS Sans Serif", 0, 10));
        mTimingValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTimingValueLabel.setText("Value");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTimingLinePanel.add(mTimingValueLabel, gridBagConstraints);

        mLineTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeLabel.setText("Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 20, 5, 5);
        mTimingLinePanel.add(mLineTypeLabel, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTimingLinePanel.add(mLineWidthLabel, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mTimingLinePanel.add(mColorLabel, gridBagConstraints);

        mTimingValueTextField.setColumns(6);
        mTimingValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mTimingValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTimingLinePanel.add(mTimingValueTextField, gridBagConstraints);

        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        mLineWidthSpinner.setMinimumSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTimingLinePanel.add(mLineWidthSpinner, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTimingLinePanel.add(mLineColorButton, gridBagConstraints);

        mLineTypeComboBox.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTimingLinePanel.add(mLineTypeComboBox, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTimingLinePanel.add(mRightSpaceLabel, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTimingLinePanel.add(mLeftSpaceLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mTimingLinePanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mCommonPanel.setLayout(new java.awt.GridBagLayout());

        mLeftRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftRadioButton.setText("Left");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mCommonPanel.add(mLeftRadioButton, gridBagConstraints);

        mBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mBottomRadioButton.setText("Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        mCommonPanel.add(mBottomRadioButton, gridBagConstraints);

        mTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mTopRadioButton.setText("Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHWEST;
        mCommonPanel.add(mTopRadioButton, gridBagConstraints);

        mRightRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightRadioButton.setText("Right");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightRadioButton, gridBagConstraints);

        mScaleReferenceLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mCommonPanel.add(mScaleReferenceLabel2, gridBagConstraints);

        mScaleReferenceLabel1.setFont(new java.awt.Font("Dialog", 1, 12));
        mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        mCommonPanel.add(mScaleReferenceLabel1, gridBagConstraints);

        mCenterLabel.setFont(new java.awt.Font("SansSerif", 0, 11));
        mCenterLabel.setText("        ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        mCommonPanel.add(mCenterLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mCommonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents

    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        // ɏR[hǉ:
    }//GEN-LAST:event_closeDialog
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JRadioButton mBottomRadioButton;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mCenterLabel;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JPanel mCommonPanel;
    private javax.swing.JRadioButton mLeftRadioButton;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JButton mLineColorButton;
    private javax.swing.JComboBox mLineTypeComboBox;
    private javax.swing.JLabel mLineTypeLabel;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JRadioButton mRightRadioButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mScaleReferenceLabel1;
    private javax.swing.JLabel mScaleReferenceLabel2;
    private javax.swing.JPanel mTimingLinePanel;
    private javax.swing.JLabel mTimingValueLabel;
    private javax.swing.JTextField mTimingValueTextField;
    private javax.swing.JRadioButton mTopRadioButton;
    // ϐ錾̏I//GEN-END:variables



	/**
	 * 
	 */
	private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();

	
   	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGTimingLineDialog.TITLE );


		//
		{
			final String typeArray[] = {
				SGDrawingElementLine.LINE_NAME_SOLID,
				SGDrawingElementLine.LINE_NAME_BROKEN,
				SGDrawingElementLine.LINE_NAME_DOT
			};
			for(int ii=0 ; ii<typeArray.length ; ii++)
			{
				this.mLineTypeComboBox.addItem( typeArray[ii] );
			}
		}


		this.pack();

		
		// create a button group
		ButtonGroup bg = new ButtonGroup();
		bg.add( this.mTopRadioButton );
		bg.add( this.mBottomRadioButton );
		bg.add( this.mLeftRadioButton );
		bg.add( this.mRightRadioButton );
		bg.add( this.mNoAxisSelectionRadioButton );

		

		//
		// Xsi[f̓Kp
		//

		// line
		this.mLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


		// FύX{^ɃANVXiǉ
		this.mLineColorButton.addActionListener(this);


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mLineColorButton;


{
	this.mOKButton.addActionListener(this);
	this.mCancelButton.addActionListener(this);
	this.mPreviewButton.addActionListener(this);
}


		return true;
	}

	
	

	/**
	 * 
	 */
	public boolean setActionListener( final ActionListener listener )
	{

		this.mOKButton.addActionListener(listener);
		this.mCancelButton.addActionListener(listener);
		this.mPreviewButton.addActionListener(listener);

		// ^C~OleLXgtB[hɃANVXiǉ
		this.mTimingValueTextField.addActionListener(listener);

		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( listener );
		}

		return true;
	}


	/**
	 * 
	 */
	public String getTimingValueString()
	{
		return this.mTimingValueTextField.getText();
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getTimingValue()
	{
		String str = this.getTimingValueString();
		if( str==null )
		{
			return null;
		}

		Number num = SGUtilityText.getDouble(str);		
		
		return num;
	}
	

	/**
	 * 
	 */
	public boolean setTiminValueString( final double value )
	{
		this.mTimingValueTextField.setText( new Double(value).toString() );
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineType( final int type )
	{
		final String typeName = SGDrawingElementLine.getLineTypeName( type );
		this.mLineTypeComboBox.setSelectedItem(typeName);
		return true;
	}


	/**
	 * 
	 */
	public int getLineType()
	{
		final String typeName = (String)this.mLineTypeComboBox.getSelectedItem();
		final Integer num = SGDrawingElementLine.getLineTypeFromName(typeName);
		if( num==null )
		{
			throw new Error();
		}
		return num.intValue();
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float width )
	{
		this.mLineWidthSpinner.setValue( new Double( width ) );
		return true;
	}


	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public boolean setLineColorList( final ArrayList cList )
	{
		if( cList==null )
		{
			return false;
		}
		if( cList.size()==0 )
		{
			return false;
		}
		Color cl = (Color)cList.get(0);
		this.mLineColorButton.setBackground( cl );
		return true;
	}


	/**
	 * 
	 */
	public ArrayList getLineColorList()
	{
		Color cl = this.mLineColorButton.getBackground();
		ArrayList list = new ArrayList();
		list.add(cl);
		return list;
	}


	
	/**
	 * 
	 * @return
	 */
	public String getAxisLocation()
	{
		String str = null;
		if( this.mTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_TOP;
		}
		else if( this.mBottomRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_BOTTOM;
		}
		else if( this.mLeftRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_LEFT;
		}
		else if( this.mRightRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_RIGHT;
		}
		return str;
	}

	
	
	/**
	 * 
	 */
	public boolean setAxisRadioButton( final int config )
	{
		switch( config )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				this.mBottomRadioButton.setSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				this.mTopRadioButton.setSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_PERPENDICULAR_1 :
			{
				this.mLeftRadioButton.setSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_PERPENDICULAR_2 :
			{
				this.mRightRadioButton.setSelected(true);
				break;
			}

			default :
			{
				return false;
			}
		}

		return true;
	}


	
	/**
	 * 
	 * @param xAxisList
	 * @param yAxisList
	 * @return
	 */
	private boolean setAxesProperties( final ArrayList axisList )
	{

		final int num = axisList.size();

		if( num==0 )
		{
			return false;
		}

		Integer axis0 = (Integer)axisList.get(0);
		Integer axis = axis0;

		if( num>1 )
		{
			for( int ii=1; ii<num; ii++ )
			{
				Integer axis1 = (Integer)axisList.get(ii);
				if( axis0.equals(axis1)==false )
				{
					axis = null;
					break;
				}
			}
		}

		if( axis==null )
		{
			this.mNoAxisSelectionRadioButton.setSelected(true);
			return false;
		}
		this.setAxisRadioButton( axis.intValue() );

		return true;
	}


	
	/**
	 * 
	 */
	public ArrayList getColorSelectionComponentList()
	{
		final ArrayList list = new ArrayList();
		list.add(this.mLineColorButton);

		return list;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		list.add(this.mTimingValueTextField);

		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLineWidthSpinner );
		return list;
	}


	/**
	 * 
	 */
	public boolean removeActionListener()
	{
		ActionListener[] array = null;

		array = this.mOKButton.getActionListeners();
		for( int ii=0; ii<array.length; ii++ )
		{
			this.mOKButton.removeActionListener( array[ii] );
			this.mCancelButton.removeActionListener( array[ii] );
			this.mPreviewButton.removeActionListener( array[ii] );
			this.mTimingValueTextField.removeActionListener( array[ii] );

			final ArrayList sList = this.getSpinnerList();
			for( int jj=0; jj<sList.size(); jj++ )
			{
				SGSpinner spinner = (SGSpinner)sList.get(jj);
				spinner.getFormattedTextField().removeActionListener( array[ii] );
			}
		}

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public SGTimingLine.TimingLineProperties getTimingLineProperties()
	{
		SGTimingLine.TimingLineProperties p
			= new SGTimingLine.TimingLineProperties();

		Number lineWidth = this.getLineWidth();
		if( lineWidth==null )
		{
//			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setLineWidth( lineWidth.floatValue() );
		}

		p.setLineType( this.getLineType() );
		p.setColorList( this.getLineColorList() );

		Number num = this.getTimingValue();
		if( num==null )
		{
			return null;
		}
		p.setValue( num.doubleValue() );
		
		return p;
	}


}
