/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;

public class SGDataCreator {
    public SGData create(String string, ArrayList arrayList) throws FileNotFoundException {
        if (string == null || arrayList == null) {
            throw new NullPointerException("path==null || infoList==null");
        }
        if (arrayList.size() == 0) {
            return null;
        }
        SGData sGData = null;
        String string2 = (String)arrayList.get(0);
        if (string2.equals("SXY")) {
            sGData = this.createSXYData(string);
        } else if (!string2.equals("VXY")) {
            if (string2.equals("SXY_MULTIPLE")) {
                sGData = this.createSXYMultipleData(string);
            } else if (string2.equals("SXY_SAMPLING")) {
                if (arrayList.size() <= 1) {
                    return null;
                }
                double d = (Double)arrayList.get(1);
                sGData = this.createSXYSamplingData(string, d);
            }
        }
        return sGData;
    }

    private SGSXYData createSXYData(String string) throws FileNotFoundException {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 2) {
            return null;
        }
        ArrayList[] arrayListArray = this.createListArray(string, n);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        SGSXYData sGSXYData = null;
        String string2 = null;
        Double d = null;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayListArray[0].get(i);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[i] = d;
            string2 = (String)arrayListArray[1].get(i);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray2[i] = d;
        }
        double[] dArray3 = null;
        double[] dArray4 = null;
        String[] stringArray = null;
        switch (n) {
            case 2: {
                break;
            }
            case 4: {
                dArray3 = new double[n2];
                dArray4 = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    string2 = (String)arrayListArray[2].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray3[i] = d;
                    string2 = (String)arrayListArray[3].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray4[i] = d;
                }
                break;
            }
            case 3: {
                stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = (String)arrayListArray[2].get(i);
                }
                break;
            }
            case 5: {
                dArray3 = new double[n2];
                dArray4 = new double[n2];
                stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    string2 = (String)arrayListArray[2].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray3[i] = d;
                    string2 = (String)arrayListArray[3].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray4[i] = d;
                    stringArray[i] = (String)arrayListArray[4].get(i);
                }
                break;
            }
        }
        sGSXYData = new SGSXYData(dArray, dArray2, dArray3, dArray4, stringArray);
        return sGSXYData;
    }

    private SGSXYMultipleData createSXYMultipleData(String string) throws FileNotFoundException {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 2) {
            return null;
        }
        ArrayList[] arrayListArray = this.createListArray(string, n);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        SGSXYMultipleData sGSXYMultipleData = null;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)arrayListArray[0].get(i);
            Double d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[i] = d;
        }
        double[][] dArrayArray = new double[n - 1][];
        for (int i = 0; i < n - 1; ++i) {
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                String string3 = (String)arrayListArray[i + 1].get(j);
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return null;
                }
                dArrayArray[i][j] = d;
            }
        }
        sGSXYMultipleData = new SGSXYMultipleData(dArray, dArrayArray);
        return sGSXYMultipleData;
    }

    private SGSXYMultipleData createSXYSamplingData(String string, double d) throws FileNotFoundException {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 1) {
            return null;
        }
        ArrayList[] arrayListArray = this.createListArray(string, n);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        SGSXYSamplingData sGSXYSamplingData = null;
        Double d2 = null;
        String string2 = null;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                string2 = (String)arrayListArray[i].get(j);
                d2 = SGUtilityText.getDouble(string2);
                if (d2 == null) {
                    return null;
                }
                dArrayArray[i][j] = d2;
            }
        }
        sGSXYSamplingData = new SGSXYSamplingData(d, (double[][])dArrayArray);
        return sGSXYSamplingData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getColumnNumber(String string) throws FileNotFoundException {
        int n = -1;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            ArrayList arrayList = this.getFirstTokenList(bufferedReader);
            n = arrayList.size();
            Object var6_6 = null;
            if (bufferedReader == null) return n;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        return n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList[] createListArray(String var1_1, int var2_2) throws FileNotFoundException {
        block17: {
            block16: {
                block15: {
                    var3_3 = new ArrayList[var2_2];
                    for (var4_4 = 0; var4_4 < var3_3.length; ++var4_4) {
                        var3_3[var4_4] = new ArrayList<E>();
                    }
                    var4_5 = null;
                    try {
                        var4_5 = new BufferedReader(new FileReader(var1_1));
                        var5_6 = null;
                        while ((var5_6 = SGUtilityText.readLine(var4_5)) != null) {
                            var6_8 = new ArrayList<E>();
                            if (!SGUtilityText.tokenize(var5_6, var6_8)) {
                                var7_9 = null;
                                var11_12 = null;
                                if (var4_5 == null) return var7_9;
                                break block15;
                            }
                            if (var6_8.size() != var2_2) {
                                if (var6_8.size() == 0) continue;
                                var7_9 = null;
                                break block16;
                            }
                            var7_9 = new String[var2_2];
                            for (var8_10 = 0; var8_10 < var2_2; ++var8_10) {
                                var9_11 = (String)var6_8.get(var8_10);
                                var3_3[var8_10].add(var9_11);
                            }
                        }
                        break block17;
                    }
                    catch (Throwable var10_20) {
                        var11_15 = null;
                        if (var4_5 == null) throw var10_20;
                        try {
                            var4_5.close();
                            throw var10_20;
                        }
                        catch (IOException var12_19) {
                            // empty catch block
                        }
                        throw var10_20;
                    }
                }
                ** try [egrp 2[TRYBLOCK] [7 : 193->201)] { 
lbl45:
                // 1 sources

                var4_5.close();
                return var7_9;
lbl47:
                // 1 sources

                catch (IOException var12_16) {
                    // empty catch block
                }
                return var7_9;
            }
            var11_13 = null;
            if (var4_5 == null) return var7_9;
            ** try [egrp 2[TRYBLOCK] [7 : 193->201)] { 
lbl54:
            // 1 sources

            var4_5.close();
            return var7_9;
lbl56:
            // 1 sources

            catch (IOException var12_17) {
                // empty catch block
            }
            return var7_9;
        }
        var11_14 = null;
        if (var4_5 == null) return var3_3;
        try {}
        catch (IOException var12_18) {}
        var4_5.close();
        return var3_3;
        return var3_3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getFileTypeCandidateList(String string, ArrayList arrayList, ArrayList arrayList2) throws FileNotFoundException {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            ArrayList arrayList3 = this.getFirstTokenList(bufferedReader);
            int n = arrayList3.size();
            if (n == 2 || n == 3 || n == 5) {
                if (this.evaluateDataTypeSXY(arrayList3)) {
                    arrayList.add("SXY");
                }
            } else if (n == 4 && this.evaluateDataTypeSXY(arrayList3)) {
                arrayList.add("SXY");
            }
            if (n >= 2 && this.evaluateDataTypeSXYMultiple(arrayList3)) {
                arrayList.add("SXY_MULTIPLE");
            }
            if (n >= 1 && this.evaluateDataTypeSXYMultiple(arrayList3)) {
                arrayList.add("SXY_SAMPLING");
            }
            arrayList2.add(new Integer(n));
            Object var8_8 = null;
            if (bufferedReader == null) return true;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        return true;
    }

    private boolean evaluateDataTypeSXY(ArrayList arrayList) {
        int n = 0;
        if (arrayList.size() == 2 || arrayList.size() == 4) {
            n = arrayList.size();
        } else if (arrayList.size() == 3) {
            n = 2;
        } else if (arrayList.size() == 5) {
            n = 4;
        }
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            Double d = SGUtilityText.getDouble(string);
            if (d != null) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateDataTypeSXYMultiple(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            Double d = SGUtilityText.getDouble(string);
            if (d != null) continue;
            return false;
        }
        return true;
    }

    private ArrayList getFirstTokenList(BufferedReader bufferedReader) {
        String string;
        ArrayList arrayList = new ArrayList();
        while ((string = SGUtilityText.readLine(bufferedReader)) != null) {
            arrayList.clear();
            SGUtilityText.tokenize(string, arrayList);
            int n = arrayList.size();
            if (n == 0) continue;
            break;
        }
        return arrayList;
    }
}

