/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JDialog;
import javax.swing.text.JTextComponent;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;

public abstract class SGDialog
extends JDialog
implements ActionListener,
WindowListener,
ComponentListener,
SGIConstants {
    public static final String OK_BUTTON_TEXT = "OK";
    public static final String CANCEL_BUTTON_TEXT = "Cancel";
    public static final String YES_BUTTON_TEXT = "Yes";
    public static final String NO_BUTTON_TEXT = "No";
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private ArrayList mActionListenerList = new ArrayList();
    private int mCloseOption = -1;

    public SGDialog() {
        this.initialize();
    }

    public SGDialog(Dialog dialog) {
        super(dialog);
        this.initialize();
    }

    public SGDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initialize();
    }

    public SGDialog(Dialog dialog, String string) {
        super(dialog, string);
        this.initialize();
    }

    public SGDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.initialize();
    }

    public SGDialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(dialog, string, bl, graphicsConfiguration);
        this.initialize();
    }

    public SGDialog(Frame frame) {
        super(frame);
        this.initialize();
    }

    public SGDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initialize();
    }

    public SGDialog(Frame frame, String string) {
        super(frame, string);
        this.initialize();
    }

    public SGDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.initialize();
    }

    public SGDialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(frame, string, bl, graphicsConfiguration);
        this.initialize();
    }

    private boolean initialize() {
        this.setResizable(false);
        this.addComponentListener(this);
        this.addWindowListener(this);
        return true;
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        Window window = this.getOwner();
        if (window instanceof Window) {
            Window window2 = window;
            window2.repaint();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.mCloseOption = 1;
    }

    protected ActionEvent getActionEvent(String string) {
        return new ActionEvent(this, 0, string);
    }

    public void addActionListener(ActionListener actionListener) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        this.mActionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        for (int i = this.mActionListenerList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            this.mActionListenerList.remove(actionListener);
        }
    }

    protected void notifyToListener(String string) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.mActionListenerList.get(i);
            actionListener.actionPerformed(this.getActionEvent(string));
        }
    }

    public void setCenter(Window window) {
        SGUtility.setCenter(this, window);
    }

    protected Number getNumber(JTextComponent jTextComponent) {
        if (jTextComponent == null) {
            return null;
        }
        String string = jTextComponent.getText();
        Number number = null;
        try {
            NumberFormat numberFormat = NumberFormat.getInstance();
            number = numberFormat.parse(string);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return number;
    }

    public int getCloseOption() {
        return this.mCloseOption;
    }

    protected void setCloseOption(int n) {
        if (n != 0 & n != 1) {
            throw new IllegalArgumentException("num!=OK_OPTION & num!=CANCEL_OPTION");
        }
        this.mCloseOption = n;
    }
}

