/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.print.attribute.standard.MediaSize;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIImageExportManager;
import jp.riken.brain.ni.samuraigraph.base.SGIPaintable;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertySettingListener;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGToggleMenuItem;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGWindowDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SGDrawingWindow
extends JFrame
implements ComponentListener,
PropertyChangeListener,
MouseInputListener,
MouseWheelListener,
ActionListener,
AdjustmentListener,
WindowListener,
SGIUndoable,
SGIPropertySettingListener,
SGIConstants,
SGIRootObjectConstants {
    private int mID;
    private TreeMap mFigureMap = new TreeMap();
    private final JLayeredPane mLayeredPane = new JLayeredPane();
    private BackgroundPanel mBackgroundPanel;
    private ForegroundPanel mForegroundPanel;
    private RulerPanel mRulerPanel;
    private JScrollBar mHScrollBar = null;
    private JScrollBar mVScrollBar = null;
    private JComboBox mZoomComboBox = null;
    private JPanel mZoomComboBoxPanel = null;
    private JButton mCreateNewWindowButton = null;
    private JButton mDrawGraphButton = null;
    private JButton mLoadPropertyButton = null;
    private JButton mSavePropertyButton = null;
    private JButton mExportFormatButton = null;
    private JToggleButton mInsertBreakButton = null;
    private JButton mBoundingBoxButton = null;
    private JToggleButton mInsertLabelButton = null;
    private JToggleButton mInsertTimingLineButton = null;
    private JToggleButton mInsertSignificantDifferenceSymbolButton = null;
    private JToggleButton mLockFigureButton = null;
    private JButton mUndoButton = null;
    private JButton mRedoButton = null;
    private JButton mCutButton = null;
    private JButton mCopyButton = null;
    private JButton mPasteButton = null;
    private JButton mPrintButton = null;
    private JButton mHelpButton = null;
    private JPopupMenu mPopupMenu = new JPopupMenu();
    private SGWindowDialog mDialog = null;
    private SGIImageExportManager mImageExportManager;
    private final Dimension mTemporaryViewportSize = new Dimension();
    private float mMagnification = 1.0f;
    private JToolBar mToolBar = new JToolBar();
    private boolean mLockFigureFlag = false;
    public static final int LAYER_GRID_PANEL = 20;
    public static final int LAYER_FIGURE = 30;
    public static final int LAYER_ANCHOR_PANEL = 40;
    public static final int LAYER_RULER_PANEL = 50;
    public static final int MIN_MAGNIFICATION_VALUE = 10;
    public static final int MAX_MAGNIFICATION_VALUE = 400;
    public static final int[] MAGNIFICATION_ARRAY = new int[]{400, 300, 200, 150, 100, 75, 66, 50, 33, 25};
    private SGProperties mTemporaryProperties = null;
    private final SGTuple2f mPaperOrigin = new SGTuple2f();
    private final SGTuple2f mPaperSize = new SGTuple2f();
    private Rectangle2D mClientRect = null;
    public static final int MINIMAL_LENGTH_ORDER = -2;
    public static final String TITLE = "Samurai Graph";
    private ArrayList mCopiedFiguresList = new ArrayList();
    private ArrayList mCopiedObjectsList = new ArrayList();
    private ArrayList mCopiedDataObjectsList = new ArrayList();
    private ArrayList mCopiedDataNameList = new ArrayList();
    private ArrayList mCopiedDataPropertiesMapList = new ArrayList();
    private static final String SAMURAI_IMG_FILENAME = "Samurai.gif";
    private static final String NEW_WINDOW_ICON_FILENAME = "NewGraph.png";
    private static final String DRAW_GRAPH_ICON_FILENAME = "DrawGraph.png";
    private static final String LOAD_PROPERTY_ICON_FILENAME = "LoadProperty.png";
    private static final String SAVE_PROPERTY_ICON_FILENAME = "SaveGraph.png";
    private static final String EXPORT_IMAGE_ICON_FILENAME = "ExportImage.png";
    private static final String BOUNDING_BOX_ICON_FILENAME = "BoundingBox.png";
    private static final String INSERT_LABEL_ICON_FILENAME = "InsertString.png";
    private static final String INSERT_SIGDIFF_ICON_FILENAME = "InsertSig.png";
    private static final String INSERT_BREAK_ICON_FILENAME = "InsertBreak.png";
    private static final String INSERT_TIMING_ICON_FILENAME = "InsertTiming.png";
    private static final String LOCK_ICON_FILENAME = "LockFigure.png";
    private static final String UNLOCK_ICON_FILENAME = "UnlockFigure.png";
    private Dimension mMinimumWindowSize = new Dimension();
    protected boolean mRulerVisibleFlag = true;
    public static final float PAPER_MARGIN = 56.692917f;
    private boolean mViewportPressedFlag = false;
    protected final Point mTempMouseLocation = new Point();
    public static final String WINDOW_TITLE_PREFIX = "Samurai Graph - Window : ";
    private ArrayList mActionListenerList = new ArrayList();
    private boolean mPaperPortraitFlag = true;
    private ArrayList mPasteTargetList = new ArrayList();
    private final Rectangle2D mTempPaperRect = new Rectangle2D.Float();
    private boolean mChangedFlag = false;
    private Rectangle2D mTempRect = new Rectangle2D.Double();
    private int mCurrentStateCounter = 0;
    private int mWindowStateCounter = 0;
    private ArrayList mWindowPropertyHistoryList = new ArrayList();
    private ArrayList mUndoableObjectHistoryList = new ArrayList();
    private static final int PREVIEW = 0;
    private static final int EXPORT = 1;
    private static final int PRINT = 2;
    private int mPropertyFileCreationModeOfFigures;
    public static final int ALL_FIGURES = 0;
    public static final int FOCUSED_FIGURES_FOR_COPY = 1;
    public static final int FOCUSED_FIGURES_IN_BOUNDING_BOX = 2;
    public static final int FOCUSED_FIGURES_FOR_DUPLICATION = 3;

    public SGDrawingWindow() {
        this.setTitle(TITLE);
        this.create();
    }

    public String toString() {
        return new String("SGDrawingWindow:" + this.getID());
    }

    private Map loadImages() {
        String[] stringArray = new String[]{SAMURAI_IMG_FILENAME, NEW_WINDOW_ICON_FILENAME, DRAW_GRAPH_ICON_FILENAME, LOAD_PROPERTY_ICON_FILENAME, SAVE_PROPERTY_ICON_FILENAME, EXPORT_IMAGE_ICON_FILENAME, BOUNDING_BOX_ICON_FILENAME, INSERT_LABEL_ICON_FILENAME, INSERT_SIGDIFF_ICON_FILENAME, INSERT_BREAK_ICON_FILENAME, INSERT_TIMING_ICON_FILENAME, LOCK_ICON_FILENAME, UNLOCK_ICON_FILENAME};
        int n = stringArray.length;
        ImageIcon[] imageIconArray = new ImageIcon[n];
        for (int i = 0; i < n; ++i) {
            imageIconArray[i] = this.createIcon(stringArray[i]);
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        HashMap<String, ImageIcon> hashMap = new HashMap<String, ImageIcon>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(stringArray[i], imageIconArray[i]);
            mediaTracker.addImage(imageIconArray[i].getImage(), i);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return hashMap;
    }

    private boolean create() {
        Map map = this.loadImages();
        SwingUtilities.updateComponentTreeUI(this);
        ImageIcon imageIcon = (ImageIcon)map.get(SAMURAI_IMG_FILENAME);
        this.setIconImage(imageIcon.getImage());
        this.createPopupMenu();
        this.createPropertyDialog();
        this.createPreviewDialog();
        this.setJMenuBar(new JMenuBar());
        this.createMenuBar();
        this.getContentPane().add((Component)this.mLayeredPane, "Center");
        this.createToolBar(map);
        this.mLockFigureButton.setSelected(this.mLockFigureFlag);
        this.createBackgroundPanel();
        this.createForegroundPanel();
        this.createRulerPanel();
        this.createScrollBars();
        this.pack();
        this.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.mVScrollBar.addAdjustmentListener(this);
        this.mHScrollBar.addAdjustmentListener(this);
        this.updateItemsByFigureNumbers();
        this.updateGridItems();
        this.updatePaperItems();
        return true;
    }

    public boolean updateItemsByFigureNumbers() {
        boolean bl = this.getVisibleFigureListFromMap().size() != 0;
        this.mExportFormatButton.setEnabled(bl);
        this.mSavePropertyButton.setEnabled(bl);
        this.setInsertToggleItemsEnabled(bl);
        this.mBoundingBoxButton.setEnabled(bl);
        JMenuItem jMenuItem = this.getMenuItem("File", "Export as Image");
        jMenuItem.setEnabled(bl);
        jMenuItem = this.getMenuItem("File", "Save Property");
        jMenuItem.setEnabled(bl);
        jMenuItem = this.getMenuItem("File", "Print");
        jMenuItem.setEnabled(bl);
        jMenuItem = this.getMenuFromMenuBar("Layout");
        JMenu jMenu = this.getMenu((JMenu)jMenuItem, "Paper Size");
        JMenuItem jMenuItem2 = this.getMenuItem(jMenu, "Bounding Box");
        jMenuItem2.setEnabled(bl);
        jMenuItem = this.getMenuItem("Arrange", "Auto Arrangement");
        jMenuItem.setEnabled(bl);
        return true;
    }

    public boolean init() {
        float f = 566.92914f;
        float f2 = f / SGIConstants.GOLDEN_RATIO;
        this.setViewportSize(f, f2);
        int n = this.getInsets().left + this.mZoomComboBoxPanel.getX() + this.mZoomComboBoxPanel.getWidth();
        int n2 = this.getInsets().top + this.getJMenuBar().getHeight() + this.getToolBarHeight() + this.getRulerWidth();
        this.mMinimumWindowSize.setSize(n, n2);
        this.setComponentBounds();
        this.mClientRect = new Rectangle2D.Float();
        this.setPaperOrigin(0.0f, 0.0f);
        float f3 = SGDefaultValues.PAPER_WIDTH;
        float f4 = SGDefaultValues.PAPER_HEIGHT;
        this.setPaperSizeRoundingOut(f3, f4);
        this.updateClientRect();
        return true;
    }

    private boolean createPreviewDialog() {
        String string = "Preview : " + this.getID();
        return true;
    }

    private boolean createScrollBars() {
        ForegroundPanel foregroundPanel = this.mForegroundPanel;
        JScrollBar jScrollBar = new JScrollBar(1, 0, 100, 0, 100);
        JScrollBar jScrollBar2 = new JScrollBar(0, 0, 100, 0, 100);
        jScrollBar.setVisible(false);
        jScrollBar2.setVisible(false);
        foregroundPanel.setLayout(new BorderLayout());
        foregroundPanel.add((Component)jScrollBar, "East");
        foregroundPanel.add((Component)jScrollBar2, "South");
        int n = jScrollBar2.getMinimum();
        int n2 = jScrollBar2.getMaximum();
        int n3 = jScrollBar2.getVisibleAmount();
        jScrollBar2.setValue((n2 - n3 - n) / 2);
        n = jScrollBar.getMinimum();
        n2 = jScrollBar.getMaximum();
        n3 = jScrollBar.getVisibleAmount();
        jScrollBar.setValue((n2 - n3 - n) / 2);
        this.mHScrollBar = jScrollBar2;
        this.mVScrollBar = jScrollBar;
        return true;
    }

    private ImageIcon createIcon(String string) {
        URL uRL = this.getClass().getResource("/resources/" + string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon;
    }

    private boolean createToolBar(Map map) {
        this.mCreateNewWindowButton = this.createButtonInToolBar(map, NEW_WINDOW_ICON_FILENAME, "Create New Window");
        this.mDrawGraphButton = this.createButtonInToolBar(map, DRAW_GRAPH_ICON_FILENAME, "Draw Graph");
        this.mLoadPropertyButton = this.createButtonInToolBar(map, LOAD_PROPERTY_ICON_FILENAME, "Load Property");
        this.mSavePropertyButton = this.createButtonInToolBar(map, SAVE_PROPERTY_ICON_FILENAME, "Save Property");
        this.mExportFormatButton = this.createButtonInToolBar(map, EXPORT_IMAGE_ICON_FILENAME, "Export as Image");
        this.mBoundingBoxButton = this.createButtonInToolBar(map, BOUNDING_BOX_ICON_FILENAME, "Bounding Box");
        this.mInsertLabelButton = this.createToggleButtonInToolBar(map, INSERT_LABEL_ICON_FILENAME, "Insert Label");
        this.mInsertSignificantDifferenceSymbolButton = this.createToggleButtonInToolBar(map, INSERT_SIGDIFF_ICON_FILENAME, "Insert Significant Difference Symbol");
        this.mInsertBreakButton = this.createToggleButtonInToolBar(map, INSERT_BREAK_ICON_FILENAME, "Insert Axis Break Symbol");
        this.mInsertTimingLineButton = this.createToggleButtonInToolBar(map, INSERT_TIMING_ICON_FILENAME, "Insert Timing Line");
        this.mLockFigureButton = this.createToggleButtonInToolBar(map, UNLOCK_ICON_FILENAME, "Lock");
        this.createZoomComboBox();
        this.mZoomComboBoxPanel = new JPanel();
        this.mZoomComboBoxPanel.setLayout(new FlowLayout(0, 5, 6));
        this.mZoomComboBoxPanel.add(this.mZoomComboBox);
        JToolBar jToolBar = this.mToolBar;
        String string = SGUtility.getLookAndFeelID();
        if ("Windows".equals(string)) {
            jToolBar.setRollover(true);
        }
        jToolBar.add(this.mCreateNewWindowButton);
        jToolBar.add(this.mDrawGraphButton);
        jToolBar.add(this.mLoadPropertyButton);
        jToolBar.add(this.mSavePropertyButton);
        jToolBar.add(this.mExportFormatButton);
        jToolBar.add(this.mBoundingBoxButton);
        jToolBar.addSeparator();
        jToolBar.add(this.mInsertLabelButton);
        jToolBar.add(this.mInsertSignificantDifferenceSymbolButton);
        jToolBar.add(this.mInsertBreakButton);
        jToolBar.add(this.mInsertTimingLineButton);
        jToolBar.addSeparator();
        jToolBar.add(this.mLockFigureButton);
        jToolBar.addSeparator();
        jToolBar.add(this.mZoomComboBoxPanel);
        jToolBar.setOrientation(0);
        jToolBar.setFloatable(false);
        jToolBar.addPropertyChangeListener(this);
        this.setToolBar();
        this.mInsertLabelButton.addActionListener(this);
        this.mInsertTimingLineButton.addActionListener(this);
        this.mInsertSignificantDifferenceSymbolButton.addActionListener(this);
        this.mSavePropertyButton.addActionListener(this);
        this.mExportFormatButton.addActionListener(this);
        this.mDrawGraphButton.addActionListener(this);
        this.mLoadPropertyButton.addActionListener(this);
        this.mInsertBreakButton.addActionListener(this);
        this.mLockFigureButton.addActionListener(this);
        this.mCreateNewWindowButton.addActionListener(this);
        this.mBoundingBoxButton.addActionListener(this);
        return true;
    }

    private JButton createButtonInToolBar(Map map, String string, String string2) {
        ImageIcon imageIcon = (ImageIcon)map.get(string);
        imageIcon.getImage();
        JButton jButton = new JButton(imageIcon);
        jButton.setToolTipText(string2);
        return jButton;
    }

    private JToggleButton createToggleButtonInToolBar(Map map, String string, String string2) {
        ImageIcon imageIcon = (ImageIcon)map.get(string);
        JToggleButton jToggleButton = new JToggleButton(imageIcon);
        jToggleButton.setToolTipText(string2);
        return jToggleButton;
    }

    private boolean setToolBar() {
        this.getContentPane().remove(this.mToolBar);
        int n = this.mToolBar.getOrientation();
        if (n == 0) {
            this.getContentPane().add((Component)this.mToolBar, "North");
        } else if (n == 1) {
            this.getContentPane().add((Component)this.mToolBar, "West");
        }
        return true;
    }

    private int getToolBarHeight() {
        int n = 0;
        if (this.mToolBar.isVisible()) {
            n = this.mToolBar.getHeight();
        }
        return n;
    }

    private int getToolBarWidth() {
        int n = 0;
        if (this.mToolBar.isVisible()) {
            n = this.mToolBar.getWidth();
        }
        return n;
    }

    private boolean setLockToggleButton(boolean bl) {
        ImageIcon imageIcon = bl ? this.createIcon(LOCK_ICON_FILENAME) : this.createIcon(UNLOCK_ICON_FILENAME);
        if (imageIcon == null) {
            return false;
        }
        this.mLockFigureButton.setSelected(bl);
        this.mLockFigureButton.setIcon(imageIcon);
        return true;
    }

    protected boolean isInsertLabelButtonSelected() {
        return this.mInsertLabelButton.isSelected();
    }

    protected boolean isInsertTimingLineButtonSelected() {
        return this.mInsertTimingLineButton.isSelected();
    }

    protected boolean isInsertBreakButtonSelected() {
        return this.mInsertBreakButton.isSelected();
    }

    protected boolean isInsertSignificantDifferenceSymbolButtonSelected() {
        return this.mInsertSignificantDifferenceSymbolButton.isSelected();
    }

    private boolean createBackgroundPanel() {
        BackgroundPanel backgroundPanel = new BackgroundPanel(this);
        this.mLayeredPane.add(backgroundPanel);
        this.mLayeredPane.setLayer(backgroundPanel, 20);
        this.mBackgroundPanel = backgroundPanel;
        return true;
    }

    private boolean createZoomComboBox() {
        Dimension dimension;
        int n;
        JComboBox<Integer> jComboBox;
        this.mZoomComboBox = jComboBox = new JComboBox<Integer>();
        Integer[] integerArray = new Integer[MAGNIFICATION_ARRAY.length];
        for (n = 0; n < integerArray.length; ++n) {
            integerArray[n] = new Integer(MAGNIFICATION_ARRAY[n]);
        }
        for (n = 0; n < MAGNIFICATION_ARRAY.length; ++n) {
            jComboBox.addItem(integerArray[n]);
        }
        jComboBox.setEditable(true);
        jComboBox.setToolTipText("Zoom");
        jComboBox.setFont(new Font("Dialog", 1, 12));
        String string = SGUtility.getLookAndFeelID();
        if (!"Aqua".equals(string) & !"Windows".equals(string)) {
            dimension = new Dimension(120, 25);
            jComboBox.setBackground(Color.WHITE);
            jComboBox.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            dimension = new Dimension(120, 22);
        }
        jComboBox.setPreferredSize(dimension);
        this.setDefaultZoom();
        jComboBox.addActionListener(this);
        return true;
    }

    private boolean createForegroundPanel() {
        ForegroundPanel foregroundPanel = new ForegroundPanel(this);
        this.mLayeredPane.add((Component)foregroundPanel, "Center");
        this.mLayeredPane.setLayer(foregroundPanel, 40);
        this.mForegroundPanel = foregroundPanel;
        return true;
    }

    private boolean createRulerPanel() {
        RulerPanel rulerPanel = new RulerPanel(this);
        this.mLayeredPane.add(rulerPanel);
        this.mLayeredPane.setLayer(rulerPanel, 50);
        this.mRulerPanel = rulerPanel;
        return true;
    }

    public int getRulerWidth() {
        int n = 0;
        if (this.mRulerVisibleFlag) {
            n = 20;
        }
        return n;
    }

    private boolean createPopupMenu() {
        JPopupMenu jPopupMenu = this.mPopupMenu;
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Window --"));
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Paste");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Property");
        return true;
    }

    private boolean createPropertyDialog() {
        this.mDialog = new SGWindowDialog((Frame)this, true);
        return true;
    }

    public int getID() {
        return this.mID;
    }

    public boolean setID(int n) {
        this.mID = n;
        return true;
    }

    public boolean isGridVisible() {
        return this.mBackgroundPanel.isGridVisible();
    }

    public float getGridLineWidth() {
        return this.mBackgroundPanel.getGridLineWidth();
    }

    public float getGridInterval() {
        return this.mBackgroundPanel.getGridInterval();
    }

    public Color getGridLineColor() {
        return this.mBackgroundPanel.getGridLineColor();
    }

    public void setGridLineWidth(float f) {
        this.mBackgroundPanel.setGridLineWidth(f);
    }

    public void setGridLineColor(Color color) {
        this.mBackgroundPanel.setGridLineColor(color);
    }

    public boolean setBackgroundColor(Color color) {
        if (this.mBackgroundPanel == null) {
            return false;
        }
        this.mBackgroundPanel.setPaperColor(color);
        return true;
    }

    public void setGridVisible(boolean bl) {
        this.mBackgroundPanel.setGridVisible(bl);
    }

    public void setGridInterval(float f) {
        this.mBackgroundPanel.setGridInterval(f);
    }

    public Color getPaperColor() {
        return this.mBackgroundPanel.getPaperColor();
    }

    static float getAnchorSize() {
        return 6.0f;
    }

    public int getCurrentFigureId() {
        return this.mFigureMap.size() + 1;
    }

    public int getTopWidth() {
        Insets insets = this.getInsets();
        int n = insets.top;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n2 = jMenuBar.getHeight();
        int n3 = 0;
        if (this.mToolBar.getOrientation() == 0) {
            n3 = this.getToolBarHeight();
        }
        int n4 = n + n2 + n3;
        return n4;
    }

    public int getBottomWidth() {
        Insets insets = this.getInsets();
        int n = insets.bottom;
        return n;
    }

    public int getLeftWidth() {
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = 0;
        if (this.mToolBar.getOrientation() == 1) {
            n2 = this.getToolBarWidth();
        }
        return n + n2;
    }

    public int getRightWidth() {
        Insets insets = this.getInsets();
        int n = insets.right;
        return n;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public float getMagnificationPercent() {
        return this.mMagnification * 100.0f;
    }

    public void setImageFileCreator(SGIImageExportManager sGIImageExportManager) {
        this.mImageExportManager = sGIImageExportManager;
    }

    public TreeMap getFigureMap() {
        return this.mFigureMap;
    }

    public boolean addFigure(int n, SGFigure sGFigure) {
        this.addFigure_(n, sGFigure);
        return true;
    }

    public boolean addFigure(int n, SGFigure sGFigure, Point point) {
        this.addFigure_(n, sGFigure);
        Point2D point2D = this.getLocationOnFigure(point);
        sGFigure.setGraphRectLocation((float)point2D.getX(), (float)point2D.getY());
        return true;
    }

    private boolean addFigure_(int n, SGFigure sGFigure) {
        sGFigure.setID(n);
        this.mFigureMap.put(new Integer(n), sGFigure);
        this.mLayeredPane.setLayer(sGFigure, 30);
        this.mLayeredPane.add(sGFigure);
        SGTuple2f sGTuple2f = this.getViewportSize();
        int n2 = this.getRulerWidth();
        sGFigure.setLocation(n2, n2);
        sGFigure.setSize((int)sGTuple2f.x, (int)sGTuple2f.y);
        SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].setISize(new SGTuple2f(sGTuple2f.x, sGTuple2f.y));
        }
        sGFigure.setViewBounds();
        this.zoom(this.mMagnification);
        this.updateItemsByFigureNumbers();
        return true;
    }

    public SGFigure[] getFigureArrayFromMap() {
        SGFigure[] sGFigureArray = new SGFigure[this.mFigureMap.size()];
        Iterator iterator = this.mFigureMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            sGFigureArray[n] = (SGFigure)iterator.next();
            ++n;
        }
        return sGFigureArray;
    }

    public ArrayList getFigureListFromLayer() {
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>(Arrays.asList(this.getFigureArrayFromLayer()));
        return arrayList;
    }

    public ArrayList getFigureListFromMap() {
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>(Arrays.asList(this.getFigureArrayFromMap()));
        return arrayList;
    }

    public SGFigure[] getFigureArrayFromLayer() {
        Component[] componentArray = this.mLayeredPane.getComponentsInLayer(30);
        SGFigure[] sGFigureArray = new SGFigure[componentArray.length];
        for (int i = 0; i < sGFigureArray.length; ++i) {
            sGFigureArray[i] = (SGFigure)componentArray[i];
        }
        return sGFigureArray;
    }

    public ArrayList getVisibleFigureListFromMap() {
        SGFigure[] sGFigureArray = this.getFigureArrayFromMap();
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible()) continue;
            arrayList.add(sGFigureArray[i]);
        }
        return arrayList;
    }

    public ArrayList getVisibleFigureListFromLayer() {
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible()) continue;
            arrayList.add(sGFigureArray[i]);
        }
        return arrayList;
    }

    public boolean drawBackAllVisibleFigures() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (this.drawBackFigure(sGFigure)) continue;
            return false;
        }
        return true;
    }

    public boolean drawBackFigure(SGFigure sGFigure) {
        return sGFigure.drawbackFigure();
    }

    public void moveToBack(SGFigure sGFigure) {
        this.move(sGFigure, false);
    }

    public void moveToFront(SGFigure sGFigure) {
        this.move(sGFigure, true);
    }

    private void move(SGFigure sGFigure, boolean bl) {
        JLayeredPane jLayeredPane = this.mLayeredPane;
        if (bl) {
            jLayeredPane.moveToFront(sGFigure);
        } else {
            jLayeredPane.moveToBack(sGFigure);
        }
    }

    public SGFigure getFigure(int n) {
        return (SGFigure)this.mFigureMap.get(new Integer(n));
    }

    protected boolean hideFigure(SGFigure sGFigure) {
        sGFigure.setVisible(false);
        sGFigure.setChanged(true);
        return true;
    }

    public boolean clearFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
            sGISelectable.setSelected(false);
        }
        return true;
    }

    public ArrayList getFocusedObjectsList() {
        ArrayList arrayList = new ArrayList();
        this.getFocusedObjectsList(arrayList);
        return arrayList;
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList2.get(i);
            if (!sGISelectable.isSelected()) continue;
            arrayList.add(sGISelectable);
        }
        return true;
    }

    public ArrayList getCopiedFiguresList() {
        return new ArrayList(this.mCopiedFiguresList);
    }

    public boolean hideSelectedObjects() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.isSelected()) {
                this.hideFigure(sGFigure);
                continue;
            }
            if (sGFigure.hideSelectedObjects()) continue;
            return false;
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
            this.clearFocusedObjects();
            this.updateItemsByFigureNumbers();
        }
        return true;
    }

    protected void setSelectionSymbolsVisible(boolean bl) {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.setSelectionSymbolsVisible(bl);
        }
    }

    public boolean removeFigure(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (this.removeFigure(sGFigure)) continue;
            return false;
        }
        return true;
    }

    protected boolean removeFigure(SGFigure sGFigure) {
        if (sGFigure == null) {
            return false;
        }
        this.mFigureMap.remove(new Integer(sGFigure.getID()));
        this.mLayeredPane.remove(sGFigure);
        return true;
    }

    protected boolean setFigureVisible(SGFigure sGFigure, boolean bl) {
        if (sGFigure == null) {
            return false;
        }
        sGFigure.setVisible(bl);
        this.setFocusedFigure(sGFigure, false);
        return true;
    }

    public boolean clearAllFocusedObjectsInFigures() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.clearFocusedObjects()) continue;
            return false;
        }
        return this.clearFocusedFigures();
    }

    public boolean clearFocusedFigures() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            this.setFocusedFigure(sGFigure, false);
        }
        return true;
    }

    public boolean setFocusedFigure(SGFigure sGFigure, boolean bl) {
        sGFigure.setSelected(bl);
        sGFigure.setSymbolsVisibleAroundAllObjects(bl);
        return true;
    }

    public Point2D getLocationOnFigure(int n, int n2) {
        int n3 = this.getRulerWidth();
        float f = n - this.getLeftWidth() - n3;
        float f2 = n2 - this.getTopWidth() - n3;
        return new Point2D.Float(f, f2);
    }

    public Point2D getLocationOnFigure(Point point) {
        return this.getLocationOnFigure(point.x, point.y);
    }

    protected boolean setScrollValue(JScrollBar jScrollBar, double d) {
        int n = jScrollBar.getMinimum();
        int n2 = jScrollBar.getMaximum();
        int n3 = jScrollBar.getVisibleAmount();
        int n4 = n2 - n - n3;
        double d2 = d * (double)n4;
        jScrollBar.setValue((int)d2);
        return true;
    }

    protected float getScrollValue(JScrollBar jScrollBar) {
        int n;
        int n2 = jScrollBar.getMinimum();
        int n3 = jScrollBar.getMaximum();
        if (n3 - n2 - (n = jScrollBar.getVisibleAmount()) == 0) {
            return 0.0f;
        }
        float f = (float)jScrollBar.getValue() / (float)(n3 - n2 - n);
        return f;
    }

    protected float getHScrollValue() {
        return this.getScrollValue(this.mHScrollBar);
    }

    protected float getVScrollValue() {
        return this.getScrollValue(this.mVScrollBar);
    }

    private boolean setScrollBarValue() {
        if (this.mHScrollBar.isVisible()) {
            this.setScrollBarValue(true);
        }
        if (this.mVScrollBar.isVisible()) {
            this.setScrollBarValue(false);
        }
        return true;
    }

    private boolean setScrollBarValue(boolean bl) {
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getViewportBounds();
        JScrollBar jScrollBar = null;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (bl) {
            jScrollBar = this.mHScrollBar;
            f = (float)rectangle2D.getWidth();
            f2 = (float)rectangle2D.getX();
            f3 = (float)rectangle2D2.getWidth();
        } else {
            jScrollBar = this.mVScrollBar;
            f = (float)rectangle2D.getHeight();
            f2 = (float)rectangle2D.getY();
            f3 = (float)rectangle2D2.getHeight();
        }
        int n = jScrollBar.getMinimum();
        int n2 = jScrollBar.getMaximum();
        int n3 = (int)(f3 / f * (float)(n2 - n));
        jScrollBar.setVisibleAmount(n3);
        float f4 = -f2 / (f - f3);
        int n4 = n + (int)(f4 * (float)(n2 - n3 - n));
        jScrollBar.setValue(n4);
        jScrollBar.setBlockIncrement(n3);
        return true;
    }

    public SGTuple2f getViewportSize() {
        SGTuple2f sGTuple2f = this.getPaneSize();
        int n = this.getRulerWidth();
        sGTuple2f.x -= (float)n;
        sGTuple2f.y -= (float)n;
        return sGTuple2f;
    }

    public SGTuple2f getPaneSize() {
        Insets insets = this.getInsets();
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n5 = jMenuBar.getHeight();
        int n6 = this.getToolBarHeight();
        float f = this.getWidth() - (n3 + n4);
        float f2 = this.getHeight() - (n + n2 + n5 + n6);
        SGTuple2f sGTuple2f = new SGTuple2f(f, f2);
        return sGTuple2f;
    }

    public boolean setPaperOrigin(float f, float f2) {
        Rectangle2D rectangle2D = this.getClientRect();
        float f3 = this.mMagnification;
        float f4 = (f - (float)rectangle2D.getX()) / f3;
        float f5 = (f2 - (float)rectangle2D.getY()) / f3;
        this.mPaperOrigin.setValues(f4, f5);
        return true;
    }

    public boolean setPaperSize(float f, float f2) {
        this.setPaperSizeRoundingOut(f, f2);
        return true;
    }

    public float getPaperX() {
        Rectangle2D rectangle2D = this.getClientRect();
        return (float)rectangle2D.getX() + this.mMagnification * this.mPaperOrigin.x;
    }

    public float getPaperY() {
        Rectangle2D rectangle2D = this.getClientRect();
        return (float)rectangle2D.getY() + this.mMagnification * this.mPaperOrigin.y;
    }

    public float getPaperWidth() {
        return this.mMagnification * this.mPaperSize.x;
    }

    public float getPaperHeight() {
        return this.mMagnification * this.mPaperSize.y;
    }

    public Rectangle2D getPaperRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getPaperX(), this.getPaperY(), this.getPaperWidth(), this.getPaperHeight());
        return float_;
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float f = this.mMagnification * 56.692917f;
        Rectangle2D rectangle2D = this.getPaperRect();
        ((Rectangle2D)float_).setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + (double)f, rectangle2D.getHeight() + (double)f);
        return float_;
    }

    public boolean setViewportSize(float f, float f2) {
        this.mTemporaryViewportSize.setSize(f, f2);
        Insets insets = this.getInsets();
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n5 = jMenuBar.getHeight();
        int n6 = this.getToolBarHeight();
        int n7 = this.getRulerWidth();
        float f3 = f + (float)n3 + (float)n4 + (float)n7;
        float f4 = f2 + (float)n + (float)n2 + (float)n5 + (float)n6 + (float)n7;
        this.setSize((int)f3, (int)f4);
        return true;
    }

    protected boolean setComponentBounds() {
        SGTuple2f sGTuple2f = this.getPaneSize();
        int n = (int)sGTuple2f.x;
        int n2 = (int)sGTuple2f.y;
        int n3 = this.getRulerWidth();
        this.mLayeredPane.setSize(n, n2);
        this.mRulerPanel.setBounds(0, 0, n, n2);
        this.mForegroundPanel.setBounds(n3, n3, n - n3, n2 - n3);
        this.mForegroundPanel.setPreferredSize(new Dimension(n - n3, n2 - n3));
        this.mForegroundPanel.validate();
        this.mBackgroundPanel.setBounds(n3, n3, n - n3, n2 - n3);
        return true;
    }

    private boolean onResized() {
        if (this.getClientRect() == null) {
            return false;
        }
        this.setComponentBounds();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x / (float)this.mTemporaryViewportSize.width;
        float f2 = sGTuple2f.y / (float)this.mTemporaryViewportSize.height;
        this.updateClientRect();
        SGTuple2f sGTuple2f2 = this.getViewportSize();
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.recordFigureRect();
            sGFigure.setSize(sGTuple2f2);
            sGFigure.setViewBounds();
        }
        if (this.mLockFigureFlag) {
            Rectangle2D rectangle2D = this.getPaperRect();
            float f3 = f * (float)rectangle2D.getWidth() / this.mMagnification;
            float f4 = f2 * (float)rectangle2D.getHeight() / this.mMagnification;
            this.setPaperSizeRoundingOut(f3, f4);
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.recordFigureRect();
                sGFigure.resize(f, f2);
                sGFigure.setChanged(true);
            }
            this.updateClientRect();
            this.setChanged(true);
            this.notifyToRoot();
        }
        this.mTemporaryViewportSize.setSize(sGTuple2f.x, sGTuple2f.y);
        this.zoomWithBoundingBox();
        return true;
    }

    public boolean setZoom(Number number) {
        this.mZoomComboBox.setSelectedItem(number);
        this.updateZoomItems();
        return true;
    }

    private boolean setDefaultZoom() {
        return this.setZoom(new Integer(100));
    }

    private boolean onZoomed() {
        float f = 0.0f;
        try {
            Object object = this.mZoomComboBox.getSelectedItem();
            f = Float.valueOf(object.toString()).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            this.setZoom(new Float(this.getMagnificationPercent()));
            return false;
        }
        if ((double)f < 0.0) {
            this.setZoom(new Float(this.getMagnificationPercent()));
            return false;
        }
        if (f < 10.0f) {
            this.setZoom(new Integer(10));
        }
        if (f > 400.0f) {
            this.setZoom(new Integer(400));
        }
        return this.zoom(f / 100.0f);
    }

    private boolean zoom(float f) {
        this.mMagnification = f;
        SGFigure[] sGFigureArray = this.getFigureArrayFromMap();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (sGFigureArray[i].zoom(this.mMagnification)) continue;
            throw new Error();
        }
        this.mRulerPanel.setMagnification(f);
        this.mBackgroundPanel.setMagnification(f);
        this.mForegroundPanel.setMagnification(f);
        this.updateClientRect();
        this.getContentPane().repaint();
        return true;
    }

    public boolean setFigureBoundingBox(int n) {
        Object object;
        if (n != 0 && n != 1 && n != 2) {
            return false;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        ArrayList arrayList2 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (SGFigure)arrayList2.get(i);
            arrayList.add(((SGFigure)object).getBoundingBox());
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        if (rectangle2D == null) {
            return false;
        }
        object = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getPaperRect();
        float f = (float)rectangle2D2.getWidth();
        float f2 = (float)rectangle2D2.getHeight();
        float f3 = this.mMagnification;
        if (n == 0 || n == 1) {
            f = (float)(-((RectangularShape)object).getX() + rectangle2D.getX() + rectangle2D.getWidth()) / f3;
        }
        if (n == 0 || n == 2) {
            f2 = (float)(-((RectangularShape)object).getY() + rectangle2D.getY() + rectangle2D.getHeight()) / f3;
        }
        this.setPaperSizeRoundingOut(f, f2);
        this.updateClientRect();
        return true;
    }

    public Rectangle2D getBoundingBoxOfFigures(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return new Rectangle2D.Float();
        }
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure == null) continue;
            Rectangle2D rectangle2D = sGFigure.getBoundingBox();
            if (rectangle2D == null) {
                return null;
            }
            arrayList2.add(rectangle2D);
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList2);
        return rectangle2D;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        Object object = adjustmentEvent.getSource();
        if (object instanceof JScrollBar) {
            JScrollBar jScrollBar = (JScrollBar)object;
            if (jScrollBar.equals(this.mHScrollBar)) {
                this.setClientRectByValueOfScrollBar(true);
            } else if (jScrollBar.equals(this.mVScrollBar)) {
                this.setClientRectByValueOfScrollBar(false);
            }
            this.updateGraphRectOfAllFigures();
            this.getContentPane().repaint();
        }
    }

    private boolean setClientRectByValueOfScrollBar(boolean bl) {
        JScrollBar jScrollBar = null;
        jScrollBar = bl ? this.mHScrollBar : this.mVScrollBar;
        float f = this.getScrollValue(jScrollBar);
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getViewportBounds();
        float f2 = (float)rectangle2D.getX();
        float f3 = (float)rectangle2D.getY();
        float f4 = (float)rectangle2D.getWidth();
        float f5 = (float)rectangle2D.getHeight();
        float f6 = (float)rectangle2D2.getWidth();
        float f7 = (float)rectangle2D2.getHeight();
        if (bl) {
            float f8 = f4 - f6;
            float f9 = -f * f8;
            this.setClientRect(f9, f3, f4, f5);
        } else {
            float f10 = f5 - f7;
            float f11 = -f * f10;
            this.setClientRect(f2, f11, f4, f5);
        }
        return true;
    }

    public Component getComponent(int n, int n2) {
        Container container = this;
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            Point point;
            Rectangle2D rectangle2D;
            if (!sGFigureArray[i].isVisible() || !(rectangle2D = sGFigureArray[i].getGraphRect()).contains(point = this.getLocationInPane(n, n2))) continue;
            container = sGFigureArray[i];
            break;
        }
        return container;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        Object object2 = propertyChangeEvent.getOldValue();
        Object object3 = propertyChangeEvent.getNewValue();
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.getWidth() < this.mMinimumWindowSize.width) {
            this.setSize(this.mMinimumWindowSize.width, this.getHeight());
            return;
        }
        if (this.getHeight() < this.mMinimumWindowSize.height) {
            this.setSize(this.getWidth(), this.mMinimumWindowSize.height);
            return;
        }
        this.onResized();
    }

    private int getTopShift() {
        return this.getTopWidth() + this.getRulerWidth();
    }

    private int getLeftShift() {
        return this.getLeftWidth() + this.getRulerWidth();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.getLeftShift();
        int n2 = this.getTopShift();
        mouseEvent.translatePoint(-n, -n2);
        if (this.clickFigures(mouseEvent)) {
            this.updateDataItem();
            this.updateFocusedObjectItem();
            return;
        }
        mouseEvent.translatePoint(n, n2);
        this.onMouseClicked(mouseEvent);
        this.updateDataItem();
        this.updateFocusedObjectItem();
    }

    protected boolean onMouseClicked(MouseEvent mouseEvent) {
        this.clearAllFocusedObjectsInFigures();
        this.setDefaultCursor();
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
            this.showPropertyDialog();
        }
        if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
            this.mPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
        return true;
    }

    private boolean showPropertyDialog() {
        SGWindowDialog sGWindowDialog = this.mDialog;
        sGWindowDialog.addPropertySettingListener(this);
        sGWindowDialog.setLocation(this.getLocation());
        this.setDialogProperty();
        sGWindowDialog.setColorButtonBorder(true);
        this.createTemporaryPropertyObject();
        sGWindowDialog.setVisible(true);
        sGWindowDialog.removeAllPropertySettingListeners();
        return true;
    }

    protected boolean clickFigures(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleFigureListFromLayer();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (!sGFigure.onMouseClicked(mouseEvent)) continue;
            return true;
        }
        return false;
    }

    protected boolean onMouseReleasedToFigure(MouseEvent mouseEvent) {
        JComponent jComponent;
        int n;
        ArrayList arrayList = this.getVisibleFigureListFromLayer();
        if (arrayList.size() == 0) {
            return true;
        }
        AbstractButton abstractButton = null;
        ArrayList arrayList2 = this.getInsertToggleButtonList();
        for (n = 0; n < arrayList2.size(); ++n) {
            jComponent = (AbstractButton)arrayList2.get(n);
            if (!((AbstractButton)jComponent).isSelected()) continue;
            abstractButton = jComponent;
            break;
        }
        if (abstractButton != null) {
            String string = null;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.onMouseReleased(mouseEvent);
                if (!sGFigure.onToggleSelected(mouseEvent)) continue;
                this.setDefaultCursor();
                this.setInsertToggleItemsUnselected();
                return true;
            }
            string = this.mInsertLabelButton.isSelected() | this.mInsertBreakButton.isSelected() | this.mInsertSignificantDifferenceSymbolButton.isSelected() ? "Click the figure." : (this.mInsertTimingLineButton.isSelected() ? "Click the axis line." : "Failed to add a symbol.");
            SGUtility.showMessageDialog(this, string, "Error", 2);
        } else {
            SGFigure sGFigure;
            int n2;
            for (n = 0; n < arrayList.size(); ++n) {
                jComponent = (SGFigure)arrayList.get(n);
                ((SGFigure)jComponent).onMouseReleased(mouseEvent);
            }
            ArrayList arrayList3 = this.getFocusedObjectsList();
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                sGFigure = (SGFigure)arrayList3.get(n2);
                if (!sGFigure.isFigureMoved()) continue;
                sGFigure.setChanged(true);
            }
            arrayList3 = this.getVisibleFigureListFromMap();
            for (n2 = 0; n2 < arrayList3.size(); ++n2) {
                sGFigure = (SGFigure)arrayList3.get(n2);
                SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
                for (int i = 0; i < sGIFigureElementArray.length; ++i) {
                    sGIFigureElementArray[i].setChangedFocusedObjects();
                }
            }
            this.updateClientRect();
            this.notifyToRoot();
        }
        return true;
    }

    protected boolean pressFigures(MouseEvent mouseEvent) {
        SGFigure[] sGFigureArray = this.getFigureArrayFromLayer();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (!sGFigureArray[i].isVisible() || !sGFigureArray[i].onMousePressed(mouseEvent)) continue;
            return true;
        }
        return false;
    }

    protected void onMouseDraggedOnFigures(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleFigureListFromLayer();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.onMouseDragged(mouseEvent)) continue;
            return;
        }
    }

    public boolean translateFocusedObjects(int n, int n2) {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.isSelected()) {
                sGFigure.translate(n, n2);
                continue;
            }
            sGFigure.translateSelectedObjects(n, n2);
        }
        return true;
    }

    protected boolean moveFocusedObjects(int n, int n2) {
        int n3 = n - this.mTempMouseLocation.x;
        int n4 = n2 - this.mTempMouseLocation.y;
        this.translateFocusedObjects(n3, n4);
        this.mTempMouseLocation.setLocation(this.mTempMouseLocation.x + n3, this.mTempMouseLocation.y + n4);
        return true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.getViewportBoundsInComponent().contains(mouseEvent.getPoint())) {
            return;
        }
        this.mViewportPressedFlag = true;
        int n = this.getLeftWidth();
        int n2 = this.getTopWidth();
        mouseEvent.translatePoint(-n, -n2);
        if (this.mRulerPanel.pressed(mouseEvent)) {
            return;
        }
        mouseEvent.translatePoint(n, n2);
        n = this.getLeftShift();
        n2 = this.getTopShift();
        mouseEvent.translatePoint(-n, -n2);
        this.mTempMouseLocation.setLocation(mouseEvent.getPoint());
        if (this.pressFigures(mouseEvent)) {
            return;
        }
        mouseEvent.translatePoint(n, n2);
        this.onMousePressed(mouseEvent);
    }

    protected boolean onMousePressed(MouseEvent mouseEvent) {
        this.clearAllFocusedObjectsInFigures();
        return true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.mViewportPressedFlag) {
            return;
        }
        if (this.mRulerPanel.isPressed()) {
            int n = this.getLeftWidth();
            int n2 = this.getTopWidth();
            mouseEvent.translatePoint(-n, -n2);
            this.mRulerPanel.released(mouseEvent);
            mouseEvent.translatePoint(n, n2);
        } else {
            int n = this.getLeftShift();
            int n3 = this.getTopShift();
            mouseEvent.translatePoint(-n, -n3);
            this.onMouseReleasedToFigure(mouseEvent);
            mouseEvent.translatePoint(n, n3);
        }
        this.getContentPane().repaint();
        this.mViewportPressedFlag = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.mViewportPressedFlag) {
            return;
        }
        if (this.mRulerPanel.isPressed()) {
            int n = this.getLeftWidth();
            int n2 = this.getTopWidth();
            mouseEvent.translatePoint(-n, -n2);
            this.mRulerPanel.dragged(mouseEvent);
            mouseEvent.translatePoint(n, n2);
        } else {
            int n = this.getLeftShift();
            int n3 = this.getTopShift();
            mouseEvent.translatePoint(-n, -n3);
            this.onMouseDraggedOnFigures(mouseEvent);
            mouseEvent.translatePoint(n, n3);
        }
        this.onMouseMovedOrDragged(mouseEvent);
        this.getContentPane().repaint();
    }

    protected void onMouseMovedOnFigures(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleFigureListFromLayer();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (!sGFigure.onMouseMoved(mouseEvent)) continue;
            return;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.getLeftShift();
        int n2 = this.getTopShift();
        mouseEvent.translatePoint(-n, -n2);
        this.onMouseMovedOnFigures(mouseEvent);
        mouseEvent.translatePoint(n, n2);
        this.onMouseMovedOrDragged(mouseEvent);
    }

    private void onMouseMovedOrDragged(MouseEvent mouseEvent) {
        Point point = this.getLocationInPane(mouseEvent.getX(), mouseEvent.getY());
        int n = point.x;
        int n2 = point.y;
        if (n < 0 || n2 < 0) {
            return;
        }
        this.setPositionLabel(n, n2);
    }

    private Point getLocationInPane(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Insets insets = this.getInsets();
        int n5 = insets.top;
        int n6 = insets.bottom;
        int n7 = insets.left;
        int n8 = insets.right;
        n3 -= n7;
        n4 -= n5;
        JMenuBar jMenuBar = this.getJMenuBar();
        double d = jMenuBar.getHeight();
        n4 = (int)((double)n4 - d);
        n4 -= this.getToolBarHeight();
        double d2 = this.getRulerWidth();
        n3 = (int)((double)n3 - d2);
        n4 = (int)((double)n4 - d2);
        return new Point(n3, n4);
    }

    protected boolean notifyPosition(Component component, int n, int n2) {
        Insets insets = this.getInsets();
        int n3 = insets.top;
        int n4 = insets.bottom;
        int n5 = insets.left;
        int n6 = insets.right;
        int n7 = n + component.getX();
        int n8 = n2 + component.getY();
        n8 += n3;
        JMenuBar jMenuBar = this.getJMenuBar();
        n8 -= jMenuBar.getHeight();
        int n9 = this.getRulerWidth();
        if ((n7 -= n9) < 0 || (n8 -= n9) < 0) {
            return true;
        }
        this.setPositionLabel(n7, n8);
        return true;
    }

    private boolean setPositionLabel(int n, int n2) {
        Rectangle2D rectangle2D = this.getClientRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        DecimalFormat decimalFormat = new DecimalFormat("0.0");
        float f3 = 0.035277776f / this.mMagnification;
        float f4 = (-f + (float)n) * f3;
        float f5 = (-f2 + (float)n2) * f3;
        String string = "(" + decimalFormat.format(f4) + ", " + decimalFormat.format(f5) + ")";
        String string2 = WINDOW_TITLE_PREFIX + this.getID() + "  " + string;
        this.setTitle(string2);
        return true;
    }

    public void addActionListener(ActionListener actionListener) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        this.mActionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        for (int i = this.mActionListenerList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            this.mActionListenerList.remove(actionListener);
        }
    }

    public void notifyToListener(String string) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.mActionListenerList.get(i);
            actionListener.actionPerformed(this.getActionEvent(string));
        }
    }

    private ActionEvent getActionEvent(String string) {
        return new ActionEvent(this, 0, string);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        Object object = windowEvent.getSource();
        if (object.equals(this.mDialog)) {
            this.cancel();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        JScrollBar jScrollBar = this.mVScrollBar;
        int n = mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation();
        int n2 = jScrollBar.getValue() + n;
        jScrollBar.setValue(n2);
    }

    public boolean createTemporaryPropertyObject() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    protected ArrayList getInsertToggleButtonList() {
        ArrayList<JToggleButton> arrayList = new ArrayList<JToggleButton>(Arrays.asList(this.getInsertToggleButtonArray()));
        return arrayList;
    }

    protected ArrayList getInsertMenuCommandList() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.getInsertMenuCommandArray()));
        return arrayList;
    }

    protected JToggleButton[] getInsertToggleButtonArray() {
        JToggleButton[] jToggleButtonArray = new JToggleButton[]{this.mInsertLabelButton, this.mInsertSignificantDifferenceSymbolButton, this.mInsertBreakButton, this.mInsertTimingLineButton};
        return jToggleButtonArray;
    }

    protected String[] getInsertMenuCommandArray() {
        String[] stringArray = new String[]{"Label", "Significant Difference", "Axis Break", "Timing Line"};
        return stringArray;
    }

    protected JToggleButton getInsertToggleButton(String string) {
        ArrayList arrayList = this.getInsertMenuCommandList();
        int n = arrayList.indexOf(string);
        JToggleButton[] jToggleButtonArray = this.getInsertToggleButtonArray();
        return jToggleButtonArray[n];
    }

    protected String getInsertCommand(JToggleButton jToggleButton) {
        ArrayList arrayList = this.getInsertToggleButtonList();
        int n = arrayList.indexOf(jToggleButton);
        String[] stringArray = this.getInsertMenuCommandArray();
        return stringArray[n];
    }

    protected boolean setInsertToggleItemsUnselected() {
        ArrayList arrayList = this.getInsertToggleButtonList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)arrayList.get(i);
            abstractButton.setSelected(false);
        }
        ArrayList arrayList2 = this.getMenuItemList("Insert");
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGToggleMenuItem sGToggleMenuItem = (SGToggleMenuItem)arrayList2.get(i);
            sGToggleMenuItem.setSelected(false);
        }
        return true;
    }

    protected boolean setInsertToggleItemsEnabled(boolean bl) {
        ArrayList arrayList = this.getInsertToggleButtonList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)arrayList.get(i);
            abstractButton.setEnabled(bl);
        }
        ArrayList arrayList2 = this.getMenuItemList("Insert");
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGToggleMenuItem sGToggleMenuItem = (SGToggleMenuItem)arrayList2.get(i);
            sGToggleMenuItem.setEnabled(bl);
        }
        return true;
    }

    protected boolean isInsertToggleButtonSelected() {
        ArrayList arrayList = this.getInsertToggleButtonList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AbstractButton abstractButton = (AbstractButton)arrayList.get(i);
            if (!abstractButton.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void pasteToFigures(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4) {
        ArrayList arrayList5 = this.getFocusedObjectsList();
        if (arrayList5.size() == 0) {
            return;
        }
        for (int i = 0; i < arrayList5.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList5.get(i);
            sGFigure.paste(arrayList);
            for (int j = 0; j < arrayList3.size(); ++j) {
                SGData sGData = (SGData)arrayList2.get(j);
                String string = (String)arrayList3.get(j);
                Map map = (Map)arrayList4.get(j);
                SGData sGData2 = (SGData)sGData.copy();
                sGFigure.addData(sGData2, string, map);
            }
        }
        this.notifyToRoot();
    }

    public boolean closeWindow() {
        WindowEvent windowEvent = new WindowEvent(this, 201);
        WindowListener[] windowListenerArray = this.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            windowListenerArray[i].windowClosing(windowEvent);
        }
        this.dispose();
        return true;
    }

    private void updateDataItem() {
        this.updateFocusedObjectItem();
    }

    private void updateFocusedObjectItem() {
        JMenu jMenu;
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2;
        Object object;
        JComponent jComponent;
        boolean bl = false;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            jComponent = (SGFigure)arrayList.get(i);
            if (((SGFigure)jComponent).isSelected()) {
                bl = true;
                break;
            }
            object = ((SGFigure)jComponent).getIFigureElementArray();
            for (int j = 0; j < ((SGIFigureElement[])object).length; ++j) {
                if (object[j].getFocusedObjectsList().size() == 0) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        if ((jMenuItem2 = this.getMenuItem("Edit", "Cut")) != null) {
            jMenuItem2.setEnabled(bl);
        }
        if ((jComponent = this.getMenuItem("Edit", "Copy")) != null) {
            ((JMenuItem)jComponent).setEnabled(bl);
        }
        if ((object = this.getMenuItem("Edit", "Delete")) != null) {
            ((JMenuItem)object).setEnabled(bl);
        }
        if ((jMenuItem = this.getMenuItem("Edit", "Duplicate")) != null) {
            jMenuItem.setEnabled(bl);
        }
        if ((jMenu = this.getMenuFromMenuBar("Arrange")) != null) {
            this.getMenuItem("Arrange", "Move to Front").setEnabled(bl);
            this.getMenuItem("Arrange", "Move to Back").setEnabled(bl);
        }
    }

    public void setPasteMenuEnabled(boolean bl) {
        JMenuItem jMenuItem = this.getMenuItem("Edit", "Paste");
        jMenuItem.setEnabled(bl);
        Component[] componentArray = this.mPopupMenu.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            JMenuItem jMenuItem2;
            if (!(componentArray[i] instanceof JMenuItem) || !(jMenuItem2 = (JMenuItem)componentArray[i]).getActionCommand().equals("Paste")) continue;
            jMenuItem2.setEnabled(bl);
        }
    }

    private void updateGridItems() {
        JMenu jMenu = this.getMenuFromMenuBar("Layout");
        JMenu jMenu2 = this.getMenu(jMenu, "Grid");
        if (jMenu2 == null) {
            throw new Error();
        }
        JMenuItem jMenuItem = this.getMenuItem(jMenu2, "Plus");
        if (jMenuItem == null) {
            throw new Error();
        }
        JMenuItem jMenuItem2 = this.getMenuItem(jMenu2, "Minus");
        if (jMenuItem2 == null) {
            throw new Error();
        }
        JMenuItem jMenuItem3 = this.getMenuItem(jMenu2, "Visible");
        if (jMenuItem3 == null) {
            throw new Error();
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)jMenuItem3;
        boolean bl = this.isGridVisible();
        jCheckBoxMenuItem.setSelected(bl);
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            float f = this.getGridInterval() * 0.035277776f;
            int n = (int)Math.ceil(f / 0.5f);
            int n2 = (int)Math.floor(f / 0.5f);
            int n3 = (int)Math.rint(1.0);
            int n4 = (int)Math.rint(20.0);
            if (n3 <= n2) {
                bl3 = true;
            }
            if (n <= n4) {
                bl2 = true;
            }
        }
        jMenuItem.setEnabled(bl2);
        jMenuItem2.setEnabled(bl3);
    }

    public void setPaperPortrait(boolean bl) {
        this.mPaperPortraitFlag = bl;
    }

    public boolean getPaperPortrait() {
        return this.mPaperPortraitFlag;
    }

    private void updatePaperItems() {
        JMenu jMenu = this.getMenuFromMenuBar("Layout");
        JMenu jMenu2 = this.getMenu(jMenu, "Paper Size");
        if (jMenu2 == null) {
            throw new Error();
        }
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.getMenuItem(jMenu2, "Portrait");
        if (jRadioButtonMenuItem == null) {
            throw new Error();
        }
        if (this.mPaperPortraitFlag) {
            jRadioButtonMenuItem.setSelected(true);
        }
    }

    private void updateZoomItems() {
        int[] nArray = MAGNIFICATION_ARRAY;
        int n = nArray[0];
        int n2 = nArray[nArray.length - 1];
        JMenu jMenu = this.getMenuFromMenuBar("Layout");
        int n3 = (int)this.getMagnificationPercent();
        JMenu jMenu2 = this.getMenu(jMenu, "Zoom");
        if (jMenu2 == null) {
            throw new Error();
        }
        JMenuItem jMenuItem = this.getMenuItem(jMenu2, "Zoom In");
        if (jMenuItem == null) {
            throw new Error();
        }
        JMenuItem jMenuItem2 = this.getMenuItem(jMenu2, "Zoom Out");
        if (jMenuItem2 == null) {
            throw new Error();
        }
        JMenuItem jMenuItem3 = this.getMenuItem(jMenu2, "Zoom Way Out");
        if (jMenuItem3 == null) {
            throw new Error();
        }
        JMenuItem jMenuItem4 = this.getMenuItem(jMenu2, "Default Zoom");
        if (jMenuItem4 == null) {
            throw new Error();
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        if (n3 == n) {
            bl = false;
        } else if (n3 == n2) {
            bl2 = false;
        } else if (n3 == 100) {
            bl3 = true;
        }
        jMenuItem.setEnabled(bl);
        jMenuItem2.setEnabled(bl2);
        jMenuItem3.setEnabled(bl2);
        jMenuItem4.setEnabled(!bl3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        Object object;
        int n2;
        int n3;
        float f;
        String string = actionEvent.getActionCommand();
        Object object2 = actionEvent.getSource();
        if (string.equals("Exit")) {
            this.notifyToListener("exit");
        } else if (string.equals("Create New Window")) {
            this.notifyToListener("open a new window");
        } else if (string.equals("Close Window")) {
            this.closeWindow();
        } else if (string.equals("Draw Graph")) {
            this.notifyToListener("add new data");
        } else if (string.equals("Load Property")) {
            this.notifyToListener("load property");
        } else if (string.equals("Save Property")) {
            this.mPropertyFileCreationModeOfFigures = 0;
            this.notifyToListener("save property");
        } else if (string.equals("Export as Image")) {
            this.notifyToListener("export as image");
        } else if (string.equals("Print")) {
            this.notifyToListener("print");
        } else if (string.equals("Preview")) {
            this.previewImage();
        } else if (string.equals("Delete")) {
            this.deleteFocusedObjects();
        } else if (string.equals("Cut")) {
            this.cutFocusedObjects();
        } else if (string.equals("Copy")) {
            this.copyFocusedObjects();
        }
        if (string.equals("Paste")) {
            this.pasteCopiedObjects();
        } else if (string.equals("Duplicate")) {
            this.duplicateFocusedObjects();
        } else if (string.equals("Move to Front")) {
            this.moveFocusedObjectsToFront();
        } else if (string.equals("Move to Back")) {
            this.moveFocusedObjectsToBack();
        } else if (string.equals("Undo")) {
            this.onUndo();
        } else if (string.equals("Redo")) {
            this.onRedo();
        } else if (string.equals("A4") || string.equals("B5") || string.equals("US Letter")) {
            MediaSize mediaSize = null;
            if (string.equals("A4")) {
                mediaSize = MediaSize.ISO.A4;
            } else if (string.equals("B5")) {
                mediaSize = MediaSize.ISO.B5;
            } else if (string.equals("US Letter")) {
                mediaSize = MediaSize.NA.LETTER;
            }
            this.onPaperSizeChanged(mediaSize);
        } else if (string.equals("Portrait") || string.equals("Landscape")) {
            this.mPaperPortraitFlag = string.equals("Portrait");
            this.updatePaperItems();
        } else if (string.equals("Bounding Box")) {
            this.setBoundigBox();
        } else if (string.equals("User Customize")) {
            this.showPropertyDialog();
        } else if (string.equals("Auto Arrangement")) {
            this.onFiguresAligned();
        } else if (string.equals("Visible")) {
            this.setGridVisible(!this.isGridVisible());
            this.getContentPane().repaint();
            this.updateGridItems();
            this.setChanged(true);
            this.notifyToRoot();
        } else if (string.equals("Plus")) {
            float f2 = this.getGridInterval() * 0.035277776f;
            f = SGUtilityNumber.stepValue(true, f2, 0.5f, 10.0f, 0.5f, 0.001f);
            n3 = (int)Math.rint(f / 0.5f);
            if (n3 != (n2 = (int)Math.rint(20.0)) + 1) {
                if (f > 10.0f) {
                    f = 10.0f;
                }
                this.setGridInterval(f / 0.035277776f);
                this.updateGridItems();
                this.setChanged(true);
                this.notifyToRoot();
            }
        } else if (string.equals("Minus")) {
            float f3 = this.getGridInterval() * 0.035277776f;
            f = SGUtilityNumber.stepValue(false, f3, 0.5f, 10.0f, 0.5f, 0.001f);
            n3 = (int)Math.rint(f / 0.5f);
            if (n3 != (n2 = (int)Math.rint(1.0)) - 1) {
                if (f < 0.5f) {
                    f = 0.5f;
                }
                this.setGridInterval(f / 0.035277776f);
                this.updateGridItems();
                this.setChanged(true);
                this.notifyToRoot();
            }
        } else if (string.equals("Zoom In")) {
            int n4 = (int)this.getMagnificationPercent();
            object = MAGNIFICATION_ARRAY;
            for (n = ((Object)object).length - 1; n >= 0; --n) {
                if (object[n] <= n4) continue;
                this.setZoom(new Integer((int)object[n]));
                break;
            }
        } else if (string.equals("Zoom Out")) {
            int n5 = (int)this.getMagnificationPercent();
            object = MAGNIFICATION_ARRAY;
            for (n = 0; n < ((Object)object).length; ++n) {
                if (object[n] >= n5) continue;
                this.setZoom(new Integer((int)object[n]));
                break;
            }
        } else if (string.equals("Default Zoom")) {
            this.setDefaultZoom();
        } else if (string.equals("Zoom Way Out")) {
            this.zoomWayOut();
        } else if (string.equals("Auto Zoom")) {
            this.zoomWithBoundingBox();
        } else if (string.equals("Lock")) {
            this.mLockFigureFlag = !this.mLockFigureFlag;
            this.updateLockItems();
        } else if (string.equals("Upgrade")) {
            this.notifyToListener("upgrade the latest version");
        } else if (string.equals("Change Log")) {
            this.notifyToListener("show the change log");
        } else if (string.equals("Proxy")) {
            this.notifyToListener("set proxy");
        } else if (string.equals("About")) {
            this.notifyToListener("show about dialog");
        } else if (string.equals("Metal")) {
            this.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (string.equals("Motif")) {
            this.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        } else if (string.equals("Windows")) {
            this.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        } else if (string.equals("Windows Classic")) {
            this.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel");
        } else if (string.equals("Aqua")) {
            this.setLookAndFeel("apple.laf.AquaLookAndFeel");
        }
        ArrayList arrayList = this.getMenuItemList("Insert");
        if (arrayList.contains(object2)) {
            JMenuItem jMenuItem;
            object = this.getInsertToggleButton(string);
            jMenuItem.setSelected(!(jMenuItem = (JMenuItem)object2).isSelected());
            boolean bl = jMenuItem.isSelected();
            if (bl) {
                Cursor cursor = new Cursor(1);
                this.setCursor(cursor);
            } else {
                this.setDefaultCursor();
            }
            this.setInsertToggleItemsUnselected();
            ((AbstractButton)object).setSelected(bl);
            jMenuItem.setSelected(bl);
        }
        if (object2.equals(this.mZoomComboBox)) {
            this.onZoomed();
        }
        if (object2.equals(this.mCreateNewWindowButton)) {
            this.notifyToListener("open a new window");
        }
        if (object2.equals(this.mDrawGraphButton)) {
            this.notifyToListener("add new data");
        }
        if (object2.equals(this.mLoadPropertyButton)) {
            this.notifyToListener("load property");
        }
        if (object2.equals(this.mBoundingBoxButton)) {
            this.setBoundigBox();
        }
        if (((ArrayList)(object = this.getInsertToggleButtonList())).contains(object2)) {
            JToggleButton jToggleButton = (JToggleButton)object2;
            String string2 = this.getInsertCommand(jToggleButton);
            JMenuItem jMenuItem = this.getMenuItem("Insert", string2);
            n3 = jToggleButton.isSelected();
            if (n3 != 0) {
                Cursor cursor = new Cursor(1);
                this.setCursor(cursor);
            } else {
                this.setDefaultCursor();
            }
            this.setInsertToggleItemsUnselected();
            jToggleButton.setSelected(n3 != 0);
            jMenuItem.setSelected(n3 != 0);
        }
        if (object2.equals(this.mLockFigureButton)) {
            this.mLockFigureFlag = this.mLockFigureButton.isSelected();
            this.updateLockItems();
        }
        if (object2.equals(this.mExportFormatButton)) {
            this.notifyToListener("export as image");
        }
        if (object2.equals(this.mSavePropertyButton)) {
            this.mPropertyFileCreationModeOfFigures = 0;
            this.notifyToListener("save property");
        }
        if (string.equals("Property")) {
            this.showPropertyDialog();
        }
        this.getContentPane().repaint();
    }

    void moveFocusedObjectsToFront() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.moveFocusedObjects(true);
        }
        this.notifyToRoot();
        this.updateDataItem();
    }

    void moveFocusedObjectsToBack() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.moveFocusedObjects(false);
        }
        this.notifyToRoot();
        this.updateDataItem();
    }

    void copyFocusedObjects() {
        this.copyAllObjectsInVisibleFigures();
        this.notifyToListener("copy");
        this.updateFocusedObjectItem();
    }

    void cutFocusedObjects() {
        this.cutAllObjectsInVisibleFigures();
        this.notifyToListener("cut");
        this.notifyToRoot();
        this.updateFocusedObjectItem();
    }

    void pasteCopiedObjects() {
        this.notifyToListener("paste");
        this.notifyToRoot();
    }

    void duplicateFocusedObjects() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.duplicateFocusedObjects()) continue;
            return;
        }
        this.notifyToListener("duplicate");
        ArrayList arrayList2 = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList2.get(i);
            this.setFocusedFigure(sGFigure, false);
        }
        ArrayList arrayList3 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList3.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList3.get(i);
            if (arrayList.contains(sGFigure)) continue;
            this.setFocusedFigure(sGFigure, true);
        }
        this.notifyToRoot();
    }

    void deleteFocusedObjects() {
        this.hideSelectedObjects();
        this.notifyToRoot();
        this.updateDataItem();
    }

    private void cutAllObjectsInVisibleFigures() {
        this.cutOrCopyAllObjectsInVisibleFigures(false);
    }

    private void copyAllObjectsInVisibleFigures() {
        this.cutOrCopyAllObjectsInVisibleFigures(true);
    }

    private void cutOrCopyAllObjectsInVisibleFigures(boolean bl) {
        int n;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        if (bl) {
            for (n = 0; n < arrayList.size(); ++n) {
                SGFigure sGFigure = (SGFigure)arrayList.get(n);
                arrayList2.addAll(sGFigure.createCopiedObjects());
                sGFigure.createCopiedDataObjects(arrayList3, arrayList4, arrayList5);
            }
        } else {
            for (n = 0; n < arrayList.size(); ++n) {
                SGFigure sGFigure = (SGFigure)arrayList.get(n);
                arrayList2.addAll(sGFigure.cutFocusedObjects());
                sGFigure.cutFocusedDataObjects(arrayList3, arrayList4, arrayList5);
            }
        }
        ArrayList arrayList6 = new ArrayList();
        SGUtility.copyObjects(arrayList3, arrayList6);
        this.clearCopiedObjectsList();
        this.mCopiedObjectsList.addAll(arrayList2);
        this.mCopiedDataObjectsList.addAll(arrayList6);
        this.mCopiedDataNameList.addAll(arrayList4);
        this.mCopiedDataPropertiesMapList.addAll(arrayList5);
        this.mCopiedFiguresList.addAll(this.getFocusedObjectsList());
    }

    public ArrayList getCopiedObjectsList() {
        return new ArrayList(this.mCopiedObjectsList);
    }

    public ArrayList getCopiedObjectsDataList() {
        return new ArrayList(this.mCopiedDataObjectsList);
    }

    public ArrayList getCopiedDataNameList() {
        return new ArrayList(this.mCopiedDataNameList);
    }

    public ArrayList getCopiedDataPropertiesMapList() {
        return new ArrayList(this.mCopiedDataPropertiesMapList);
    }

    private void clearCopiedObjectsList() {
        this.mCopiedObjectsList.clear();
        this.mCopiedDataObjectsList.clear();
        this.mCopiedDataNameList.clear();
        this.mCopiedDataPropertiesMapList.clear();
        this.mCopiedFiguresList.clear();
    }

    void notifyPasteToFocusedFigures() {
        this.mPasteTargetList.clear();
        this.mPasteTargetList.addAll(this.getFocusedObjectsList());
        this.notifyToListener("paste");
    }

    private boolean zoomWithBoundingBox() {
        JMenu jMenu = this.getMenuFromMenuBar("Layout");
        JMenu jMenu2 = this.getMenu(jMenu, "Zoom");
        if (jMenu2 == null) {
            throw new Error();
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.getMenuItem(jMenu2, "Auto Zoom");
        if (jCheckBoxMenuItem == null) {
            throw new Error();
        }
        if (jCheckBoxMenuItem.isSelected()) {
            this.zoomWayOut();
        }
        return true;
    }

    private boolean zoomWayOut() {
        float f;
        Rectangle2D rectangle2D = this.getBoundingBox();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f2 = (float)((double)sGTuple2f.x / (rectangle2D.getWidth() / (double)this.mMagnification));
        float f3 = f2 < (f = (float)((double)sGTuple2f.y / (rectangle2D.getHeight() / (double)this.mMagnification))) ? f2 : f;
        int n = (int)Math.floor(f3 * 100.0f);
        this.setZoom(new Integer(n));
        return true;
    }

    private void setLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            System.out.println("Error L&F Setting");
        }
    }

    private boolean updateLockItems() {
        boolean bl = this.mLockFigureFlag;
        this.setLockToggleButton(bl);
        JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)this.getMenuItem("Layout", "Lock");
        jCheckBoxMenuItem.setSelected(bl);
        return true;
    }

    private Rectangle2D getPaperRectInClientRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.mPaperOrigin.x, this.mPaperOrigin.y, this.mPaperSize.x, this.mPaperSize.y);
        return float_;
    }

    boolean recordPaperRect() {
        this.mTempPaperRect.setRect(this.getPaperRectInClientRect());
        return true;
    }

    public boolean isPaperBoundsChanged() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.mTempPaperRect.getBounds();
        return !rectangle2.equals(rectangle = this.getPaperRectInClientRect().getBounds());
    }

    private boolean onFiguresAligned() {
        SGFigure sGFigure;
        int n;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.recordFigureRect();
        }
        this.recordPaperRect();
        if (!this.alignFiguresByGraphAreaNew()) {
            return false;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            if (!sGFigure.isFigureMoved()) continue;
            sGFigure.setChanged(true);
        }
        if (this.isPaperBoundsChanged()) {
            this.setChanged(true);
        }
        this.notifyToRoot();
        return true;
    }

    private boolean onPaperSizeChanged(MediaSize mediaSize) {
        Rectangle rectangle = this.getPaperRect().getBounds();
        this.setPaperSize(mediaSize);
        Rectangle rectangle2 = this.getPaperRect().getBounds();
        if (rectangle.equals(rectangle2)) {
            return true;
        }
        this.updateClientRect();
        this.setChanged(true);
        this.notifyToRoot();
        this.zoomWithBoundingBox();
        return true;
    }

    private boolean setBoundigBox() {
        Rectangle rectangle = this.getPaperRect().getBounds();
        Rectangle2D rectangle2D = this.getClientRect();
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        if (arrayList.size() != 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.recordFigureRect();
            }
            this.recordPaperRect();
            Rectangle2D rectangle2D2 = this.getBoundingBoxOfFigures(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                float f = (float)(rectangle2D.getX() + (double)sGFigure.getGraphRectX() - rectangle2D2.getX());
                float f2 = (float)(rectangle2D.getY() + (double)sGFigure.getGraphRectY() - rectangle2D2.getY());
                sGFigure.setGraphRectLocation(f, f2);
                if (!sGFigure.isFigureMoved()) continue;
                sGFigure.setChanged(true);
            }
            this.setFigureBoundingBox(0);
            if (this.isPaperBoundsChanged()) {
                this.setChanged(true);
            }
            this.notifyToRoot();
        } else {
            SGUtility.showMessageDialog(this, "There is no figure.", "Failed to get the Bounding box.", 2);
        }
        return true;
    }

    public boolean setPaperSize(MediaSize mediaSize) {
        if (mediaSize == null) {
            return false;
        }
        BigDecimal bigDecimal = new BigDecimal(mediaSize.getX(1000));
        BigDecimal bigDecimal2 = new BigDecimal(mediaSize.getY(1000));
        bigDecimal = bigDecimal.movePointLeft(1);
        bigDecimal2 = bigDecimal2.movePointLeft(1);
        float f = bigDecimal.floatValue();
        float f2 = bigDecimal2.floatValue();
        if (this.mPaperPortraitFlag) {
            this.setPaperSizeRoundingOutInCMUnit(f, f2);
        } else {
            this.setPaperSizeRoundingOutInCMUnit(f2, f);
        }
        return true;
    }

    protected boolean setPaperSizeRoundingOutInCMUnit(float f, float f2) {
        float f3 = (float)SGUtilityNumber.roundOutNumber(f, -2);
        float f4 = (float)SGUtilityNumber.roundOutNumber(f2, -2);
        float f5 = f3 / 0.035277776f;
        float f6 = f4 / 0.035277776f;
        this.mPaperSize.setValues(f5, f6);
        return true;
    }

    protected boolean setPaperSizeRoundingOut(float f, float f2) {
        float f3 = f * 0.035277776f;
        float f4 = f2 * 0.035277776f;
        this.setPaperSizeRoundingOutInCMUnit(f3, f4);
        return true;
    }

    public boolean initPropertiesHistory() {
        WindowProperties windowProperties = (WindowProperties)this.getProperties();
        this.addWindowPropertiesHistory(windowProperties);
        return true;
    }

    private boolean addWindowPropertiesHistory(WindowProperties windowProperties) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.mWindowStateCounter; ++i) {
            arrayList.add(this.mWindowPropertyHistoryList.get(i));
        }
        arrayList.add(windowProperties);
        this.mWindowPropertyHistoryList = arrayList;
        return true;
    }

    public boolean commit() {
        return this.commit(this.mDialog);
    }

    public boolean commit(SGPropertyDialog sGPropertyDialog) {
        SGWindowDialog sGWindowDialog = (SGWindowDialog)sGPropertyDialog;
        boolean bl = this.setPropertiesFromDialog(sGWindowDialog);
        if (!bl) {
            return false;
        }
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.mChangedFlag = true;
        }
        this.mTemporaryProperties = null;
        this.mDialog.removePropertySettingListener(this);
        this.getContentPane().repaint();
        this.notifyToRoot();
        return true;
    }

    public boolean updateHistory() {
        ArrayList<Container> arrayList = new ArrayList<Container>();
        if (this.mChangedFlag) {
            this.updateThisObjectHistory();
            arrayList.add(this);
            this.setChanged(false);
        }
        ArrayList arrayList2 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList2.get(i);
            if (!sGFigure.isChanged()) continue;
            sGFigure.updateHistory();
            arrayList.add(sGFigure);
        }
        if (arrayList.size() != 0) {
            this.updateObjectHistory(arrayList);
        }
        return true;
    }

    public boolean updateThisObjectHistory() {
        ++this.mWindowStateCounter;
        this.addWindowPropertiesHistory((WindowProperties)this.getProperties());
        return true;
    }

    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.mDialog.removePropertySettingListener(this);
        this.updateClientRect();
        this.getContentPane().repaint();
        return true;
    }

    public boolean preview() {
        return this.preview(this.mDialog);
    }

    public boolean preview(SGPropertyDialog sGPropertyDialog) {
        SGWindowDialog sGWindowDialog = (SGWindowDialog)sGPropertyDialog;
        this.setPropertiesFromDialog(sGWindowDialog);
        this.getContentPane().repaint();
        return true;
    }

    protected boolean setDefaultCursor() {
        Cursor cursor = Cursor.getDefaultCursor();
        this.setCursor(cursor);
        return true;
    }

    private boolean setDialogProperty() {
        SGWindowDialog sGWindowDialog = this.mDialog;
        String string = "Window Properties : " + this.getID();
        sGWindowDialog.setTitle(string);
        sGWindowDialog.setWindowWidth(this.mPaperSize.x * 0.035277776f);
        sGWindowDialog.setWindowHeight(this.mPaperSize.y * 0.035277776f);
        sGWindowDialog.setWindowGridVisible(this.isGridVisible());
        sGWindowDialog.setWindowGridLinesInterval(this.getGridInterval() * 0.035277776f);
        sGWindowDialog.setWindowGridLinesWidth(this.getGridLineWidth());
        sGWindowDialog.setWindowBackgroundColor(this.getPaperColor());
        sGWindowDialog.setWindowGridLinesColor(this.getGridLineColor());
        return true;
    }

    private boolean setPropertiesFromDialog(SGWindowDialog sGWindowDialog) {
        WindowProperties windowProperties = this.getPropertiesFromDialog(sGWindowDialog);
        if (!this.setProperties(windowProperties)) {
            return false;
        }
        this.updateClientRect();
        this.zoomWithBoundingBox();
        this.updateGridItems();
        return true;
    }

    private boolean updateClientRect() {
        this.updateClientRectOld();
        return true;
    }

    private boolean updateClientRectNew() {
        float f;
        float f2;
        System.out.println("-- updateClientRect --");
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getPaperRect();
        Rectangle2D rectangle2D3 = this.getBoundingBox();
        Rectangle2D rectangle2D4 = this.getViewportBounds();
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        float f3 = (float)rectangle2D.getX();
        float f4 = (float)rectangle2D.getY();
        float f5 = (float)rectangle2D.getWidth();
        float f6 = (float)rectangle2D.getHeight();
        float f7 = (float)rectangle2D4.getX();
        float f8 = (float)rectangle2D4.getY();
        float f9 = (float)rectangle2D4.getWidth();
        float f10 = (float)rectangle2D4.getHeight();
        float f11 = this.getPaperX();
        float f12 = this.getPaperY();
        float f13 = this.getPaperWidth();
        float f14 = this.getPaperHeight();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(rectangle2D3);
        boolean bl = (int)f7 <= (int)((RectangularShape)float_).getX();
        boolean bl2 = (int)(((RectangularShape)float_).getX() + ((RectangularShape)float_).getWidth()) <= (int)(f7 + f9);
        double d = ((RectangularShape)float_).getX();
        double d2 = ((RectangularShape)float_).getWidth();
        if (bl & bl2) {
            d = f7;
            d2 = f9;
        } else if (bl) {
            d = f7;
            if (d2 < (double)f9) {
                d2 = f9;
            }
        } else if (bl2) {
            d = (double)(f7 + f9) - d2;
            if ((double)f7 < d) {
                d = f7;
            }
            if (d2 < (double)f9) {
                d2 = f9;
            }
        }
        ((Rectangle2D)float_).setRect(d, ((RectangularShape)float_).getY(), d2, ((RectangularShape)float_).getHeight());
        bl = (double)f8 < float_.getMinY();
        bl2 = float_.getMinY() + ((RectangularShape)float_).getHeight() < (double)(f8 + f10);
        d = ((RectangularShape)float_).getY();
        d2 = ((RectangularShape)float_).getHeight();
        if (bl & bl2) {
            d = f8;
            d2 = f10;
        } else if (bl) {
            d = f8;
            if (d2 < (double)f10) {
                d2 = f10;
            }
        } else if (bl2) {
            d = (double)(f8 + f10) - d2;
            if ((double)f8 < d) {
                d = f8;
            }
            if (d2 < (double)f10) {
                d2 = f10;
            }
        }
        ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX(), d, ((RectangularShape)float_).getWidth(), d2);
        this.mTempRect.setRect(float_);
        if (arrayList.size() == 0) {
            f2 = (float)((RectangularShape)float_).getX() + 0.0f;
            f = (float)((RectangularShape)float_).getY() + 0.0f;
        } else {
            SGFigure sGFigure = null;
            SGFigure sGFigure2 = null;
            float f15 = f11;
            float f16 = f12;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure3 = (SGFigure)arrayList.get(i);
                Rectangle2D rectangle2D5 = sGFigure3.getBoundingBox();
                float f17 = (float)rectangle2D5.getX();
                float f18 = (float)rectangle2D5.getY();
                if (f17 < f15) {
                    f15 = f17;
                    sGFigure = sGFigure3;
                }
                if (!(f18 < f16)) continue;
                f16 = f18;
                sGFigure2 = sGFigure3;
            }
            f2 = sGFigure != null ? f11 - f15 : f11;
            f = sGFigure2 != null ? f12 - f16 : f12;
        }
        System.out.println(f11 + "  " + f12);
        System.out.println(f2 + "  " + f);
        this.setClientRect(float_);
        this.setPaperOrigin(f2, f);
        this.updateGraphRectOfAllFigures();
        this.setEnableScrollBars();
        this.setScrollBarValue();
        System.out.println();
        return true;
    }

    private boolean updateClientRectOld() {
        double d;
        boolean bl;
        boolean bl2;
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2;
        this.fitRect(this.mClientRect, this.getBoundingBox(), true);
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), true)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), true);
        }
        if (!SGUtility.isRectContains(this.getClientRect(), this.getViewportBounds(), true)) {
            rectangle2D2 = this.getClientRect();
            rectangle2D = this.getViewportBounds();
            bl2 = SGUtility.isRectContains(rectangle2D2, rectangle2D.getX(), true);
            bl = SGUtility.isRectContains(rectangle2D2, rectangle2D.getX() + rectangle2D.getWidth(), true);
            d = 0.0;
            if (!bl2 && bl) {
                d = rectangle2D.getX() - rectangle2D2.getX();
            } else if (bl2 && !bl) {
                d = rectangle2D.getX() + rectangle2D.getWidth() - (rectangle2D2.getX() + rectangle2D2.getWidth());
            } else if (!bl2 && !bl) {
                d = rectangle2D2.getX() < rectangle2D.getX() ? rectangle2D.getX() + rectangle2D.getWidth() - (rectangle2D2.getX() + rectangle2D2.getWidth()) : rectangle2D.getX() - rectangle2D2.getX();
            }
            this.setClientRect((float)(rectangle2D2.getX() + d), (float)rectangle2D2.getY(), (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight());
        }
        this.fitRect(this.mClientRect, this.getBoundingBox(), false);
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), false)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), false);
        }
        if (!SGUtility.isRectContains(this.getClientRect(), this.getViewportBounds(), false)) {
            rectangle2D2 = this.getClientRect();
            rectangle2D = this.getViewportBounds();
            bl2 = SGUtility.isRectContains(rectangle2D2, rectangle2D.getY(), false);
            bl = SGUtility.isRectContains(rectangle2D2, rectangle2D.getY() + rectangle2D.getHeight(), false);
            d = 0.0;
            if (!bl2 && bl) {
                d = rectangle2D.getY() - rectangle2D2.getY();
            } else if (bl2 && !bl) {
                d = rectangle2D.getY() + rectangle2D.getHeight() - (rectangle2D2.getY() + rectangle2D2.getHeight());
            } else if (!bl2 && !bl) {
                d = rectangle2D2.getY() < rectangle2D.getY() ? rectangle2D.getY() + rectangle2D.getHeight() - (rectangle2D2.getY() + rectangle2D2.getHeight()) : rectangle2D.getY() - rectangle2D2.getY();
            }
            this.setClientRect((float)rectangle2D2.getX(), (float)(rectangle2D2.getY() + d), (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight());
        }
        this.setScrollBarValue();
        this.setEnableScrollBars();
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), true)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), true);
        }
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), false)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), false);
        }
        this.setScrollBarValue();
        return true;
    }

    private void fitRect(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        if (bl) {
            rectangle2D.setRect(rectangle2D2.getX(), rectangle2D.getY(), rectangle2D2.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D2.getY(), rectangle2D.getWidth(), rectangle2D2.getHeight());
        }
    }

    protected boolean setEnableScrollBars() {
        Rectangle rectangle = this.getViewportBounds().getBounds();
        Rectangle rectangle2 = this.getClientRect().getBounds();
        boolean bl = SGUtilityNumber.contains(rectangle.x, rectangle.x + rectangle.width, rectangle2.x, rectangle2.x + rectangle2.width);
        boolean bl2 = SGUtilityNumber.contains(rectangle.y, rectangle.y + rectangle.height, rectangle2.y, rectangle2.y + rectangle2.height);
        this.mHScrollBar.setVisible(!bl);
        this.mVScrollBar.setVisible(!bl2);
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof WindowProperties)) {
            return false;
        }
        WindowProperties windowProperties = (WindowProperties)sGProperties;
        Float f = windowProperties.getPaperWidth();
        Float f2 = windowProperties.getPaperHeight();
        if (f == null || f2 == null) {
            return false;
        }
        this.mPaperSize.setValues(f.floatValue(), f2.floatValue());
        Color color = windowProperties.getBackgroundColor();
        if (color == null) {
            return false;
        }
        this.setBackgroundColor(color);
        Color color2 = windowProperties.getGridColor();
        if (color2 == null) {
            return false;
        }
        this.setGridLineColor(color2);
        Boolean bl = windowProperties.getGridVisible();
        if (bl == null) {
            return false;
        }
        this.setGridVisible(bl);
        Float f3 = windowProperties.getGridInterval();
        if (f3 == null) {
            return false;
        }
        this.setGridInterval(f3.floatValue());
        Float f4 = windowProperties.getGridLineWidth();
        if (f4 == null) {
            return false;
        }
        this.setGridLineWidth(f4.floatValue());
        this.mFigureMap = windowProperties.figureMap;
        this.setFigureVisible(new ArrayList(windowProperties.visibleFigureList));
        return true;
    }

    public SGProperties getProperties() {
        WindowProperties windowProperties = new WindowProperties();
        windowProperties.setPaperWidth(this.mPaperSize.x);
        windowProperties.setPaperHeight(this.mPaperSize.y);
        windowProperties.setBackGroundColor(this.getPaperColor());
        windowProperties.setGridColor(this.getGridLineColor());
        windowProperties.setGridVisible(this.isGridVisible());
        windowProperties.setGridInterval(this.getGridInterval());
        windowProperties.setGridLineWidth(this.getGridLineWidth());
        windowProperties.figureMap = this.mFigureMap;
        windowProperties.visibleFigureList = new ArrayList(this.getVisibleFigureIDList());
        return windowProperties;
    }

    protected ArrayList getVisibleFigureIDList() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList arrayList2 = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList2.get(i);
            int n = sGFigure.getID();
            arrayList.add(new Integer(n));
        }
        return arrayList;
    }

    protected boolean setFigureVisible(ArrayList arrayList) {
        if (arrayList == null) {
            return false;
        }
        SGFigure[] sGFigureArray = this.getFigureArrayFromMap();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            int n = sGFigureArray[i].getID();
            if (arrayList.contains(new Integer(n))) {
                sGFigureArray[i].setVisible(true);
                continue;
            }
            sGFigureArray[i].setVisible(false);
        }
        return true;
    }

    private WindowProperties getPropertiesFromDialog(SGWindowDialog sGWindowDialog) {
        WindowProperties windowProperties = sGWindowDialog.getProperties();
        if (windowProperties == null) {
            return null;
        }
        windowProperties.figureMap = this.mFigureMap;
        windowProperties.visibleFigureList = this.getVisibleFigureIDList();
        return windowProperties;
    }

    public Rectangle2D getClientRect() {
        if (this.mClientRect == null) {
            return null;
        }
        return (Rectangle2D)this.mClientRect.clone();
    }

    public void dumpClientRect() {
        Rectangle2D rectangle2D = this.getClientRect();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        System.out.println("x=" + d * 0.035277776420116425 + "cm, y=" + d2 * 0.035277776420116425 + "cm");
        System.out.println("w=" + d3 * 0.035277776420116425 + "cm, h=" + d4 * 0.035277776420116425 + "cm");
        System.out.println();
    }

    public void dumpRect() {
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getViewportBounds();
        Rectangle2D rectangle2D3 = this.getBoundingBox();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        Rectangle2D.Float float_2 = new Rectangle2D.Float();
        Rectangle2D.Float float_3 = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect((float)rectangle2D.getX() * 0.035277776f, (float)rectangle2D.getY() * 0.035277776f, (float)rectangle2D.getWidth() * 0.035277776f, (float)rectangle2D.getHeight() * 0.035277776f);
        ((Rectangle2D)float_2).setRect((float)rectangle2D2.getX() * 0.035277776f, (float)rectangle2D2.getY() * 0.035277776f, (float)rectangle2D2.getWidth() * 0.035277776f, (float)rectangle2D2.getHeight() * 0.035277776f);
        ((Rectangle2D)float_3).setRect((float)rectangle2D3.getX() * 0.035277776f, (float)rectangle2D3.getY() * 0.035277776f, (float)rectangle2D3.getWidth() * 0.035277776f, (float)rectangle2D3.getHeight() * 0.035277776f);
        System.out.println("client:" + float_);
        System.out.println("viewport:" + float_2);
        System.out.println("bounding box:" + float_3);
    }

    public boolean setClientRect(float f, float f2, float f3, float f4) {
        this.mClientRect.setRect(f, f2, f3, f4);
        return true;
    }

    public boolean setClientRect(Rectangle2D rectangle2D) {
        this.mClientRect.setRect(rectangle2D);
        return true;
    }

    public Rectangle2D getViewportBounds() {
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        return float_;
    }

    public Rectangle2D getViewportBoundsInLayeredPane() {
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        int n = this.getRulerWidth();
        Rectangle2D.Float float_ = new Rectangle2D.Float(n, n, f, f2);
        return float_;
    }

    public Rectangle2D getViewportBoundsInComponent() {
        int n = this.getTopWidth();
        int n2 = this.getLeftWidth();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x + 20.0f;
        float f2 = sGTuple2f.y + 20.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2, n, f, f2);
        return float_;
    }

    protected SGFigure[][] getOrderedFigureArray() {
        int n;
        int n2;
        int n3;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        int n4 = arrayList.size();
        if (n4 == 0) {
            return new SGFigure[0][0];
        }
        int n5 = 0;
        for (n3 = 1; n3 <= 16; ++n3) {
            n2 = (n3 - 1) * (n3 - 1);
            n = n3 * n3;
            if (n2 >= n4 || n4 > n) continue;
            n5 = n3;
            break;
        }
        n3 = n5;
        n2 = n4 / n3;
        n = n4 % n3 == 0 ? n2 : n2 + 1;
        SGFigure[][] sGFigureArray = new SGFigure[n][n3];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n6 = i * n3 + j;
                if (n6 >= arrayList.size()) {
                    bl = false;
                    break;
                }
                sGFigureArray[i][j] = (SGFigure)arrayList.get(n6);
            }
            if (!bl) break;
        }
        return sGFigureArray;
    }

    private ArrayList[][] getFigureListArray() {
        int n;
        int n2;
        int n3;
        int n4;
        Rectangle2D rectangle2D;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        if (arrayList.size() == 0) {
            return null;
        }
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            rectangle2D = sGFigure.getGraphRect();
            if (rectangle2D.getWidth() < (double)f) {
                f = (float)rectangle2D.getWidth();
            }
            if (!(rectangle2D.getHeight() < (double)f2)) continue;
            f2 = (float)rectangle2D.getHeight();
        }
        float f3 = f;
        float f4 = f2;
        rectangle2D = this.getBoundingBoxOfFigures(arrayList);
        int n5 = (int)((float)rectangle2D.getWidth() / f3) + 1;
        int n6 = (int)((float)rectangle2D.getHeight() / f4) + 1;
        ArrayList[][] arrayListArray = new ArrayList[n5][n6];
        for (n4 = 0; n4 < n5; ++n4) {
            for (int i = 0; i < n6; ++i) {
                arrayListArray[n4][i] = new ArrayList();
            }
        }
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            SGFigure sGFigure = (SGFigure)arrayList.get(n4);
            Rectangle2D rectangle2D2 = sGFigure.getGraphRect();
            n3 = (int)((rectangle2D2.getCenterX() - rectangle2D.getX()) / (double)f3);
            n2 = (int)((rectangle2D2.getCenterY() - rectangle2D.getY()) / (double)f4);
            arrayListArray[n3][n2].add(sGFigure);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < n5; ++i) {
            boolean bl = false;
            for (n3 = 0; n3 < n6; ++n3) {
                if (arrayListArray[i][n3].size() == 0) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList2.add(new Integer(i));
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (n = 0; n < n6; ++n) {
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                if (arrayListArray[n2][n].size() == 0) continue;
                n3 = 1;
                break;
            }
            if (n3 == 0) continue;
            arrayList3.add(new Integer(n));
        }
        n = arrayList2.size();
        n3 = arrayList3.size();
        ArrayList[][] arrayListArray2 = new ArrayList[n][n3];
        for (int i = 0; i < n; ++i) {
            int n7 = (Integer)arrayList2.get(i);
            for (int j = 0; j < n3; ++j) {
                int n8 = (Integer)arrayList3.get(j);
                arrayListArray2[i][j] = arrayListArray[n7][n8];
            }
        }
        return arrayListArray2;
    }

    private boolean alignFiguresLeftAndBottom(ArrayList[][] arrayListArray) {
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        int n2;
        int n3 = arrayListArray.length;
        int n4 = arrayListArray[0].length;
        float[][] fArray = new float[n3][n4];
        float[][] fArray2 = new float[n3][n4];
        float[][] fArray3 = new float[n3][n4];
        float[][] fArray4 = new float[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                ArrayList arrayList = arrayListArray[i][n2];
                float f5 = 0.0f;
                f4 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                for (int j = 0; j < arrayList.size(); ++j) {
                    SGFigure sGFigure = (SGFigure)arrayList.get(j);
                    Rectangle2D rectangle2D = sGFigure.getGraphRect();
                    f = (float)rectangle2D.getWidth();
                    float f6 = (float)rectangle2D.getHeight();
                    SGTuple2f sGTuple2f = new SGTuple2f();
                    SGTuple2f sGTuple2f2 = new SGTuple2f();
                    sGFigure.calcMargin(sGTuple2f, sGTuple2f2);
                    float f7 = sGTuple2f.x;
                    float f8 = sGTuple2f.y;
                    float f9 = sGTuple2f2.x;
                    float f10 = sGTuple2f2.y;
                    if (f7 + f6 > f5) {
                        f5 = f7 + f6;
                    }
                    if (f8 > f4) {
                        f4 = f8;
                    }
                    if (f9 > f3) {
                        f3 = f9;
                    }
                    if (!(f10 + f > f2)) continue;
                    f2 = f10 + f;
                }
                fArray[i][n2] = f5;
                fArray2[i][n2] = f4;
                fArray3[i][n2] = f3;
                fArray4[i][n2] = f2;
            }
        }
        float[] fArray5 = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            float f11 = 0.0f;
            for (int i = 0; i < n4; ++i) {
                f4 = fArray3[n2][i] + fArray4[n2][i];
                if (!(f4 > f11)) continue;
                f11 = f4;
            }
            fArray5[n2] = f11;
        }
        float[] fArray6 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            float f12 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                f3 = fArray[j][i] + fArray2[j][i];
                if (!(f3 > f12)) continue;
                f12 = f3;
            }
            fArray6[i] = f12;
        }
        float[] fArray7 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f13 = 0.0f;
            for (int j = 0; j < n4; ++j) {
                f2 = fArray3[i][j];
                if (!(f2 > f13)) continue;
                f13 = f2;
            }
            fArray7[i] = f13;
        }
        float[] fArray8 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f14 = 0.0f;
            for (int j = 0; j < n4; ++j) {
                float f15 = fArray4[i][j];
                if (!(f15 > f14)) continue;
                f14 = f15;
            }
            fArray8[i] = f14;
        }
        float[] fArray9 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            float f16 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                float f17 = fArray2[j][i];
                if (!(f17 > f16)) continue;
                f16 = f17;
            }
            fArray9[i] = f16;
        }
        float f18 = this.mMagnification * this.mBackgroundPanel.getGridInterval();
        Rectangle2D rectangle2D = this.getPaperRect();
        float f19 = (float)rectangle2D.getX();
        float f20 = (float)rectangle2D.getY();
        float f21 = f19;
        f = f20;
        float[] fArray10 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f22 = f21 + fArray7[i];
            int n5 = (int)((f22 - f19) / f18) + 1;
            fArray10[i] = f19 + (float)n5 * f18;
            f21 = fArray10[i] + fArray8[i];
        }
        float[] fArray11 = new float[n4];
        for (n = 0; n < n4; ++n) {
            float f23 = f + fArray6[n] - fArray9[n];
            int n6 = (int)((f23 - f20) / f18) + 1;
            fArray11[n] = f20 + (float)n6 * f18;
            f = fArray11[n] + fArray9[n];
        }
        n = 1;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                ArrayList arrayList = arrayListArray[j][i];
                for (int k = 0; k < arrayList.size(); ++k) {
                    SGFigure sGFigure = (SGFigure)arrayList.get(k);
                    if (sGFigure == null) {
                        n = 0;
                        break;
                    }
                    if (sGFigure.setGraphRectLocationByLeftBottom(fArray10[j], fArray11[i])) continue;
                    return false;
                }
                if (n == 0) break;
            }
            if (n == 0) break;
        }
        return true;
    }

    private Float findCeilingValue(float[] fArray, float f) {
        float[] fArray2 = (float[])fArray.clone();
        Arrays.sort(fArray2);
        for (int i = 0; i < fArray2.length; ++i) {
            if (!(f <= fArray2[i])) continue;
            return new Float(fArray2[i]);
        }
        return null;
    }

    public boolean alignFiguresByGraphArea() {
        int n;
        Cloneable cloneable;
        float f;
        float f2;
        float f3;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Rectangle2D rectangle2D;
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D2 = this.mClientRect;
        float f4 = Float.MAX_VALUE;
        float f5 = Float.MAX_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            rectangle2D = sGFigure.getGraphRect();
            if (rectangle2D.getWidth() < (double)f4) {
                f4 = (float)rectangle2D.getWidth();
            }
            if (!(rectangle2D.getHeight() < (double)f5)) continue;
            f5 = (float)rectangle2D.getHeight();
        }
        float f6 = f4;
        float f7 = f5;
        rectangle2D = this.getBoundingBoxOfFigures(arrayList);
        int n7 = (int)((float)rectangle2D.getWidth() / f6) + 1;
        int n8 = (int)((float)rectangle2D.getHeight() / f7) + 1;
        ArrayList[][] arrayListArray = new ArrayList[n7][n8];
        for (n6 = 0; n6 < n7; ++n6) {
            for (int i = 0; i < n8; ++i) {
                arrayListArray[n6][i] = new ArrayList();
            }
        }
        for (n6 = 0; n6 < arrayList.size(); ++n6) {
            SGFigure sGFigure = (SGFigure)arrayList.get(n6);
            Rectangle2D rectangle2D3 = sGFigure.getGraphRect();
            n5 = (int)((rectangle2D3.getCenterX() - rectangle2D.getX()) / (double)f6);
            n4 = (int)((rectangle2D3.getCenterY() - rectangle2D.getY()) / (double)f7);
            arrayListArray[n5][n4].add(sGFigure);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < n7; ++i) {
            boolean bl = false;
            for (n5 = 0; n5 < n8; ++n5) {
                if (arrayListArray[i][n5].size() == 0) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList2.add(new Integer(i));
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (n3 = 0; n3 < n8; ++n3) {
            n5 = 0;
            for (n4 = 0; n4 < n7; ++n4) {
                if (arrayListArray[n4][n3].size() == 0) continue;
                n5 = 1;
                break;
            }
            if (n5 == 0) continue;
            arrayList3.add(new Integer(n3));
        }
        n3 = arrayList2.size();
        n5 = arrayList3.size();
        ArrayList[][] arrayListArray2 = new ArrayList[n3][n5];
        for (int i = 0; i < n3; ++i) {
            int n9 = (Integer)arrayList2.get(i);
            for (int j = 0; j < n5; ++j) {
                int n10 = (Integer)arrayList3.get(j);
                arrayListArray2[i][j] = arrayListArray[n9][n10];
            }
        }
        float[][] fArray = new float[n3][n5];
        float[][] fArray2 = new float[n3][n5];
        float[][] fArray3 = new float[n3][n5];
        float[][] fArray4 = new float[n3][n5];
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (arrayListArray2[i][n2] == null) continue;
                ArrayList arrayList4 = arrayListArray2[i][n2];
                float f8 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
                for (int j = 0; j < arrayList4.size(); ++j) {
                    SGFigure sGFigure = (SGFigure)arrayList4.get(j);
                    Rectangle2D rectangle2D4 = sGFigure.getGraphRect();
                    SGTuple2f sGTuple2f = new SGTuple2f();
                    cloneable = new SGTuple2f();
                    sGFigure.calcMargin(sGTuple2f, (SGTuple2f)cloneable);
                    if (sGTuple2f.x + (float)rectangle2D4.getHeight() > f8) {
                        f8 = sGTuple2f.x + (float)rectangle2D4.getHeight();
                    }
                    if (sGTuple2f.y > f3) {
                        f3 = sGTuple2f.y;
                    }
                    if (((SGTuple2f)cloneable).x > f2) {
                        f2 = ((SGTuple2f)cloneable).x;
                    }
                    if (!(((SGTuple2f)cloneable).y + (float)rectangle2D4.getWidth() > f)) continue;
                    f = ((SGTuple2f)cloneable).y + (float)rectangle2D4.getWidth();
                }
                fArray[i][n2] = f8;
                fArray2[i][n2] = f3;
                fArray3[i][n2] = f2;
                fArray4[i][n2] = f;
            }
        }
        float[] fArray5 = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            float f9 = 0.0f;
            for (int i = 0; i < n5; ++i) {
                f3 = fArray3[n2][i] + fArray4[n2][i];
                if (!(f3 > f9)) continue;
                f9 = f3;
            }
            fArray5[n2] = f9;
        }
        float[] fArray6 = new float[n5];
        for (int i = 0; i < n5; ++i) {
            float f10 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                f2 = fArray[j][i] + fArray2[j][i];
                if (!(f2 > f10)) continue;
                f10 = f2;
            }
            fArray6[i] = f10;
        }
        float[] fArray7 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f11 = 0.0f;
            for (int j = 0; j < n5; ++j) {
                f = fArray3[i][j];
                if (!(f > f11)) continue;
                f11 = f;
            }
            fArray7[i] = f11;
        }
        float[] fArray8 = new float[n5];
        for (int i = 0; i < n5; ++i) {
            float f12 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                float f13 = fArray2[j][i];
                if (!(f13 > f12)) continue;
                f12 = f13;
            }
            fArray8[i] = f12;
        }
        float[] fArray9 = new float[n3];
        float f14 = (float)rectangle2D2.getX();
        for (int i = 0; i < n3; ++i) {
            fArray9[i] = f14 + fArray7[i];
            f14 += fArray5[i];
        }
        float[] fArray10 = new float[n5];
        float f15 = (float)rectangle2D2.getY();
        for (n = 0; n < n5; ++n) {
            fArray10[n] = f15 + fArray6[n] - fArray8[n];
            f15 += fArray6[n];
        }
        n = 1;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n3; ++j) {
                cloneable = arrayListArray2[j][i];
                for (int k = 0; k < ((ArrayList)cloneable).size(); ++k) {
                    SGFigure sGFigure = (SGFigure)((ArrayList)cloneable).get(k);
                    if (sGFigure == null) {
                        n = 0;
                        break;
                    }
                    if (sGFigure.setGraphRectLocationByLeftBottom(fArray9[j], fArray10[i])) continue;
                    return false;
                }
                if (n == 0) break;
            }
            if (n == 0) break;
        }
        return this.setFigureBoundingBox(0);
    }

    public boolean alignFiguresByGraphAreaNew() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        if (arrayList.size() == 0) {
            return true;
        }
        ArrayList[][] arrayListArray = this.getFigureListArray();
        if (arrayListArray == null) {
            return false;
        }
        if (arrayListArray.length == 0) {
            return false;
        }
        if (!this.alignFiguresLeftAndBottom(arrayListArray)) {
            return false;
        }
        return this.setFigureBoundingBox(0);
    }

    public boolean alignFiguresByBoundingBox() {
        boolean bl;
        int n;
        int n2;
        float f;
        int n3;
        SGFigure[][] sGFigureArray = this.getOrderedFigureArray();
        if (sGFigureArray == null) {
            return false;
        }
        if (sGFigureArray.length == 0) {
            return true;
        }
        int n4 = sGFigureArray.length;
        int n5 = sGFigureArray[0].length;
        Rectangle2D[][] rectangle2DArray = new Rectangle2D[n4][n5];
        boolean bl2 = true;
        for (int i = 0; i < n4; ++i) {
            for (n3 = 0; n3 < n5; ++n3) {
                if (sGFigureArray[i][n3] == null) {
                    bl2 = false;
                    break;
                }
                rectangle2DArray[i][n3] = sGFigureArray[i][n3].getBoundingBox();
            }
            if (!bl2) break;
        }
        float[] fArray = new float[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            Rectangle2D rectangle2D;
            float f2 = 0.0f;
            for (int i = 0; i < n4 && (rectangle2D = rectangle2DArray[i][n3]) != null; ++i) {
                float f3 = (float)rectangle2DArray[i][n3].getWidth();
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            fArray[n3] = f2;
        }
        float[] fArray2 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            Rectangle2D rectangle2D;
            float f4 = 0.0f;
            for (int j = 0; j < n5 && (rectangle2D = rectangle2DArray[i][j]) != null; ++j) {
                f = (float)rectangle2DArray[i][j].getHeight();
                if (!(f > f4)) continue;
                f4 = f;
            }
            fArray2[i] = f4;
        }
        Rectangle2D rectangle2D = this.getClientRect();
        float[] fArray3 = new float[n5];
        float f5 = (float)rectangle2D.getX();
        for (int i = 0; i < n5; ++i) {
            fArray3[i] = f5 + fArray[i] / 2.0f;
            f5 += fArray[i];
        }
        float[] fArray4 = new float[n4];
        f = (float)rectangle2D.getY();
        for (n2 = 0; n2 < n4; ++n2) {
            fArray4[n2] = f + fArray2[n2] / 2.0f;
            f += fArray2[n2];
        }
        bl2 = true;
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n5; ++i) {
                int n6 = n2 * n5 + i;
                SGFigure sGFigure = sGFigureArray[n2][i];
                if (sGFigure == null) {
                    bl2 = false;
                    break;
                }
                if (sGFigure.setCenter(fArray3[i], fArray4[n2])) continue;
                return false;
            }
            if (!bl2) break;
        }
        n2 = -1;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            f6 += fArray[n];
        }
        for (n = 0; n < fArray2.length; ++n) {
            f7 += fArray2[n];
        }
        Rectangle2D rectangle2D2 = this.getPaperRect();
        boolean bl3 = rectangle2D2.getWidth() < (double)f6;
        boolean bl4 = bl = rectangle2D2.getHeight() < (double)f7;
        if (bl3 & bl) {
            n2 = 0;
        } else if (bl3) {
            n2 = 1;
        } else if (bl) {
            n2 = 2;
        }
        return n2 == -1 || this.setFigureBoundingBox(n2);
    }

    public boolean updateObjectHistory(SGIUndoable sGIUndoable) {
        ArrayList<SGIUndoable> arrayList = new ArrayList<SGIUndoable>();
        arrayList.add(sGIUndoable);
        boolean bl = this.updateObjectHistory(arrayList);
        return bl;
    }

    public boolean updateObjectHistory(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        for (int i = 0; i < this.mCurrentStateCounter; ++i) {
            Object e = this.mUndoableObjectHistoryList.get(i);
            arrayList2.add(e);
        }
        arrayList2.add(new ArrayList(arrayList));
        this.mUndoableObjectHistoryList = arrayList2;
        ++this.mCurrentStateCounter;
        this.updateUndoItems();
        return true;
    }

    public boolean undo() {
        --this.mWindowStateCounter;
        WindowProperties windowProperties = (WindowProperties)this.mWindowPropertyHistoryList.get(this.mWindowStateCounter);
        this.setProperties(windowProperties);
        return true;
    }

    public boolean redo() {
        ++this.mWindowStateCounter;
        WindowProperties windowProperties = (WindowProperties)this.mWindowPropertyHistoryList.get(this.mWindowStateCounter);
        this.setProperties(windowProperties);
        return true;
    }

    boolean updateGraphRectOfAllFigures() {
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.updateGraphRect();
        }
        return true;
    }

    private boolean updateOnUndo() {
        this.clearAllFocusedObjectsInFigures();
        this.updateClientRect();
        this.updateGraphRectOfAllFigures();
        this.updateUndoItems();
        this.updateItemsByFigureNumbers();
        this.updateDataItem();
        this.updateGridItems();
        return true;
    }

    public boolean onUndo() {
        if (this.mCurrentStateCounter == 0) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter - 1);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.undo() : sGIUndoable.onUndo();
            if (bl) continue;
            return false;
        }
        --this.mCurrentStateCounter;
        this.updateOnUndo();
        return true;
    }

    public boolean onRedo() {
        if (this.mCurrentStateCounter == this.mUndoableObjectHistoryList.size()) {
            return false;
        }
        ArrayList arrayList = (ArrayList)this.mUndoableObjectHistoryList.get(this.mCurrentStateCounter);
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            boolean bl = sGIUndoable.equals(this) ? this.redo() : sGIUndoable.onRedo();
            if (bl) continue;
            return false;
        }
        ++this.mCurrentStateCounter;
        this.updateOnUndo();
        return true;
    }

    public boolean isChanged() {
        return this.mChangedFlag;
    }

    public void setChanged(boolean bl) {
        this.mChangedFlag = bl;
    }

    private boolean updateUndoItems() {
        JMenuItem jMenuItem = this.getMenuItem("Edit", "Undo");
        if (this.mCurrentStateCounter == 0) {
            jMenuItem.setEnabled(false);
        } else {
            jMenuItem.setEnabled(true);
        }
        jMenuItem = this.getMenuItem("Edit", "Redo");
        if (this.mCurrentStateCounter == this.mUndoableObjectHistoryList.size()) {
            jMenuItem.setEnabled(false);
        } else {
            jMenuItem.setEnabled(true);
        }
        return true;
    }

    public void notifyToRoot() {
        this.updateHistoryTree();
    }

    private boolean updateHistoryTree() {
        return this.updateHistory();
    }

    private boolean createMenuBar() {
        JMenuBar jMenuBar = this.getJMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        this.createMenuItem(jMenu, "Create New Window", this, 78, KeyStroke.getKeyStroke(78, 2), true);
        this.createMenuItem(jMenu, "Close Window", this, 87, KeyStroke.getKeyStroke(87, 2), true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Draw Graph", this, 68, KeyStroke.getKeyStroke(79, 2), true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Load Property", this, 76, null, true);
        this.createMenuItem(jMenu, "Save Property", this, 83, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Export as Image", this, 69, KeyStroke.getKeyStroke(69, 2), false);
        this.createMenuItem(jMenu, "Print", this, 80, KeyStroke.getKeyStroke(80, 2), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Exit", this, 88, KeyStroke.getKeyStroke(81, 2), true);
        jMenu = new JMenu("Edit");
        jMenu.setMnemonic(69);
        jMenuBar.add(jMenu);
        this.createMenuItem(jMenu, "Undo", this, 85, KeyStroke.getKeyStroke(90, 2), false);
        this.createMenuItem(jMenu, "Redo", this, 82, KeyStroke.getKeyStroke(89, 2), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Cut", this, 84, KeyStroke.getKeyStroke(88, 2), false);
        this.createMenuItem(jMenu, "Copy", this, 67, KeyStroke.getKeyStroke(67, 2), false);
        this.createMenuItem(jMenu, "Paste", this, 80, KeyStroke.getKeyStroke(86, 2), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Delete", this, 68, KeyStroke.getKeyStroke(127, 0), false);
        this.createMenuItem(jMenu, "Duplicate", this, 73, KeyStroke.getKeyStroke(68, 2), false);
        jMenu = new JMenu("Insert");
        jMenu.setMnemonic(73);
        jMenuBar.add(jMenu);
        this.createToggleMenuItem(jMenu, "Label", this, 76, null, false);
        this.createToggleMenuItem(jMenu, "Significant Difference", this, 68, null, false);
        this.createToggleMenuItem(jMenu, "Axis Break", this, 66, null, false);
        this.createToggleMenuItem(jMenu, "Timing Line", this, 84, null, false);
        jMenu = new JMenu("Layout");
        jMenu.setMnemonic(76);
        jMenuBar.add(jMenu);
        JMenu jMenu2 = new JMenu("Paper Size");
        jMenu2.setMnemonic(80);
        jMenu.add(jMenu2);
        this.createMenuItem(jMenu2, "A4", this, 52, null, true);
        this.createMenuItem(jMenu2, "B5", this, 53, null, true);
        this.createMenuItem(jMenu2, "US Letter", this, 85, null, true);
        jMenu2.addSeparator();
        JMenuItem jMenuItem = (JRadioButtonMenuItem)this.createRadioButtonMenuItem(jMenu2, "Portrait", this, 80, null, true);
        JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)this.createRadioButtonMenuItem(jMenu2, "Landscape", this, 76, null, true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jMenuItem);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.addSeparator();
        this.createMenuItem(jMenu2, "Bounding Box", this, 66, null, true);
        this.createMenuItem(jMenu2, "User Customize", this, 67, null, true);
        jMenu.addSeparator();
        jMenu2 = new JMenu("Grid");
        jMenu2.setMnemonic(71);
        jMenu.add(jMenu2);
        this.createMenuItem(jMenu2, "Plus", this, 80, KeyStroke.getKeyStroke(73, 9), true);
        this.createMenuItem(jMenu2, "Minus", this, 77, KeyStroke.getKeyStroke(68, 9), true);
        this.createCheckBoxMenuItem(jMenu2, "Visible", this, 86, KeyStroke.getKeyStroke(71, 9), true);
        jMenu.addSeparator();
        jMenu2 = new JMenu("Zoom");
        jMenu2.setMnemonic(90);
        jMenu.add(jMenu2);
        this.createMenuItem(jMenu2, "Zoom In", this, 73, KeyStroke.getKeyStroke(90, 9), true);
        jMenuItem = this.createMenuItem(jMenu2, "Zoom Out", this, 79, KeyStroke.getKeyStroke(79, 9), true);
        jMenuItem.setDisplayedMnemonicIndex(5);
        this.createMenuItem(jMenu2, "Default Zoom", this, 68, null, true);
        this.createMenuItem(jMenu2, "Zoom Way Out", this, 87, null, true);
        this.createCheckBoxMenuItem(jMenu2, "Auto Zoom", this, 65, null, true);
        jMenu.addSeparator();
        this.createCheckBoxMenuItem(jMenu, "Lock", this, 79, null, true);
        jMenu = new JMenu("Arrange");
        jMenu.setMnemonic(65);
        jMenuBar.add(jMenu);
        this.createMenuItem(jMenu, "Move to Front", this, 70, KeyStroke.getKeyStroke(70, 2), false);
        this.createMenuItem(jMenu, "Move to Back", this, 66, KeyStroke.getKeyStroke(66, 2), false);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Auto Arrangement", this, 82, null, true);
        jMenu = new JMenu("Help");
        jMenu.setMnemonic(72);
        jMenuBar.add(jMenu);
        this.createMenuItem(jMenu, "Upgrade", this, 85, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Change Log", this, 67, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "Proxy", this, 80, null, true);
        jMenu.addSeparator();
        this.createMenuItem(jMenu, "About", this, 65, null, true);
        return true;
    }

    private JMenuItem createMenuItem(JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        return this.createMenuItem(jMenu, string, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createMenuItem(JMenu jMenu, String string, String string2, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        JMenuItem jMenuItem = new JMenuItem(string);
        return this.createMenuItem_(jMenu, jMenuItem, string2, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createRadioButtonMenuItem(JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
        return this.createMenuItem_(jMenu, jRadioButtonMenuItem, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createCheckBoxMenuItem(JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        return this.createMenuItem_(jMenu, jCheckBoxMenuItem, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createToggleMenuItem(JMenu jMenu, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        SGToggleMenuItem sGToggleMenuItem = new SGToggleMenuItem(string);
        return this.createMenuItem_(jMenu, sGToggleMenuItem, string, actionListener, n, keyStroke, bl);
    }

    private JMenuItem createMenuItem_(JMenu jMenu, JMenuItem jMenuItem, String string, ActionListener actionListener, int n, KeyStroke keyStroke, boolean bl) {
        jMenuItem.setActionCommand(string);
        jMenuItem.addActionListener(this);
        jMenuItem.setMnemonic(n);
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        jMenuItem.setEnabled(bl);
        jMenu.add(jMenuItem);
        return jMenuItem;
    }

    public JMenu getMenuFromMenuBar(String string) {
        JMenuBar jMenuBar = this.getJMenuBar();
        for (int i = 0; i < jMenuBar.getMenuCount(); ++i) {
            JMenu jMenu = jMenuBar.getMenu(i);
            String string2 = jMenu.getText();
            if (!string2.equals(string)) continue;
            return jMenu;
        }
        return null;
    }

    public JMenu getMenu(JMenu jMenu, String string) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenu jMenu2;
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !(jMenuItem instanceof JMenu) || !(jMenu2 = (JMenu)jMenuItem).getText().equals(string)) continue;
            return jMenu2;
        }
        return null;
    }

    public JMenuItem getMenuItem(String string, String string2) {
        JMenu jMenu = this.getMenuFromMenuBar(string);
        if (jMenu == null) {
            return null;
        }
        return this.getMenuItem(jMenu, string2);
    }

    public JMenuItem getMenuItem(JMenu jMenu, String string) {
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            JMenuItem jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null || !jMenuItem.getText().equals(string)) continue;
            return jMenuItem;
        }
        return null;
    }

    public ArrayList getMenuItemList(String string) {
        JMenu jMenu = this.getMenuFromMenuBar(string);
        if (jMenu == null) {
            return null;
        }
        ArrayList<Component> arrayList = new ArrayList<Component>();
        Component[] componentArray = jMenu.getMenuComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JMenuItem)) continue;
            arrayList.add(componentArray[i]);
        }
        return arrayList;
    }

    public boolean previewImage() {
        return this.toImage(0);
    }

    public boolean exportAsImage() {
        return this.toImage(1);
    }

    public boolean printImage() {
        return this.toImage(2);
    }

    private boolean toImage(int n) {
        boolean bl;
        int n2 = (int)this.mPaperSize.x;
        int n3 = (int)this.mPaperSize.y;
        InfoForExport infoForExport = new InfoForExport();
        ExportPanel exportPanel = new ExportPanel();
        exportPanel.setOpaque(true);
        exportPanel.setBackground(this.getPaperColor());
        exportPanel.setPreferredSize(new Dimension(n2, n3));
        this.beforeExport(exportPanel, infoForExport);
        SGIImageExportManager sGIImageExportManager = this.mImageExportManager;
        switch (n) {
            case 1: {
                bl = sGIImageExportManager.export(exportPanel, this, n2, n3);
                break;
            }
            case 2: {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(null);
                jPanel.setSize(n2, n3);
                jPanel.add(exportPanel);
                jPanel.setOpaque(true);
                jPanel.setBackground(exportPanel.getBackground());
                bl = sGIImageExportManager.print(jPanel, this, n2, n3);
                break;
            }
            default: {
                bl = false;
            }
        }
        this.afterExport(exportPanel, infoForExport);
        return bl;
    }

    private boolean beforeExport(ExportPanel exportPanel, InfoForExport infoForExport) {
        SGFigure sGFigure;
        int n;
        int n2;
        Serializable serializable;
        SGFigure sGFigure2;
        int n3;
        float f = this.mMagnification;
        float f2 = this.getHScrollValue();
        float f3 = this.getVScrollValue();
        ArrayList arrayList = this.getVisibleFigureListFromLayer();
        boolean bl = true;
        Rectangle rectangle = this.getPaperRect().getBounds();
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            sGFigure2 = (SGFigure)arrayList.get(n3);
            serializable = sGFigure2.getBoundingBox().getBounds();
            if (rectangle.contains((Rectangle)serializable)) continue;
            bl = false;
            break;
        }
        if (!bl) {
            SGUtility.showMessageDialog(this, "Some figures run off the edge of paper.", "Warning", 2);
        }
        this.setSelectionSymbolsVisible(false);
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            sGFigure2 = (SGFigure)arrayList.get(n3);
            sGFigure2.setSymbolsVisibleAroundAllObjects(false);
        }
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            serializable = (SGFigure)arrayList.get(i);
            sGTuple2fArray[i] = new SGTuple2f(((SGFigure)serializable).mGraphRectX, ((SGFigure)serializable).mGraphRectY);
        }
        this.zoom(1.0f);
        Rectangle2D rectangle2D = this.getClientRect();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            SGFigure sGFigure3 = (SGFigure)arrayList.get(n2);
            sGFigure3.setGraphRectLocation(sGFigure3.getGraphRectX() - (float)rectangle2D.getX(), sGFigure3.getGraphRectY() - (float)rectangle2D.getY());
        }
        n2 = (int)this.mPaperSize.x;
        int n4 = (int)this.mPaperSize.y;
        exportPanel.setOpaque(false);
        exportPanel.setLocation(0, 0);
        exportPanel.setSize(n2, n4);
        for (n = arrayList.size() - 1; n >= 0; --n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.setSize(new SGTuple2f(n2, n4));
            exportPanel.add(sGFigure);
            sGFigure.setViewBounds(null);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.setVisible(false);
        }
        infoForExport.mag = f;
        infoForExport.hValue = f2;
        infoForExport.vValue = f3;
        infoForExport.locationArray = sGTuple2fArray;
        infoForExport.visibleList = arrayList;
        return true;
    }

    private boolean afterExport(ExportPanel exportPanel, InfoForExport infoForExport) {
        SGFigure sGFigure;
        int n;
        float f = infoForExport.mag;
        float f2 = infoForExport.hValue;
        float f3 = infoForExport.vValue;
        SGTuple2f[] sGTuple2fArray = infoForExport.locationArray;
        ArrayList arrayList = infoForExport.visibleList;
        this.zoom(f);
        this.setScrollValue(this.mHScrollBar, f2);
        this.setScrollValue(this.mVScrollBar, f3);
        SGTuple2f sGTuple2f = this.getViewportSize();
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.mGraphRectX = sGTuple2fArray[n].x;
            sGFigure.mGraphRectY = sGTuple2fArray[n].y;
            sGFigure.setSize(sGTuple2f);
            sGFigure.updateGraphRect();
            sGFigure.setViewBounds();
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.setVisible(true);
        }
        this.setSelectionSymbolsVisible(true);
        ArrayList arrayList2 = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure2 = (SGFigure)arrayList2.get(i);
            sGFigure2.setSymbolsVisibleAroundAllObjects(true);
        }
        return true;
    }

    public Element createElement(Document document) {
        Element element = document.createElement("Window");
        if (!this.writeProperty(element)) {
            return null;
        }
        return element;
    }

    public Element createElementForFocusedFiguresInBoundingBox(Document document) {
        Element element = document.createElement("Window");
        if (!this.writePropertyForFocusedFiguresInBoundingBox(element)) {
            return null;
        }
        return element;
    }

    public boolean createDOMTree(Document document) {
        boolean bl;
        switch (this.mPropertyFileCreationModeOfFigures) {
            case 0: {
                bl = this.createDOMTreeForAllFigures(document);
                break;
            }
            case 1: {
                bl = this.createDOMTreeForFocusedFiguresForDuplication(document);
                break;
            }
            case 2: {
                bl = this.createDOMTreeForFocusedFiguresInBoundingBox(document);
                break;
            }
            case 3: {
                bl = this.createDOMTreeForFocusedFiguresForDuplication(document);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return bl;
    }

    public boolean createDOMTree(Document document, int n) {
        this.mPropertyFileCreationModeOfFigures = n;
        return this.createDOMTree(document);
    }

    private boolean createDOMTreeForAllFigures(Document document) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElement(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        ArrayList arrayList = this.getVisibleFigureListFromMap();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            Element element3 = sGFigure.createElement(document);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    boolean createPropertyFileFromFocusedFigures() {
        this.mPropertyFileCreationModeOfFigures = 2;
        this.notifyToListener("save property");
        return true;
    }

    private boolean createDOMTreeForFocusedFiguresInBoundingBox(Document document) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElementForFocusedFiguresInBoundingBox(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            Element element3 = sGFigure.createElementForFocusedInBoundingBox(document);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    private boolean createDOMTreeForFocusedFiguresForDuplication(Document document) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElement(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            Element element3 = sGFigure.createElementForFocusedForDuplication(document);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    public boolean writePropertyForFocusedFiguresInBoundingBox(Element element) {
        Rectangle2D rectangle2D = this.getBoundingBoxOfFigures(this.getFocusedObjectsList());
        float f = (float)rectangle2D.getWidth() * 0.035277776f / this.mMagnification;
        float f2 = (float)rectangle2D.getHeight() * 0.035277776f / this.mMagnification;
        element.setAttribute("PaperWidth", Float.toString(f) + "cm");
        element.setAttribute("PaperHeight", Float.toString(f2) + "cm");
        this.writeProperty_(element);
        return true;
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("PaperWidth", Float.toString(this.mPaperSize.x * 0.035277776f) + "cm");
        element.setAttribute("PaperHeight", Float.toString(this.mPaperSize.y * 0.035277776f) + "cm");
        this.writeProperty_(element);
        return true;
    }

    private boolean writeProperty_(Element element) {
        element.setAttribute("GridVisible", Boolean.toString(this.isGridVisible()));
        element.setAttribute("GridInterval", Float.toString(this.getGridInterval() * 0.035277776f) + "cm");
        element.setAttribute("GridLineWidth", Float.toString(this.getGridLineWidth()) + "pt");
        element.setAttribute("BackgroundColor", SGUtilityText.getColorString(this.getPaperColor()));
        element.setAttribute("GridLineColor", SGUtilityText.getColorString(this.getGridLineColor()));
        return true;
    }

    protected boolean setPropertyOfSelectedObjects() {
        ArrayList arrayList;
        SGFigure sGFigure;
        int n;
        ArrayList arrayList2 = new ArrayList();
        ArrayList<SGPropertyDialog> arrayList3 = new ArrayList<SGPropertyDialog>();
        ArrayList arrayList4 = this.getVisibleFigureListFromMap();
        for (n = 0; n < arrayList4.size(); ++n) {
            sGFigure = (SGFigure)arrayList4.get(n);
            SGIGraphElement sGIGraphElement = sGFigure.getGraphElement();
            arrayList = sGIGraphElement.getPropertySettingListerListOfDataElements();
            if (arrayList.size() == 0) continue;
            arrayList2.addAll(arrayList);
            arrayList3.add(sGIGraphElement.getPropertyDialogForDataElements());
        }
        if (arrayList2.size() == 0) {
            return true;
        }
        for (n = 0; n < arrayList3.size() - 1; ++n) {
            sGFigure = arrayList3.get(n);
            for (int i = n; i < arrayList3.size(); ++i) {
                arrayList = arrayList3.get(i);
                if (sGFigure.getClass().equals(arrayList.getClass())) continue;
                return false;
            }
        }
        SGPropertyDialog sGPropertyDialog = (SGPropertyDialog)arrayList3.get(0);
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGIPropertySettingListener sGIPropertySettingListener = (SGIPropertySettingListener)arrayList2.get(i);
            sGPropertyDialog.addPropertySettingListener(sGIPropertySettingListener);
            sGIPropertySettingListener.createTemporaryPropertyObject();
        }
        sGPropertyDialog.setDialogProperty();
        sGPropertyDialog.setLocation(this.getLocation());
        sGPropertyDialog.setVisible(true);
        this.notifyToRoot();
        return true;
    }

    public static class WindowProperties
    extends SGProperties {
        TreeMap figureMap = new TreeMap();
        ArrayList visibleFigureList = new ArrayList();
        public static final String[] keys = new String[]{"PaperWidth", "PaperHeight", "BackgroundColor", "GridVisible", "GridLineColor", "GridInterval", "GridLineWidth"};

        public boolean equals(Object object) {
            if (!(object instanceof WindowProperties)) {
                return false;
            }
            WindowProperties windowProperties = (WindowProperties)object;
            for (int i = 0; i < keys.length; ++i) {
                if (this.getProperty(keys[i]).equals(windowProperties.getProperty(keys[i]))) continue;
                return false;
            }
            if (!windowProperties.figureMap.equals(this.figureMap)) {
                return false;
            }
            return windowProperties.visibleFigureList.equals(this.visibleFigureList);
        }

        public Float getPaperWidth() {
            String string = this.getProperty("PaperWidth");
            return SGUtilityText.getFloat(string);
        }

        public Float getPaperHeight() {
            String string = this.getProperty("PaperHeight");
            return SGUtilityText.getFloat(string);
        }

        public Color getBackgroundColor() {
            String string = this.getProperty("BackgroundColor");
            return SGUtilityText.getColorFromString(string);
        }

        public Color getGridColor() {
            String string = this.getProperty("GridLineColor");
            return SGUtilityText.getColorFromString(string);
        }

        public Boolean getGridVisible() {
            String string = this.getProperty("GridVisible");
            return SGUtilityText.getBoolean(string);
        }

        public Float getGridInterval() {
            String string = this.getProperty("GridInterval");
            return SGUtilityText.getFloat(string);
        }

        public Float getGridLineWidth() {
            String string = this.getProperty("GridLineWidth");
            return SGUtilityText.getFloat(string);
        }

        public boolean setPaperWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("PaperWidth", new Float(f).toString());
            return true;
        }

        public boolean setPaperHeight(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("PaperHeight", new Float(f).toString());
            return true;
        }

        public boolean setBackGroundColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty("BackgroundColor", string);
            return true;
        }

        public boolean setGridColor(Color color) {
            if (color == null) {
                return false;
            }
            String string = SGUtilityText.getColorString(color);
            if (string == null) {
                return false;
            }
            this.setProperty("GridLineColor", string);
            return true;
        }

        public boolean setGridVisible(boolean bl) {
            this.setProperty("GridVisible", new Boolean(bl).toString());
            return true;
        }

        public boolean setGridInterval(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("GridInterval", new Float(f).toString());
            return true;
        }

        public boolean setGridLineWidth(float f) {
            if (f < 0.0f) {
                return false;
            }
            this.setProperty("GridLineWidth", new Float(f).toString());
            return true;
        }
    }

    private static class RulerPanel
    extends InnerPanel {
        private static final int RULER_WIDTH = 20;
        private static final int ANCHOR_SIZE = 12;
        private static final Color INNER_COLOR_1 = new Color(234, 238, 232);
        private static final Color INNER_COLOR_2 = new Color(124, 155, 64);
        private static final Color ANCHOR_INNER_COLOR = new Color(222, 222, 222);
        private static final float ANCHOR_EDGE_LINE_WIDTH = 4.0f;
        private static final Color ANCHOR_EDGE_LINE_COLOR = Color.WHITE;
        private static final Color LINE_COLOR = Color.BLACK;
        private static final float LINE_WIDTH = 2.0f;
        private static final BasicStroke LINE_STROKE = new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{10.0f, 2.0f, 2.0f, 4.0f}, 0.0f);
        private Font mRulerFont = null;
        private Point2D mHorizontalLocation = null;
        private Point2D mVerticalLocation = null;
        private boolean mDrawHorizontalLineFlag = false;
        private boolean mDrawVerticalLineFlag = false;

        RulerPanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(false);
            int n = SGUtilityText.getFontStyle("Plain");
            this.mRulerFont = new Font("Serif", n, 11);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.drawRuler(graphics2D);
            if (this.mDrawHorizontalLineFlag) {
                this.drawHorizontalLine(graphics2D);
            }
            if (this.mDrawVerticalLineFlag) {
                this.drawVerticalLine(graphics2D);
            }
            Point2D point2D = null;
            point2D = this.mDrawHorizontalLineFlag ? this.mHorizontalLocation : this.getHorizontalAnchorLocationFromPaper();
            this.drawHorizontalAnchor((int)point2D.getX(), (Graphics2D)graphics2D.create());
            point2D = null;
            point2D = this.mDrawVerticalLineFlag ? this.mVerticalLocation : this.getVerticalAnchorLocationFromPaper();
            this.drawVerticalAnchor((int)point2D.getY(), (Graphics2D)graphics2D.create());
        }

        private void drawHorizontalAnchor(int n, Graphics2D graphics2D) {
            int[] nArray = new int[7];
            int[] nArray2 = new int[7];
            int n2 = (int)this.getHorizontalAnchorLocationFromPaper().getY() - 1;
            nArray[0] = n + 3;
            nArray2[0] = n2 - 10;
            nArray[1] = nArray[0];
            nArray2[1] = n2 - 6;
            nArray[2] = n + 6;
            nArray2[2] = nArray2[1];
            nArray[3] = n;
            nArray2[3] = n2;
            nArray[4] = n - 6;
            nArray2[4] = nArray2[2];
            nArray[5] = n - 3;
            nArray2[5] = nArray2[4];
            nArray[6] = nArray[5];
            nArray2[6] = nArray2[0];
            this.drawAnchor(nArray, nArray2, 7, graphics2D);
        }

        private void drawVerticalAnchor(int n, Graphics2D graphics2D) {
            int[] nArray = new int[7];
            int[] nArray2 = new int[7];
            int n2 = (int)this.getVerticalAnchorLocationFromPaper().getX() - 1;
            nArray[0] = n2 - 10;
            nArray2[0] = n + 3;
            nArray[1] = n2 - 6;
            nArray2[1] = nArray2[0];
            nArray[2] = nArray[1];
            nArray2[2] = n + 6;
            nArray[3] = n2;
            nArray2[3] = n;
            nArray[4] = nArray[2];
            nArray2[4] = n - 6;
            nArray[5] = nArray[4];
            nArray2[5] = n - 3;
            nArray[6] = nArray[0];
            nArray2[6] = nArray2[5];
            this.drawAnchor(nArray, nArray2, 7, graphics2D);
        }

        private void drawAnchor(int[] nArray, int[] nArray2, int n, Graphics2D graphics2D) {
            Polygon polygon = new Polygon(nArray, nArray2, n);
            int n2 = nArray[6];
            int n3 = nArray2[6];
            int n4 = (nArray[2] + nArray[3]) / 2;
            int n5 = (nArray2[2] + nArray2[3]) / 2;
            GradientPaint gradientPaint = new GradientPaint(n2, n3, INNER_COLOR_1, n4, n5, INNER_COLOR_2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(polygon);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.draw(polygon);
        }

        private void drawHorizontalLine(Graphics2D graphics2D) {
            if (this.mHorizontalLocation == null) {
                return;
            }
            Point2D point2D = this.mHorizontalLocation;
            float f = (float)point2D.getX();
            Line2D.Float float_ = new Line2D.Float();
            ((Line2D)float_).setLine(point2D.getX(), this.getHorizontalAnchorLocationFromPaper().getY(), point2D.getX(), this.getHeight());
            graphics2D.setPaint(LINE_COLOR);
            graphics2D.setStroke(LINE_STROKE);
            graphics2D.draw(float_);
        }

        private void drawVerticalLine(Graphics2D graphics2D) {
            if (this.mVerticalLocation == null) {
                return;
            }
            Point2D point2D = this.mVerticalLocation;
            Line2D.Float float_ = new Line2D.Float();
            ((Line2D)float_).setLine(this.getVerticalAnchorLocationFromPaper().getX(), point2D.getY(), this.getWidth(), point2D.getY());
            graphics2D.setPaint(LINE_COLOR);
            graphics2D.setStroke(LINE_STROKE);
            graphics2D.draw(float_);
        }

        private boolean isPressed() {
            return this.mDrawHorizontalLineFlag | this.mDrawVerticalLineFlag;
        }

        private boolean pressed(MouseEvent mouseEvent) {
            int n;
            Point2D point2D = this.getHorizontalAnchorLocationFromPaper();
            int n2 = (int)point2D.getX();
            Rectangle rectangle = new Rectangle(n2 - 5, (n = (int)point2D.getY()) - 10, 10, 10);
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.mDrawHorizontalLineFlag = true;
                this.mHorizontalLocation = point2D;
                this.repaint();
                return true;
            }
            point2D = this.getVerticalAnchorLocationFromPaper();
            n2 = (int)point2D.getX();
            rectangle = new Rectangle(n2 - 10, (n = (int)point2D.getY()) - 5, 10, 10);
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.mDrawVerticalLineFlag = true;
                this.mVerticalLocation = point2D;
                this.repaint();
                return true;
            }
            this.mDrawHorizontalLineFlag = false;
            this.mDrawVerticalLineFlag = false;
            this.mHorizontalLocation = null;
            this.mVerticalLocation = null;
            this.repaint();
            return false;
        }

        private boolean dragged(MouseEvent mouseEvent) {
            this.mHorizontalLocation = mouseEvent.getPoint();
            this.mVerticalLocation = mouseEvent.getPoint();
            return true;
        }

        private boolean released(MouseEvent mouseEvent) {
            float f;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f2 = this.getPaperStartX();
            float f3 = this.getPaperStartY();
            if (this.mDrawHorizontalLineFlag) {
                f = ((float)n - f2) / this.mMagnification;
                if (f < 141.73228f) {
                    f = 141.73228f;
                }
                if (f > 2806.2993f) {
                    f = 2806.2993f;
                }
                this.mWnd.setPaperSize(f, ((SGDrawingWindow)this.mWnd).mPaperSize.y);
                this.mWnd.setChanged(true);
            }
            if (this.mDrawVerticalLineFlag) {
                f = ((float)n2 - f3) / this.mMagnification;
                if (f < 141.73228f) {
                    f = 141.73228f;
                }
                if (f > 2806.2993f) {
                    f = 2806.2993f;
                }
                this.mWnd.setPaperSize(((SGDrawingWindow)this.mWnd).mPaperSize.x, f);
                this.mWnd.setChanged(true);
            }
            if (this.mDrawHorizontalLineFlag | this.mDrawVerticalLineFlag) {
                this.mWnd.updateClientRect();
                this.mWnd.notifyToRoot();
                this.repaint();
            }
            this.mDrawHorizontalLineFlag = false;
            this.mDrawVerticalLineFlag = false;
            this.mHorizontalLocation = null;
            this.mVerticalLocation = null;
            return true;
        }

        private Point2D getHorizontalAnchorLocationFromPaper() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            Point2D.Float float_ = new Point2D.Float(f + 20.0f + f3, 20.0f);
            return float_;
        }

        private Point2D getVerticalAnchorLocationFromPaper() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getHeight();
            Point2D.Float float_ = new Point2D.Float(20.0f, f2 + 20.0f + f3);
            return float_;
        }

        private float getPaperStartX() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            return f + 20.0f;
        }

        private float getPaperStartY() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getY();
            return f + 20.0f;
        }

        private float getPaperEndX() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getWidth();
            return f + 20.0f + f2;
        }

        private float getPaperEndY() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getY();
            float f2 = (float)rectangle2D.getHeight();
            return f + 20.0f + f2;
        }

        private boolean drawRuler(Graphics2D graphics2D) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int[] nArray = new int[6];
            int[] nArray2 = new int[6];
            nArray[0] = 0;
            nArray2[0] = 0;
            nArray[1] = n;
            nArray2[1] = 0;
            nArray[2] = n;
            nArray2[2] = 20;
            nArray[3] = 20;
            nArray2[3] = 20;
            nArray[4] = 20;
            nArray2[4] = n2;
            nArray[5] = 0;
            nArray2[5] = n2;
            Polygon polygon = new Polygon(nArray, nArray2, 6);
            Color color = this.getBackground();
            Color color2 = Color.BLACK;
            graphics2D.setPaint(color);
            graphics2D.fill(polygon);
            graphics2D.setPaint(color2);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(polygon);
            this.drawNumbersAndLines(graphics2D);
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 20.0f, 20.0f);
            graphics2D.setPaint(color);
            graphics2D.fill(float_);
            graphics2D.setPaint(color2);
            graphics2D.draw(float_);
            return true;
        }

        private boolean drawNumbersAndLines(Graphics2D graphics2D) {
            float f;
            int n;
            float f2;
            float f3;
            int n2;
            float f4;
            int n3;
            int n4;
            float f5 = this.mMagnification;
            int n5 = this.getWidth();
            int n6 = this.getHeight();
            Rectangle rectangle = new Rectangle(0, 0, n5 - 20, n6 - 20);
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            Rectangle2D rectangle2D2 = this.mWnd.getClientRect();
            Line2D.Float float_ = new Line2D.Float();
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(2.0f));
            float f6 = n5;
            ((Line2D)float_).setLine(20.0, 20.0, f6, 20.0);
            graphics2D.draw(float_);
            float f7 = n6;
            ((Line2D)float_).setLine(20.0, 20.0, 20.0, f7);
            graphics2D.draw(float_);
            Font font = this.mRulerFont;
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setFont(font);
            f6 = font.getSize();
            if (f5 < 0.5f) {
                n4 = 4;
                n3 = 8;
            } else if (f5 < 1.0f) {
                n4 = 2;
                n3 = 4;
            } else {
                n4 = 1;
                n3 = 4;
            }
            float f8 = f5 / 0.035277776f;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            float f9 = (float)rectangle2D.getX();
            float f10 = -f9;
            float f11 = f10 / f8;
            float f12 = (float)rectangle.getWidth() + f10;
            int n7 = (int)f11;
            if (n7 % n4 != 0) {
                n7 = n7 / n4 * n4;
            }
            int n8 = n7;
            while (!((f4 = f8 * (float)n8) > f12)) {
                arrayList.add(new Integer(n8));
                n8 += n4;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                n2 = (Integer)arrayList.get(i);
                f3 = (float)n2 * f8;
                f2 = f9 + 20.0f + f3;
                ((Line2D)float_).setLine(f2, 4.0, f2, 20.0);
                graphics2D.draw(float_);
                int n9 = (int)(f2 + 0.3f * f6);
                n = (int)f6 + 1;
                graphics2D.drawString(Integer.toString(n2), n9, n);
                for (int j = 0; j < n3; ++j) {
                    float f13 = f2 + 0.2f * (float)(j + 1) * f8 * (float)n4;
                    ((Line2D)float_).setLine(f13, 15.0, f13, 20.0);
                    graphics2D.draw(float_);
                }
            }
            arrayList = new ArrayList();
            f9 = (float)rectangle2D.getY();
            f10 = -f9;
            f11 = f10 / f8;
            f12 = (float)rectangle.getHeight() + f10;
            n7 = (int)f11;
            if (n7 % n4 != 0) {
                n7 = n7 / n4 * n4;
            }
            n8 = n7;
            while (!((f = f8 * (float)n8) > f12)) {
                arrayList.add(new Integer(n8));
                n8 += n4;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                int n10;
                n2 = (Integer)arrayList.get(i);
                f3 = (float)n2 * f8;
                f2 = f9 + 20.0f + f3;
                ((Line2D)float_).setLine(4.0, f2, 20.0, f2);
                graphics2D.draw(float_);
                n = (int)(f2 + f6 + 1.0f);
                char[] cArray = Integer.toString(n2).toCharArray();
                for (n10 = 0; n10 < cArray.length; ++n10) {
                    Character c = new Character(cArray[n10]);
                    graphics2D.drawString(c.toString(), 4, n);
                    n += (int)f6;
                }
                for (n10 = 0; n10 < n3; ++n10) {
                    float f14 = f2 + 0.2f * (float)(n10 + 1) * f8 * (float)n4;
                    ((Line2D)float_).setLine(15.0, f14, 20.0, f14);
                    graphics2D.draw(float_);
                }
            }
            return true;
        }
    }

    private static class BackgroundPanel
    extends InnerPanel {
        private boolean mGridVisibleFlag = true;
        private float mGridInterval = 28.346458f;
        private float mGridLineWidth = 1.0f;
        private Color mGridLineColor = SGDefaultValues.GRID_LINE_COLOR;
        private Color mPaperColor = SGDefaultValues.WINDOW_PAPER_COLOR;

        protected BackgroundPanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(true);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            float f4 = (float)rectangle2D.getHeight();
            Rectangle2D rectangle2D2 = this.mWnd.getViewportBounds();
            float f5 = (float)rectangle2D2.getX();
            float f6 = (float)rectangle2D2.getY();
            float f7 = (float)rectangle2D2.getWidth();
            float f8 = (float)rectangle2D2.getHeight();
            graphics2D.setPaint(this.getPaperColor());
            graphics2D.fill(rectangle2D);
            Line2D.Float float_ = new Line2D.Float();
            if (this.isGridVisible()) {
                graphics2D.setStroke(new BasicStroke(this.getGridLineWidth()));
                graphics2D.setPaint(this.getGridLineColor());
                float[] fArray = this.getVerticalGridLocation();
                for (int i = 0; i < fArray.length; ++i) {
                    float f9 = fArray[i];
                    ((Line2D)float_).setLine(f9, f2, f9, f2 + f4);
                    graphics2D.draw(float_);
                }
                float[] fArray2 = this.getHorizontalGridLocation();
                for (int i = 0; i < fArray2.length; ++i) {
                    float f10 = fArray2[i];
                    ((Line2D)float_).setLine(f, f10, f + f3, f10);
                    graphics2D.draw(float_);
                }
            }
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(rectangle2D);
        }

        public float[] getVerticalGridLocation() {
            float f;
            float f2 = this.mMagnification * this.getGridInterval();
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f3 = (float)rectangle2D.getX();
            float f4 = (float)rectangle2D.getWidth();
            Rectangle2D rectangle2D2 = this.mWnd.getViewportBounds();
            float f5 = (float)rectangle2D2.getX();
            float f6 = (float)rectangle2D2.getWidth();
            ArrayList<Float> arrayList = new ArrayList<Float>();
            int n = (int)((f5 - f3) / f2) + 1;
            while (!((f = (float)n * f2 + f3) > f5 + f6) && !(f > f3 + f4)) {
                arrayList.add(new Float(f));
                ++n;
            }
            float[] fArray = new float[arrayList.size()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = ((Float)arrayList.get(i)).floatValue();
            }
            return fArray;
        }

        public float[] getHorizontalGridLocation() {
            float f;
            float f2 = this.mMagnification * this.getGridInterval();
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f3 = (float)rectangle2D.getY();
            float f4 = (float)rectangle2D.getHeight();
            Rectangle2D rectangle2D2 = this.mWnd.getViewportBounds();
            float f5 = (float)rectangle2D2.getY();
            float f6 = (float)rectangle2D2.getHeight();
            ArrayList<Float> arrayList = new ArrayList<Float>();
            int n = (int)((f5 - f3) / f2) + 1;
            while (!((f = (float)n * f2 + f3) > f5 + f6) && !(f > f3 + f4)) {
                arrayList.add(new Float(f));
                ++n;
            }
            float[] fArray = new float[arrayList.size()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = ((Float)arrayList.get(i)).floatValue();
            }
            return fArray;
        }

        public float getGridInterval() {
            return this.mGridInterval;
        }

        public Color getGridLineColor() {
            return this.mGridLineColor;
        }

        public float getGridLineWidth() {
            return this.mGridLineWidth;
        }

        public boolean isGridVisible() {
            return this.mGridVisibleFlag;
        }

        public void setGridInterval(float f) {
            this.mGridInterval = f;
        }

        public void setGridLineColor(Color color) {
            this.mGridLineColor = color;
        }

        public void setGridLineWidth(float f) {
            this.mGridLineWidth = f;
        }

        public void setGridVisible(boolean bl) {
            this.mGridVisibleFlag = bl;
        }

        public Color getPaperColor() {
            return this.mPaperColor;
        }

        public void setPaperColor(Color color) {
            this.mPaperColor = color;
        }
    }

    private static class ForegroundPanel
    extends InnerPanel {
        public static final float ANCHOR_SIZE = 6.0f;

        protected ForegroundPanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(false);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            ArrayList arrayList = this.mWnd.getFocusedObjectsList();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                if (!sGFigure.isSelectionSymbolsVisible()) continue;
                Rectangle2D rectangle2D = sGFigure.getRubberBandRect();
                if (SGFigure.mRubberBandFlag & SGFigure.mRubberBandVisibleFlag) {
                    this.drawRubberBand(graphics2D, rectangle2D.getBounds());
                }
                Rectangle2D rectangle2D2 = sGFigure.getGraphRect();
                int n = (int)rectangle2D2.getX();
                int n2 = (int)rectangle2D2.getY();
                int n3 = (int)rectangle2D2.getWidth();
                int n4 = (int)rectangle2D2.getHeight();
                this.drawAnchor(graphics2D, n, n2);
                this.drawAnchor(graphics2D, n + n3, n2);
                this.drawAnchor(graphics2D, n, n2 + n4);
                this.drawAnchor(graphics2D, n + n3, n2 + n4);
                this.drawAnchor(graphics2D, n + n3 / 2, n2);
                this.drawAnchor(graphics2D, n, n2 + n4 / 2);
                this.drawAnchor(graphics2D, n + n3 / 2, n2 + n4);
                this.drawAnchor(graphics2D, n + n3, n2 + n4 / 2);
            }
        }

        private void drawAnchor(Graphics2D graphics2D, int n, int n2) {
            Ellipse2D.Float float_ = new Ellipse2D.Float((float)n - 3.0f, (float)n2 - 3.0f, 6.0f, 6.0f);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.draw(float_);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill(float_);
        }

        private void drawRubberBand(Graphics2D graphics2D, Rectangle rectangle) {
            graphics2D.setPaint(Color.BLACK);
            float[] fArray = new float[]{4.0f, 2.0f};
            graphics2D.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, fArray, 0.0f));
            graphics2D.draw(rectangle);
        }
    }

    private static abstract class InnerPanel
    extends JPanel {
        protected float mMagnification = 1.0f;
        protected SGDrawingWindow mWnd = null;

        protected InnerPanel(SGDrawingWindow sGDrawingWindow) {
            this.mWnd = sGDrawingWindow;
        }

        public void setMagnification(float f) {
            this.mMagnification = f;
        }
    }

    private static class ExportPanel
    extends JPanel {
        private ArrayList mPrintableList = new ArrayList();

        private ExportPanel() {
        }

        private void add(SGFigure sGFigure) {
            ArrayList arrayList = this.mPrintableList;
            arrayList.add(sGFigure);
            SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArrayFromLayer();
            for (int i = sGIFigureElementArray.length - 1; i >= 0; --i) {
                arrayList.add(sGIFigureElementArray[i]);
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            ArrayList arrayList = this.mPrintableList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGIPaintable sGIPaintable = (SGIPaintable)arrayList.get(i);
                sGIPaintable.paintGraphics(graphics, false);
            }
        }
    }

    private static class InfoForExport {
        float mag;
        float hValue;
        float vValue;
        SGTuple2f[] locationArray;
        ArrayList visibleList;

        private InfoForExport() {
        }
    }
}

