;Samurai Graph installer script for Win32

!define SG_PRODUCT       "Samurai Graph"
!define SG_VER_MAJOR     "0"
!define SG_VER_MINOR     "6"
!define SG_VER_MICRO     "1"
!define SG_URL           "http://samurai-graph.sourceforge.jp/"
!define SG_PUBLISHER     "RIKEN BSI Neuroinformatics Laboratory"
!define SG_PUBLISHER_URL "http://www.ni.brain.riken.jp/"

!define SG_NAME    "${SG_PRODUCT} ${SG_VERSION}"
!define SG_VERSION "${SG_VER_MAJOR}.${SG_VER_MINOR}.${SG_VER_MICRO}"
!define SG_REGKEY  "Software\${SG_PRODUCT}"
!define SG_UNINST_REGKEY  "Software\Microsoft\Windows\CurrentVersion\Uninstall\${SG_NAME}"

!define SG_PROPERTY_EXT_REGKEY         ".sgp"
!define SG_PROPERTY_EXT_BACKUP_REGKEY  "backup_val"
!define SG_PROPERTY_REGKEY             "SamuraiGraphPropertyFile"
!define SG_PROPERTY_LABEL              "Samurai Graph Property File"

;!define SG_SELECT_COMPONENTS  "YES"

!include "MUI.nsh"

;--------------------------------
;General

  ;Name and file
  Name "${SG_NAME}"
  OutFile "samurai-graph-win32-${SG_VERSION}.exe"

  ;Default installation folder
  InstallDir "$PROGRAMFILES\${SG_PRODUCT}"
  
  ;Get installation folder from registry if available
  InstallDirRegKey HKLM "${SG_REGKEY}" ""

  ;------------------------------
  ;Interface Configuration

  ; Installer and uninstaller icon file
  !define MUI_ICON   "resources\setup.ico"
  !define MUI_UNICON "resources\remove.ico"
  ; welcome page bitmap
  !define MUI_WELCOMEFINISHPAGE_BITMAP "resources\welcome.bmp"
  !define MUI_WELCOMEFINISHPAGE_BITMAP_NOSTRETCH
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP "resources\unwelcome.bmp"
  !define MUI_UNWELCOMEFINISHPAGE_BITMAP_NOSTRETCH

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
!ifdef SG_SELECT_COMPONENTS
  !insertmacro MUI_PAGE_COMPONENTS
!endif
  !insertmacro MUI_PAGE_DIRECTORY
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH

  !insertmacro MUI_UNPAGE_WELCOME
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES
  !insertmacro MUI_UNPAGE_FINISH

;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING
  
;--------------------------------
;Languages
  !insertmacro MUI_LANGUAGE "English"
  !insertmacro MUI_LANGUAGE "Japanese"
  !include "languages\english.nsh"
  !include "languages\japanese.nsh"

;-------------------------
;Installer Sections

Function .onInit

   ; If it is failed to extract the installation directory from command lines,
   ; find the keyword "/D=", extract the installation directory, and set it
   ; to the variable $INSTDIR.

   Push $R0
   Push $R1
   Push $R2
   Push $R3  ; length of commad line

   StrCpy $R2 0
   StrLen $R3 $CMDLINE

   loop:
     StrCpy $R0 $CMDLINE 3 $R2
     StrCpy $R1 "/D="
     StrCmp $R0 $R1 get
     StrCmp $R2 $R3 end
     IntOp $R2 $R2 + 1
     Goto loop

   get:
     IntOp $R2 $R2 + 3
     IntOp $R1 $R3 - $R2
     IntOp $R1 $R1 - 1
     StrCpy $R0 $CMDLINE $R1 $R2
     StrCpy $INSTDIR $R0

   end:

   Pop $R3
   Pop $R2
   Pop $R1
   Pop $R0
FunctionEnd

Section "Samura Graph" SecCopyUI
  ;Check an old version
  Push $R0
  Push $R1
  Push $R2
  Push $R3
  ReadRegStr $R0 HKLM "${SG_REGKEY}" ""
  StrCmp $R0 "" NoOldVer
  ReadRegDWORD $R1 HKLM "${SG_REGKEY}" "VersionMajor"
  ReadRegDWORD $R2 HKLM "${SG_REGKEY}" "VersionMinor"
  ReadRegDWORD $R3 HKLM "${SG_REGKEY}" "VersionMicro"
  IntCmp $R1 ${SG_VER_MAJOR} IsSameMajorVer MessageOldVer MessageNewVer
IsSameMajorVer:
  IntCmp $R2 ${SG_VER_MINOR} IsSameMinorVer MessageOldVer MessageNewVer
IsSameMinorVer:
  IntCmp $R3 ${SG_VER_MICRO} MessageSameVer MessageOldVer MessageNewVer
MessageOldVer:
  MessageBox MB_YESNO|MB_ICONEXCLAMATION|MB_TOPMOST $(DESC_OverwriteOldVer) IDYES DoUnInstPrevInst
  goto DoAbortInst
MessageNewVer:
  MessageBox MB_YESNO|MB_ICONEXCLAMATION|MB_TOPMOST $(DESC_OverwriteNewVer) IDYES DoUnInstPrevInst
  goto DoAbortInst
MessageSameVer:
  MessageBox MB_YESNO|MB_ICONEXCLAMATION|MB_TOPMOST $(DESC_OverwriteSameVer) IDYES DoUnInstPrevInst
DoAbortInst:
  DetailPrint "The installation was canceled.."
  Abort
DoUnInstPrevInst:
  ExecWait '"$R0\Uninstall.exe" /S'
  Sleep 500
NoOldVer:
  Pop $R3
  Pop $R2
  Pop $R1
  Pop $R0

  WriteRegStr HKLM "${SG_REGKEY}" "" $INSTDIR
  WriteRegDWORD HKLM "${SG_REGKEY}" "VersionMajor"   "${SG_VER_MAJOR}"
  WriteRegDWORD HKLM "${SG_REGKEY}" "VersionMinor"   "${SG_VER_MINOR}"
  WriteRegDWORD HKLM "${SG_REGKEY}" "VersionMicro"   "${SG_VER_MICRO}"

  ;Install Files
  SetOutPath "$INSTDIR"
;  File ..\..\SamuraiGraph.exe
  File ..\..\dist\COPYING.txt
  File ..\..\dist\LICENSE.txt
  File resources\samurai-graph.ico
  File resources\samurai-graph-property.ico
  File ..\..\dist\samurai-graph.jar
;  File ..\..\dist\samurai-graph-client.jar

  SetOutPath "$INSTDIR\lib"
  File ..\..\helper\lib\upgrade-helper.jar

  SetOutPath "$INSTDIR\lib\vectorgraphics"
  File ..\..\dist\lib\vectorgraphics\freehep-base.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphics2d.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-cgm.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-emf.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-gif.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-java.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-pdf.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-ppm.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-ps.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-svg.jar
  File ..\..\dist\lib\vectorgraphics\freehep-graphicsio-swf.jar

  SetOutPath "$INSTDIR\doc\vectorgraphics"
  File ..\..\dist\doc\vectorgraphics\LGPL.txt
  File ..\..\dist\doc\vectorgraphics\LICENSE.txt
  File ..\..\dist\doc\vectorgraphics\SAMURAIGRAPH-ChangeLog.txt
  File ..\..\dist\doc\vectorgraphics\ReleaseNotes-1.2.2.html

  SetOutPath "$INSTDIR\examples"
  File ..\..\examples\data\ReadMe.txt
  File ..\..\examples\data\Example1.txt
  File ..\..\examples\data\Example2.txt
  File ..\..\examples\data\Example3.txt
  File ..\..\examples\data\Example4.txt
  File ..\..\examples\data\Example5.txt
  File ..\..\examples\data\Example6.txt
  File ..\..\examples\data\Example7.txt
  File ..\..\examples\data\Property1.sgp
  File ..\..\examples\data\Property2.sgp
  File ..\..\examples\data\Property3.sgp

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

SectionEnd

;--------------------------------
; Section for Create shortcut on Desktop

Section "Desktop Shortcut" DesktopIcon
  Call GetJRE
  Pop $R0
  SetOutPath "$INSTDIR\"
;  CreateShortCut  "$DESKTOP\${SG_NAME}.lnk" "$INSTDIR\SamuraiGraph.exe"
  CreateShortCut  "$DESKTOP\${SG_NAME}.lnk" "$R0" '-Xmx128M -jar "$INSTDIR\samurai-graph.jar"' "$INSTDIR\samurai-graph.ico" 0
SectionEnd

;--------------------------------
; Section for Create shortcut on Start Menu

Section "Start Menu Shortcuts" StartMenu
  Call GetJRE
  Pop $R0
  SetOutPath "$INSTDIR\"
  CreateDirectory "$SMPROGRAMS\${SG_NAME}"
;  CreateShortCut  "$SMPROGRAMS\${SG_NAME}\${SG_PRODUCT}.lnk" "$INSTDIR\SamuraiGraph.exe"
  CreateShortCut  "$SMPROGRAMS\${SG_NAME}\${SG_PRODUCT}.lnk" "$R0" '-Xmx128M -jar "$INSTDIR\samurai-graph.jar"' "$INSTDIR\samurai-graph.ico" 0
  CreateShortCut  "$SMPROGRAMS\${SG_NAME}\${SG_PRODUCT} Examples Directory.lnk" "$INSTDIR\examples"
  WriteINIStr "$SMPROGRAMS\${SG_NAME}\${SG_PRODUCT} Site.url" "InternetShortcut" "URL" "${SG_URL}"
  CreateShortCut  "$SMPROGRAMS\${SG_NAME}\Uninstall.lnk" "$INSTDIR\Uninstall.exe" "" "$INSTDIR\Uninstall.exe" 0
SectionEnd

;--------------------------------
; Section for Write Registry
Section -post
  Push $0
  ; Write to Registry Uninstall information
  WriteRegExpandStr HKLM "${SG_UNINST_REGKEY}" "UninstallString" '"$INSTDIR\Uninstall.exe"'
  WriteRegExpandStr HKLM "${SG_UNINST_REGKEY}" "InstallLocation" "$INSTDIR"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "DisplayName" "${SG_NAME}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "DisplayIcon" "$INSTDIR\samurai-graph.ico,0"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "DisplayVersion" "${SG_VERSION}"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "VersionMajor"   "${SG_VER_MAJOR}"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "VersionMinor"   "${SG_VER_MINOR}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "Publisher"      "${SG_PUBLISHER}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "URLInfoAbout"   "${SG_PUBLISHER_URL}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "HelpLink"       "${SG_URL}"
  WriteRegStr   HKLM "${SG_UNINST_REGKEY}" "URLUpdateInfo"  "${SG_URL}"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "NoModify" "1"
  WriteRegDWORD HKLM "${SG_UNINST_REGKEY}" "NoRepair" "1"

  ; Write to Registry Samurai Graph Property File Icon
  WriteRegStr HKCR "${SG_PROPERTY_REGKEY}" "" "${SG_PROPERTY_LABEL}"
  WriteRegStr HKCR "${SG_PROPERTY_REGKEY}\DefaultIcon" "" "$INSTDIR\samurai-graph-property.ico,0"
  ReadRegStr $0 HKCR "${SG_PROPERTY_EXT_REGKEY}" ""
  StrCmp $0 "" 0 DoWrite
  StrCmp $0 "${SG_PROPERTY_LABEL}" 0 DoWrite
  WriteRegStr HKCR "${SG_PROPERTY_EXT_REGKEY}" "${SG_PROPERTY_EXT_BACKUP_REGKEY}" $0
  DoWrite:
  WriteRegStr HKCR "${SG_PROPERTY_EXT_REGKEY}" "" "${SG_PROPERTY_REGKEY}"
  Pop $0

  ; Write to Registry Samurai Graph Property File Association 
  Call GetJRE
  Pop $R0
  SetOutPath "$INSTDIR\"
;  WriteRegStr HKCR "${SG_PROPERTY_REGKEY}\shell\open\command" "" '"$INSTDIR\SamuraiGraph.exe" -prop "%1"'
  WriteRegStr HKCR "${SG_PROPERTY_REGKEY}\shell\open\command" "" '$R0 -Xmx128M -jar "$INSTDIR\samurai-graph.jar" -prop "%1"'

SectionEnd


!ifdef SG_SELECT_COMPONENTS
;--------------------------------
;Descriptions

  ;Assign language strings to sections
  !insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
    !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyUI} $(DESC_SecCopyUI)
    !insertmacro MUI_DESCRIPTION_TEXT ${DesktopIcon} $(DESC_DesktopIcon)
    !insertmacro MUI_DESCRIPTION_TEXT ${StartMenu} $(DESC_StartMenu)
  !insertmacro MUI_FUNCTION_DESCRIPTION_END
!endif

;-------------------------
;Uninstaller Section

!include "WinMessages.nsh"

Function un.CloseProgram
  Push $0
  loop:
    FindWindow $0 "jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow"
    IntCmp $0 0 done
    SendMessage $0 ${WM_CLOSE} 0 0
    Sleep 300
    Goto loop
  done:
  Pop $0
FunctionEnd

Section "Uninstall"
  ;If Samurai Graph windows exist, close them.
  Call un.CloseProgram

  Push $0

  ;Uninstall Files
;  Delete "$INSTDIR\SamuraiGraph.exe"
  Delete "$INSTDIR\COPYING.txt"
  Delete "$INSTDIR\LICENSE.txt"
  Delete "$INSTDIR\samurai-graph.ico"
  Delete "$INSTDIR\samurai-graph.jar"
;  Delete "$INSTDIR\samurai-graph-client.jar"

  Delete "$INSTDIR\lib\upgrade-helper.jar"

  Delete "$INSTDIR\lib\vectorgraphics\freehep-base.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphics2d.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-cgm.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-emf.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-gif.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-java.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-pdf.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-ppm.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-ps.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-svg.jar"
  Delete "$INSTDIR\lib\vectorgraphics\freehep-graphicsio-swf.jar"

  Delete "$INSTDIR\doc\vectorgraphics\LGPL.txt"
  Delete "$INSTDIR\doc\vectorgraphics\LICENSE.txt"
  Delete "$INSTDIR\doc\vectorgraphics\SAMURAIGRAPH-ChangeLog.txt"
  Delete "$INSTDIR\doc\vectorgraphics\ReleaseNotes-1.2.2.html"

  Delete "$INSTDIR\examples\ReadMe.txt"
  Delete "$INSTDIR\examples\Example1.txt"
  Delete "$INSTDIR\examples\Example2.txt"
  Delete "$INSTDIR\examples\Example3.txt"
  Delete "$INSTDIR\examples\Example4.txt"
  Delete "$INSTDIR\examples\Example5.txt"
  Delete "$INSTDIR\examples\Example6.txt"
  Delete "$INSTDIR\examples\Example7.txt"
  Delete "$INSTDIR\examples\Property1.sgp"
  Delete "$INSTDIR\examples\Property2.sgp"
  Delete "$INSTDIR\examples\Property3.sgp"

  Delete "$INSTDIR\Uninstall.exe"

  ; desktop
  Delete "$DESKTOP\${SG_PRODUCT} ${SG_VERSION}.lnk"

  ; start menu
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT}.lnk"
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT} Examples Directory.lnk"
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\${SG_PRODUCT} Site.url"
  Delete "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}\Uninstall.lnk"
  RMDir  "$SMPROGRAMS\${SG_PRODUCT} ${SG_VERSION}"

  RMDir "$INSTDIR\lib\vectorgraphics"
  RMDir "$INSTDIR\lib"
  RMDir "$INSTDIR\doc\vectorgraphics"
  RMDir "$INSTDIR\doc"
  RMDir "$INSTDIR\examples\data"
  RMDir "$INSTDIR\examples"
  RMDir /r "$INSTDIR"

  ; delete regkeys for uninstall information 
  DeleteRegValue HKLM "${SG_REGKEY}" "VersionMajor"
  DeleteRegValue HKLM "${SG_REGKEY}" "VersionMinor"
  DeleteRegValue HKLM "${SG_REGKEY}" "VersionMicro"
  DeleteRegKey /ifempty HKLM "${SG_REGKEY}"
  DeleteRegKey HKLM "${SG_UNINST_REGKEY}"

  ; delete regkeys for property file
  DeleteRegKey HKCR "${SG_PROPERTY_EXT_REGKEY}"
  ReadRegStr $0 HKCR "${SG_PROPERTY_EXT_REGKEY}" ""
  StrCmp $0 "${SG_PROPERTY_LABEL}" 0 NoOwn
  ReadRegStr $0 HKCR "${SG_PROPERTY_EXT_REGKEY}" "${SG_PROPERTY_EXT_BACKUP_REGKEY}"
  StrCmp $0 "" 0 RestoreBackup
  DeleteRegKey HKCR "${SG_PROPERTY_EXT_REGKEY}"
  Goto NoOwn
  RestoreBackup:
  WriteRegStr HKCR "${SG_PROPERTY_EXT_REGKEY}" "" $0
  DeleteRegValue HKCR "${SG_PROPERTY_EXT_REGKEY}" "${SG_PROPERTY_EXT_BACKUP_REGKEY}"
  NoOwn:
  Pop $0
SectionEnd

;  Find JRE (javaw.exe)
Function GetJRE
;  1 - in .\jre directory (JRE Installed with application)
;  2 - in JAVA_HOME environment variable
;  3 - in the registry
;  4 - assume java.exe in current dir or PATH

  Push $R0
  Push $R1

  ClearErrors
  StrCpy $R0 "$EXEDIR\jre\bin\javaw.exe"
  IfFileExists $R0 JreFound
  StrCpy $R0 ""

  ClearErrors
  ReadEnvStr $R0 "JAVA_HOME"
  StrCpy $R0 "$R0\bin\javaw.exe"
  IfErrors 0 JreFound

  ClearErrors
  ReadRegStr $R1 HKLM "SOFTWARE\JavaSoft\Java Development Kit" "CurrentVersion"
  ReadRegStr $R0 HKLM "SOFTWARE\JavaSoft\Java Development Kit\$R1" "JavaHome"
  StrCpy $R0 "$R0\jre\bin\javaw.exe"
  IfErrors 0 JreFound

  StrCpy $R0 "javaw.exe"
        
 JreFound:
  Pop $R1
  Exch $R0
FunctionEnd
