/*
 * SGAxisBreakSymbolDialog.java
 *
 * Created on 2004/09/30, 11:02
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.SpinnerNumberModel;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGAxisBreakSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisBreakElement.AxisBreakSymbolWithAxesProperties;


/**
 *
 * @author  kuromaru
 */
public class SGAxisBreakSymbolDialog extends SGPropertyDialog
{

	public static final String TITLE = "Axis Break Symbol Properties";


    /** Creates new form SGAxisBreakSymbolDialog */
    public SGAxisBreakSymbolDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mPanel = new javax.swing.JPanel();
        mSizeSeparator = new javax.swing.JSeparator();
        mFormSeparator = new javax.swing.JSeparator();
        mColorSeparator = new javax.swing.JSeparator();
        mDistortionLabel = new javax.swing.JLabel();
        mAngleLabel = new javax.swing.JLabel();
        mDistortionSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mAngleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mSizeLabel = new javax.swing.JLabel();
        mFormLabel = new javax.swing.JLabel();
        mLengthLabel = new javax.swing.JLabel();
        mLengthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mIntervalLabel = new javax.swing.JLabel();
        mIntervalSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineWidthLabel = new javax.swing.JLabel();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mColorLabel = new javax.swing.JLabel();
        mInnerColorButton = new javax.swing.JButton();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mLineColorLabel = new javax.swing.JLabel();
        mLineColorButton = new javax.swing.JButton();
        mInnerColorLabel = new javax.swing.JLabel();
        mHorizontalRadioButton = new javax.swing.JRadioButton();
        mVerticalRadioButton = new javax.swing.JRadioButton();
        mLocationLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mXValueLabel = new javax.swing.JLabel();
        mXValueTextField = new javax.swing.JTextField();
        mYValueLabel = new javax.swing.JLabel();
        mYValueTextField = new javax.swing.JTextField();
        mCommonPanel = new javax.swing.JPanel();
        mLeftTopRadioButton = new javax.swing.JRadioButton();
        mLeftBottomRadioButton = new javax.swing.JRadioButton();
        mRightTopRadioButton = new javax.swing.JRadioButton();
        mRightBottomRadioButton = new javax.swing.JRadioButton();
        mScaleReferenceLabel2 = new javax.swing.JLabel();
        mScaleReferenceLabel1 = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 35, 0, 0);
        mPanel.add(mSizeSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 45, 0, 0);
        mPanel.add(mFormSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 45, 0, 0);
        mPanel.add(mColorSeparator, gridBagConstraints);

        mDistortionLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mDistortionLabel.setText("Distortion");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mDistortionLabel, gridBagConstraints);

        mAngleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mAngleLabel.setText("Angle");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mPanel.add(mAngleLabel, gridBagConstraints);

        mDistortionSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mDistortionSpinner, gridBagConstraints);

        mAngleSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mAngleSpinner, gridBagConstraints);

        mSizeLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mSizeLabel, gridBagConstraints);

        mFormLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFormLabel.setText("Form");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFormLabel, gridBagConstraints);

        mLengthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLengthLabel.setText("Length");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLengthLabel, gridBagConstraints);

        mLengthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLengthSpinner, gridBagConstraints);

        mIntervalLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mIntervalLabel.setText("Interval");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mPanel.add(mIntervalLabel, gridBagConstraints);

        mIntervalSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mIntervalSpinner, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Line Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLineWidthLabel, gridBagConstraints);

        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLineWidthSpinner, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mColorLabel, gridBagConstraints);

        mInnerColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mPanel.add(mInnerColorButton, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        mPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        mPanel.add(mRightSpaceLabel, gridBagConstraints);

        mLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineColorLabel.setText("Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mPanel.add(mLineColorLabel, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mPanel.add(mLineColorButton, gridBagConstraints);

        mInnerColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mInnerColorLabel.setText("Inner");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mPanel.add(mInnerColorLabel, gridBagConstraints);

        mHorizontalRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mHorizontalRadioButton.setText("Horizontal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mHorizontalRadioButton, gridBagConstraints);

        mVerticalRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mVerticalRadioButton.setText("Vertical");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mVerticalRadioButton, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLocationLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 60, 0, 0);
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        mPanel.add(mLocationSeparator, gridBagConstraints);

        mXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mXValueLabel.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mXValueLabel, gridBagConstraints);

        mXValueTextField.setColumns(6);
        mXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mXValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mXValueTextField, gridBagConstraints);

        mYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mYValueLabel.setText("Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mYValueLabel, gridBagConstraints);

        mYValueTextField.setColumns(6);
        mYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mYValueTextField.setPreferredSize(new java.awt.Dimension(72, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mYValueTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mPanel, gridBagConstraints);

        mCommonPanel.setLayout(new java.awt.GridBagLayout());

        mLeftTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftTopRadioButton.setText("Left/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftTopRadioButton, gridBagConstraints);

        mLeftBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mLeftBottomRadioButton.setText("Left/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mLeftBottomRadioButton, gridBagConstraints);

        mRightTopRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightTopRadioButton.setText("Right/Top");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightTopRadioButton, gridBagConstraints);

        mRightBottomRadioButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mRightBottomRadioButton.setText("Right/Bottom");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        mCommonPanel.add(mRightBottomRadioButton, gridBagConstraints);

        mScaleReferenceLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleReferenceLabel2.setText("(Value <-> Scale)");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mCommonPanel.add(mScaleReferenceLabel2, gridBagConstraints);

        mScaleReferenceLabel1.setFont(new java.awt.Font("Dialog", 1, 12));
        mScaleReferenceLabel1.setText("Scale Reference");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 7;
        mCommonPanel.add(mScaleReferenceLabel1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mCommonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JLabel mAngleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mAngleSpinner;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JSeparator mColorSeparator;
    private javax.swing.JPanel mCommonPanel;
    private javax.swing.JLabel mDistortionLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mDistortionSpinner;
    private javax.swing.JLabel mFormLabel;
    private javax.swing.JSeparator mFormSeparator;
    private javax.swing.JRadioButton mHorizontalRadioButton;
    private javax.swing.JButton mInnerColorButton;
    private javax.swing.JLabel mInnerColorLabel;
    private javax.swing.JLabel mIntervalLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mIntervalSpinner;
    private javax.swing.JRadioButton mLeftBottomRadioButton;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JRadioButton mLeftTopRadioButton;
    private javax.swing.JLabel mLengthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLengthSpinner;
    private javax.swing.JButton mLineColorButton;
    private javax.swing.JLabel mLineColorLabel;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JRadioButton mRightBottomRadioButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JRadioButton mRightTopRadioButton;
    private javax.swing.JLabel mScaleReferenceLabel1;
    private javax.swing.JLabel mScaleReferenceLabel2;
    private javax.swing.JLabel mSizeLabel;
    private javax.swing.JSeparator mSizeSeparator;
    private javax.swing.JRadioButton mVerticalRadioButton;
    private javax.swing.JLabel mXValueLabel;
    private javax.swing.JTextField mXValueTextField;
    private javax.swing.JLabel mYValueLabel;
    private javax.swing.JTextField mYValueTextField;
    // ϐ錾̏I//GEN-END:variables




	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGAxisBreakSymbolDialog.TITLE );


		//
		// set the spinner model
		//

		// length
		this.mLengthSpinner.initProperties(
			new SpinnerNumberModel( 0.50, 0.50, 2.0, 0.10 ),
			SGSpinner.SPINNER_UNIT_CM );

		// interval
		this.mIntervalSpinner.initProperties(
			new SpinnerNumberModel( 0.50, 0.10, 2.0, 0.10 ),
			SGSpinner.SPINNER_UNIT_CM );

		// distortion
		this.mDistortionSpinner.initProperties(
			new SpinnerNumberModel( 0.0, -1.0, 1.0, 0.10 ),
			null );

		// angle
		final float max = SGAxisBreakSymbol.ANGLE_ABS_MAX/RADIAN_DEGREE_RATIO;
		this.mAngleSpinner.initProperties(
			new SpinnerNumberModel( 0.0, -max, max, 1.0 ),
			SGSpinner.SPINNER_UNIT_DEGREE );

		// line width
		this.mLineWidthSpinner.initProperties(
			this.getLineWidthSpinnerNumberModel(),
			SGSpinner.SPINNER_UNIT_PT );


		//
		// create a radio-button-group
		//
		{
			final ButtonGroup group = new ButtonGroup();
			group.add( this.mHorizontalRadioButton );
			group.add( this.mVerticalRadioButton );
		}
		{
			final ButtonGroup group = new ButtonGroup();
			group.add( this.mLeftBottomRadioButton );
			group.add( this.mLeftTopRadioButton );
			group.add( this.mRightBottomRadioButton );
			group.add( this.mRightTopRadioButton );
			group.add( this.mNoAxisSelectionRadioButton );
		}


		//
		// add action listeners
		//

{
	this.mOKButton.addActionListener(this);
	this.mCancelButton.addActionListener(this);
	this.mPreviewButton.addActionListener(this);
}

		this.mLineColorButton.addActionListener(this);
		this.mInnerColorButton.addActionListener(this);


		// add as an action listener to spinners
		final ArrayList sList = this.getSpinnerList();
		for( int ii=0; ii<sList.size(); ii++ )
		{
			SGSpinner spinner = (SGSpinner)sList.get(ii);
			spinner.getFormattedTextField().addActionListener( this );
		}

		this.mXValueTextField.addActionListener( this );
		this.mYValueTextField.addActionListener( this );
		

		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mLineColorButton;

/*		
{
	this.mVerticalRadioButton.setVisible(false);
	this.mHorizontalRadioButton.setVisible(false);
	this.pack();
}
*/

		return true;
	}



	
	/**
	 * 
	 * @return
	 */
	public Number getXValue()
	{
		return this.getNumber( this.mXValueTextField );
	}
	

	/**
	 * 
	 * @return
	 */
	public Number getYValue()
	{
		return this.getNumber( this.mYValueTextField );
	}
	
	
	/**
	 * 
	 * @return
	 */
	public Number getLength()
	{
		return this.mLengthSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getInterval()
	{
		return this.mIntervalSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getDistortion()
	{
		return this.mDistortionSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getAngle()
	{
		return this.mAngleSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Boolean isHorizontal()
	{
		return new Boolean( this.mHorizontalRadioButton.isSelected() );
	}


	/**
	 * 
	 * @return
	 */
	public Color getLineColor()
	{
		return this.mLineColorButton.getBackground();
	}


	/**
	 * 
	 * @return
	 */
	public Color getInnerColor()
	{
		return this.mInnerColorButton.getBackground();
	}


	
	
	/**
	 * 
	 */
	public boolean setAxisRadioButton( final int configX, final int configY )
	{

		switch( configX )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftBottomRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightBottomRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				switch( configY )
				{
					case SGIAxisElement.AXIS_PERPENDICULAR_1 :
					{
						this.mLeftTopRadioButton.setSelected(true);
						break;
					}

					case SGIAxisElement.AXIS_PERPENDICULAR_2 :
					{
						this.mRightTopRadioButton.setSelected(true);
						break;
					}
						
					default :
					{
						return false;
					}
				}

				break;
			}

			default :
			{
				return false;
			}
		}

		return true;
	}


	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setXValue( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Double d = SGUtilityText.getDouble(str);
		if( d==null )
		{
			return false;
		}
		this.mXValueTextField.setText( str );
		return true;
	}

	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setYValue( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Number num = SGUtilityText.getDouble(str);
		if( num==null )
		{
			return false;
		}
		this.mYValueTextField.setText( str );
		return true;
	}

	

	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setLength( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Number num = SGUtilityText.getFloat(str);
		if( num==null )
		{
			return false;
		}
		this.mLengthSpinner.setValue( num );
		return true;
	}


	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setInterval( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Number num = SGUtilityText.getFloat(str);
		if( num==null )
		{
			return false;
		}
		this.mIntervalSpinner.setValue( num );
		return true;
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setDistortion( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Number num = SGUtilityText.getFloat(str);
		if( num==null )
		{
			return false;
		}
		this.mDistortionSpinner.setValue( num );
		return true;
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setAngle( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Number num = SGUtilityText.getFloat(str);
		if( num==null )
		{
			return false;
		}
		this.mAngleSpinner.setValue( num );
		return true;
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setLineWidth( final Object obj )
	{
		if( obj==null )
		{
			return false;
		}
		String str = obj.toString();
		Number num = SGUtilityText.getFloat(str);
		if( num==null )
		{
			return false;
		}
		this.mLineWidthSpinner.setValue( num );
		return true;
	}



	/**
	 * 
	 * @param flag
	 * @return
	 */
	public boolean setHorizontal( final boolean flag )
	{
		this.mHorizontalRadioButton.setSelected( flag );
		this.mVerticalRadioButton.setSelected( !flag );

		return true;
	}



	/**
	 * 
	 * @param c
	 * @return
	 */
	public boolean setLineColor( final Color c )
	{
		this.mLineColorButton.setBackground(c);
		return true;
	}


	/**
	 * 
	 * @param c
	 * @return
	 */
	public boolean setInnerColor( final Color c )
	{
		this.mInnerColorButton.setBackground(c);
		return true;
	}


	/**
	 * 
	 */
	public ArrayList getActiveComponentList()
	{
		final ArrayList list = this.getActiveComponentListFromSpinners();
		list.add( this.mXValueTextField );
		list.add( this.mYValueTextField );
		return list;
	}


	/**
	 * 
	 */    
	public ArrayList getColorSelectionComponentList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLineColorButton );
		list.add( this.mInnerColorButton );
		return list;
	}


	/**
	 * 
	 */    
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLengthSpinner );
		list.add( this.mIntervalSpinner );
		list.add( this.mDistortionSpinner );
		list.add( this.mAngleSpinner );
		list.add( this.mLineWidthSpinner );
		return list;
	}
    
    
    
	/**
	 * 
	 * @return
	 */
	public AxisBreakSymbolWithAxesProperties getProperties()
	{
		AxisBreakSymbolWithAxesProperties p
			= new AxisBreakSymbolWithAxesProperties();

		// x value
		final Number xValue = this.getXValue();
		if( xValue==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setXValue( xValue.doubleValue() );
		}
		

		// y value
		final Number yValue = this.getYValue();
		if( yValue==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setYValue( yValue.doubleValue() );
		}

		
		// length
		final Number len = this.getLength();
		if( len==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setLength( len.floatValue()/SGIConstants.CM_POINT_RATIO );
		}


		// interval
		final Number interval = this.getInterval();
		if( interval==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setInterval( interval.floatValue()/SGIConstants.CM_POINT_RATIO );
		}


		// distortion
		final Number distortion = this.getDistortion();
		if( distortion==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setDistortion( distortion.floatValue() );
		}


		// angle
		final Number angle = this.getAngle();
		if( angle==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setAngle( angle.floatValue()*RADIAN_DEGREE_RATIO );
		}


		// line width
		final Number lineWidth = this.getLineWidth();
		if( lineWidth==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setLineWidth( lineWidth.floatValue() );
		}


		// horizontal
		final Boolean horizontal = this.isHorizontal();
		if( horizontal==null )
		{
			SGUtility.showIllegalInputErrorMessageDialog( this );
			return null;
		}
		else
		{
			p.setHorizontal( horizontal.booleanValue() );
		}


		// line color
		final Color lc = this.getLineColor();
		p.setLineColor(lc);
		
		
		// inner color
		final Color ic = this.getInnerColor();
		p.setColor(ic);


		return p;
	}

	

	/**
	 * 
	 * @return
	 */
	public String getXAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mRightBottomRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_BOTTOM;
		}
		else if( this.mLeftTopRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_TOP;
		}
		return str;
	}
	

	
	/**
	 * 
	 * @return
	 */
	public String getYAxisLocation()
	{
		String str = null;
		if( this.mLeftBottomRadioButton.isSelected() || this.mLeftTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_LEFT;
		}
		else if( this.mRightBottomRadioButton.isSelected() || this.mRightTopRadioButton.isSelected() )
		{
			str = SGIAxisElement.AXIS_RIGHT;
		}
		return str;
	}


	
	/**
	 * 
	 */
	private JRadioButton mNoAxisSelectionRadioButton = new JRadioButton();

	
	/**
	 * 
	 * @param xAxisList
	 * @param yAxisList
	 * @return
	 */
	private boolean setAxesProperties( final ArrayList xAxisList, final ArrayList yAxisList )
	{
		if( xAxisList.size()!=yAxisList.size() )
		{
			throw new IllegalArgumentException();
		}

		final int num = xAxisList.size();

		if( num==0 )
		{
			return false;
		}

		Integer xAxis0 = (Integer)xAxisList.get(0);
		Integer yAxis0 = (Integer)yAxisList.get(0);
		Integer xAxis = xAxis0;
		Integer yAxis = yAxis0;

		if( num>1 )
		{
			for( int ii=1; ii<num; ii++ )
			{
				Integer xAxis1 = (Integer)xAxisList.get(ii);
				if( xAxis0.equals(xAxis1)==false )
				{
					xAxis = null;
					break;
				}
			}
			for( int ii=1; ii<num; ii++ )
			{
				Integer yAxis1 = (Integer)yAxisList.get(ii);
				if( yAxis0.equals(yAxis1)==false )
				{
					yAxis = null;
					break;
				}
			}
		}

		if( xAxis==null || yAxis==null )
		{
			this.mNoAxisSelectionRadioButton.setSelected(true);
			return false;
		}
		this.setAxisRadioButton( xAxis.intValue(), yAxis.intValue() );


		return true;
	}



}

