/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import jp.riken.brain.ni.samuraigraph.base.SGISingleAxisHolder;

public class SGSingleAxisRadioButtonManager {
    private ButtonGroup mButtonGroup = new ButtonGroup();
    private JRadioButton mTopRadioButton = null;
    private JRadioButton mBottomRadioButton = null;
    private JRadioButton mLeftRadioButton = null;
    private JRadioButton mRightRadioButton = null;
    private JRadioButton mNoAxisSelectionRadioButton = null;

    public SGSingleAxisRadioButtonManager(JRadioButton jRadioButton, JRadioButton jRadioButton2, JRadioButton jRadioButton3, JRadioButton jRadioButton4, JRadioButton jRadioButton5) {
        this.mTopRadioButton = jRadioButton;
        this.mBottomRadioButton = jRadioButton2;
        this.mLeftRadioButton = jRadioButton3;
        this.mRightRadioButton = jRadioButton4;
        this.mNoAxisSelectionRadioButton = jRadioButton5;
        ButtonGroup buttonGroup = this.mButtonGroup;
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        buttonGroup.add(jRadioButton5);
    }

    public boolean isTopSelected() {
        return this.mTopRadioButton.isSelected();
    }

    public boolean isBottomSelected() {
        return this.mBottomRadioButton.isSelected();
    }

    public boolean isLeftSelected() {
        return this.mLeftRadioButton.isSelected();
    }

    public boolean isRightSelected() {
        return this.mRightRadioButton.isSelected();
    }

    private boolean setRadioButton_(ArrayList arrayList) {
        Integer n;
        int n2 = arrayList.size();
        if (n2 == 0) {
            return false;
        }
        Integer n3 = n = (Integer)arrayList.get(0);
        if (n2 > 1) {
            for (int i = 1; i < n2; ++i) {
                Integer n4 = (Integer)arrayList.get(i);
                if (n.equals(n4)) continue;
                n3 = null;
                break;
            }
        }
        if (n3 == null) {
            this.mNoAxisSelectionRadioButton.setSelected(true);
        } else {
            this.setRadioButton(n3);
        }
        return true;
    }

    private boolean setRadioButton(int n) {
        switch (n) {
            case 0: {
                this.mBottomRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.mTopRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.mLeftRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.mRightRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        return true;
    }

    public int getAxisConfiguration() {
        int n = -1;
        if (!this.mNoAxisSelectionRadioButton.isSelected()) {
            if (this.isTopSelected()) {
                n = 1;
            } else if (this.isBottomSelected()) {
                n = 0;
            } else if (this.isLeftSelected()) {
                n = 2;
            } else if (this.isRightSelected()) {
                n = 3;
            }
        }
        return n;
    }

    public boolean setRadioButton(ArrayList arrayList) {
        int n = arrayList.size();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            SGISingleAxisHolder sGISingleAxisHolder = (SGISingleAxisHolder)arrayList.get(i);
            arrayList2.add(new Integer(sGISingleAxisHolder.getAxisConfiguration()));
        }
        return this.setRadioButton_(arrayList2);
    }
}

