/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGUtility
implements SGIConstants {
    public static String[] getAvailableFontNames() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        return stringArray;
    }

    public static String getCanonicalPath(String string) {
        File file = new File(string);
        String string2 = null;
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
        return string2;
    }

    public static Rectangle2D createUnion(ArrayList arrayList) {
        if (arrayList == null) {
            throw new IllegalArgumentException("rectList==null");
        }
        Rectangle2D rectangle2D = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            Rectangle2D rectangle2D2 = (Rectangle2D)arrayList.get(i);
            if (rectangle2D2 == null) {
                throw new IllegalArgumentException("rect==null");
            }
            rectangle2D = rectangle2D == null ? rectangle2D2 : rectangle2D2.createUnion(rectangle2D);
        }
        return rectangle2D;
    }

    public static double getRectStart(Rectangle2D rectangle2D, boolean bl) {
        if (bl) {
            return rectangle2D.getX();
        }
        return rectangle2D.getY();
    }

    public static double getRectSize(Rectangle2D rectangle2D, boolean bl) {
        if (bl) {
            return rectangle2D.getWidth();
        }
        return rectangle2D.getHeight();
    }

    public static double getRectEnd(Rectangle2D rectangle2D, boolean bl) {
        return SGUtility.getRectStart(rectangle2D, bl) + SGUtility.getRectSize(rectangle2D, bl);
    }

    public static boolean setRectStart(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(d, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), d, rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    public static boolean setRectEnd(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(d - rectangle2D.getWidth(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), d - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return true;
    }

    public static boolean setRectSize(Rectangle2D rectangle2D, double d, boolean bl) {
        if (bl) {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), d, rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), d);
        }
        return true;
    }

    public static boolean isRectContains(Rectangle2D rectangle2D, double d, boolean bl) {
        return SGUtilityNumber.contains(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), d);
    }

    public static boolean isRectContains(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        return SGUtilityNumber.contains(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), SGUtility.getRectStart(rectangle2D2, bl), SGUtility.getRectEnd(rectangle2D2, bl));
    }

    public static double getOverlapping(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        return SGUtilityNumber.getOverlap(SGUtility.getRectStart(rectangle2D, bl), SGUtility.getRectEnd(rectangle2D, bl), SGUtility.getRectStart(rectangle2D2, bl), SGUtility.getRectEnd(rectangle2D2, bl));
    }

    public static boolean showMessageDialog(Component component, Object object, String string, int n) {
        JOptionPane.showMessageDialog(component, object, string, n);
        return true;
    }

    public static boolean showErrorMessageDialog(Component component, String string, String string2) {
        Toolkit.getDefaultToolkit().beep();
        SGUtility.showMessageDialog(component, string, string2, 0);
        return true;
    }

    public static boolean showIllegalInputErrorMessageDialog(Component component) {
        return SGUtility.showIllegalInputErrorMessageDialog(component, "The input value is illegal.");
    }

    public static boolean showIllegalInputErrorMessageDialog(Component component, String string) {
        return SGUtility.showErrorMessageDialog(component, string, "Illegal input");
    }

    public static boolean showFileNotFoundMessageDialog(Component component) {
        SGUtility.showMessageDialog(component, "Failed to open the file denoted by a specified pathname.", "File not found", 0);
        return true;
    }

    public static void setCenter(Window window, Window window2) {
        Dimension dimension = window2.getSize();
        int n = window.getWidth();
        int n2 = window.getHeight();
        int n3 = window2.getX() + (dimension.width - n) / 2;
        int n4 = window2.getY() + (dimension.height - n2) / 2;
        window.setLocation(n3, n4);
    }

    public static boolean copyObjects(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList == null | arrayList2 == null) {
            throw new IllegalArgumentException("list1==null | list2==null");
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof SGICopiable)) {
                throw new IllegalArgumentException("Not copiable objects are included.");
            }
            SGICopiable sGICopiable = (SGICopiable)e;
            arrayList2.add(sGICopiable.copy());
        }
        return true;
    }

    public static JMenuItem addItem(JPopupMenu jPopupMenu, ActionListener actionListener, String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jPopupMenu.add(jMenuItem);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    public static JCheckBoxMenuItem addCheckBoxItem(JPopupMenu jPopupMenu, ActionListener actionListener, String string) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string);
        jPopupMenu.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(actionListener);
        return jCheckBoxMenuItem;
    }

    public static boolean identifyOS(String string) {
        if (string == null) {
            throw new IllegalArgumentException("prefix==null");
        }
        return SGIConstants.OS_NAME.toLowerCase().startsWith(string);
    }

    public static String getLookAndFeelID() {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel != null) {
            return lookAndFeel.getID();
        }
        return null;
    }

    public static String[] copyStringArray(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public static double[] copyDoubleArray(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        return dArray2;
    }

    public static boolean setValue(SGTextField sGTextField, Object object) {
        if (object == null) {
            sGTextField.setText(null);
        } else {
            String string = object.toString();
            Double d = SGUtilityText.getDouble(string);
            if (d == null) {
                return false;
            }
            sGTextField.setText(string);
        }
        return true;
    }

    public static boolean setIntValue(SGTextField sGTextField, Object object) {
        if (object == null) {
            sGTextField.setText(null);
        } else {
            String string = object.toString();
            Integer n = SGUtilityText.getInteger(string);
            if (n == null) {
                return false;
            }
            sGTextField.setText(string);
        }
        return true;
    }

    public static boolean setValue(SGSpinner sGSpinner, Object object) {
        if (object == null) {
            sGSpinner.setText("");
            return false;
        }
        String string = object.toString();
        Double d = SGUtilityText.getDouble(string);
        if (d == null) {
            return false;
        }
        sGSpinner.setText(string);
        sGSpinner.setValue(d);
        try {
            sGSpinner.commitEditByDefault();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return true;
    }

    public static boolean setIntValue(SGSpinner sGSpinner, Object object) {
        if (object == null) {
            sGSpinner.setText("");
            return false;
        }
        String string = object.toString();
        Integer n = SGUtilityText.getInteger(string);
        if (n == null) {
            return false;
        }
        sGSpinner.setText(string);
        sGSpinner.setValue(n);
        try {
            sGSpinner.commitEditByDefault();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return true;
    }

    public static void clearGlobalFocusOwner() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
    }
}

