/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIErrorBarConstants;

public abstract class SGDrawingElementErrorBar
extends SGDrawingElement
implements SGIArrowConstants,
SGIErrorBarConstants {
    protected SGDrawingElementArrow mArrowElement;
    private int mHeadType;
    private int mErrorBarStyle = 1;

    public static Integer getErrorBarStyleFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.equals("Bothsides")) {
            n = 1;
        } else if (string.equals("Upside")) {
            n = 2;
        } else if (string.equals("Downside")) {
            n = 3;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getErrorBarStyleName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Bothsides";
                break;
            }
            case 2: {
                string = "Upside";
                break;
            }
            case 3: {
                string = "Downside";
                break;
            }
        }
        return string;
    }

    public static Integer getHeadTypeFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.equals("Circle")) {
            n = 1;
        } else if (string.equals("Transverse Line")) {
            n = 8;
        } else if (string.equals("No Symbol")) {
            n = -1;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getHeadTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Circle";
                break;
            }
            case 8: {
                string = "Transverse Line";
                break;
            }
            case -1: {
                string = "No Symbol";
                break;
            }
        }
        return string;
    }

    public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        return this.mArrowElement.setTermPoints(sGTuple2f, sGTuple2f2);
    }

    public boolean setColor(Color color) {
        super.setColor(color);
        this.mArrowElement.setColor(color);
        return true;
    }

    public boolean setColorList(ArrayList arrayList) {
        super.setColorList(arrayList);
        this.mArrowElement.setColorList(arrayList);
        return true;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        this.mArrowElement.setMagnification(f);
        return true;
    }

    public float getLineWidth() {
        return this.mArrowElement.getLineWidth();
    }

    public void setLineWidth(float f) {
        this.mArrowElement.setLineWidth(f);
        this.mArrowElement.setHeadLineWidth(f);
    }

    public float getHeadSize() {
        return this.mArrowElement.getHeadSize();
    }

    public void setHeadSize(float f) {
        this.mArrowElement.setHeadSize(f);
    }

    private int getStartHeadType() {
        return this.mArrowElement.getStartHeadType();
    }

    private int getEndHeadType() {
        return this.mArrowElement.getEndHeadType();
    }

    public int getErrorBarStyle() {
        return this.mErrorBarStyle;
    }

    public boolean setErrorBarStyle(int n) {
        this.mErrorBarStyle = n;
        int n2 = this.getHeadType();
        SGDrawingElementArrow sGDrawingElementArrow = this.mArrowElement;
        switch (n) {
            case 1: {
                sGDrawingElementArrow.setStartHeadType(n2);
                sGDrawingElementArrow.setEndHeadType(n2);
                break;
            }
            case 2: {
                sGDrawingElementArrow.setStartHeadType(-1);
                sGDrawingElementArrow.setEndHeadType(n2);
                break;
            }
            case 3: {
                sGDrawingElementArrow.setStartHeadType(n2);
                sGDrawingElementArrow.setEndHeadType(-1);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return true;
    }

    public int getHeadType() {
        return this.mHeadType;
    }

    public boolean setHeadType(int n) {
        this.mHeadType = n;
        SGDrawingElementArrow sGDrawingElementArrow = this.mArrowElement;
        switch (this.mErrorBarStyle) {
            case 1: {
                sGDrawingElementArrow.setStartHeadType(n);
                sGDrawingElementArrow.setEndHeadType(n);
                break;
            }
            case 2: {
                sGDrawingElementArrow.setStartHeadType(-1);
                sGDrawingElementArrow.setEndHeadType(n);
                break;
            }
            case 3: {
                sGDrawingElementArrow.setStartHeadType(n);
                sGDrawingElementArrow.setEndHeadType(-1);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return true;
    }

    public SGProperties getProperties() {
        ErrorBarProperties errorBarProperties = new ErrorBarProperties();
        this.getProperties(errorBarProperties);
        return errorBarProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        errorBarProperties.setLineWidth(this.getLineWidth());
        errorBarProperties.setHeadSize(this.getHeadSize());
        errorBarProperties.setHeadType(this.getHeadType());
        errorBarProperties.setErrorBarStyle(this.getErrorBarStyle());
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementErrorBar)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementErrorBar sGDrawingElementErrorBar = (SGDrawingElementErrorBar)sGDrawingElement;
        this.setLineWidth(sGDrawingElementErrorBar.getLineWidth());
        this.setHeadSize(sGDrawingElementErrorBar.getHeadSize());
        this.setHeadType(sGDrawingElementErrorBar.getHeadType());
        this.setErrorBarStyle(sGDrawingElementErrorBar.getErrorBarStyle());
        return true;
    }

    public static class ErrorBarProperties
    extends SGDrawingElement.DrawingElementProperties {
        private SGDrawingElementArrow.ArrowProperties mArrowProperties = new SGDrawingElementArrow.ArrowProperties();
        private int mErrorBarStyle = 1;
        private int mHeadType;

        public ErrorBarProperties() {
            this.mArrowProperties.setLineType(1);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ErrorBarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ErrorBarProperties errorBarProperties = (ErrorBarProperties)object;
            if (!this.mArrowProperties.equals(errorBarProperties.mArrowProperties)) {
                return false;
            }
            if (this.mErrorBarStyle != errorBarProperties.mErrorBarStyle) {
                return false;
            }
            return this.mHeadType == errorBarProperties.mHeadType;
        }

        public Float getLineWidth() {
            return this.mArrowProperties.getLineWidth();
        }

        public Float getHeadSize() {
            return this.mArrowProperties.getHeadSize();
        }

        public Integer getHeadType() {
            return new Integer(this.mHeadType);
        }

        public Integer getErrorBarStyle() {
            return new Integer(this.mErrorBarStyle);
        }

        public void setColor(Color color) {
            super.setColor(color);
            this.mArrowProperties.setColor(color);
        }

        public void setColorList(ArrayList arrayList) {
            super.setColorList(arrayList);
            this.mArrowProperties.setColorList(arrayList);
        }

        public void setLineWidth(float f) {
            this.mArrowProperties.setLineWidth(f);
        }

        public void setHeadType(int n) {
            this.mHeadType = n;
            SGDrawingElementArrow.ArrowProperties arrowProperties = this.mArrowProperties;
            switch (this.mErrorBarStyle) {
                case 1: {
                    arrowProperties.setStartHeadType(n);
                    arrowProperties.setEndHeadType(n);
                    break;
                }
                case 2: {
                    arrowProperties.setStartHeadType(-1);
                    arrowProperties.setEndHeadType(n);
                    break;
                }
                case 3: {
                    arrowProperties.setStartHeadType(n);
                    arrowProperties.setEndHeadType(-1);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }

        public void setHeadSize(float f) {
            this.mArrowProperties.setHeadSize(f);
        }

        public void setErrorBarStyle(int n) {
            this.mErrorBarStyle = n;
            int n2 = this.getHeadType();
            SGDrawingElementArrow.ArrowProperties arrowProperties = this.mArrowProperties;
            switch (n) {
                case 1: {
                    arrowProperties.setStartHeadType(n2);
                    arrowProperties.setEndHeadType(n2);
                    break;
                }
                case 2: {
                    arrowProperties.setStartHeadType(-1);
                    arrowProperties.setEndHeadType(n2);
                    break;
                }
                case 3: {
                    arrowProperties.setStartHeadType(n2);
                    arrowProperties.setEndHeadType(-1);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
    }
}

