/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;

public class SGDrawingElementArrow2D
extends SGDrawingElementArrow
implements SGIDrawingElementJava2D {
    public SGDrawingElementArrow2D() {
        this.mLine = new SGDrawingElementLine2D();
        this.mStartHead = new SGDrawingElementSymbol2D();
        this.mEndHead = new SGDrawingElementSymbol2D();
    }

    private SGDrawingElementLine2D getLine2D() {
        return (SGDrawingElementLine2D)this.mLine;
    }

    private SGDrawingElementSymbol2D getStart2D() {
        return (SGDrawingElementSymbol2D)this.mStartHead;
    }

    private SGDrawingElementSymbol2D getEnd2D() {
        return (SGDrawingElementSymbol2D)this.mEndHead;
    }

    public boolean contains(int n, int n2) {
        boolean bl = this.mLine.contains(n, n2);
        boolean bl2 = this.mStartHead.contains(n, n2);
        boolean bl3 = this.mEndHead.contains(n, n2);
        boolean bl4 = bl | bl2 | bl3;
        return bl4;
    }

    public Rectangle2D getElementBounds() {
        SGDrawingElementLine2D sGDrawingElementLine2D = this.getLine2D();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = this.getStart2D();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D2 = this.getEnd2D();
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(sGDrawingElementLine2D.getElementBounds());
        arrayList.add(sGDrawingElementSymbol2D.getElementBounds());
        arrayList.add(sGDrawingElementSymbol2D2.getElementBounds());
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    private AffineTransform getAffineTransform() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.getStart().x, this.getStart().y);
        double d = (double)this.getAngle() - 1.5707963267948966;
        affineTransform.rotate(d);
        return affineTransform;
    }

    public float getAngle() {
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        return SGUtilityJava2D.getAngle(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y);
    }

    void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.getLine2D().paint(graphics2D, rectangle2D);
        this.getStart2D().paint(graphics2D, rectangle2D);
        this.getEnd2D().paint(graphics2D, rectangle2D);
    }

    public float getMagnitude() {
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        float f = sGTuple2f.x - sGTuple2f2.x;
        float f2 = sGTuple2f.y - sGTuple2f2.y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public Shape getBodyShape() {
        float f = this.getMagnification();
        float f2 = this.getMagnitude();
        float f3 = this.getHeadSize();
        float f4 = 0.5f * f * f3;
        int n = this.mStartHead.getType();
        int n2 = this.mEndHead.getType();
        float f5 = 0.0f;
        if (n == 10) {
            f5 = f4;
        }
        float f6 = f2;
        if (n2 == 10) {
            f6 = f2 - f4;
        }
        Line2D.Float float_ = new Line2D.Float(0.0f, f5, 0.0f, f6);
        AffineTransform affineTransform = this.getAffineTransform();
        Shape shape = affineTransform.createTransformedShape(float_);
        return shape;
    }

    public Shape getStartHeadShape() {
        Shape shape = this.getStart2D().getShape();
        if (shape == null) {
            return null;
        }
        SGTuple2f sGTuple2f = this.getStart();
        this.mStartHead.setLocation(sGTuple2f);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(sGTuple2f.x, sGTuple2f.y);
        double d = (double)this.getAngle() - 1.5707963267948966;
        affineTransform.rotate(d);
        affineTransform.translate(-sGTuple2f.x, -sGTuple2f.y);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    public Shape getEndHeadShape() {
        Shape shape = this.getEnd2D().getShape();
        if (shape == null) {
            return null;
        }
        SGTuple2f sGTuple2f = this.getEnd();
        this.mEndHead.setLocation(sGTuple2f);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(sGTuple2f.x, sGTuple2f.y);
        double d = (double)this.getAngle() + 1.5707963267948966;
        affineTransform.rotate(d);
        affineTransform.translate(-sGTuple2f.x, -sGTuple2f.y);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        return shape2;
    }

    public Object copy() {
        SGDrawingElementArrow2D sGDrawingElementArrow2D = new SGDrawingElementArrow2D();
        this.setPropertiesForCopy(sGDrawingElementArrow2D);
        return sGDrawingElementArrow2D;
    }

    protected boolean setPropertiesForCopy(SGDrawingElementArrow2D sGDrawingElementArrow2D) {
        sGDrawingElementArrow2D.setProperties(this.getProperties());
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        sGDrawingElementArrow2D.setTermPoints(sGTuple2f, sGTuple2f2);
        sGDrawingElementArrow2D.setMagnification(this.mMagnification);
        return true;
    }
}

