/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;

public class SGDrawingElementLine2D
extends SGDrawingElementLine
implements SGIDrawingElementJava2D {
    public static final float MINIMUM_LINE_WIDTH = 2.0f;

    public SGDrawingElementLine2D() {
    }

    public SGDrawingElementLine2D(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        super(sGTuple2f, sGTuple2f2);
    }

    public SGDrawingElementLine2D(float f, float f2, float f3, float f4) {
        super(f, f2, f3, f4);
    }

    public boolean contains(int n, int n2) {
        float f = this.mLineWidth * this.mMagnification;
        if (f < 2.0f) {
            f = 2.0f;
        }
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        double d = Line2D.ptSegDistSq(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y, n, n2);
        return d < (double)(f * f);
    }

    public boolean paintElement(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return false;
        }
        graphics2D.setPaint(this.getColor(0));
        float f = this.mMagnification * this.mLineWidth;
        BasicStroke basicStroke = SGUtilityJava2D.getBasicStroke(this.mLineType, f, this.mCap, this.mJoin, this.mMiterLimit, this.mDashPhase);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(this.getShape());
        return true;
    }

    void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Shape shape = this.getShape();
        if (shape == null) {
            return;
        }
        BasicStroke basicStroke = new BasicStroke(this.mMagnification * this.mLineWidth, 0, 0);
        if (rectangle2D == null) {
            graphics2D.setPaint(this.getColor(0));
            graphics2D.setStroke(basicStroke);
            graphics2D.draw(shape);
        } else {
            Area area = new Area(rectangle2D);
            Shape shape2 = basicStroke.createStrokedShape(shape);
            Area area2 = new Area(shape2);
            area2.intersect(area);
            graphics2D.setPaint(this.getColor(0));
            graphics2D.fill(area2);
        }
    }

    public Rectangle2D getElementBounds() {
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        Rectangle2D.Float float_ = new Rectangle2D.Float(sGTuple2f.x, sGTuple2f.y, 0.0f, 0.0f);
        float_.add(new Point2D.Float(sGTuple2f2.x, sGTuple2f2.y));
        return float_;
    }

    public Shape getShape() {
        Line2D.Float float_ = new Line2D.Float(this.getStart().x, this.getStart().y, this.getEnd().x, this.getEnd().y);
        return float_;
    }

    public static Line2D getLine(SGDrawingElementLine sGDrawingElementLine) {
        SGTuple2f sGTuple2f = sGDrawingElementLine.getStart();
        SGTuple2f sGTuple2f2 = sGDrawingElementLine.getEnd();
        Line2D.Float float_ = new Line2D.Float(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y);
        return float_;
    }

    public ArrayList getShapeList() {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        arrayList.add(this.getShape());
        return arrayList;
    }

    public Object copy() {
        SGDrawingElementLine2D sGDrawingElementLine2D = new SGDrawingElementLine2D();
        return sGDrawingElementLine2D;
    }

    protected boolean setForCopy(SGDrawingElementLine2D sGDrawingElementLine2D) {
        sGDrawingElementLine2D.setProperties(this.getProperties());
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        sGDrawingElementLine2D.setTermPoints(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y);
        sGDrawingElementLine2D.setMagnification(this.mMagnification);
        return true;
    }

    public float getAngle() {
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        return SGUtilityJava2D.getAngle(sGTuple2f.x, sGTuple2f.y, sGTuple2f2.x, sGTuple2f2.y);
    }
}

