/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.io.IOException;
import org.freehep.graphicsio.swf.DefineFont;
import org.freehep.graphicsio.swf.DefineFontInfo;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineFontInfo2
extends DefineFontInfo {
    int languageCode;

    public DefineFontInfo2(int fontID, String name, boolean italic, boolean bold, int languageCode, int[] codes) {
        super(fontID, name, false, false, italic, bold, true, codes);
        this.languageCode = languageCode;
    }

    public DefineFontInfo2() {
        super(62, 6);
    }

    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineFontInfo2 tag = new DefineFontInfo2();
        tag.fontID = swf.readUnsignedShort();
        DefineFont font = (DefineFont)swf.getDictionary().get(tag.fontID);
        int numGlyphs = font.getGlyphCount();
        font.setFontInfo(tag);
        int nameLength = swf.readUnsignedByte();
        tag.name = swf.readUTF();
        int reserved = (int)swf.readUBits(3);
        tag.shiftJIS = swf.readBitFlag();
        tag.ansi = swf.readBitFlag();
        tag.italic = swf.readBitFlag();
        tag.bold = swf.readBitFlag();
        tag.wideCodes = swf.readBitFlag();
        tag.languageCode = swf.readLanguageCode();
        tag.codes = swf.readUnsignedShort(numGlyphs);
        return tag;
    }

    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.fontID);
        swf.writeUnsignedByte(this.name.length());
        swf.writeUTF(this.name);
        swf.writeUBits(0L, 3);
        swf.writeBitFlag(false);
        swf.writeBitFlag(false);
        swf.writeBitFlag(this.italic);
        swf.writeBitFlag(this.bold);
        swf.writeBitFlag(true);
        swf.writeLanguageCode(this.languageCode);
        swf.writeUnsignedShort(this.codes);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  name:      " + this.name + "\n");
        s.append("  numGlyphs: " + this.codes.length + "\n");
        s.append("    ");
        for (int i = 0; i < this.codes.length; ++i) {
            s.append("[" + this.codes[i] + ",'" + (char)this.codes[i] + "'] ");
        }
        s.append("\n");
        return s.toString();
    }
}

