/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;

public class SGAxis {
    public static final int LINEAR_TYPE = 0;
    public static final int LOG_TYPE = 1;
    private int mScaleType = 0;
    private double mMinValue;
    private double mMaxValue;

    public boolean setRange(double d, double d2) {
        if (d > d2) {
            new IllegalArgumentException("minValue > maxValue");
        }
        this.mMinValue = d;
        this.mMaxValue = d2;
        return true;
    }

    public boolean setRange(SGTuple2d sGTuple2d) {
        return this.setRange(sGTuple2d.x, sGTuple2d.y);
    }

    public void setScaleType(int n) {
        if (n != 0 && n != 1) {
            new IllegalArgumentException("scale type is incorrect");
        }
        if (n == 1 && this.mMinValue < 0.0) {
            new IllegalArgumentException("mMinValue < 0.0 : cannot set log-type scale");
        }
        this.mScaleType = n;
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }

    public SGTuple2d getRange() {
        SGTuple2d sGTuple2d = new SGTuple2d(this.mMinValue, this.mMaxValue);
        return sGTuple2d;
    }

    public int getScaleType() {
        return this.mScaleType;
    }

    public boolean insideRange(double d) {
        return !(d < this.mMinValue) && !(d > this.mMaxValue);
    }

    public boolean isValidValue(double d) {
        int n = this.getScaleType();
        return n != 1 || !(d <= 0.0);
    }
}

