/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGSpinner
extends JSpinner
implements SGIConstants,
PropertyChangeListener {
    private static final String SUFFIX_CM = " cm";
    private static final String SUFFIX_MM = " mm";
    private static final String SUFFIX_PT = " pt";
    private static final String SUFFIX_INCH = " inch";
    private static final String SUFFIX_DEGREE = SGIConstants.degree;
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_ON_STEP = 1;
    private String mTempString = null;

    public SGSpinner() {
    }

    public SGSpinner(SpinnerNumberModel spinnerNumberModel, String string, int n, int n2) {
        this.initProperties(spinnerNumberModel, string, n, n2);
    }

    public void initProperties(SpinnerNumberModel spinnerNumberModel, String string, int n, int n2) {
        Object object;
        if (spinnerNumberModel.getStepSize().doubleValue() < Double.MIN_VALUE) {
            throw new IllegalArgumentException("too small step value");
        }
        int n3 = -n2 - 1;
        double d = SGUtilityNumber.roundOffNumber(((Number)((Object)spinnerNumberModel.getMinimum())).doubleValue(), n3);
        double d2 = SGUtilityNumber.roundOffNumber(((Number)((Object)spinnerNumberModel.getMaximum())).doubleValue(), n3);
        spinnerNumberModel.setMinimum(new Double(d));
        spinnerNumberModel.setMaximum(new Double(d2));
        this.setModel(spinnerNumberModel);
        if (string != null) {
            object = SGSpinner.getSuffix(string);
            DecimalFormat decimalFormat = this.getDecimalFormat();
            decimalFormat.setPositiveSuffix((String)object);
            decimalFormat.setNegativeSuffix((String)object);
        }
        object = this.getFormattedTextField();
        ((JFormattedTextField)object).setFocusLostBehavior(3);
        ((JTextField)object).setHorizontalAlignment(2);
        ((Container)object).addPropertyChangeListener(this);
        this.setMinimumFractionDigits(n);
        this.setMaximumFractionDigits(n2);
    }

    public boolean isEditable() {
        return this.getFormattedTextField().isEditable();
    }

    public void setEditable(boolean bl) {
        this.getFormattedTextField().setEditable(bl);
    }

    public JFormattedTextField getFormattedTextField() {
        JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)this.getEditor();
        JFormattedTextField jFormattedTextField = defaultEditor.getTextField();
        return jFormattedTextField;
    }

    public String getText() {
        return this.getFormattedTextField().getText();
    }

    public void setText(String string) {
        this.getFormattedTextField().setText(string);
    }

    public DecimalFormat getDecimalFormat() {
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.getEditor();
        return numberEditor.getFormat();
    }

    private static String getSuffix(String string) {
        String string2 = null;
        if (string.equals("cm")) {
            string2 = SUFFIX_CM;
        } else if (string.equals("mm")) {
            string2 = SUFFIX_MM;
        } else if (string.equals("pt")) {
            string2 = SUFFIX_PT;
        } else if (string.equals("inch")) {
            string2 = SUFFIX_INCH;
        } else if (string.equals(SGIConstants.degree)) {
            string2 = SUFFIX_DEGREE;
        }
        return string2;
    }

    public String getUnit() {
        String string = this.getSuffix();
        String string2 = null;
        if (string.equals(SUFFIX_CM)) {
            string2 = "cm";
        } else if (string.equals(SUFFIX_MM)) {
            string2 = "mm";
        } else if (string.equals(SUFFIX_INCH)) {
            string2 = "inch";
        } else if (string.equals(SUFFIX_PT)) {
            string2 = "pt";
        } else if (string.equals(SUFFIX_DEGREE)) {
            string2 = SGIConstants.degree;
        }
        return string2;
    }

    private String getSuffix() {
        return this.getDecimalFormat().getPositiveSuffix();
    }

    public int getMinimumFractionDigits() {
        return this.getDecimalFormat().getMinimumFractionDigits();
    }

    public int getMaximumFractionDigits() {
        return this.getDecimalFormat().getMaximumFractionDigits();
    }

    private void setMinimumFractionDigits(int n) {
        this.getDecimalFormat().setMinimumFractionDigits(n);
    }

    private void setMaximumFractionDigits(int n) {
        this.getDecimalFormat().setMaximumFractionDigits(n);
    }

    private int getDigitForRoundingOut() {
        return -this.getMaximumFractionDigits() - 1;
    }

    private boolean isInteger() {
        int n = this.getMinimumFractionDigits();
        int n2 = this.getMaximumFractionDigits();
        return n == 0 & n2 == 0;
    }

    private SpinnerNumberModel getSpinnerNumberModel() {
        return (SpinnerNumberModel)this.getModel();
    }

    public Number getMinimumValue() {
        return (Number)((Object)this.getSpinnerNumberModel().getMinimum());
    }

    public Number getMaximumValue() {
        return (Number)((Object)this.getSpinnerNumberModel().getMaximum());
    }

    public Number getStepSize() {
        return this.getSpinnerNumberModel().getStepSize();
    }

    private Number getValueOnStepInside(double d, double d2) {
        double d3;
        double d4;
        if (d < d2) {
            d4 = d;
            d3 = d2;
        } else if (d2 < d) {
            d4 = d2;
            d3 = d;
        } else {
            return null;
        }
        double d5 = this.getMinimumValue().doubleValue();
        double d6 = this.getMaximumValue().doubleValue();
        double d7 = this.getStepSize().doubleValue();
        Double d8 = null;
        int n = 0;
        int n2 = this.getDigitForRoundingOut();
        while (true) {
            double d9;
            double d10;
            if (d4 < (d10 = SGUtilityNumber.roundOffNumber(d9 = d5 + (double)n * d7, n2))) {
                if (!(d10 < d3)) break;
                d8 = new Double(d10);
                break;
            }
            ++n;
        }
        return d8;
    }

    public void commitEdit() throws ParseException {
        this.commit(1);
        super.commitEdit();
        this.mTempString = this.getText();
    }

    public boolean hasValidValue() {
        String string;
        Number number = this.getNumber();
        return number != null || (string = this.getText()).equals("");
    }

    void clearTemporaryValues() {
        this.mTempString = null;
    }

    public Number getNumber() {
        try {
            this.commitEditByDefault();
        }
        catch (Exception exception) {
            return null;
        }
        Object object = this.getValue();
        return (Number)object;
    }

    public void commitEditByDefault() throws ParseException {
        this.commit(0);
        super.commitEdit();
    }

    private boolean commit(int n) throws ParseException {
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        String string = this.parseString(jFormattedTextField.getText(), n);
        if (string == null) {
            throw new ParseException("parseSting failed.", 0);
        }
        jFormattedTextField.setText(string);
        jFormattedTextField.commitEdit();
        return true;
    }

    private String parseString(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        JFormattedTextField jFormattedTextField = this.getFormattedTextField();
        String string2 = this.getUnit();
        if (string2 == null) {
            Double d = SGUtilityText.getDouble(string);
            if (d == null) {
                return null;
            }
            if (this.isInteger()) {
                double d2 = d;
                int n2 = (int)Math.rint(d2);
                int n3 = this.getMinimumValue().intValue();
                int n4 = this.getMaximumValue().intValue();
                if (n2 < n3) {
                    n2 = n3;
                }
                if (n2 > n4) {
                    n2 = n4;
                }
                String string3 = Integer.toString(n2);
                return string3;
            }
            return ((Object)d).toString();
        }
        String string4 = null;
        Object object = null;
        object = this.isInteger() ? (Number)SGUtilityText.getInteger(string) : (Number)SGUtilityText.getDouble(string);
        string4 = object != null ? object.toString() + SGSpinner.getSuffix(string2) : string;
        object = null;
        object = SGUtilityNumber.isLengthUnit(string2) ? SGUtilityNumber.convertString(string4, string2) : SGUtilityNumber.removeUnit(string4, string2);
        if (object == null) {
            return null;
        }
        if (this.isInteger()) {
            int n5 = Integer.valueOf((String)object);
            int n6 = this.getMinimumValue().intValue();
            int n7 = this.getMaximumValue().intValue();
            if (n5 < n6) {
                n5 = n6;
            }
            if (n5 > n7) {
                n5 = n7;
            }
            String string5 = new Integer(n5).toString() + SGSpinner.getSuffix(string2);
            return string5;
        }
        double d = SGUtilityText.getDouble((String)object);
        double d3 = this.getMinimumValue().doubleValue();
        double d4 = this.getMaximumValue().doubleValue();
        if (d < d3) {
            d = d3;
        }
        if (d > d4) {
            d = d4;
        }
        double d5 = 0.0;
        switch (n) {
            case 0: {
                d5 = SGUtilityNumber.roundOffNumber(d, this.getDigitForRoundingOut());
                break;
            }
            case 1: {
                d5 = d;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        String string6 = new Double(d5).toString() + SGSpinner.getSuffix(string2);
        return string6;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        Object object = propertyChangeEvent.getSource();
        if (object.equals(this.getFormattedTextField()) && (string = this.mTempString) != null) {
            JFormattedTextField jFormattedTextField = (JFormattedTextField)object;
            String string2 = jFormattedTextField.getText();
            if (!string.equals(string2)) {
                String string3 = this.getUnit();
                if (!this.isInteger()) {
                    String string4 = SGUtilityNumber.removeUnit(string, string3);
                    String string5 = SGUtilityNumber.removeUnit(string2, string3);
                    Double d = Double.valueOf(string4);
                    Double d2 = Double.valueOf(string5);
                    Number number = this.getValueOnStepInside(d, d2);
                    if (number == null) {
                        number = d2;
                    }
                    this.setValue(number);
                }
            }
            this.mTempString = null;
        }
    }
}

