/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementLine2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;

public class SGDrawingElementArrow2D
extends SGDrawingElementArrow
implements SGIDrawingElementJava2D {
    protected SGDrawingElementLine getBodyInstance() {
        return new ArrowBody();
    }

    protected SGDrawingElementSymbol getHeadInstance() {
        return new ArrowHead();
    }

    private SGDrawingElementLine2D getLine2D() {
        return (SGDrawingElementLine2D)this.mLine;
    }

    private SGDrawingElementSymbol2D getStart2D() {
        return (SGDrawingElementSymbol2D)this.mStartHead;
    }

    private SGDrawingElementSymbol2D getEnd2D() {
        return (SGDrawingElementSymbol2D)this.mEndHead;
    }

    public boolean contains(int n, int n2) {
        boolean bl = this.mLine.contains(n, n2);
        boolean bl2 = this.mStartHead.contains(n, n2);
        boolean bl3 = this.mEndHead.contains(n, n2);
        boolean bl4 = bl | bl2 | bl3;
        return bl4;
    }

    public Rectangle2D getElementBounds() {
        SGDrawingElementLine2D sGDrawingElementLine2D = this.getLine2D();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = this.getStart2D();
        SGDrawingElementSymbol2D sGDrawingElementSymbol2D2 = this.getEnd2D();
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(sGDrawingElementLine2D.getElementBounds());
        arrayList.add(sGDrawingElementSymbol2D.getElementBounds());
        arrayList.add(sGDrawingElementSymbol2D2.getElementBounds());
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        return rectangle2D;
    }

    public void paintElement(Graphics2D graphics2D) {
        if (!this.isVisible()) {
            return;
        }
        this.getLine2D().paintElement(graphics2D);
        this.getStart2D().paintElement(graphics2D);
        this.getEnd2D().paintElement(graphics2D);
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (!this.isVisible()) {
            return;
        }
        this.getLine2D().paint(graphics2D, rectangle2D);
        this.getStart2D().paint(graphics2D, rectangle2D);
        this.getEnd2D().paint(graphics2D, rectangle2D);
    }

    public float getMagnitude() {
        SGTuple2f sGTuple2f = this.getStart();
        SGTuple2f sGTuple2f2 = this.getEnd();
        float f = sGTuple2f.x - sGTuple2f2.x;
        float f2 = sGTuple2f.y - sGTuple2f2.y;
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public boolean setStartX(float f) {
        super.setStartX(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setStartY(float f) {
        super.setStartY(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setEndX(float f) {
        super.setEndX(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setEndY(float f) {
        super.setEndY(f);
        this.updateHeadAngle();
        return true;
    }

    public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        super.setTermPoints(sGTuple2f, sGTuple2f2);
        this.updateHeadAngle();
        return true;
    }

    private void updateHeadAngle() {
        float f = this.getLine2D().getAngle();
        this.mStartHead.setAngle(f - 1.5707964f);
        this.mEndHead.setAngle(f + 1.5707964f);
    }

    private float getOpenAngleTangent() {
        return (float)Math.tan(this.getHeadOpenAngle());
    }

    private float getCloseAngleTangent() {
        return (float)Math.tan(this.getHeadCloseAngle());
    }

    private class ArrowHead
    extends SGDrawingElementSymbol2D {
        private ArrowHead() {
        }

        protected void paintLine(Graphics2D graphics2D, Shape shape) {
            if (ArrowHead.isLineTypeSymbol(this.getType())) {
                super.paintLine(graphics2D, shape);
            }
        }

        protected void paintLine(Graphics2D graphics2D, Area area, Shape shape) {
            if (ArrowHead.isLineTypeSymbol(this.getType())) {
                super.paintLine(graphics2D, area, shape);
            }
        }

        public Shape getShape() {
            if (this.getType() == -1) {
                return null;
            }
            Shape shape = null;
            int n = this.mType;
            if (n == 10) {
                float f = SGDrawingElementArrow2D.this.getOpenAngleTangent();
                float f2 = SGDrawingElementArrow2D.this.getCloseAngleTangent();
                if (f2 <= f) {
                    return null;
                }
                float f3 = this.getX();
                float f4 = this.getY();
                float f5 = this.getMagnification();
                float f6 = f5 * this.getSize();
                float f7 = f6 * f;
                Point2D[] point2DArray = new Point2D[]{new Point2D.Float(f3, f4), new Point2D.Float(f3 + f7, f4 + f6), new Point2D.Float(f3, f4 + f6 - f7 / f2), new Point2D.Float(f3 - f7, f4 + f6)};
                Line2D[] line2DArray = new Line2D[point2DArray.length];
                for (int i = 0; i < line2DArray.length; ++i) {
                    line2DArray[i] = new Line2D.Float(point2DArray[i], point2DArray[(i + 1) % point2DArray.length]);
                }
                GeneralPath generalPath = new GeneralPath();
                for (int i = 0; i < line2DArray.length; ++i) {
                    generalPath.append(line2DArray[i], true);
                }
                shape = this.getAffineTransform().createTransformedShape(generalPath);
            } else {
                shape = super.getShape();
            }
            return shape;
        }
    }

    private class ArrowBody
    extends SGDrawingElementLine2D {
        private ArrowBody() {
        }

        public Shape getShape() {
            float f;
            float f2 = SGDrawingElementArrow2D.this.getOpenAngleTangent();
            float f3 = f2 <= (f = SGDrawingElementArrow2D.this.getCloseAngleTangent()) ? this.getMagnification() * SGDrawingElementArrow2D.this.getHeadSize() * (1.0f - f2 / f) : 0.0f;
            float f4 = this.getMagnitude();
            float f5 = SGDrawingElementArrow2D.this.getStartHeadType() != 10 ? 0.0f : f3;
            float f6 = SGDrawingElementArrow2D.this.getEndHeadType() != 10 ? f4 : f4 - f3;
            Line2D.Float float_ = new Line2D.Float(0.0f, f5, 0.0f, f6);
            Shape shape = this.getAffineTransform().createTransformedShape(float_);
            return shape;
        }

        private AffineTransform getAffineTransform() {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(this.getStart().x, this.getStart().y);
            double d = (double)this.getAngle() - 1.5707963267948966;
            affineTransform.rotate(d);
            return affineTransform;
        }
    }
}

