
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;

/**
 *
 *
 */
public abstract class SGDrawingElementErrorBar extends SGDrawingElement
	implements SGIArrowConstants, SGIErrorBarConstants
{

	/**
	 * 
	 */
	protected SGDrawingElementArrow mArrowElement;


	/**
	 * 
	 */
	private int mHeadType;


	/**
	 * 
	 */
	private int mErrorBarStyle = ERROR_BAR_FULL;


	/**
	 * 
	 */
	public SGDrawingElementErrorBar()
	{
		super();
	}



	/**
	 * 
	 */
	public static Integer getErrorBarStyleFromName( final String name )
	{
		if( name==null )
		{
			return null;
		}

		int style;
		if( name.equals(SHOW_FULLY) )
		{
			style = ERROR_BAR_FULL;
		}
		else if( name.equals(SHOW_UPPER_ONLY) )
		{
			style = ERROR_BAR_UPPER_ONLY;
		}
		else if( name.equals(SHOW_LOWER_ONLY) )
		{
			style = ERROR_BAR_LOWER_ONLY;
		}
		else
		{
			return null;
		}

		return new Integer(style);
	}



	/**
	 * 
	 */
	public static String getErrorBarStyleName( final int style )
	{

		String name = null;
		switch( style )
		{
			case ERROR_BAR_FULL :
			{
				name = SHOW_FULLY;
				break;
			}

			case ERROR_BAR_UPPER_ONLY :
			{
				name = SHOW_UPPER_ONLY;
				break;
			}

			case ERROR_BAR_LOWER_ONLY :
			{
				name = SHOW_LOWER_ONLY;
				break;
			}
			
			default :
			{
				
			}
		}

		return name;
	}


	/**
	 * 
	 */
	public static Integer getHeadTypeFromName( final String name )
	{
		if( name==null )
		{
			return null;
		}
		
		int type;
		if( name.equals( SYMBOL_NAME_CIRCLE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE;
		}
		else if( name.equals( SYMBOL_NAME_TRANSVERSE_LINE ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE;
		}
		else if( name.equals( NO_SYMBOL ) )
		{
			type = SGDrawingElementSymbol.SYMBOL_TYPE_VOID;
		}
		else
		{
			return null;
		}

		return new Integer(type);
	}



	/**
	 * 
	 */
	public static String getHeadTypeName( final int type )
	{
		
		String name = null;
		switch( type )
		{
			case SGDrawingElementSymbol.SYMBOL_TYPE_CIRCLE :
			{
				name = SYMBOL_NAME_CIRCLE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_TRANSVERSELINE :
			{
				name = SYMBOL_NAME_TRANSVERSE_LINE;
				break;
			}

			case SGDrawingElementSymbol.SYMBOL_TYPE_VOID :
			{
				name = NO_SYMBOL;
				break;
			}

			default :
			{
				
			}
		}
		
		return name;
	}



	/**
	 *
	 */
	public boolean setTermPoints( final SGTuple2f start, final SGTuple2f end )
	{
		return this.mArrowElement.setTermPoints( start, end );
	}


	/**
	 * 
	 */
	public boolean setColor( final Color cl )
	{
		super.setColor( cl );
		this.mArrowElement.setColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setColor( final ArrayList cList )
	{
		super.setColor( cList );
		this.mArrowElement.setColor( cList );
		return true;
	}


	/**
	 * 
	 */
	public boolean setMagnification( final float mag )
	{
		super.setMagnification( mag );
		this.mArrowElement.setMagnification( mag );
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public float getLineWidth()
	{
		return this.mArrowElement.getLineWidth();
	}


	/**
	 * 
	 * @param width
	 */
	public void setLineWidth( final float width )
	{
		this.mArrowElement.setLineWidth( width );
//		this.mArrowElement.setHeadLineWidth( width );
	}


//	/**
//	 * 
//	 * @return
//	 */
//	public int getLineType()
//	{
//		return this.mArrowElement.getLineType();
//	}
//
//
//	/**
//	 * 
//	 * @param type
//	 */
//	public void setLineType( final int type )
//	{
//		this.mArrowElement.setLineType( type );
//	}


	/**
	 * 
	 * @return
	 */
	public float getHeadSize()
	{
		return this.mArrowElement.getHeadSize();
	}


	/**
	 * 
	 * @param size
	 */
	public void setHeadSize( final float size )
	{
		this.mArrowElement.setHeadSize( size );
	}


	/**
	 * 
	 * @return
	 */
	private int getStartHeadType()
	{
		return this.mArrowElement.getStartHeadType();
	}


	/**
	 * 
	 * @return
	 */
	private int getEndHeadType()
	{
		return this.mArrowElement.getEndHeadType();
	}


	/**
	 * 
	 * @return
	 */
	public int getErrorBarStyle()
	{
		return this.mErrorBarStyle;
	}



	/**
	 * 
	 * @param style
	 * @return
	 */
	public boolean setErrorBarStyle( final int style )
	{
		this.mErrorBarStyle = style;

		final int type = this.getHeadType();
		SGDrawingElementArrow arrow = this.mArrowElement;
		switch( style )
		{
			case ERROR_BAR_FULL :
			{
				arrow.setStartHeadType( type );
				arrow.setEndHeadType( type );
				break;
			}
			
			case ERROR_BAR_UPPER_ONLY :
			{
				arrow.setStartHeadType( SGDrawingElementSymbol.SYMBOL_TYPE_VOID );
				arrow.setEndHeadType( type );
				break;
			}

			case ERROR_BAR_LOWER_ONLY :
			{
				arrow.setStartHeadType( type );
				arrow.setEndHeadType( SGDrawingElementSymbol.SYMBOL_TYPE_VOID );
				break;
			}

			default :
			{
				throw new Error();
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public int getHeadType()
	{
		return this.mHeadType;
	}


	/**
	 * 
	 */
	public boolean setHeadType( int type )
	{
		this.mHeadType = type;

		SGDrawingElementArrow arrow = this.mArrowElement;
		switch( this.mErrorBarStyle )
		{
			case ERROR_BAR_FULL :
			{
				arrow.setStartHeadType(type);
				arrow.setEndHeadType(type);
				break;
			}
			
			case ERROR_BAR_UPPER_ONLY :
			{
				arrow.setStartHeadType(SGDrawingElementSymbol.SYMBOL_TYPE_VOID);
				arrow.setEndHeadType(type);
				break;
			}

			case ERROR_BAR_LOWER_ONLY :
			{
				arrow.setStartHeadType(type);
				arrow.setEndHeadType(SGDrawingElementSymbol.SYMBOL_TYPE_VOID);
				break;
			}

			default :
			{
				throw new Error();
			}
		}

		return true;
	}



	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		ErrorBarProperties p = new ErrorBarProperties();
		this.getProperties(p);
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;

		if( ( p instanceof ErrorBarProperties ) == false ) return false;

		if( super.getProperties(p) == false ) return false;

		ErrorBarProperties ep = (ErrorBarProperties)p;

		ep.setLineWidth( this.getLineWidth() );
		ep.setHeadSize( this.getHeadSize() );
		ep.setHeadType( this.getHeadType() );
		ep.setErrorBarStyle( this.getErrorBarStyle() );

		return true;
	}



	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementErrorBar) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementErrorBar bar = (SGDrawingElementErrorBar)element;
		this.setLineWidth( bar.getLineWidth() );
		this.setHeadSize( bar.getHeadSize() );
		this.setHeadType( bar.getHeadType() );
		this.setErrorBarStyle( bar.getErrorBarStyle() );

		return true;
	}



	/**
	 * 
	 */
	public static class ErrorBarProperties extends DrawingElementProperties
	{

		private SGDrawingElementArrow.ArrowProperties mArrowProperties
			= new SGDrawingElementArrow.ArrowProperties();


		/**
		 * 
		 */
		private int mErrorBarStyle = ERROR_BAR_FULL;


		/**
		 * 
		 */
		private int mHeadType;


		/**
		 * 
		 *
		 */
		public ErrorBarProperties()
		{
			super();
			this.mArrowProperties.setLineType( SGILineConstants.LINE_TYPE_SOLID );
		}


		/*
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof ErrorBarProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			ErrorBarProperties p = (ErrorBarProperties)obj;

			if( this.mArrowProperties.equals(p.mArrowProperties) == false ) return false;
			if( this.mErrorBarStyle!=p.mErrorBarStyle ) return false;
			if( this.mHeadType!=p.mHeadType ) return false;

			return true;
		}


		public Float getLineWidth()
		{
			return this.mArrowProperties.getLineWidth();
		}

		public Float getHeadSize()
		{
			return this.mArrowProperties.getHeadSize();
		}

		public Integer getHeadType()
		{
			return new Integer( this.mHeadType );
		}

		public Integer getErrorBarStyle()
		{
			return new Integer( this.mErrorBarStyle );
		}


		public void setColor( final Color cl )
		{
			super.setColor(cl);
			this.mArrowProperties.setColor(cl);
		}

		public void setColor( final ArrayList cList )
		{
			super.setColor( cList );
			this.mArrowProperties.setColor( cList );
		}


		public void setLineWidth( final float width )
		{
			this.mArrowProperties.setLineWidth( width );
		}


		public void setHeadType( final int type )
		{
			this.mHeadType = type;
			SGDrawingElementArrow.ArrowProperties p = this.mArrowProperties;

			switch( this.mErrorBarStyle )
			{
				case ERROR_BAR_FULL :
				{
					p.setStartHeadType(type);
					p.setEndHeadType(type);
					break;
				}
			
				case ERROR_BAR_UPPER_ONLY :
				{
					p.setStartHeadType(SGDrawingElementSymbol.SYMBOL_TYPE_VOID);
					p.setEndHeadType(type);
					break;
				}

				case ERROR_BAR_LOWER_ONLY :
				{
					p.setStartHeadType(type);
					p.setEndHeadType(SGDrawingElementSymbol.SYMBOL_TYPE_VOID);
					break;
				}

				default :
				{
					throw new Error();
				}
			}

		}

		public void setHeadSize( final float size )
		{
			this.mArrowProperties.setHeadSize( size );
		}


		public void setErrorBarStyle( final int style )
		{
			this.mErrorBarStyle = style;

			final int type = this.getHeadType().intValue();
			SGDrawingElementArrow.ArrowProperties p = this.mArrowProperties;
			switch( style )
			{
				case ERROR_BAR_FULL :
				{
					p.setStartHeadType( type );
					p.setEndHeadType( type );
					break;
				}
			
				case ERROR_BAR_UPPER_ONLY :
				{
					p.setStartHeadType( SGDrawingElementSymbol.SYMBOL_TYPE_VOID );
					p.setEndHeadType( type );
					break;
				}

				case ERROR_BAR_LOWER_ONLY :
				{
					p.setStartHeadType( type );
					p.setEndHeadType( SGDrawingElementSymbol.SYMBOL_TYPE_VOID );
					break;
				}

				default :
				{
					throw new Error();
				}
			}

		}

	}


}


