/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYDateData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;

public class SGDataCreator {
    public SGData create(String string, ArrayList arrayList) throws FileNotFoundException {
        if (string == null || arrayList == null) {
            throw new NullPointerException("path==null || infoList==null");
        }
        if (arrayList.size() == 0) {
            return null;
        }
        SGData sGData = null;
        String string2 = (String)arrayList.get(0);
        if (string2.equals("SXY")) {
            sGData = (SGData)((Object)this.createSXYData(string));
        } else if (string2.equals("SXY_DATE")) {
            sGData = (SGData)((Object)this.createSXYDateData(string));
        } else if (!string2.equals("VXY")) {
            if (string2.equals("SXY_MULTIPLE")) {
                sGData = this.createSXYMultipleData(string);
            } else if (string2.equals("SXY_SAMPLING")) {
                if (arrayList.size() <= 1) {
                    return null;
                }
                double d = (Double)arrayList.get(1);
                sGData = this.createSXYSamplingData(string, d);
            }
        }
        return sGData;
    }

    private static ArrayList getSXYTextColumnIndexList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (n == 3) {
            arrayList.add(new Integer(2));
        } else if (n == 5) {
            arrayList.add(new Integer(4));
        }
        return arrayList;
    }

    private static ArrayList getVXYTextColumnIndexList(int n) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    private static ArrayList getSXYMultipleTextColumnIndexList(int n) {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    private static ArrayList getSXYDateTextColumnIndexList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(new Integer(0));
        if (n == 3) {
            arrayList.add(new Integer(2));
        } else if (n == 5) {
            arrayList.add(new Integer(4));
        }
        return arrayList;
    }

    private SGISXYTypeData createSXYData(String string) throws FileNotFoundException {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 2) {
            return null;
        }
        ArrayList arrayList = SGDataCreator.getSXYTextColumnIndexList(n);
        ArrayList[] arrayListArray = this.createListArray(string, n, arrayList);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        ArrayList arrayList2 = new ArrayList();
        if (!this.getFileTypeCandidateList(string, arrayList2)) {
            return null;
        }
        SGSXYData sGSXYData = null;
        String string2 = null;
        Double d = null;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayListArray[0].get(i);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[i] = d;
            string2 = (String)arrayListArray[1].get(i);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray2[i] = d;
        }
        double[] dArray3 = null;
        double[] dArray4 = null;
        String[] stringArray = null;
        switch (n) {
            case 2: {
                break;
            }
            case 4: {
                dArray3 = new double[n2];
                dArray4 = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    string2 = (String)arrayListArray[2].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray3[i] = d;
                    string2 = (String)arrayListArray[3].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray4[i] = d;
                }
                break;
            }
            case 3: {
                stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = (String)arrayListArray[2].get(i);
                }
                break;
            }
            case 5: {
                dArray3 = new double[n2];
                dArray4 = new double[n2];
                stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    string2 = (String)arrayListArray[2].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray3[i] = d;
                    string2 = (String)arrayListArray[3].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray4[i] = d;
                    stringArray[i] = (String)arrayListArray[4].get(i);
                }
                break;
            }
        }
        sGSXYData = new SGSXYData(dArray, dArray2, dArray3, dArray4, stringArray);
        return sGSXYData;
    }

    private SGISXYTypeData createSXYDateData(String string) throws FileNotFoundException {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 2) {
            return null;
        }
        ArrayList arrayList = SGDataCreator.getSXYDateTextColumnIndexList(n);
        ArrayList[] arrayListArray = this.createListArray(string, n, arrayList);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        ArrayList arrayList2 = new ArrayList();
        if (!this.getFileTypeCandidateList(string, arrayList2)) {
            return null;
        }
        SGSXYDateData sGSXYDateData = null;
        String string2 = null;
        Double d = null;
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = (String)arrayListArray[0].get(i);
        }
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayListArray[1].get(i);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[i] = d;
        }
        double[] dArray2 = null;
        double[] dArray3 = null;
        if (n == 4 | n == 5) {
            dArray2 = new double[n2];
            dArray3 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                string2 = (String)arrayListArray[2].get(i);
                d = SGUtilityText.getDouble(string2);
                if (d == null) {
                    return null;
                }
                dArray2[i] = d;
                string2 = (String)arrayListArray[3].get(i);
                d = SGUtilityText.getDouble(string2);
                if (d == null) {
                    return null;
                }
                dArray3[i] = d;
            }
        }
        String[] stringArray2 = null;
        int n3 = -1;
        if (n == 3) {
            n3 = 2;
        } else if (n == 5) {
            n3 = 4;
        }
        if (n3 != -1) {
            stringArray2 = new String[n2];
            for (int i = 0; i < n2; ++i) {
                string2 = (String)arrayListArray[n3].get(i);
                stringArray2[i] = new String(string2);
            }
        }
        try {
            sGSXYDateData = new SGSXYDateData(stringArray, dArray, dArray2, dArray3, stringArray2);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return sGSXYDateData;
    }

    private SGSXYMultipleData createSXYMultipleData(String string) throws FileNotFoundException {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 2) {
            return null;
        }
        ArrayList arrayList = SGDataCreator.getSXYMultipleTextColumnIndexList(n);
        ArrayList[] arrayListArray = this.createListArray(string, n, arrayList);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        SGSXYMultipleData sGSXYMultipleData = null;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)arrayListArray[0].get(i);
            Double d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[i] = d;
        }
        double[][] dArrayArray = new double[n - 1][];
        for (int i = 0; i < n - 1; ++i) {
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                String string3 = (String)arrayListArray[i + 1].get(j);
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return null;
                }
                dArrayArray[i][j] = d;
            }
        }
        sGSXYMultipleData = new SGSXYMultipleData(dArray, dArrayArray);
        return sGSXYMultipleData;
    }

    private SGSXYMultipleData createSXYSamplingData(String string, double d) throws FileNotFoundException {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 1) {
            return null;
        }
        ArrayList arrayList = SGDataCreator.getSXYMultipleTextColumnIndexList(n);
        ArrayList[] arrayListArray = this.createListArray(string, n, arrayList);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        SGSXYSamplingData sGSXYSamplingData = null;
        Double d2 = null;
        String string2 = null;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                string2 = (String)arrayListArray[i].get(j);
                d2 = SGUtilityText.getDouble(string2);
                if (d2 == null) {
                    return null;
                }
                dArrayArray[i][j] = d2;
            }
        }
        sGSXYSamplingData = new SGSXYSamplingData(d, (double[][])dArrayArray);
        return sGSXYSamplingData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getColumnNumber(String string) throws FileNotFoundException {
        int n = -1;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            ArrayList arrayList = this.getFirstTokenList(bufferedReader);
            n = arrayList.size();
            Object var6_6 = null;
            if (bufferedReader == null) return n;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        return n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList[] createListArray(String var1_1, int var2_2, ArrayList var3_3) throws FileNotFoundException {
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            var4_4 = new ArrayList[var2_2];
                            for (var5_5 = 0; var5_5 < var4_4.length; ++var5_5) {
                                var4_4[var5_5] = new ArrayList<E>();
                            }
                            var5_6 = null;
                            try {
                                var5_6 = new BufferedReader(new FileReader(var1_1));
                                while ((var6_7 = SGUtilityText.readLine(var5_6)) != null) {
                                    if (!SGDataCreator.isValidLine(var6_7)) {
                                        var7_9 = null;
                                        var13_14 = null;
                                        if (var5_6 == null) return var7_9;
                                        break block19;
                                    }
                                    var7_9 = SGDataCreator.getColumnIndexListOfString(var6_7);
                                    if (!var7_9.equals(var3_3)) {
                                        var8_10 = null;
                                        break block20;
                                    }
                                    var8_10 = new ArrayList<E>();
                                    if (!SGUtilityText.tokenize(var6_7, var8_10)) {
                                        var9_11 = null;
                                        break block21;
                                    }
                                    if (var8_10.size() != var2_2) {
                                        if (var8_10.size() == 0) continue;
                                        var9_11 = null;
                                        break block22;
                                    }
                                    var9_11 = new String[var2_2];
                                    for (var10_12 = 0; var10_12 < var2_2; ++var10_12) {
                                        var11_13 = (String)var8_10.get(var10_12);
                                        var4_4[var10_12].add(var11_13);
                                    }
                                }
                                break block23;
                            }
                            catch (Throwable var12_26) {
                                var13_19 = null;
                                if (var5_6 == null) throw var12_26;
                                try {
                                    var5_6.close();
                                    throw var12_26;
                                }
                                catch (IOException var14_25) {
                                    // empty catch block
                                }
                                throw var12_26;
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [11 : 236->244)] { 
lbl53:
                        // 1 sources

                        var5_6.close();
                        return var7_9;
lbl55:
                        // 1 sources

                        catch (IOException var14_20) {
                            // empty catch block
                        }
                        return var7_9;
                    }
                    var13_15 = null;
                    if (var5_6 == null) return var8_10;
                    ** try [egrp 2[TRYBLOCK] [11 : 236->244)] { 
lbl62:
                    // 1 sources

                    var5_6.close();
                    return var8_10;
lbl64:
                    // 1 sources

                    catch (IOException var14_21) {
                        // empty catch block
                    }
                    return var8_10;
                }
                var13_16 = null;
                if (var5_6 == null) return var9_11;
                ** try [egrp 2[TRYBLOCK] [11 : 236->244)] { 
lbl71:
                // 1 sources

                var5_6.close();
                return var9_11;
lbl73:
                // 1 sources

                catch (IOException var14_22) {
                    // empty catch block
                }
                return var9_11;
            }
            var13_17 = null;
            if (var5_6 == null) return var9_11;
            ** try [egrp 2[TRYBLOCK] [11 : 236->244)] { 
lbl80:
            // 1 sources

            var5_6.close();
            return var9_11;
lbl82:
            // 1 sources

            catch (IOException var14_23) {
                // empty catch block
            }
            return var9_11;
        }
        var13_18 = null;
        if (var5_6 == null) return var4_4;
        try {}
        catch (IOException var14_24) {}
        var5_6.close();
        return var4_4;
        return var4_4;
    }

    public static void main(String[] stringArray) {
        String string = "\"\"  \"dd d\" AAABBB \" aaa bbb\" \"abc\" CDEFG ";
        System.out.println(string);
        ArrayList arrayList = SGDataCreator.getColumnIndexListOfString(string);
        System.out.println(arrayList);
    }

    private static boolean isValidLine(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\"') continue;
            ++n;
        }
        return n % 2 == 0;
    }

    private static ArrayList getColumnIndexListOfString(String string) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (n = 0; n < cArray.length; ++n) {
            if (cArray[n] == '\"') {
                boolean bl2 = bl = !bl;
            }
            if (!bl) continue;
            cArray[n] = 34;
        }
        n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(String.valueOf(cArray));
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("\"")) {
                arrayList.add(new Integer(n));
            }
            ++n;
        }
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getFileTypeCandidateList(String string, ArrayList arrayList) throws FileNotFoundException {
        ArrayList arrayList2;
        String string2;
        BufferedReader bufferedReader;
        block15: {
            bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(string));
            string2 = SGUtilityText.readLine(bufferedReader);
            if (SGDataCreator.isValidLine(string2)) break block15;
            boolean bl = false;
            Object var11_8 = null;
            if (bufferedReader == null) return bl;
            try {
                bufferedReader.close();
                return bl;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return bl;
        }
        ArrayList arrayList3 = SGDataCreator.getColumnIndexListOfString(string2);
        ArrayList arrayList4 = this.getFirstTokenList(bufferedReader);
        int n = arrayList4.size();
        HashSet<String> hashSet = new HashSet<String>();
        if (this.evaluateDataTypeSXY(arrayList4) && arrayList3.equals(arrayList2 = SGDataCreator.getSXYTextColumnIndexList(n))) {
            hashSet.add("SXY");
        }
        if (this.evaluateDataTypeVXY(arrayList4) && arrayList3.equals(arrayList2 = SGDataCreator.getVXYTextColumnIndexList(n))) {
            hashSet.add("VXY");
        }
        if (this.evaluateDataTypeSXYMultiple(arrayList4) && arrayList3.equals(arrayList2 = SGDataCreator.getSXYMultipleTextColumnIndexList(n))) {
            if (n >= 3) {
                hashSet.add("SXY_MULTIPLE");
            }
            if (n >= 1) {
                hashSet.add("SXY_SAMPLING");
            }
        }
        if (this.evaluateDataTypeSXYDate(arrayList4) && arrayList3.equals(arrayList2 = SGDataCreator.getSXYDateTextColumnIndexList(n))) {
            hashSet.add("SXY_DATE");
        }
        arrayList.addAll(hashSet);
        Object var11_9 = null;
        if (bufferedReader == null) return true;
        try {
            bufferedReader.close();
            return true;
        }
        catch (IOException iOException) {}
        return true;
        {
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private boolean evaluateDataTypeSXY(ArrayList arrayList) {
        int n;
        int n2 = arrayList.size();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        if (n2 == 2 | n2 == 4) {
            for (n = 0; n < n2; ++n) {
                arrayList2.add(new Integer(n));
            }
        } else if (n2 == 3) {
            arrayList2.add(new Integer(0));
            arrayList2.add(new Integer(1));
        } else if (n2 == 5) {
            for (n = 0; n < 4; ++n) {
                arrayList2.add(new Integer(n));
            }
        } else {
            return false;
        }
        n = 1;
        for (int i = 0; i < arrayList2.size(); ++i) {
            int n3 = (Integer)arrayList2.get(i);
            String string = (String)arrayList.get(n3);
            Double d = SGUtilityText.getDouble(string);
            if (d != null) continue;
            n = 0;
            break;
        }
        return n != 0;
    }

    private boolean evaluateDataTypeVXY(ArrayList arrayList) {
        boolean bl = true;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            Double d = SGUtilityText.getDouble(string);
            if (d != null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean evaluateDataTypeSXYMultiple(ArrayList arrayList) {
        boolean bl = true;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            Double d = SGUtilityText.getDouble(string);
            if (d != null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean evaluateDataTypeSXYDate(ArrayList arrayList) {
        Object object;
        int n = arrayList.size();
        if (n != 2 & n != 3 & n != 4 & n != 5) {
            return false;
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(arrayList.get(0));
        DateFormat dateFormat = DateFormat.getDateInstance();
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string = (String)arrayList2.get(i);
            object = SGUtilityText.getDate(string);
            if (object != null) continue;
            return false;
        }
        ArrayList arrayList3 = new ArrayList();
        arrayList3.add(arrayList.get(1));
        if (n == 4 | n == 5) {
            arrayList3.add(arrayList.get(1));
            arrayList3.add(arrayList.get(2));
            arrayList3.add(arrayList.get(3));
        }
        for (int i = 0; i < arrayList3.size(); ++i) {
            object = (String)arrayList3.get(i);
            Double d = SGUtilityText.getDouble((String)object);
            if (d != null) continue;
            return false;
        }
        return true;
    }

    private ArrayList getFirstTokenList(BufferedReader bufferedReader) {
        String string;
        ArrayList arrayList = new ArrayList();
        while ((string = SGUtilityText.readLine(bufferedReader)) != null) {
            arrayList.clear();
            SGUtilityText.tokenize(string, arrayList);
            int n = arrayList.size();
            if (n == 0) continue;
            break;
        }
        return arrayList;
    }
}

