/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;
import jp.riken.brain.ni.samuraigraph.base.SGAxisSelectionPanel;
import jp.riken.brain.ni.samuraigraph.base.SGExclusiveAccessController;
import jp.riken.brain.ni.samuraigraph.base.SGITwoAxesHolder;

public class SGTwoAxesSelectionPanel
extends SGAxisSelectionPanel {
    private JToggleButton mHorizontalNoAxisSelectionButton = new JToggleButton();
    private JToggleButton mPerpendicularNoAxisSelectionButton = new JToggleButton();
    private SGExclusiveAccessController mHorizontalController = new SGExclusiveAccessController();
    private SGExclusiveAccessController mPerpendicularController = new SGExclusiveAccessController();

    public SGTwoAxesSelectionPanel() {
        this.initProperty();
    }

    private void initProperty() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mTopButton);
        buttonGroup.add(this.mBottomButton);
        buttonGroup.add(this.mHorizontalNoAxisSelectionButton);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.mLeftButton);
        buttonGroup2.add(this.mRightButton);
        buttonGroup2.add(this.mPerpendicularNoAxisSelectionButton);
        this.mHorizontalController.add(this.mBottomLine);
        this.mHorizontalController.add(this.mTopLine);
        this.mPerpendicularController.add(this.mLeftLine);
        this.mPerpendicularController.add(this.mRightLine);
    }

    protected void updateImage() {
        this.mAxisImagePanel.setTopSelected(this.isTopSelected());
        this.mAxisImagePanel.setBottomSelected(this.isBottomSelected());
        this.mAxisImagePanel.setLeftSelected(this.isLeftSelected());
        this.mAxisImagePanel.setRightSelected(this.isRightSelected());
        this.repaint();
    }

    protected void updateButtons() {
        boolean bl = this.isTopSelected();
        boolean bl2 = this.isBottomSelected();
        boolean bl3 = this.isLeftSelected();
        boolean bl4 = this.isRightSelected();
        if (bl | bl2) {
            this.mTopButton.setSelected(bl);
            this.mBottomButton.setSelected(bl2);
        } else {
            this.mHorizontalNoAxisSelectionButton.setSelected(true);
        }
        if (bl3 | bl4) {
            this.mLeftButton.setSelected(bl3);
            this.mRightButton.setSelected(bl4);
        } else {
            this.mPerpendicularNoAxisSelectionButton.setSelected(true);
        }
    }

    public int getXAxisConfiguration() {
        int n = -1;
        if (!this.mHorizontalNoAxisSelectionButton.isSelected()) {
            if (this.isBottomSelected()) {
                n = 0;
            } else if (this.isTopSelected()) {
                n = 1;
            }
        }
        return n;
    }

    public int getYAxisConfiguration() {
        int n = -1;
        if (!this.mPerpendicularNoAxisSelectionButton.isSelected()) {
            if (this.isLeftSelected()) {
                n = 2;
            } else if (this.isRightSelected()) {
                n = 3;
            }
        }
        return n;
    }

    public boolean setSelected(ArrayList arrayList) {
        Object object;
        int n = arrayList.size();
        if (n == 0) {
            return false;
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            object = (SGITwoAxesHolder)arrayList.get(i);
            arrayList2.add(new Integer(object.getXAxisConfiguration()));
            arrayList3.add(new Integer(object.getYAxisConfiguration()));
        }
        Integer n2 = (Integer)arrayList2.get(0);
        object = (Integer)arrayList3.get(0);
        Integer n3 = n2;
        Object object2 = object;
        if (n > 1) {
            Integer n4;
            int n5;
            for (n5 = 1; n5 < n; ++n5) {
                n4 = (Integer)arrayList2.get(n5);
                if (n2.equals(n4)) continue;
                n3 = null;
                break;
            }
            for (n5 = 1; n5 < n; ++n5) {
                n4 = (Integer)arrayList3.get(n5);
                if (((Integer)object).equals(n4)) continue;
                object2 = null;
                break;
            }
        }
        this.clearAll();
        if (n3 != null) {
            this.setHorizontalAxis(n3);
        }
        if (object2 != null) {
            this.setPerpendicularAxis((Integer)object2);
        }
        this.updateButtons();
        this.updateImage();
        return true;
    }

    private boolean setHorizontalAxis(int n) {
        switch (n) {
            case 0: {
                this.setBottomSelected(true);
                break;
            }
            case 1: {
                this.setTopSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        return true;
    }

    private boolean setPerpendicularAxis(int n) {
        switch (n) {
            case 2: {
                this.setLeftSelected(true);
                break;
            }
            case 3: {
                this.setRightSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("");
            }
        }
        return true;
    }

    protected void selectLine(SGAxisSelectionPanel.Line line) {
        if (this.mHorizontalController.contains(line)) {
            this.mHorizontalController.select(line);
        } else if (this.mPerpendicularController.contains(line)) {
            this.mPerpendicularController.select(line);
        }
    }
}

