/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import org.w3c.dom.Document;

public class SGUtilityText
implements SGIConstants {
    public static final String[] DEFAULT_DATE_FORMAT_ARRAY = new String[]{"yy/MM/dd", "yy.MM.dd", "yy-MM-dd", "yyyyMMdd", "yyMMdd", "yy MM dd", "yyyy MM dd"};
    private static final ArrayList DATE_FORMAT_ARRAY_LIST = new ArrayList();

    public static void main(String[] stringArray) throws Exception {
        System.out.println("<< start >>");
    }

    public static String getSuperscriptString(String string, String string2) {
        String string3 = string + "^{" + string2 + "}";
        return string3;
    }

    public static String getSubscriptString(String string, String string2) {
        String string3 = string + "_{" + string2 + "}";
        return string3;
    }

    public static boolean getSubscriptAndSuperscriptInfo(String string, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
        if (string == null || arrayList == null || arrayList2 == null || arrayList3 == null) {
            return false;
        }
        if (string.length() == 0) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        Boolean bl3 = null;
        ArrayList<Character> arrayList4 = new ArrayList<Character>();
        do {
            String string2;
            String string3;
            String string4;
            Object object;
            char c = string.charAt(n);
            if (!bl) {
                if (c == '^' || c == '_') {
                    bl = true;
                    if (n == 0) {
                        return false;
                    }
                    if (c == '^') {
                        bl3 = new Boolean(true);
                        continue;
                    }
                    if (c != '_') continue;
                    bl3 = new Boolean(false);
                    continue;
                }
                arrayList.add(new Character(c));
                arrayList2.add(null);
                arrayList3.add(null);
                continue;
            }
            if (bl2) {
                if (c == '}') {
                    bl2 = false;
                    object = SGUtilityText.createString(arrayList4);
                    if (bl3.booleanValue()) {
                        string4 = arrayList2.remove(arrayList2.size() - 1);
                        if (string4 != null) {
                            string3 = string4;
                            object = string3 + (String)object;
                        }
                        arrayList2.add(object);
                    } else {
                        string4 = arrayList3.remove(arrayList3.size() - 1);
                        if (string4 != null) {
                            string3 = string4;
                            object = string3 + (String)object;
                        }
                        arrayList3.add(object);
                    }
                    bl = false;
                    bl3 = null;
                    arrayList4.clear();
                    continue;
                }
                arrayList4.add(new Character(c));
                continue;
            }
            if (c == '{') {
                bl2 = true;
                continue;
            }
            object = new ArrayList();
            ((ArrayList)object).add(new Character(c));
            string4 = SGUtilityText.createString((ArrayList)object);
            if (bl3.booleanValue()) {
                string3 = arrayList2.remove(arrayList2.size() - 1);
                if (string3 != null) {
                    string2 = string3;
                    string4 = string2 + string4;
                }
                arrayList2.add(string4);
            } else {
                string3 = arrayList3.remove(arrayList3.size() - 1);
                if (string3 != null) {
                    string2 = string3;
                    string4 = string2 + string4;
                }
                arrayList3.add(string4);
            }
            bl = false;
            bl3 = null;
        } while (++n != string.length());
        return !bl;
    }

    public static boolean tokenize(String string, ArrayList arrayList) {
        block15: {
            String string2;
            int n;
            if (string == null | arrayList == null) {
                throw new IllegalArgumentException("str==null | strList==null");
            }
            if (string.length() == 0) {
                return true;
            }
            char[] cArray = string.toCharArray();
            boolean bl = false;
            boolean bl2 = false;
            ArrayList<Character> arrayList2 = new ArrayList<Character>();
            for (n = 0; n < SGIConstants.DELIMITER_SET.length; ++n) {
                arrayList2.add(new Character(SGIConstants.DELIMITER_SET[n]));
            }
            n = 0;
            ArrayList<Character> arrayList3 = new ArrayList<Character>();
            do {
                char c;
                if ((c = string.charAt(n)) == '\"') {
                    if (bl2) {
                        arrayList3.add(new Character(c));
                        bl2 = false;
                        continue;
                    }
                    if (arrayList3.size() != 0) {
                        string2 = SGUtilityText.createString(arrayList3);
                        arrayList.add(string2);
                        arrayList3.clear();
                    } else if (bl) {
                        arrayList.add("");
                        arrayList3.clear();
                    }
                    bl = !bl;
                    continue;
                }
                if (c == '\\') {
                    bl2 = true;
                    continue;
                }
                if (arrayList2.contains(new Character(c))) {
                    if (bl) {
                        arrayList3.add(new Character(c));
                    } else if (arrayList3.size() != 0) {
                        string2 = SGUtilityText.createString(arrayList3);
                        arrayList.add(string2);
                        arrayList3.clear();
                    }
                    bl2 = false;
                    continue;
                }
                arrayList3.add(new Character(c));
                bl2 = false;
            } while (++n != string.length());
            if (bl) {
                return false;
            }
            string2 = SGUtilityText.createString(arrayList3);
            if (string2 == null || string2.length() == 0) break block15;
            arrayList.add(string2);
            arrayList3.clear();
        }
        return true;
    }

    public static String createString(ArrayList arrayList) {
        char[] cArray = new char[arrayList.size()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = ((Character)arrayList.get(i)).charValue();
        }
        String string = new String(cArray);
        return string;
    }

    public static String readLine(BufferedReader bufferedReader) {
        String string = null;
        try {
            do {
                if ((string = bufferedReader.readLine()) != null) continue;
                return null;
            } while (string.length() == 0);
        }
        catch (Exception exception) {
            return null;
        }
        return string;
    }

    public static String getColorListString(ArrayList arrayList) {
        String string = "{";
        for (int i = 0; i < arrayList.size(); ++i) {
            Color color = (Color)arrayList.get(i);
            String string2 = SGUtilityText.getColorString(color);
            string = string + string2;
            string = i != arrayList.size() - 1 ? string + ',' : string + "}";
        }
        return string;
    }

    public static boolean writeColorListPropertyLine(Writer writer, String string, ArrayList arrayList) throws IOException {
        writer.write(string + "=");
        String string2 = SGUtilityText.getColorListString(arrayList);
        writer.write(string2 + "\n");
        return true;
    }

    public static String getInnerString(String string, int n, int n2) {
        if (string == null) {
            return null;
        }
        if (string.length() < 2) {
            return null;
        }
        int n3 = string.indexOf(n) + 1;
        int n4 = string.lastIndexOf(n2);
        if (n4 <= n3) {
            return null;
        }
        String string2 = string.substring(n3, n4);
        return string2;
    }

    public static Color getColorFromString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = SGUtilityText.getInnerString(string, 40, 41);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() != 4) {
            return null;
        }
        int[] nArray = new int[arrayList.size()];
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string3 = (String)arrayList.get(i);
                int n = Integer.valueOf(string3);
                if (n < 0 || n > 255) {
                    return null;
                }
                nArray[i] = n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Color color = new Color(nArray[0], nArray[1], nArray[2], nArray[3]);
        return color;
    }

    public static String getColorString(Color color) {
        String string = new String("(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + "," + color.getAlpha() + ")");
        return string;
    }

    public static Boolean getBoolean(String string) {
        if (string == null) {
            return null;
        }
        Boolean bl = null;
        if (Boolean.TRUE.toString().equals(string)) {
            bl = Boolean.TRUE;
        } else if (Boolean.FALSE.toString().equals(string)) {
            bl = Boolean.FALSE;
        } else {
            return null;
        }
        return bl;
    }

    public static Integer getInteger(String string) {
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return new Integer(number.intValue());
    }

    public static Float getFloat(String string) {
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return new Float(number.floatValue());
    }

    public static Double getDouble(String string) {
        Number number = SGUtilityText.parse(string);
        if (number == null) {
            return null;
        }
        return new Double(number.doubleValue());
    }

    public static ArrayList getColorList(String string) {
        String string2 = SGUtilityText.getInnerString(string, 123, 125);
        if (string2 == null) {
            return null;
        }
        ArrayList arrayList = SGUtilityText.getStringListFromCommaSeparatedLine(string2);
        ArrayList<Color> arrayList2 = new ArrayList<Color>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            Color color = SGUtilityText.getColorFromString(string3);
            arrayList2.add(color);
        }
        return arrayList2;
    }

    public static ArrayList getStringListFromCommaSeparatedLine(String string) {
        String string2;
        int n;
        int n2;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n2 = string.indexOf("(", n3)) < (n = string.indexOf(")", n3)) && (string2 = string.substring(n2, n + 1)) != null) {
            arrayList.add(string2);
            n3 = n + 1;
        }
        return arrayList;
    }

    public static String getFontStyleName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Plain";
                break;
            }
            case 1: {
                string = "Bold";
                break;
            }
            case 2: {
                string = "Italic";
                break;
            }
            case 3: {
                string = "Bold Italic";
                break;
            }
        }
        return string;
    }

    public static int getFontStyle(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.equals("Plain") ? 0 : (string.equals("Bold") ? 1 : (string.equals("Italic") ? 2 : (string.equals("Bold Italic") ? 3 : -1)));
        return n;
    }

    public static String getScaleTypeName(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "Linear";
                break;
            }
            case 1: {
                string = "Log";
                break;
            }
        }
        return string;
    }

    public static int getScaleType(String string) {
        if (string == null) {
            return -1;
        }
        int n = string.equals("Linear") ? 0 : (string.equals("Log") ? 1 : -1);
        return n;
    }

    public static Document getDocument(String string) {
        Document document = null;
        try {
            URL uRL = new URL(string);
            document = SGUtilityText.getDocument(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static Document getDocument(URL uRL) {
        Document document;
        block16: {
            document = null;
            BufferedInputStream bufferedInputStream = null;
            bufferedInputStream = new BufferedInputStream(uRL.openStream());
            try {
                document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bufferedInputStream, uRL.toString());
            }
            catch (Exception exception) {
                Document document2 = null;
                Object var6_7 = null;
                try {
                    if (bufferedInputStream != null) {
                        ((InputStream)bufferedInputStream).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return document2;
            }
            Object var6_8 = null;
            try {
                if (bufferedInputStream != null) {
                    ((InputStream)bufferedInputStream).close();
                }
                break block16;
            }
            catch (IOException iOException) {}
            break block16;
            {
                catch (IOException iOException) {
                    Document document3 = null;
                    Object var6_9 = null;
                    try {
                        if (bufferedInputStream != null) {
                            ((InputStream)bufferedInputStream).close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    return document3;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (bufferedInputStream != null) {
                        ((InputStream)bufferedInputStream).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return document;
    }

    private static Number parse(String string) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string.startsWith("+") && string.length() > 1) {
            string2 = string2.substring(1);
        }
        string2 = string2.toUpperCase();
        string2 = string2.replaceAll("E\\+", "E");
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = NumberFormat.getInstance().parse(string2, parsePosition);
        if (parsePosition.getIndex() != string2.length()) {
            return null;
        }
        return number;
    }

    public static Float getFloat(String string, String string2) {
        Number number = SGUtilityText.removeUnit(string, string2);
        if (number == null) {
            return null;
        }
        return new Float(number.floatValue());
    }

    public static Double getDouble(String string, String string2) {
        Number number = SGUtilityText.removeUnit(string, string2);
        if (number == null) {
            return null;
        }
        return new Double(number.doubleValue());
    }

    public static boolean isValidString(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n == 0) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!(c != ' ' & c != '\u3000' & c != '\t' & c != '\n' & c != '\r' & c != '\f')) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String getSerialName(ArrayList arrayList, String string) {
        String string2 = string;
        int n = -1;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            if (!string3.startsWith(string)) continue;
            String string4 = string3.substring(string.length());
            if (string4.startsWith("(") & string4.endsWith(")")) {
                int n2;
                String string5 = string4.substring(1, string4.length() - 1);
                Integer n3 = SGUtilityText.getInteger(string5);
                if (n3 == null || (n2 = n3.intValue()) <= n) continue;
                n = n2;
                continue;
            }
            if (!string4.equals("")) continue;
            n = 0;
        }
        if (n != -1) {
            string2 = string2 + "(" + ++n + ")";
        }
        return string2;
    }

    public static void addAvailableDateFormat(String string) {
        DATE_FORMAT_ARRAY_LIST.add(new SimpleDateFormat(string));
    }

    public static Date getDate(String string) {
        Date date = null;
        ArrayList arrayList = DATE_FORMAT_ARRAY_LIST;
        for (int i = 0; i < arrayList.size(); ++i) {
            DateFormat dateFormat = (DateFormat)arrayList.get(i);
            ParsePosition parsePosition = new ParsePosition(0);
            Date date2 = dateFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() != string.length() || date2 == null) continue;
            date = date2;
            break;
        }
        return date;
    }

    public static String[] getUnitsArrayOfLength() {
        String[] stringArray = new String[]{"cm", "mm", "pt", "inch"};
        return stringArray;
    }

    public static boolean isLengthUnit(String string) {
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static double convert(double d, String string, String string2) {
        int n;
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        float[] fArray = new float[]{1.0f, 0.1f, 0.035277776f, 2.54f};
        int n2 = -1;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals(string)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            throw new IllegalArgumentException();
        }
        n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string2)) continue;
            n = i;
            break;
        }
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        if (string.equals(string2)) {
            return d;
        }
        float f = fArray[n2] / fArray[n];
        return d * (double)f;
    }

    public static String convertString(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        String[] stringArray = SGUtilityText.getUnitsArrayOfLength();
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            string3 = stringArray[i];
            break;
        }
        if (string3 == null) {
            return null;
        }
        Number number = SGUtilityText.removeUnit(string, string3);
        if (number == null) {
            return null;
        }
        double d = number.doubleValue();
        double d2 = SGUtilityText.convert(d, string3, string2);
        String string4 = Double.toString(d2);
        return string4;
    }

    public static Number removeUnit(String string, String string2) {
        String string3 = SGUtilityText.removeSuffix(string, string2);
        if (string3 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        if (arrayList.size() != 1) {
            return null;
        }
        String string4 = (String)arrayList.get(0);
        return SGUtilityText.getDouble(string4);
    }

    public static String removeSuffix(String string, String string2) {
        int n;
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        if (!string.endsWith(string2)) {
            return string;
        }
        int n2 = -1;
        while ((n = string.indexOf(string2, n2 + 1)) != -1) {
            n2 = n;
        }
        String string3 = string.substring(0, n2);
        if (string3.length() == 0) {
            return null;
        }
        return string3;
    }

    static {
        String[] stringArray = DEFAULT_DATE_FORMAT_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            SGUtilityText.addAvailableDateFormat(stringArray[i]);
        }
    }
}

