/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGCheckBox;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroup;
import jp.riken.brain.ni.samuraigraph.base.SGComponentGroupElement;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIWindowDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;

public class SGWindowDialog
extends SGPropertyDialog {
    public static final String TITLE = "Window Properties";
    private SGColorSelectionButton mBackgroundColorButton;
    private JLabel mBackgroundColorLabel1;
    private JLabel mBottomLabel;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JLabel mColorLabel;
    private JSeparator mColorSeparator;
    private JLabel mGridLabel;
    private SGColorSelectionButton mGridLinesColorButton;
    private JLabel mGridLinesColorLabel;
    private SGSpinner mGridLinesIntervalSpinner;
    private SGSpinner mGridLinesWidthSpinner;
    private JSeparator mGridSeparator;
    private SGCheckBox mGridVisibleCheckBox;
    private JLabel mHeightLabel;
    private SGSpinner mHeightSpinner;
    private JLabel mIntervalLabel;
    private JLabel mLeftSpaceLabel;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mSizeLabel;
    private JSeparator mSizeSeparator;
    private JLabel mWidthLabel;
    private SGSpinner mWidthSpinner;
    private JPanel mWindowPanel;
    private SGComponentGroup mGridVisibleComponentGroup = new SGComponentGroup();

    public SGWindowDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mWindowPanel = new JPanel();
        this.mWidthLabel = new JLabel();
        this.mHeightLabel = new JLabel();
        this.mWidthSpinner = new SGSpinner();
        this.mHeightSpinner = new SGSpinner();
        this.mSizeLabel = new JLabel();
        this.mColorLabel = new JLabel();
        this.mIntervalLabel = new JLabel();
        this.mGridLinesIntervalSpinner = new SGSpinner();
        this.mBottomLabel = new JLabel();
        this.mGridLinesWidthSpinner = new SGSpinner();
        this.mGridLabel = new JLabel();
        this.mGridLinesColorButton = new SGColorSelectionButton();
        this.mBackgroundColorLabel1 = new JLabel();
        this.mGridLinesColorLabel = new JLabel();
        this.mBackgroundColorButton = new SGColorSelectionButton();
        this.mSizeSeparator = new JSeparator();
        this.mGridSeparator = new JSeparator();
        this.mColorSeparator = new JSeparator();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mGridVisibleCheckBox = new SGCheckBox();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mWindowPanel.setLayout(new GridBagLayout());
        this.mWindowPanel.setBorder(new BevelBorder(0));
        this.mWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mWidthLabel.setText("Width");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mWindowPanel.add((Component)this.mWidthLabel, gridBagConstraints);
        this.mHeightLabel.setFont(new Font("Dialog", 0, 12));
        this.mHeightLabel.setText("Height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mWindowPanel.add((Component)this.mHeightLabel, gridBagConstraints);
        this.mWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mWidthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mWidthSpinner, gridBagConstraints);
        this.mHeightSpinner.setFont(new Font("Dialog", 0, 12));
        this.mHeightSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mHeightSpinner, gridBagConstraints);
        this.mSizeLabel.setFont(new Font("Dialog", 3, 12));
        this.mSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.mWindowPanel.add((Component)this.mSizeLabel, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 3, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mWindowPanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mIntervalLabel.setFont(new Font("Dialog", 0, 12));
        this.mIntervalLabel.setText("Interval");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mWindowPanel.add((Component)this.mIntervalLabel, gridBagConstraints);
        this.mGridLinesIntervalSpinner.setFont(new Font("Dialog", 0, 12));
        this.mGridLinesIntervalSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mGridLinesIntervalSpinner, gridBagConstraints);
        this.mBottomLabel.setFont(new Font("Dialog", 0, 12));
        this.mBottomLabel.setText("Line width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mWindowPanel.add((Component)this.mBottomLabel, gridBagConstraints);
        this.mGridLinesWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mGridLinesWidthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mGridLinesWidthSpinner, gridBagConstraints);
        this.mGridLabel.setFont(new Font("Dialog", 3, 12));
        this.mGridLabel.setText("Grid");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.mWindowPanel.add((Component)this.mGridLabel, gridBagConstraints);
        this.mGridLinesColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mWindowPanel.add((Component)this.mGridLinesColorButton, gridBagConstraints);
        this.mBackgroundColorLabel1.setFont(new Font("Dialog", 0, 12));
        this.mBackgroundColorLabel1.setText("Background");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mWindowPanel.add((Component)this.mBackgroundColorLabel1, gridBagConstraints);
        this.mGridLinesColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mGridLinesColorLabel.setText("Grid");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mWindowPanel.add((Component)this.mGridLinesColorLabel, gridBagConstraints);
        this.mBackgroundColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mWindowPanel.add((Component)this.mBackgroundColorButton, gridBagConstraints);
        this.mSizeSeparator.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 35, 0, 0);
        this.mWindowPanel.add((Component)this.mSizeSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 35, 0, 0);
        this.mWindowPanel.add((Component)this.mGridSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 42, 0, 0);
        this.mWindowPanel.add((Component)this.mColorSeparator, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mWindowPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mWindowPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mGridVisibleCheckBox.setFont(new Font("Dialog", 0, 12));
        this.mGridVisibleCheckBox.setText("Visible");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mWindowPanel.add((Component)this.mGridVisibleCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mWindowPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mWidthSpinner.initProperties(new SpinnerNumberModel(1.0, 1.0, 99.0, 1.0), "cm", 1, 1);
        this.mHeightSpinner.initProperties(new SpinnerNumberModel(1.0, 1.0, 99.0, 1.0), "cm", 1, 1);
        this.mGridLinesIntervalSpinner.initProperties(new SpinnerNumberModel(0.5, 0.5, 10.0, 0.5), "cm", 1, 2);
        this.mGridLinesWidthSpinner.initProperties(SGWindowDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        this.mGridVisibleCheckBox.addActionListener(this);
        this.mFocusedColorSetButton = this.mBackgroundColorButton;
        SGComponentGroupElement[] sGComponentGroupElementArray = new SGComponentGroupElement[]{new SGComponentGroupElement(this.mIntervalLabel), new SGComponentGroupElement(this.mGridLinesIntervalSpinner), new SGComponentGroupElement(this.mBottomLabel), new SGComponentGroupElement(this.mGridLinesWidthSpinner), new SGComponentGroupElement(this.mGridLinesColorLabel), new SGComponentGroupElement(this.mGridLinesColorButton)};
        this.mGridVisibleComponentGroup.addElement(sGComponentGroupElementArray);
        return true;
    }

    public Number getPaperWidth() {
        return this.mWidthSpinner.getNumber();
    }

    public Number getPaperHeight() {
        return this.mHeightSpinner.getNumber();
    }

    public Color getPaperColor() {
        return this.mBackgroundColorButton.getColor();
    }

    public Color getGridLineColor() {
        return this.mGridLinesColorButton.getColor();
    }

    public Boolean isGridVisible() {
        return this.mGridVisibleCheckBox.getSelected();
    }

    public Number getGridLineInterval() {
        return this.mGridLinesIntervalSpinner.getNumber();
    }

    public Number getGridLineWidth() {
        return this.mGridLinesWidthSpinner.getNumber();
    }

    public boolean setPaperWidth(Object object) {
        return this.setValue(this.mWidthSpinner, object);
    }

    public boolean setPaperHeight(Object object) {
        return this.setValue(this.mHeightSpinner, object);
    }

    public boolean setGridVisible(Boolean bl) {
        this.mGridVisibleCheckBox.setSelected(bl);
        this.setGridComponentEnabled(bl);
        return true;
    }

    public boolean setGridLineInterval(Object object) {
        return this.setValue(this.mGridLinesIntervalSpinner, object);
    }

    public boolean setGridLineWidth(Object object) {
        return this.setValue(this.mGridLinesWidthSpinner, object);
    }

    public boolean setPaperColor(Color color) {
        this.mBackgroundColorButton.setColor(color);
        return true;
    }

    public boolean setGridLineColor(Color color) {
        this.mGridLinesColorButton.setColor(color);
        return true;
    }

    public ArrayList getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mBackgroundColorButton);
        arrayList.add(this.mGridLinesColorButton);
        return arrayList;
    }

    public ArrayList getTextFieldComponentsList() {
        ArrayList arrayList = this.getFormattedTextFieldsListFromSpinners();
        return arrayList;
    }

    public ArrayList getNumberTextFieldList() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mWidthSpinner);
        arrayList.add(this.mHeightSpinner);
        arrayList.add(this.mGridLinesIntervalSpinner);
        arrayList.add(this.mGridLinesWidthSpinner);
        return arrayList;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.mGridVisibleCheckBox)) {
            this.setGridVisible(this.isGridVisible());
        }
    }

    private boolean setGridComponentEnabled(Boolean bl) {
        boolean bl2 = true;
        if (bl != null) {
            bl2 = bl;
        }
        this.setGridComponentEnabled(bl2);
        return true;
    }

    private boolean setGridComponentEnabled(boolean bl) {
        this.mGridVisibleComponentGroup.setEnabled(bl);
        if (this.mGridLinesColorButton.equals(this.mFocusedColorSetButton)) {
            this.mFocusedColorSetButton = this.mBackgroundColorButton;
            this.setColorButtonBorder(true);
        }
        return true;
    }

    public boolean setDialogProperty() {
        ArrayList arrayList = this.mPropertyDialogObserverList;
        SGIWindowDialogObserver sGIWindowDialogObserver = (SGIWindowDialogObserver)arrayList.get(0);
        float f = sGIWindowDialogObserver.getPaperWidth();
        float f2 = sGIWindowDialogObserver.getPaperHeight();
        float f3 = sGIWindowDialogObserver.getGridLineInterval();
        float f4 = sGIWindowDialogObserver.getGridLineWidth();
        boolean bl = sGIWindowDialogObserver.isGridLineVisible();
        Color color = sGIWindowDialogObserver.getPaperColor();
        Color color2 = sGIWindowDialogObserver.getGridLineColor();
        Float f5 = new Float(f);
        Float f6 = new Float(f2);
        Float f7 = new Float(f3);
        Float f8 = new Float(f4);
        Boolean bl2 = bl;
        Color color3 = color;
        Color color4 = color2;
        if (arrayList.size() > 1) {
            float f9;
            SGIWindowDialogObserver sGIWindowDialogObserver2;
            int n;
            for (n = 1; n < arrayList.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)arrayList.get(n);
                f9 = sGIWindowDialogObserver2.getPaperWidth();
                if (f == f9) continue;
                f5 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)arrayList.get(n);
                f9 = sGIWindowDialogObserver2.getPaperHeight();
                if (f2 == f9) continue;
                f6 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)arrayList.get(n);
                f9 = sGIWindowDialogObserver2.getGridLineInterval();
                if (f3 == f9) continue;
                f7 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)arrayList.get(n);
                f9 = sGIWindowDialogObserver2.getGridLineWidth();
                if (f4 == f9) continue;
                f8 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)arrayList.get(n);
                boolean bl3 = sGIWindowDialogObserver2.isGridLineVisible();
                if (bl == bl3) continue;
                bl2 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)arrayList.get(n);
                Color color5 = sGIWindowDialogObserver2.getPaperColor();
                if (color.equals(color5)) continue;
                color3 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIWindowDialogObserver2 = (SGIWindowDialogObserver)arrayList.get(n);
                Color color6 = sGIWindowDialogObserver2.getGridLineColor();
                if (color2.equals(color6)) continue;
                color4 = null;
                break;
            }
        }
        if (f5 != null) {
            f5 = new Float(f5.floatValue() * 0.035277776f);
        }
        this.setPaperWidth(f5);
        if (f6 != null) {
            f6 = new Float(f6.floatValue() * 0.035277776f);
        }
        this.setPaperHeight(f6);
        if (f7 != null) {
            f7 = new Float(f7.floatValue() * 0.035277776f);
        }
        this.setGridLineInterval(f7);
        this.setGridLineWidth(f8);
        this.setGridVisible(bl2);
        this.setPaperColor(color3);
        this.setGridLineColor(color4);
        this.setColorButtonBorder(true);
        return true;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        Color color;
        Color color2;
        Boolean bl;
        Number number;
        Number number2;
        Number number3;
        SGIWindowDialogObserver sGIWindowDialogObserver = (SGIWindowDialogObserver)sGIPropertyDialogObserver;
        Number number4 = this.getPaperWidth();
        if (number4 != null) {
            sGIWindowDialogObserver.setPaperWidth(number4.floatValue() / 0.035277776f);
        }
        if ((number3 = this.getPaperHeight()) != null) {
            sGIWindowDialogObserver.setPaperHeight(number3.floatValue() / 0.035277776f);
        }
        if ((number2 = this.getGridLineInterval()) != null) {
            sGIWindowDialogObserver.setGridLineInterval(number2.floatValue() / 0.035277776f);
        }
        if ((number = this.getGridLineWidth()) != null) {
            sGIWindowDialogObserver.setGridLineWidth(number.floatValue());
        }
        if ((bl = this.isGridVisible()) != null) {
            sGIWindowDialogObserver.setGridLineVisible(bl);
        }
        if ((color2 = this.getPaperColor()) != null) {
            sGIWindowDialogObserver.setPaperColor(color2);
        }
        if ((color = this.getGridLineColor()) != null) {
            sGIWindowDialogObserver.setGridLineColor(color);
        }
        return true;
    }
}

