/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIAxisBreakSymbolDialogObserver;

public class SGAxisBreakSymbolDialog
extends SGPropertyDialog {
    public static final String TITLE = "Axis Break Symbol Properties";
    private JLabel mAngleLabel;
    private SGSpinner mAngleSpinner;
    private SGTwoAxesSelectionPanel mAxisPanel;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JLabel mColorLabel;
    private JSeparator mColorSeparator;
    private JLabel mDistortionLabel;
    private SGSpinner mDistortionSpinner;
    private JLabel mFormLabel;
    private JSeparator mFormSeparator;
    private JRadioButton mHorizontalRadioButton;
    private SGColorSelectionButton mInnerColorButton;
    private JLabel mInnerColorLabel;
    private JLabel mIntervalLabel;
    private SGSpinner mIntervalSpinner;
    private JLabel mLeftSpaceLabel;
    private JLabel mLengthLabel;
    private SGSpinner mLengthSpinner;
    private SGColorSelectionButton mLineColorButton;
    private JLabel mLineColorLabel;
    private JLabel mLineWidthLabel;
    private SGSpinner mLineWidthSpinner;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mSizeLabel;
    private JSeparator mSizeSeparator;
    private JRadioButton mVerticalRadioButton;
    private JLabel mXValueLabel;
    private SGTextField mXValueTextField;
    private JLabel mYValueLabel;
    private SGTextField mYValueTextField;
    private JRadioButton mAdditionalDirectionRadioButton = new JRadioButton();

    public SGAxisBreakSymbolDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mPanel = new JPanel();
        this.mSizeSeparator = new JSeparator();
        this.mFormSeparator = new JSeparator();
        this.mColorSeparator = new JSeparator();
        this.mDistortionLabel = new JLabel();
        this.mAngleLabel = new JLabel();
        this.mDistortionSpinner = new SGSpinner();
        this.mAngleSpinner = new SGSpinner();
        this.mSizeLabel = new JLabel();
        this.mFormLabel = new JLabel();
        this.mLengthLabel = new JLabel();
        this.mLengthSpinner = new SGSpinner();
        this.mIntervalLabel = new JLabel();
        this.mIntervalSpinner = new SGSpinner();
        this.mLineWidthLabel = new JLabel();
        this.mLineWidthSpinner = new SGSpinner();
        this.mColorLabel = new JLabel();
        this.mInnerColorButton = new SGColorSelectionButton();
        this.mLeftSpaceLabel = new JLabel();
        this.mRightSpaceLabel = new JLabel();
        this.mLineColorLabel = new JLabel();
        this.mLineColorButton = new SGColorSelectionButton();
        this.mInnerColorLabel = new JLabel();
        this.mHorizontalRadioButton = new JRadioButton();
        this.mVerticalRadioButton = new JRadioButton();
        this.mLocationLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mXValueLabel = new JLabel();
        this.mXValueTextField = new SGTextField();
        this.mYValueLabel = new JLabel();
        this.mYValueTextField = new SGTextField();
        this.mAxisPanel = new SGTwoAxesSelectionPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new BevelBorder(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 35, 0, 0);
        this.mPanel.add((Component)this.mSizeSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 45, 0, 0);
        this.mPanel.add((Component)this.mFormSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 45, 0, 0);
        this.mPanel.add((Component)this.mColorSeparator, gridBagConstraints);
        this.mDistortionLabel.setFont(new Font("Dialog", 0, 12));
        this.mDistortionLabel.setText("Distortion");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mDistortionLabel, gridBagConstraints);
        this.mAngleLabel.setFont(new Font("Dialog", 0, 12));
        this.mAngleLabel.setText("Angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mPanel.add((Component)this.mAngleLabel, gridBagConstraints);
        this.mDistortionSpinner.setFont(new Font("Dialog", 0, 12));
        this.mDistortionSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mDistortionSpinner, gridBagConstraints);
        this.mAngleSpinner.setFont(new Font("Dialog", 0, 12));
        this.mAngleSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mAngleSpinner, gridBagConstraints);
        this.mSizeLabel.setFont(new Font("Dialog", 3, 12));
        this.mSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mSizeLabel, gridBagConstraints);
        this.mFormLabel.setFont(new Font("Dialog", 3, 12));
        this.mFormLabel.setText("Form");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mFormLabel, gridBagConstraints);
        this.mLengthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLengthLabel.setText("Length");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLengthLabel, gridBagConstraints);
        this.mLengthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mLengthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLengthSpinner, gridBagConstraints);
        this.mIntervalLabel.setFont(new Font("Dialog", 0, 12));
        this.mIntervalLabel.setText("Interval");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mPanel.add((Component)this.mIntervalLabel, gridBagConstraints);
        this.mIntervalSpinner.setFont(new Font("Dialog", 0, 12));
        this.mIntervalSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mIntervalSpinner, gridBagConstraints);
        this.mLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel.setText("Line Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mLineWidthLabel, gridBagConstraints);
        this.mLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 3, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mColorLabel, gridBagConstraints);
        this.mInnerColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.mPanel.add((Component)this.mInnerColorButton, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.mPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        this.mPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mLineColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineColorLabel.setText("Line");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mPanel.add((Component)this.mLineColorLabel, gridBagConstraints);
        this.mLineColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mPanel.add((Component)this.mLineColorButton, gridBagConstraints);
        this.mInnerColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mInnerColorLabel.setText("Inner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mPanel.add((Component)this.mInnerColorLabel, gridBagConstraints);
        this.mHorizontalRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mHorizontalRadioButton.setText("Horizontal");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mHorizontalRadioButton, gridBagConstraints);
        this.mVerticalRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mVerticalRadioButton.setText("Vertical");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mPanel.add((Component)this.mVerticalRadioButton, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 60, 0, 0);
        this.mPanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        this.mXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mXValueLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mXValueLabel, gridBagConstraints);
        this.mXValueTextField.setColumns(6);
        this.mXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mXValueTextField, gridBagConstraints);
        this.mYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mYValueLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mYValueLabel, gridBagConstraints);
        this.mYValueTextField.setColumns(6);
        this.mYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mPanel.add((Component)this.mYValueTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mAxisPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        this.mLengthSpinner.initProperties(new SpinnerNumberModel(0.5, 0.5, 2.0, 0.1), "cm", 1, 2);
        this.mIntervalSpinner.initProperties(new SpinnerNumberModel(0.5, 0.1, 2.0, 0.1), "cm", 1, 2);
        this.mDistortionSpinner.initProperties(new SpinnerNumberModel(0.0, -1.0, 1.0, 0.1), null, 1, 2);
        this.mAngleSpinner.initProperties(new SpinnerNumberModel(0.0, -60.000003814697266, 60.000003814697266, 1.0), SGIConstants.degree, 1, 2);
        this.mLineWidthSpinner.initProperties(SGAxisBreakSymbolDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mHorizontalRadioButton);
        buttonGroup.add(this.mVerticalRadioButton);
        buttonGroup.add(this.mAdditionalDirectionRadioButton);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mLineColorButton;
        return true;
    }

    public Number getXValue() {
        return this.getNumber(this.mXValueTextField);
    }

    public Number getYValue() {
        return this.getNumber(this.mYValueTextField);
    }

    public Number getLength() {
        return this.mLengthSpinner.getNumber();
    }

    public Number getInterval() {
        return this.mIntervalSpinner.getNumber();
    }

    public Number getDistortion() {
        return this.mDistortionSpinner.getNumber();
    }

    public Number getAngle() {
        return this.mAngleSpinner.getNumber();
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public Boolean isHorizontal() {
        if (this.mAdditionalDirectionRadioButton.isSelected()) {
            return null;
        }
        return new Boolean(this.mHorizontalRadioButton.isSelected());
    }

    public Color getLineColor() {
        return this.mLineColorButton.getColor();
    }

    public Color getInnerColor() {
        return this.mInnerColorButton.getColor();
    }

    public boolean setXValue(Object object) {
        return this.setValue(this.mXValueTextField, object);
    }

    public boolean setYValue(Object object) {
        return this.setValue(this.mYValueTextField, object);
    }

    public boolean setLength(Object object) {
        return this.setValue(this.mLengthSpinner, object);
    }

    public boolean setInterval(Object object) {
        return this.setValue(this.mIntervalSpinner, object);
    }

    public boolean setDistortion(Object object) {
        return this.setValue(this.mDistortionSpinner, object);
    }

    public boolean setAngle(Object object) {
        return this.setValue(this.mAngleSpinner, object);
    }

    public boolean setLineWidth(Object object) {
        return this.setValue(this.mLineWidthSpinner, object);
    }

    public boolean setHorizontal(boolean bl) {
        this.mHorizontalRadioButton.setSelected(bl);
        this.mVerticalRadioButton.setSelected(!bl);
        return true;
    }

    public boolean setLineColor(Color color) {
        this.mLineColorButton.setColor(color);
        return true;
    }

    public boolean setInnerColor(Color color) {
        this.mInnerColorButton.setColor(color);
        return true;
    }

    public ArrayList getTextFieldComponentsList() {
        ArrayList arrayList = this.getFormattedTextFieldsListFromSpinners();
        arrayList.addAll(this.getNumberTextFieldList());
        return arrayList;
    }

    public ArrayList getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mXValueTextField);
        arrayList.add(this.mYValueTextField);
        return arrayList;
    }

    public ArrayList getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mLineColorButton);
        arrayList.add(this.mInnerColorButton);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mLengthSpinner);
        arrayList.add(this.mIntervalSpinner);
        arrayList.add(this.mDistortionSpinner);
        arrayList.add(this.mAngleSpinner);
        arrayList.add(this.mLineWidthSpinner);
        return arrayList;
    }

    public boolean setDialogProperty() {
        SGAxisBreakSymbolDialog sGAxisBreakSymbolDialog = this;
        ArrayList arrayList = this.mPropertyDialogObserverList;
        if (!this.mAxisPanel.setSelected(arrayList)) {
            return false;
        }
        SGIAxisBreakSymbolDialogObserver sGIAxisBreakSymbolDialogObserver = (SGIAxisBreakSymbolDialogObserver)arrayList.get(0);
        double d = sGIAxisBreakSymbolDialogObserver.getXValue();
        double d2 = sGIAxisBreakSymbolDialogObserver.getYValue();
        float f = sGIAxisBreakSymbolDialogObserver.getLength();
        float f2 = sGIAxisBreakSymbolDialogObserver.getInterval();
        float f3 = sGIAxisBreakSymbolDialogObserver.getDistortion();
        float f4 = sGIAxisBreakSymbolDialogObserver.getAngle();
        float f5 = sGIAxisBreakSymbolDialogObserver.getLineWidth();
        boolean bl = sGIAxisBreakSymbolDialogObserver.isForHorizontalAxis();
        Color color = sGIAxisBreakSymbolDialogObserver.getLineColor();
        Color color2 = sGIAxisBreakSymbolDialogObserver.getInnerColor();
        Double d3 = new Double(d);
        Double d4 = new Double(d2);
        Float f6 = new Float(f);
        Float f7 = new Float(f2);
        Float f8 = new Float(f3);
        Float f9 = new Float(f4);
        Float f10 = new Float(f5);
        Boolean bl2 = bl;
        Color color3 = color;
        Color color4 = color2;
        if (arrayList.size() > 1) {
            double d5;
            SGIAxisBreakSymbolDialogObserver sGIAxisBreakSymbolDialogObserver2;
            int n;
            for (n = 1; n < arrayList.size(); ++n) {
                sGIAxisBreakSymbolDialogObserver2 = (SGIAxisBreakSymbolDialogObserver)arrayList.get(n);
                d5 = sGIAxisBreakSymbolDialogObserver2.getXValue();
                if (d == d5) continue;
                d3 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIAxisBreakSymbolDialogObserver2 = (SGIAxisBreakSymbolDialogObserver)arrayList.get(n);
                d5 = sGIAxisBreakSymbolDialogObserver2.getYValue();
                if (d2 == d5) continue;
                d4 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIAxisBreakSymbolDialogObserver2 = (SGIAxisBreakSymbolDialogObserver)arrayList.get(n);
                float f11 = sGIAxisBreakSymbolDialogObserver2.getLength();
                if (f == f11) continue;
                f6 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIAxisBreakSymbolDialogObserver2 = (SGIAxisBreakSymbolDialogObserver)arrayList.get(n);
                float f12 = sGIAxisBreakSymbolDialogObserver2.getInterval();
                if (f2 == f12) continue;
                f7 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIAxisBreakSymbolDialogObserver2 = (SGIAxisBreakSymbolDialogObserver)arrayList.get(n);
                float f13 = sGIAxisBreakSymbolDialogObserver2.getDistortion();
                if (f3 == f13) continue;
                f8 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIAxisBreakSymbolDialogObserver2 = (SGIAxisBreakSymbolDialogObserver)arrayList.get(n);
                float f14 = sGIAxisBreakSymbolDialogObserver2.getAngle();
                if (f4 == f14) continue;
                f9 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIAxisBreakSymbolDialogObserver2 = (SGIAxisBreakSymbolDialogObserver)arrayList.get(n);
                float f15 = sGIAxisBreakSymbolDialogObserver2.getLineWidth();
                if (f5 == f15) continue;
                f10 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIAxisBreakSymbolDialogObserver2 = (SGIAxisBreakSymbolDialogObserver)arrayList.get(n);
                boolean bl3 = sGIAxisBreakSymbolDialogObserver2.isForHorizontalAxis();
                if (bl == bl3) continue;
                bl2 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIAxisBreakSymbolDialogObserver2 = (SGIAxisBreakSymbolDialogObserver)arrayList.get(n);
                Color color5 = sGIAxisBreakSymbolDialogObserver2.getLineColor();
                if (color.equals(color5)) continue;
                color3 = null;
                break;
            }
            for (n = 1; n < arrayList.size(); ++n) {
                sGIAxisBreakSymbolDialogObserver2 = (SGIAxisBreakSymbolDialogObserver)arrayList.get(n);
                Color color6 = sGIAxisBreakSymbolDialogObserver2.getInnerColor();
                if (color2.equals(color6)) continue;
                color4 = null;
                break;
            }
        }
        this.setXValue(d3);
        this.setYValue(d4);
        if (f6 != null) {
            f6 = new Float(f6.floatValue() * 0.035277776f);
        }
        this.setLength(f6);
        if (f7 != null) {
            f7 = new Float(f7.floatValue() * 0.035277776f);
        }
        this.setInterval(f7);
        this.setDistortion(f8);
        if (f9 != null) {
            f9 = new Float(f9.floatValue() / ((float)Math.PI / 180));
        }
        this.setAngle(f9);
        this.setLineWidth(f10);
        if (bl2 != null) {
            this.setHorizontal(bl2);
        } else {
            this.mAdditionalDirectionRadioButton.setSelected(true);
        }
        this.setLineColor(color3);
        this.setInnerColor(color4);
        this.setColorButtonBorder(true);
        return true;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        SGIAxisBreakSymbolDialogObserver sGIAxisBreakSymbolDialogObserver = (SGIAxisBreakSymbolDialogObserver)sGIPropertyDialogObserver;
        int n = this.mAxisPanel.getXAxisConfiguration();
        int n2 = this.mAxisPanel.getYAxisConfiguration();
        Number number = this.getXValue();
        Number number2 = this.getYValue();
        Number number3 = this.getLength();
        Number number4 = this.getInterval();
        Number number5 = this.getDistortion();
        Number number6 = this.getAngle();
        Number number7 = this.getLineWidth();
        Boolean bl = this.isHorizontal();
        Color color = this.getLineColor();
        Color color2 = this.getInnerColor();
        if (!sGIAxisBreakSymbolDialogObserver.hasValidXValue(n, number)) {
            return false;
        }
        if (!sGIAxisBreakSymbolDialogObserver.hasValidYValue(n2, number2)) {
            return false;
        }
        if (n != -1) {
            sGIAxisBreakSymbolDialogObserver.setXAxisConfiguration(n);
        }
        if (n2 != -1) {
            sGIAxisBreakSymbolDialogObserver.setYAxisConfiguration(n2);
        }
        if (number != null) {
            sGIAxisBreakSymbolDialogObserver.setXValue(number.doubleValue());
        }
        if (number2 != null) {
            sGIAxisBreakSymbolDialogObserver.setYValue(number2.doubleValue());
        }
        if (number3 != null) {
            sGIAxisBreakSymbolDialogObserver.setLength(number3.floatValue() / 0.035277776f);
        }
        if (number4 != null) {
            sGIAxisBreakSymbolDialogObserver.setInterval(number4.floatValue() / 0.035277776f);
        }
        if (number5 != null) {
            sGIAxisBreakSymbolDialogObserver.setDistortion(number5.floatValue());
        }
        if (number6 != null) {
            sGIAxisBreakSymbolDialogObserver.setAngle(number6.floatValue() * ((float)Math.PI / 180));
        }
        if (number7 != null) {
            sGIAxisBreakSymbolDialogObserver.setLineWidth(number7.floatValue());
        }
        if (bl != null) {
            sGIAxisBreakSymbolDialogObserver.setForHorizontalAxisFlag(bl);
        }
        if (color != null) {
            sGIAxisBreakSymbolDialogObserver.setLineColor(color);
        }
        if (color2 != null) {
            sGIAxisBreakSymbolDialogObserver.setInnerColor(color2);
        }
        return true;
    }
}

