/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGIBarConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupRectangle;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIElementGroupConstants;
import org.w3c.dom.Element;

public abstract class SGElementGroupBar
extends SGElementGroupRectangle
implements SGIBarConstants,
SGIElementGroupConstants {
    protected double mBaselineValue;

    public double getBaselineValue() {
        return this.mBaselineValue;
    }

    public boolean setBaselineValue(double d) {
        this.mBaselineValue = d;
        return true;
    }

    public boolean setProperty(SGDrawingElement sGDrawingElement) {
        if (!(sGDrawingElement instanceof SGDrawingElementBar)) {
            return false;
        }
        if (!super.setProperty(sGDrawingElement)) {
            return false;
        }
        SGDrawingElementBar sGDrawingElementBar = (SGDrawingElementBar)sGDrawingElement;
        this.setBaselineValue(sGDrawingElementBar.getBaselineValue());
        return true;
    }

    public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        if (sGDrawingElementArray != null) {
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                sGDrawingElementBar2D.paint(graphics2D, rectangle2D);
            }
        }
        return true;
    }

    public SGDrawingElement getDrawingElement() {
        SGDrawingElementBar2D sGDrawingElementBar2D = new SGDrawingElementBar2D();
        sGDrawingElementBar2D.setVisible(this.mVisibleFlag);
        sGDrawingElementBar2D.setWidth(this.mRectangleWidth);
        sGDrawingElementBar2D.setHeight(this.mRectangleHeight);
        sGDrawingElementBar2D.setEdgeLineWidth(this.mEdgeLineWidth);
        sGDrawingElementBar2D.setEdgeLineColor(this.mEdgeLineColor);
        sGDrawingElementBar2D.setColor(this.mColorList);
        sGDrawingElementBar2D.setBaselineValue(this.mBaselineValue);
        return sGDrawingElementBar2D;
    }

    public String getTagName() {
        return "Bar";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("Visible", Boolean.toString(this.mVisibleFlag));
        element.setAttribute("Width", Float.toString(this.mRectangleWidth * 0.035277776f) + "cm");
        element.setAttribute("EdgeLineWidth", Float.toString(this.mEdgeLineWidth) + "pt");
        element.setAttribute("BaselineValue", Double.toString(this.mBaselineValue));
        element.setAttribute("Color", SGUtilityText.getColorListString(this.mColorList));
        element.setAttribute("EdgeLineColor", SGUtilityText.getColorString(this.mEdgeLineColor));
        return true;
    }

    public SGProperties readProperties(Element element) {
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        ArrayList arrayList = null;
        BarProperties barProperties = new BarProperties();
        string = element.getAttribute("Visible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        barProperties.setVisible(bl);
        string = element.getAttribute("Width");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "cm");
        if (number == null) {
            return null;
        }
        barProperties.setBarWidth(number.floatValue() / 0.035277776f);
        string = element.getAttribute("Color");
        if (string.length() == 0) {
            return null;
        }
        arrayList = SGUtilityText.getColorList(string);
        if (arrayList == null) {
            return null;
        }
        barProperties.setColorList(arrayList);
        string = element.getAttribute("EdgeLineWidth");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getFloat(string, "pt");
        if (number == null) {
            return null;
        }
        barProperties.setEdgeLineWidth(number.floatValue());
        string = element.getAttribute("BaselineValue");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        barProperties.setBaselineValue(number.doubleValue());
        string = element.getAttribute("EdgeLineColor");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        barProperties.setEdgeLineColor(color);
        return barProperties;
    }

    protected boolean initDrawingElement(int n) {
        SGDrawingElementBar2D[] sGDrawingElementBar2DArray = new SGDrawingElementBar2D[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementBar2DArray[i] = new SGDrawingElementBar2D();
        }
        this.mDrawingElementArray = sGDrawingElementBar2DArray;
        return true;
    }

    protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
        int n = sGTuple2fArray.length;
        SGDrawingElementBar2D[] sGDrawingElementBar2DArray = new SGDrawingElementBar2D[n];
        for (int i = 0; i < n; ++i) {
            sGDrawingElementBar2DArray[i] = new SGDrawingElementBar2D();
            sGDrawingElementBar2DArray[i].setLocation(sGTuple2fArray[i].x, sGTuple2fArray[i].y);
        }
        this.mDrawingElementArray = sGDrawingElementBar2DArray;
        return true;
    }

    public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
            throw new IllegalArgumentException();
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
            boolean bl = !(sGTuple2fArray[i].isInfinite() | sGTuple2fArray[i].isNaN());
            sGDrawingElementBar2D.setVisible(bl);
            if (!bl) continue;
            sGDrawingElementBar2D.setLocation(sGTuple2fArray[i]);
        }
        return true;
    }

    public boolean setWidth(float f) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
            sGDrawingElementBar2D.setWidth(f);
        }
        return true;
    }

    public boolean setHeight(float f) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
            sGDrawingElementBar2D.setHeight(f);
        }
        return true;
    }

    public boolean setHorizontal(boolean bl) {
        if (this.mDrawingElementArray == null) {
            return true;
        }
        SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
        for (int i = 0; i < sGDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
            sGDrawingElementBar2D.setHorizontal(bl);
        }
        return true;
    }

    public boolean setPropertiesOfDrawingElements() {
        for (int i = 0; i < this.mDrawingElementArray.length; ++i) {
            SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)this.mDrawingElementArray[i];
            sGDrawingElementBar2D.setMagnification(this.mMagnification);
            sGDrawingElementBar2D.setColor(this.mColorList);
            sGDrawingElementBar2D.setEdgeLineWidth(this.mEdgeLineWidth);
            sGDrawingElementBar2D.setEdgeLineColor(this.mEdgeLineColor);
        }
        return true;
    }

    public SGProperties getProperties() {
        BarProperties barProperties = new BarProperties();
        this.getProperties(barProperties);
        return barProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        BarProperties barProperties = (BarProperties)sGProperties;
        barProperties.setBarWidth(this.getRectangleWidth());
        barProperties.setEdgeLineWidth(this.getEdgeLineWidth());
        barProperties.setEdgeLineColor(this.getEdgeLineColor());
        barProperties.setBaselineValue(this.getBaselineValue());
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof BarProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        BarProperties barProperties = (BarProperties)sGProperties;
        Float f = barProperties.getBarWidth();
        if (f == null) {
            return false;
        }
        this.setRectangleWidth(f.floatValue());
        Float f2 = barProperties.getEdgeLineWidth();
        if (f2 == null) {
            return false;
        }
        this.setEdgeLineWidth(f2.floatValue());
        Color color = barProperties.getEdgeLineColor();
        if (color == null) {
            return false;
        }
        this.setEdgeLineColor(color);
        Double d = barProperties.getBaselineValue();
        if (d == null) {
            return false;
        }
        this.setBaselineValue(d);
        return true;
    }

    public static class BarProperties
    extends SGElementGroup.ElementGroupProperties {
        private SGDrawingElementBar.BarProperties mBarProperties = new SGDrawingElementBar.BarProperties();

        public boolean equals(Object object) {
            if (!(object instanceof BarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            BarProperties barProperties = (BarProperties)object;
            return this.mBarProperties.equals(barProperties.mBarProperties);
        }

        public Float getBarWidth() {
            return this.mBarProperties.getWidth();
        }

        public Float getEdgeLineWidth() {
            return this.mBarProperties.getEdgeLineWidth();
        }

        public Color getEdgeLineColor() {
            return this.mBarProperties.getEdgeLineColor();
        }

        public Double getBaselineValue() {
            return this.mBarProperties.getBaselineValue();
        }

        public void setBarWidth(float f) {
            this.mBarProperties.setWidth(f);
        }

        public void setBaselineValue(double d) {
            this.mBarProperties.setBaselineValue(d);
        }

        public void setEdgeLineWidth(float f) {
            this.mBarProperties.setEdgeLineWidth(f);
        }

        public void setEdgeLineColor(Color color) {
            this.mBarProperties.setEdgeLineColor(color);
        }
    }
}

