/*
 * SGSingleDataFileChooserWizardDialog.java
 *
 * Created on 2004/06/28, 18:39
 */

package jp.riken.brain.ni.samuraigraph.application;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;


/**
 *
 * @author  kuromaru
 */
public class SGSingleDataFileChooserWizardDialog extends SGFileChooserWizardDialog
	implements CaretListener
{

	/**
	 * 
	 */
	public static final String TITLE = "Data File";


	/**
	 * 
	 */
	public SGSingleDataFileChooserWizardDialog()
	{
		super();
		initComponents();
		this.initProperty();
	}


    /**
     * Creates new form SGSingleDataFileChooserWizardDialog
	 */
    public SGSingleDataFileChooserWizardDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mPanel = new javax.swing.JPanel();
        mDataFileNameTextField = new javax.swing.JTextField();
        mShowFileChooserButton = new javax.swing.JButton();
        mButtonPanel = new javax.swing.JPanel();
        mPreviousButton = new javax.swing.JButton();
        mNextButton = new javax.swing.JButton();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.TitledBorder(null, "Select the Data File", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12)));
        mDataFileNameTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mDataFileNameTextField.setPreferredSize(new java.awt.Dimension(250, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 10, 5);
        mPanel.add(mDataFileNameTextField, gridBagConstraints);

        mShowFileChooserButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mShowFileChooserButton.setText("Browse");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 10);
        mPanel.add(mShowFileChooserButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        getContentPane().add(mPanel, gridBagConstraints);

        mPreviousButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviousButton.setText("<Prev");
        mButtonPanel.add(mPreviousButton);

        mNextButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mNextButton.setText("Next>");
        mButtonPanel.add(mNextButton);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JTextField mDataFileNameTextField;
    private javax.swing.JButton mNextButton;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviousButton;
    private javax.swing.JButton mShowFileChooserButton;
    // ϐ錾̏I//GEN-END:variables



   
	/**
	 * 
	 */
	private boolean initProperty()
	{

		//
		this.setTitle( SGSingleDataFileChooserWizardDialog.TITLE );


		//
		this.mNextButton.setEnabled(false);


		//
		this.mShowFileChooserButton.addActionListener(this);

		this.mDataFileNameTextField.addCaretListener(this);


this.getPreviousButton().addActionListener(this);
this.getNextButton().addActionListener(this);
this.getOKButton().addActionListener(this);
this.getCancelButton().addActionListener(this);

		return true;

	}



	/**
	 * 
	 */
	public File setFile( String dir, String name )
	{
		// get a File object from the method of the super class
		File f = super.setFile( dir, name );

		// set to the text field
		if( f.isFile() )
		{
			this.setFileNameToTextField(f);
		}
		return f;
	}


	/**
	 * 
	 */
	private boolean setFileNameToTextField( final File f )
	{
		this.mDataFileNameTextField.setText( f.getPath() );
		return true;
	}


	/**
	 * 
	 */
	public File getSelectedFileFromTextField()
	{
		File file = new File( this.mDataFileNameTextField.getText() );
		return file;
	}


	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();
            
		if( source.equals( this.mShowFileChooserButton ) )
		{
			this.showFileChooser();
		}

	}



	/**
	 * 
	 */
	public void caretUpdate( CaretEvent e )
	{
		Object source = e.getSource();
		if( source instanceof JTextComponent )
		{
			JTextComponent tc = (JTextComponent)source;
			String str = tc.getText();
			if( str.length()==0 )
			{
				this.mNextButton.setEnabled(false);
			}
			else
			{
				this.mNextButton.setEnabled(true);
			}
		}

	}



	/**
	 * 
	 */
	private boolean showFileChooser()
	{
		ArrayList list = this.openFileChooser();
		if( list==null )
		{
			return false;
		}
		if( list.size()!=1 )
		{
			return true;
		}

		File f = (File)list.get(0);
		boolean flag = this.setFileNameToTextField(f);

		this.mNextButton.setEnabled(true);

		return flag;
	}


	protected JButton getPreviousButton()
	{
		return this.mPreviousButton;
	}


	protected JButton getNextButton()
	{
		return this.mNextButton;
	}


	protected JButton getOKButton()
	{
		return this.mOKButton;
	}
	
	
	protected JButton getCancelButton()
	{
		return this.mCancelButton;
	}

}
