
package jp.riken.brain.ni.samuraigraph.data;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

/**
 *
 */
public abstract class SGDateData extends SGData
	implements Cloneable
{

	// array of date
	protected InnerDate[] mDateArray = null;


	/**
	 * The default constructor.
	 *
	 */
	public SGDateData()
	{
		super();
	}


	/**
	 * 
	 */
	public SGDateData( final String[] dateArray ) throws ParseException
	{
		super();

		final DateFormat df = DateFormat.getDateInstance();
		final Calendar cal = Calendar.getInstance();
		final int cYear = Calendar.YEAR;
		final int cMonth = Calendar.MONTH;
		final int cDate = Calendar.DATE;

		final int num = dateArray.length;
		final InnerDate[] array = new InnerDate[num];
		for( int ii=0; ii<num; ii++ )
		{
			final Date d = SGUtilityText.getDate( dateArray[ii] );
			if( d==null )
			{
				throw new ParseException("Parse error",0);
			}
			cal.setTime(d);
			final int year = cal.get( cYear );
			final int month = cal.get( cMonth );
			final int date = cal.get( cDate );
			array[ii] = new InnerDate( year, month, date );
		}

		this.mDateArray = array;		
	}


	/**
	 * 
	 */
	public SGDateData(
		final int[] yearArray, final int[] monthArray, final int[] dateArray )
	{
		super();

		if( yearArray==null | monthArray==null | dateArray==null )
		{
			throw new IllegalArgumentException("yearArray==null | monthArray==null | dateArray==null");
		}

		if( yearArray.length!=monthArray.length | monthArray.length!=dateArray.length )
		{
			throw new IllegalArgumentException("yearArray.length!=monthArray.length | monthArray.length!=dateArray.length");
		}

		final int num = yearArray.length;
		InnerDate[] array = new InnerDate[num];
		for( int ii=0; ii<num; ii++ )
		{
			array[ii] = new InnerDate( yearArray[ii], monthArray[ii], dateArray[ii] );
		}

		this.mDateArray = array;		
	}


	/**
	 * Set data.
	 * @param data - data set to this object
	 */
	public boolean setData( final SGData data )
	{
		if( !(data instanceof SGDateData) )
		{
			throw new IllegalArgumentException("!(data instanceof SGDateData)");
		}

		SGDateData dData = (SGDateData)data;
		this.mDateArray = (InnerDate[])dData.mDateArray.clone();

		return true;
	}


	/**
	 * Clone this data object.
	 * @return copy of this data object
	 */
	public Object clone()
	{
		try
		{
			return super.clone();
		}
		catch( CloneNotSupportedException ex )
		{
			// this shouldn't happen, since we are Cloneable
			throw new InternalError();
		}
	}


	/**
	 * Calling the clone method.
	 * @return copy of this data object
	 */
	public Object copy()
	{
		return this.clone();
	}


	/**
	 * An inner class for date. 
	 *
	 */
	protected static class InnerDate
	{
		protected int year;
		protected int month;
		protected int date;

		protected InnerDate( final int year, final int month, final int date )
		{
			super();
			this.year = year;
			this.month = month;
			this.date = date;
		}
	}
	

}

