
package jp.riken.brain.ni.samuraigraph.data;

import jp.riken.brain.ni.samuraigraph.base.SGData;

/**
 * Data with arrays of y-values and the sampling rate for x-values.
 */
public class SGSXYSamplingData extends SGSXYMultipleData
	implements Cloneable
{

	/**
	 * Sampling rate.
	 */
	private double mSamplingRate;


	/**
	 * 
	 *
	 */
	public SGSXYSamplingData()
	{
		super();
	}


	/**
	 * 
	 * @param sRate
	 * @param yArray
	 */
	public SGSXYSamplingData(
		final double sRate,
		final double[][] yArray )
	{
		super();

		if( sRate<=0.0 )
		{
			throw new IllegalArgumentException("sRate<=0.0");
		}

		if( yArray==null )
		{
			throw new IllegalArgumentException("yArray==null");
		}

		if( yArray.length==0 )
		{
			throw new IllegalArgumentException("yArray.length==0");
		}

		int len = yArray[0].length;
		for( int ii=1; ii<yArray.length; ii++ )
		{
			if( yArray[ii].length!=len )
			{
				throw new IllegalArgumentException("yArray[ii].length!=len");
			}
		}

		this.mSamplingRate = sRate;
		this.mYValueArray = new double[yArray.length][];
		for( int ii=0; ii<this.mYValueArray.length; ii++ )
		{
			this.mYValueArray[ii] = (double[])yArray[ii].clone();
		}

	}


	/**
	 * 
	 * @return
	 */
	public double getSamplingRate()
	{
		return this.mSamplingRate;
	}



	/**
	 * 
	 */
	public Double getXValue( final int n )
	{
		return new Double( this.getPrimitiveXValue(n) );
	}


	private double getPrimitiveXValue( final int n )
	{
		return n/this.mSamplingRate;
	}


	/**
	 * 
	 */
	public double[] getXValueArray()
	{
		final int num = this.getPointsNumber();
		final double[] xArray = new double[num];
		for( int ii=0; ii<num; ii++ )
		{
			xArray[ii] = this.getPrimitiveXValue(ii);
		}
		
		return xArray;
	}



	/**
	 * 
	 */
	public boolean setData( final SGData data )
	{
		if( ( data instanceof SGSXYSamplingData ) == false )
		{
			return false;
		}

		SGSXYSamplingData data_ = (SGSXYSamplingData)data;
		this.mSamplingRate = data_.mSamplingRate;
		this.mYValueArray = data_.mYValueArray;

		return true;
	}


	/**
	 * Returns the name of data type.
	 * @return
	 */
	public String getDataType()
	{
		return SGDataTypeConstants.SXY_SAMPLING_DATA;
	}


	/**
	 * 
	 */
	public double getMinValueX()
	{
		return 0.0;
	}


	/**
	 * 
	 */
	public double getMaxValueX()
	{
		return ( this.getPointsNumber() - 1 )/this.mSamplingRate;
	}


	/**
	 * 
	 */
	public int getPointsNumber()
	{
		return this.mYValueArray[0].length;
	}



	/**
	 * 
	 */
	public String toString()
	{
		String str = "[";
		str += "SamplingRate=" + Double.toString( this.mSamplingRate ) + ", ";
			
		str += "Y={";
		final int num = this.getDataNumber();
		for( int ii=0; ii<num; ii++ )
		{
			double[] array = this.mYValueArray[ii];
			str += this.toDoubleArrayString( array );
			if( ii==array.length-1 )
			{
				break;
			}
			str += ",";
		}
		str += "}";

		str += "]";
	
		return str;
	}

}

