
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;

/**
 * Default values for SGISignificantDifferenceElement.
 */
public interface SGIDefaultValuesSignificantDifferenceSymbol extends SGIConstants
{

	// Width
	public static final float SIGDIFF_SYMBOL_WIDTH = 1.0f/SGIConstants.CM_POINT_RATIO;

	// Left Height
	public static final float SIGDIFF_SYMBOL_LEFT_HEIGHT = 1.0f/SGIConstants.CM_POINT_RATIO;

	// Right Height
	public static final float SIGDIFF_SYMBOL_RIGHT_HEIGHT = 1.0f/SGIConstants.CM_POINT_RATIO;

	// Line Width
	public static final float SIGDIFF_SYMBOL_LINE_WIDTH = 1.0f;

	// Space
	public static final float SIGDIFF_SYMBOL_SPACE = 0.0f/SGIConstants.CM_POINT_RATIO;

	// Horizontal Axis
	public static final String SIGDIFF_HORIZONTAL_AXIS = SGIAxisElement.AXIS_BOTTOM;
	
	// Perpendicular Axis
	public static final String SIGDIFF_PERPENDICULAR_AXIS = SGIAxisElement.AXIS_LEFT;


	// Font
	public static final String SIGDIFF_SYMBOL_FONT_NAME = "Serif";
	public static final String SIGDIFF_SYMBOL_FONT_STYLE = "Plain";

	// Size
	public static final float SIGDIFF_SYMBOL_FONT_SIZE = 24.0f;

	// Color
	public static final Color SIGDIFF_SYMBOL_COLOR = new Color( 0, 0, 0 );


}

