
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureElementConstants;

/**
 * This class has utility methods for the subclasses of SGFigureElement 
 * in this package.
 * 
 */
public class SGUtilityForFigureElement implements SGIFigureElementConstants
{

	/**
	 * Draw an anchor around a focused object.
	 * @param pos location of an anchor
	 * @param g2d graphic context
	 */
	public static void drawAnchorAsFocusedObject(
		final Point2D pos, final Graphics2D g2d )
	{
		SGUtilityJava2D.drawCircle(
			pos,
			ANCHOR_SIZE_FOR_FOCUSED_OBJECTS,
			ANCHOR_EDGE_LINE_WIDTH,
			ANCHOR_EDGE_LINE_COLOR,
			ANCHOR_INNER_COLOR,
			g2d );
	}


	/**
	 * Draw anchors around focused objects.
	 * @param pointList list of the location of anchors
	 * @param g2d graphic context
	 */
	public static void drawAnchorAsFocusedObject(
		final ArrayList pointList, final Graphics2D g2d )
	{
		for( int ii=0; ii<pointList.size(); ii++ )
		{
			Point2D pos = (Point2D)pointList.get(ii);
			drawAnchorAsFocusedObject( pos, g2d );
		}
	}


	/**
	 * Draw an anchor around child objects.
	 * @param pos location of an anchor
	 * @param g2d graphic context
	 */
	public static void drawAnchorAsChildObject(
	final Point2D pos, final Graphics2D g2d )
	{
		SGUtilityJava2D.drawSquare(
			pos,
			ANCHOR_SIZE_FOR_CHILD_OBJECTS,
			ANCHOR_EDGE_LINE_WIDTH,
			ANCHOR_EDGE_LINE_COLOR,
			ANCHOR_INNER_COLOR_FOR_CHILD_OBJECTS,
			g2d );
	}


	/**
	 * Draw anchors around child objects.
	 * @param pointList list of the location of anchors
	 * @param g2d graphic context
	 */
	public static void drawAnchorAsChildObject(
		final ArrayList pointList, final Graphics2D g2d )
	{
		for( int ii=0; ii<pointList.size(); ii++ )
		{
			Point2D pos = (Point2D)pointList.get(ii);
			drawAnchorAsChildObject( pos, g2d );
		}
	}


	/**
	 * Clip the graph rectangle of figure element.
	 * @param el - figure element
	 * @param g2d - graphic context to be clipped
	 * @return
	 */
	public static boolean clipGraphRect(
		final SGFigureElement el, final Graphics2D g2d )
	{
		Rectangle2D vBounds = el.getViewBounds();
		if( vBounds==null )
		{
			return false;
		}
		final Rectangle2D rectGraph = el.getGraphRect();
		final Rectangle2D rectCommon = new Rectangle2D.Float();
		Rectangle2D.intersect( rectGraph, vBounds, rectCommon );
		g2d.setClip( rectCommon );
		return true;
	}

}

