/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGIPropertyFileConstants;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;

public class SGPropertyFileCreator
implements SGIConstants,
SGIPropertyFileConstants {
    private JFileChooser mFileChooser;

    public SGPropertyFileCreator() {
        this.init();
    }

    private void init() {
        SGFileChooser sGFileChooser = new SGFileChooser();
        this.mFileChooser = sGFileChooser;
        SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
        sGExtensionFileFilter.setDescription("Samurai Graph Property File");
        sGExtensionFileFilter.addExtension("sgp");
        sGFileChooser.setFileFilter(sGExtensionFileFilter);
        String string = SGIConstants.USER_HOME;
        String string2 = "My Documents";
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new Error();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(string2)) continue;
            string = string + SGIConstants.FILE_SEPARATOR + string2;
            break;
        }
        String string3 = string + SGIConstants.FILE_SEPARATOR + "property" + "." + "sgp";
        ((JFileChooser)sGFileChooser).setSelectedFile(new File(string3));
    }

    public int create(SGDrawingWindow sGDrawingWindow) {
        DOMImplementation dOMImplementation = SGApplicationUtility.getDOMImplementation();
        if (dOMImplementation == null) {
            return -1;
        }
        DocumentType documentType = dOMImplementation.createDocumentType("Property", "-//NILAB//DTD Samurai-Graph Property XML 1.0//EN", "http://samurai-graph.sourceforge.jp/property.dtd");
        Document document = dOMImplementation.createDocument("", "Property", documentType);
        if (!sGDrawingWindow.createDOMTree(document)) {
            return -1;
        }
        int n = this.exportToFile(document, sGDrawingWindow);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int exportToFile(Document document, SGDrawingWindow sGDrawingWindow) {
        File file = this.getPropertyFileFromFileChooser(sGDrawingWindow);
        if (file == null) {
            return 1;
        }
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(file);
        StreamResult streamResult = new StreamResult(fileOutputStream);
        DOMSource dOMSource = new DOMSource(document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("doctype-system", "http://samurai-graph.sourceforge.jp/property.dtd");
        transformer.setOutputProperty("doctype-public", "-//NILAB//DTD Samurai-Graph Property XML 1.0//EN");
        transformer.transform(dOMSource, streamResult);
        Object var10_11 = null;
        if (fileOutputStream == null) return 0;
        try {
            fileOutputStream.close();
            return 0;
        }
        catch (IOException iOException) {}
        return 0;
        {
            catch (Exception exception) {
                int n = -1;
                Object var10_12 = null;
                if (fileOutputStream == null) return n;
                try {
                    fileOutputStream.close();
                    return n;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (fileOutputStream == null) throw throwable;
            try {
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private File getPropertyFileFromFileChooser(SGDrawingWindow sGDrawingWindow) {
        JFileChooser jFileChooser = this.mFileChooser;
        int n = jFileChooser.showSaveDialog(sGDrawingWindow);
        File file = null;
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        return file;
    }

    public File getSelectedFile() {
        if (this.mFileChooser == null) {
            return null;
        }
        return this.mFileChooser.getSelectedFile();
    }

    public File setFile(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.mFileChooser.setCurrentDirectory(new File(string));
        String string3 = string + SGIConstants.FILE_SEPARATOR + string2;
        File file = new File(string3);
        this.mFileChooser.setSelectedFile(file);
        return file;
    }
}

