/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureElementConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SGFigureElement
implements SGIFigureElement,
SGIFigureElementConstants {
    protected ArrayList mChildList = new ArrayList();
    private JComponent mComponent = null;
    protected float mGraphRectX;
    protected float mGraphRectY;
    protected float mGraphRectWidth;
    protected float mGraphRectHeight;
    protected float mMagnification = 1.0f;
    protected Rectangle2D mViewBounds = null;
    protected ArrayList mDataList = new ArrayList();
    protected ArrayList mActionListenerList = new ArrayList();
    private Cursor mCursor = null;
    protected Frame mDialogOwner = null;
    protected Point mPressedPoint = null;
    protected boolean mDraggableFlag = false;
    protected SGUndoManager mUndoManager = new SGUndoManager(this);
    protected boolean mChangedFlag = false;
    protected boolean mSymbolsVisibleFlagAroundFocusedObjects = true;
    protected boolean mSymbolsVisibleFlagAroundAllObjects = false;
    public static final int OFFSET_DUPLICATED_OBJECT_X = 10;
    public static final int OFFSET_DUPLICATED_OBJECT_Y = 10;

    public JComponent getComponent() {
        return this.mComponent;
    }

    public void setComponent(JComponent jComponent) {
        this.mComponent = jComponent;
    }

    public void repaint() {
        this.mComponent.repaint();
    }

    public void finalize() {
    }

    public void dispose() {
        this.mComponent = null;
        this.mActionListenerList.clear();
        this.mActionListenerList = null;
        this.mDataList.clear();
        this.mDataList = null;
        ArrayList arrayList = this.mChildList;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof SGIDisposable)) continue;
            SGIDisposable sGIDisposable = (SGIDisposable)e;
            sGIDisposable.dispose();
        }
        this.mChildList.clear();
        this.mChildList = null;
        this.mUndoManager.dispose();
        this.mUndoManager = null;
        this.mDialogOwner = null;
        this.mViewBounds = null;
        this.mPressedPoint = null;
        this.mCursor = null;
    }

    public boolean addData(SGData sGData, String string) {
        this.addDataToList(sGData);
        return true;
    }

    private void addDataToList(SGData sGData) {
        this.mDataList.add(sGData);
    }

    protected boolean removeChild(Object object) {
        if (object instanceof SGIDisposable) {
            SGIDisposable sGIDisposable = (SGIDisposable)object;
            sGIDisposable.dispose();
        }
        return this.mChildList.remove(object);
    }

    public boolean removeData(SGData sGData) {
        ArrayList arrayList = this.mDataList;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SGData sGData2 = (SGData)arrayList.get(i);
            if (!sGData2.equals(sGData)) continue;
            arrayList.remove(i);
        }
        return true;
    }

    public ArrayList getDataList() {
        return this.mDataList;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (sGTuple2f == null || sGTuple2f2 == null) {
            return false;
        }
        sGTuple2f.clear();
        sGTuple2f2.clear();
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        this.setGraphRectLocation(f, f2);
        this.setGraphRectSize(f3, f4);
        return true;
    }

    public boolean setGraphRect(Rectangle2D rectangle2D) {
        return this.setGraphRect((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
    }

    public boolean setGraphRectLocation(float f, float f2) {
        this.mGraphRectX = f;
        this.mGraphRectY = f2;
        return true;
    }

    public boolean setGraphRectSize(float f, float f2) {
        if ((double)f < 0.0 || (double)f2 < 0.0) {
            throw new IllegalArgumentException("width<0.0 || height<0.0");
        }
        this.mGraphRectWidth = f;
        this.mGraphRectHeight = f2;
        return true;
    }

    public Rectangle2D getGraphRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.mGraphRectX, this.mGraphRectY, this.mGraphRectWidth, this.mGraphRectHeight);
        return float_;
    }

    public boolean isInsideGraphArea(SGTuple2f sGTuple2f) {
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        float f3 = this.mGraphRectX;
        float f4 = this.mGraphRectY;
        float f5 = this.mGraphRectWidth;
        float f6 = this.mGraphRectHeight;
        if (f < f3 || f > f3 + f5) {
            return false;
        }
        return !(f2 < f4) && !(f2 > f4 + f6);
    }

    public boolean isInsideGraphArea(Point2D point2D) {
        return this.isInsideGraphArea((int)point2D.getX(), (int)point2D.getY());
    }

    public boolean isInsideGraphArea(int n, int n2) {
        SGTuple2f sGTuple2f = new SGTuple2f(n, n2);
        return this.isInsideGraphArea(sGTuple2f);
    }

    public boolean setDialogOwner(Frame frame) {
        this.mDialogOwner = frame;
        return true;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setMagnification(float f) {
        this.mMagnification = f;
        return true;
    }

    public Cursor getFigureElementCursor() {
        return this.mCursor;
    }

    protected void setMouseCursor(int n) {
        this.mCursor = Cursor.getPredefinedCursor(n);
        this.notifyChangeCursor();
    }

    protected void setMouseCursor(Cursor cursor) {
        this.mCursor = cursor;
        this.notifyChangeCursor();
    }

    public void notifyChangeCursor() {
        this.notifyToListener("Notify the change of cursor");
    }

    public boolean zoom(float f) {
        this.setMagnification(f);
        return true;
    }

    public abstract boolean synchronize(SGIFigureElement var1);

    public abstract boolean synchronizeArgument(SGIFigureElement var1);

    public boolean setViewBounds(Rectangle2D rectangle2D) {
        this.mViewBounds = rectangle2D;
        return true;
    }

    public Rectangle2D getViewBounds() {
        return this.mViewBounds;
    }

    public boolean createDataObject(Element element, SGData sGData) {
        if (element == null || sGData == null) {
            throw new IllegalArgumentException();
        }
        this.mDataList.add(sGData);
        return true;
    }

    protected boolean updateFocusedObjectsList(SGISelectable sGISelectable, int n) {
        ArrayList arrayList = this.getFocusedObjectsList();
        if ((n & 2) == 0 & (n & 1) == 0) {
            if (!arrayList.contains(sGISelectable)) {
                this.notifyToListener("Clear focused objects");
                sGISelectable.setSelected(true);
            }
        } else {
            sGISelectable.setSelected(!sGISelectable.isSelected());
        }
        return true;
    }

    protected boolean updateFocusedObjectsList(SGISelectable sGISelectable, MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        return this.updateFocusedObjectsList(sGISelectable, n);
    }

    public void translateFocusedObjects(int n, int n2) {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof SGIMovable)) continue;
            SGIMovable sGIMovable = (SGIMovable)e;
            sGIMovable.translate(n, n2);
        }
    }

    public boolean clearFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
            sGISelectable.setSelected(false);
        }
        return true;
    }

    public void addActionListener(ActionListener actionListener) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        this.mActionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        for (int i = this.mActionListenerList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)this.mActionListenerList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            this.mActionListenerList.remove(actionListener);
        }
    }

    public void notifyChange() {
        this.notifyToListener("Notify the change");
    }

    public boolean setPropertiesOfSelectedObjects() {
        this.notifyToListener("Set properties of selected objects");
        return true;
    }

    public void notifyToListener(String string) {
        for (int i = 0; i < this.mActionListenerList.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.mActionListenerList.get(i);
            actionListener.actionPerformed(this.getActionEvent(string));
        }
    }

    private ActionEvent getActionEvent(String string) {
        return new ActionEvent(this, 0, string);
    }

    public float getGraphRectX() {
        return this.mGraphRectX;
    }

    public float getGraphRectY() {
        return this.mGraphRectY;
    }

    public float getGraphRectWidth() {
        return this.mGraphRectWidth;
    }

    public float getGraphRectHeight() {
        return this.mGraphRectHeight;
    }

    protected float calcLocation(double d, SGAxis sGAxis, boolean bl) {
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d2 = sGTuple2d.x;
        double d3 = sGTuple2d.y;
        int n = sGAxis.getScaleType();
        float f = 0.0f;
        if (n == 0) {
            f = (float)((d - d2) / (d3 - d2));
        } else if (n == 1) {
            if (d <= 0.0) {
                return Float.NaN;
            }
            double d4 = Math.log(d2);
            double d5 = Math.log(d3);
            double d6 = Math.log(d);
            f = (float)((d6 - d4) / (d5 - d4));
        }
        float f2 = 0.0f;
        f2 = bl ? this.mGraphRectX + f * this.mGraphRectWidth : this.mGraphRectY + (1.0f - f) * this.mGraphRectHeight;
        return f2;
    }

    protected double calcValue(float f, SGAxis sGAxis, boolean bl) {
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        if (d >= d2) {
            throw new IllegalArgumentException("min>=max");
        }
        int n = sGAxis.getScaleType();
        float f2 = bl ? (f - this.mGraphRectX) / this.mGraphRectWidth : 1.0f - (f - this.mGraphRectY) / this.mGraphRectHeight;
        double d3 = 0.0;
        if (n == 0) {
            d3 = d + (double)f2 * (d2 - d);
        } else if (n == 1) {
            if (d >= 0.0 & d2 >= 0.0) {
                double d4 = Math.log(d);
                double d5 = Math.log(d2);
                d3 = Math.exp(d4 + (double)f2 * (d5 - d4));
            } else {
                d3 = Double.NaN;
            }
        }
        return d3;
    }

    protected boolean showPopupMenu(JPopupMenu jPopupMenu, int n, int n2) {
        jPopupMenu.show(this.getComponent(), n, n2);
        return true;
    }

    public abstract SGProperties getProperties();

    public abstract boolean setProperties(SGProperties var1);

    public SGProperties getMemento() {
        return this.getProperties();
    }

    public boolean setMemento(SGProperties sGProperties) {
        return this.setProperties(sGProperties);
    }

    public boolean isUndoable() {
        return this.mUndoManager.isUndoable();
    }

    public boolean isRedoable() {
        return this.mUndoManager.isRedoable();
    }

    public boolean initPropertiesHistory() {
        return this.mUndoManager.initPropertiesHistory();
    }

    protected boolean updateHistory(ArrayList arrayList) {
        return this.mUndoManager.updateHistory(arrayList);
    }

    public boolean undo() {
        return this.mUndoManager.undo();
    }

    public boolean redo() {
        return this.mUndoManager.redo();
    }

    public boolean setMementoBackward() {
        return this.mUndoManager.setMementoBackward();
    }

    public boolean setMementoForward() {
        return this.mUndoManager.setMementoForward();
    }

    public void notifyToRoot() {
        this.notifyToListener("Notify the change to root");
    }

    public void setChanged(boolean bl) {
        this.mChangedFlag = bl;
    }

    protected boolean setVisibleList(ArrayList arrayList, ArrayList arrayList2) {
        return SGUtility.setVisibleList(arrayList, arrayList2);
    }

    protected boolean hideObject(SGDrawingElement sGDrawingElement) {
        sGDrawingElement.setVisible(false);
        this.notifyChange();
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    public boolean hideSelectedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
            if (this.hideSelectedObject(sGISelectable)) continue;
            return false;
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
            this.notifyChange();
        }
        return true;
    }

    public abstract String getTagName();

    public abstract boolean writeProperty(Element var1);

    protected Element createThisElement(Document document) {
        Element element = document.createElement(this.getTagName());
        if (!this.writeProperty(element)) {
            return null;
        }
        return element;
    }

    public void setSymbolsVisibleAroundFocusedObjects(boolean bl) {
        this.mSymbolsVisibleFlagAroundFocusedObjects = bl;
    }

    public void setSymbolsVisibleAroundAllObjects(boolean bl) {
        this.mSymbolsVisibleFlagAroundAllObjects = bl;
    }

    protected double getNumberInRangeOrder(double d, SGAxis sGAxis) {
        int n = sGAxis.getScaleType();
        if (n == 0) {
            return SGUtilityNumber.getNumberInRangeOrder(d, sGAxis.getMinValue(), sGAxis.getMaxValue(), 4);
        }
        if (n == 1) {
            int n2 = SGUtilityNumber.getOrder(d);
            double d2 = SGUtilityNumber.getPowersOfTen(n2);
            double d3 = d2 * 10.0;
            return SGUtilityNumber.getNumberInRangeOrder(d, d2, d3, 4);
        }
        throw new IllegalArgumentException("scale type is invalid");
    }

    protected ArrayList getCopyList(ArrayList arrayList) {
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGICopiable sGICopiable = (SGICopiable)arrayList.get(i);
            arrayList2.add(sGICopiable.copy());
        }
        return arrayList2;
    }

    public ArrayList getFocusedObjectsList() {
        ArrayList arrayList = new ArrayList();
        this.getFocusedObjectsList(arrayList);
        return arrayList;
    }

    protected ArrayList getCopiableFocusedObjectsList() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Object e = arrayList.get(i);
            if (e instanceof SGICopiable) continue;
            arrayList.remove(i);
        }
        return arrayList;
    }

    public boolean duplicateFocusedObjects() {
        return true;
    }

    protected ArrayList duplicateObjects() {
        ArrayList arrayList = this.getCopiableFocusedObjectsList();
        ArrayList arrayList2 = this.getCopyList(arrayList);
        this.clearFocusedObjects();
        return arrayList2;
    }

    public ArrayList getCopiedObjectsList() {
        ArrayList arrayList = this.getCopiableFocusedObjectsList();
        return this.getCopyList(arrayList);
    }

    public boolean paste(ArrayList arrayList) {
        return true;
    }

    public ArrayList cutFocusedObjects() {
        ArrayList arrayList = this.getCopiedObjectsList();
        this.hideSelectedObjects();
        return arrayList;
    }

    public SGProperties getDataProperties(SGData sGData) {
        return null;
    }

    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        this.addDataToList(sGData);
        return true;
    }

    protected double calcStepValue(SGAxis sGAxis) {
        SGTuple2d sGTuple2d = sGAxis.getRange();
        double d = sGTuple2d.x;
        double d2 = sGTuple2d.y;
        double d3 = d2 - d;
        int n = SGUtilityNumber.getOrder(d3);
        double d4 = SGUtilityNumber.getPowersOfTen(n);
        double d5 = d3 - 0.1 * d4;
        int n2 = SGUtilityNumber.getOrder(d5);
        double d6 = SGUtilityNumber.getPowersOfTen(n2);
        double d7 = d5 / d6;
        double d8 = 0.0;
        if (d7 <= 1.1) {
            d8 = 0.2 * d6;
        } else if (1.1 < d7 & d7 <= 2.0) {
            d8 = 0.5 * d6;
        } else if (2.0 < d7 & d7 <= 6.0) {
            d8 = 1.0 * d6;
        } else if (6.0 < d7) {
            d8 = 2.0 * d6;
        }
        d8 = this.getNumberInRangeOrder(d8, sGAxis);
        return d8;
    }

    public ArrayList getPropertyDialogObserverList() {
        return new ArrayList();
    }

    public String getInstanceDescription() {
        return this.getClassDescription();
    }

    protected float getXFromGraphRectValue(float f) {
        float f2 = this.getMagnification() * f + this.mGraphRectX;
        return f2;
    }

    protected float getYFromGraphRectValue(float f) {
        float f2 = this.getMagnification() * f + this.mGraphRectY;
        return f2;
    }

    protected float getGraphRectValueX(float f) {
        float f2 = (f - this.mGraphRectX) / this.getMagnification();
        return f2;
    }

    protected float getGraphRectValueY(float f) {
        float f2 = (f - this.mGraphRectY) / this.getMagnification();
        return f2;
    }

    protected abstract void paintGraphics(Graphics var1, boolean var2);

    protected void updateImage() {
    }

    public void paint(Graphics graphics, boolean bl) {
        this.paintGraphics(graphics, bl);
    }

    public ArrayList getVisibleChildList() {
        ArrayList<SGIVisible> arrayList = new ArrayList<SGIVisible>();
        ArrayList arrayList2 = new ArrayList(this.mChildList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGIVisible sGIVisible = (SGIVisible)arrayList2.get(i);
            if (!sGIVisible.isVisible()) continue;
            arrayList.add(sGIVisible);
        }
        return arrayList;
    }

    protected boolean setVisibleChildList(ArrayList arrayList) {
        return this.setVisibleList(this.mChildList, arrayList);
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleChildList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList2.get(i);
            if (!sGISelectable.isSelected()) continue;
            arrayList.add(sGISelectable);
        }
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        SGIVisible sGIVisible = (SGIVisible)((Object)sGISelectable);
        sGIVisible.setVisible(false);
        return true;
    }

    public boolean moveFocusedObjects(boolean bl) {
        return this.moveFocusedObjects(bl, this.mChildList);
    }

    private boolean moveFocusedObjects(boolean bl, List list) {
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 0) {
            return true;
        }
        ArrayList arrayList2 = new ArrayList(list);
        if (bl) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                this.moveObjectToHead(e, list);
            }
        } else {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Object e = arrayList.get(i);
                this.moveObjectToTail(e, list);
            }
        }
        if (!((Object)list).equals(arrayList2)) {
            this.notifyChange();
            this.setChanged(true);
        }
        return true;
    }

    protected boolean moveObjectToHead(Object object, List list) {
        return SGUtility.moveObject(object, list, list.size() - 1);
    }

    protected boolean moveObjectToTail(Object object, List list) {
        return SGUtility.moveObject(object, list, 0);
    }

    public ArrayList getChildNodes() {
        return this.getVisibleChildList();
    }

    public boolean isChanged() {
        if (this.mChangedFlag) {
            return true;
        }
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable;
            Object e = arrayList.get(i);
            if (!(e instanceof SGIUndoable) || !(sGIUndoable = (SGIUndoable)e).isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean updateHistory() {
        boolean bl = this.isChanged();
        if (!this.updateHistory(this.getVisibleChildList())) {
            return false;
        }
        if (bl) {
            this.removeUselessChild();
        }
        return true;
    }

    protected boolean removeUselessChild() {
        Set set = this.getAvailableChildSet();
        if (set.size() != 0) {
            boolean bl = false;
            ArrayList arrayList = new ArrayList(this.mChildList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Object e = arrayList.get(i);
                if (!set.contains(e)) {
                    this.removeChild(e);
                    bl = true;
                }
                e = null;
            }
            if (bl) {
                arrayList.clear();
                set.clear();
            }
        }
        return true;
    }

    protected Set getAvailableChildSet() {
        return new HashSet();
    }

    public void initUndoBuffer() {
        this.mUndoManager.initUndoBuffer();
        ArrayList arrayList = this.mChildList;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof SGIUndoable)) continue;
            SGIUndoable sGIUndoable = (SGIUndoable)e;
            sGIUndoable.initUndoBuffer();
        }
    }
}

