/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIShapeElement;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGAxisBreakSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisBreakSymbolConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisBreakSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGAxisBreakSymbolDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIAxisBreakSymbolDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SGAxisBreakElement
extends SGFigureElement
implements SGIAxisBreakElement,
SGIAxisBreakSymbolConstants {
    private SGIAxisElement mAxisElement = null;
    private SGAxisBreakSymbolDialog mDialog = null;
    private int mIDCounter = 0;

    public void dispose() {
        super.dispose();
        this.mDialog.dispose();
        this.mDialog = null;
        this.mAxisElement = null;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDialog();
        return true;
    }

    private boolean createDialog() {
        SGAxisBreakSymbolDialog sGAxisBreakSymbolDialog;
        this.mDialog = sGAxisBreakSymbolDialog = new SGAxisBreakSymbolDialog(this.mDialogOwner, true);
        return true;
    }

    public String toString() {
        return "SGAxisBreakElement";
    }

    public String getClassDescription() {
        return "Axis Break Symbols";
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIGraphElement || sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGILegendElement)) {
            if (sGIFigureElement instanceof SGIAxisElement) {
                bl = this.synchronizeToAxisElement((SGIAxisElement)sGIFigureElement);
            } else if (!(sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement || sGIFigureElement instanceof SGIGridElement || sGIFigureElement instanceof SGIShapeElement)) {
                bl = sGIFigureElement.synchronizeArgument(this);
            }
        }
        return bl;
    }

    private boolean synchronizeToAxisElement(SGIAxisElement sGIAxisElement) {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.setDrawingElementsLocation();
        }
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    public void setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
    }

    public String getTagName() {
        return "AxisBreakSymbols";
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean readProperty(Element element) {
        NodeList nodeList = element.getElementsByTagName("AxisBreakSymbol");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol();
            Element element2 = (Element)node;
            if (!axisBreakSymbol.readProperty(element2)) {
                return false;
            }
            axisBreakSymbol.initPropertiesHistory();
            this.addToList(axisBreakSymbol);
        }
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        this.setLocationOfAllDrawingElements();
        return true;
    }

    private boolean setLocationOfAllDrawingElements() {
        ArrayList arrayList = this.mChildList;
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.setDrawingElementsLocation();
        }
        return true;
    }

    public boolean zoom(float f) {
        super.zoom(f);
        ArrayList arrayList = this.mChildList;
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.zoom(f);
        }
        return true;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Object object;
        AxisBreakSymbol axisBreakSymbol;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.getVisibleChildList();
        for (n = 0; n < arrayList.size(); ++n) {
            axisBreakSymbol = (AxisBreakSymbol)arrayList.get(n);
            if (!axisBreakSymbol.isValid()) continue;
            axisBreakSymbol.paintElement(graphics2D);
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < arrayList.size(); ++n) {
                axisBreakSymbol = (AxisBreakSymbol)arrayList.get(n);
                if (!axisBreakSymbol.isValid()) continue;
                object = axisBreakSymbol.getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsChildObject((ArrayList)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList arrayList2 = new ArrayList();
            this.getFocusedObjectsList(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (AxisBreakSymbol)arrayList2.get(i);
                if (!((AxisBreakSymbol)object).isValid()) continue;
                ArrayList arrayList3 = ((AxisBreakSymbol)object).getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsFocusedObject(arrayList3, graphics2D);
            }
        }
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid()) continue;
            Element element2 = axisBreakSymbol.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return element;
    }

    public boolean addAxisBreakSymbol(int n, int n2) {
        if (!this.getGraphRect().contains(n, n2)) {
            return false;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        return this.addAxisBreakSymbol(sGAxis, sGAxis2, n, n2);
    }

    public boolean addAxisBreakSymbol(SGAxis sGAxis, SGAxis sGAxis2, int n, int n2) {
        AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol(28.346458f, 14.173229f, 0.5f, 0.0f, true);
        axisBreakSymbol.addColor(SGDefaultValues.AXIS_BREAK_INNER_COLOR);
        axisBreakSymbol.setLineColor(SGDefaultValues.AXIS_BREAK_LINE_COLOR);
        axisBreakSymbol.setLineWidth(1.5f);
        axisBreakSymbol.setMagnification(this.mMagnification);
        axisBreakSymbol.mXAxis = sGAxis;
        axisBreakSymbol.mYAxis = sGAxis2;
        axisBreakSymbol.setLocation(n, n2);
        axisBreakSymbol.setAxisValue();
        this.addToList(axisBreakSymbol);
        this.setChanged(true);
        axisBreakSymbol.initPropertiesHistory();
        this.notifyToRoot();
        return true;
    }

    private void addToList(AxisBreakSymbol axisBreakSymbol) {
        this.mChildList.add(axisBreakSymbol);
        axisBreakSymbol.mID = this.mIDCounter;
        ++this.mIDCounter;
    }

    protected boolean setAllDrawingElementsLocation() {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (axisBreakSymbol.setDrawingElementsLocation()) continue;
            return false;
        }
        return true;
    }

    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChange();
        return true;
    }

    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChange();
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid() || !this.clickDrawingElements(axisBreakSymbol, mouseEvent)) continue;
            return true;
        }
        return false;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.mTemporaryProperties = axisBreakSymbol.getProperties();
        }
        return true;
    }

    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    private boolean clickDrawingElements(AxisBreakSymbol axisBreakSymbol, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (axisBreakSymbol.contains(n, n2)) {
            this.updateFocusedObjectsList((SGISelectable)axisBreakSymbol, mouseEvent);
            if (!(SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 1)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 2) {
                    this.setPropertiesOfSelectedObjects();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) & n3 == 1) {
                    axisBreakSymbol.getPopupMenu().show(this.getComponent(), n, n2);
                }
            }
            return true;
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid() || !axisBreakSymbol.contains(n, n2)) continue;
            this.mPressedPoint = mouseEvent.getPoint();
            this.setMouseCursor(13);
            if (axisBreakSymbol.isSelected()) {
                this.mDraggableFlag = true;
            }
            return true;
        }
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (!this.mDraggableFlag) {
            return false;
        }
        int n = mouseEvent.getX() - this.mPressedPoint.x;
        int n2 = mouseEvent.getY() - this.mPressedPoint.y;
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid()) continue;
            axisBreakSymbol.translate(n, n2);
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGProperties sGProperties;
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            SGProperties sGProperties2 = axisBreakSymbol.mTemporaryProperties;
            if (sGProperties2 == null || (sGProperties = axisBreakSymbol.getProperties()).equals(sGProperties2)) continue;
            axisBreakSymbol.setChanged(true);
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid()) continue;
            Rectangle2D rectangle2D = axisBreakSymbol.getElementBounds();
            if (rectangle2D.contains(mouseEvent.getPoint())) {
                this.setMouseCursor(12);
                continue;
            }
            this.setMouseCursor(0);
        }
        this.mDraggableFlag = false;
        this.notifyToRoot();
        return true;
    }

    public boolean onDrawingElement(int n, int n2) {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            boolean bl;
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            if (!axisBreakSymbol.isValid() || !(bl = axisBreakSymbol.contains(n, n2))) continue;
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        Cloneable cloneable;
        Object object;
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ArrayList arrayList = this.getVisibleChildList();
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (AxisBreakSymbol)arrayList.get(i);
            cloneable = ((SGAxisBreakSymbol2D)object).getElementBounds();
            arrayList2.add((Rectangle2D)cloneable);
        }
        Rectangle2D rectangle2D = null;
        if (arrayList2.size() != 0) {
            rectangle2D = SGUtility.createUnion(arrayList2);
        }
        object = this.getGraphRect();
        cloneable = new ArrayList();
        ((ArrayList)cloneable).add(object);
        if (rectangle2D != null) {
            ((ArrayList)cloneable).add(rectangle2D);
        }
        Rectangle2D rectangle2D2 = SGUtility.createUnion((ArrayList)cloneable);
        float f = (float)(((RectangularShape)object).getY() - rectangle2D2.getY());
        float f2 = (float)(rectangle2D2.getY() + rectangle2D2.getHeight() - (((RectangularShape)object).getY() + ((RectangularShape)object).getHeight()));
        float f3 = (float)(((RectangularShape)object).getX() - rectangle2D2.getX());
        float f4 = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() - (((RectangularShape)object).getX() + ((RectangularShape)object).getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.mUndoManager.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            AxisProperties axisProperties = (AxisProperties)list.get(i);
            hashSet.addAll(axisProperties.visibleAxisBreakSymbolList);
        }
        return hashSet;
    }

    public SGProperties getProperties() {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.visibleAxisBreakSymbolList = this.getVisibleChildList();
        return axisProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof AxisProperties)) {
            return false;
        }
        AxisProperties axisProperties = (AxisProperties)sGProperties;
        boolean bl = this.setVisibleChildList(axisProperties.visibleAxisBreakSymbolList);
        return bl;
    }

    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        ArrayList arrayList = this.duplicateObjects();
        for (int i = 0; i < arrayList.size(); ++i) {
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)arrayList.get(i);
            axisBreakSymbol.translate(n, n2);
            axisBreakSymbol.setSelected(true);
            this.addToList(axisBreakSymbol);
            axisBreakSymbol.initPropertiesHistory();
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    public boolean paste(ArrayList arrayList) {
        float f = this.getMagnification();
        int n = (int)(f * 10.0f);
        int n2 = (int)(f * 10.0f);
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof AxisBreakSymbol)) continue;
            AxisBreakSymbol axisBreakSymbol = (AxisBreakSymbol)e;
            axisBreakSymbol.translate(n, n2);
            SGProperties sGProperties = axisBreakSymbol.getProperties();
            AxisBreakSymbol axisBreakSymbol2 = new AxisBreakSymbol();
            axisBreakSymbol2.setMagnification(f);
            axisBreakSymbol2.setProperties(sGProperties);
            axisBreakSymbol2.mXAxis = this.mAxisElement.getAxisInCube(axisBreakSymbol.mTempXAxis);
            axisBreakSymbol2.mYAxis = this.mAxisElement.getAxisInCube(axisBreakSymbol.mTempYAxis);
            axisBreakSymbol2.setDrawingElementsLocation();
            axisBreakSymbol2.setAxisValue();
            this.addToList(axisBreakSymbol2);
            axisBreakSymbol2.initPropertiesHistory();
            ++n3;
        }
        if (n3 != 0) {
            this.setChanged(true);
        }
        return true;
    }

    public static class AxisBreakSymbolWithAxesProperties
    extends SGAxisBreakSymbol.AxisBreakSymbolProperties {
        private double mXValue = 0.0;
        private double mYValue = 0.0;
        private SGAxis mXAxis = null;
        private SGAxis mYAxis = null;

        public boolean equals(Object object) {
            if (!(object instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)object;
            if (axisBreakSymbolWithAxesProperties.mXValue != this.mXValue) {
                return false;
            }
            if (axisBreakSymbolWithAxesProperties.mYValue != this.mYValue) {
                return false;
            }
            if (!this.mXAxis.equals(axisBreakSymbolWithAxesProperties.mXAxis)) {
                return false;
            }
            return this.mYAxis.equals(axisBreakSymbolWithAxesProperties.mYAxis);
        }

        public Double getXValue() {
            return new Double(this.mXValue);
        }

        public Double getYValue() {
            return new Double(this.mYValue);
        }

        public SGAxis getXAxis() {
            return this.mXAxis;
        }

        public SGAxis getYAxis() {
            return this.mYAxis;
        }

        public boolean setXValue(double d) {
            this.mXValue = d;
            return true;
        }

        public boolean setYValue(double d) {
            this.mYValue = d;
            return true;
        }

        private boolean setXAxis(SGAxis sGAxis) {
            if (sGAxis == null) {
                throw new IllegalArgumentException("axis==null");
            }
            this.mXAxis = sGAxis;
            return true;
        }

        private boolean setYAxis(SGAxis sGAxis) {
            if (sGAxis == null) {
                throw new IllegalArgumentException("axis==null");
            }
            this.mYAxis = sGAxis;
            return true;
        }
    }

    class AxisBreakSymbol
    extends SGAxisBreakSymbol2D
    implements ActionListener,
    SGIAxisBreakSymbolDialogObserver,
    SGIUndoable,
    SGISelectable,
    SGIMovable,
    SGICopiable,
    SGINode,
    SGIDisposable {
        private int mID;
        private SGAxis mXAxis = null;
        private SGAxis mYAxis = null;
        private double mXValue;
        private double mYValue;
        private boolean mFrameFlag = false;
        private SGProperties mTemporaryProperties = null;
        private JPopupMenu mPopupMenu = new JPopupMenu();
        private int mTempXAxis = -1;
        private int mTempYAxis = -1;
        private boolean mValidFlag = true;
        private SGUndoManager mUndoManager = new SGUndoManager(this);
        private boolean mChangedFlag = false;
        private boolean mSelectedFlag = false;

        AxisBreakSymbol() {
            this.init();
        }

        AxisBreakSymbol(float f, float f2, float f3, float f4, boolean bl) {
            super(f, f2, f3, f4, bl);
            this.init();
        }

        private boolean init() {
            this.createPopupMenu();
            return true;
        }

        public void dispose() {
            super.dispose();
            this.mPopupMenu = null;
            this.mTemporaryProperties = null;
            this.mUndoManager.dispose();
            this.mUndoManager = null;
            this.mXAxis = null;
            this.mYAxis = null;
        }

        public String toString() {
            return "AxisBreak:" + this.mID;
        }

        public void finalize() {
        }

        public int getXAxisConfiguration() {
            return SGAxisBreakElement.this.mAxisElement.getConfigurationInPlane(this.mXAxis);
        }

        public int getYAxisConfiguration() {
            return SGAxisBreakElement.this.mAxisElement.getConfigurationInPlane(this.mYAxis);
        }

        public void setXAxisConfiguration(int n) {
            this.mXAxis = this.getAxis(n);
        }

        public void setYAxisConfiguration(int n) {
            this.mYAxis = this.getAxis(n);
        }

        private SGAxis getAxis(int n) {
            return SGAxisBreakElement.this.mAxisElement.getAxisInPlane(n);
        }

        public double getXValue() {
            return this.mXValue;
        }

        public double getYValue() {
            return this.mYValue;
        }

        public Color getInnerColor() {
            return this.getColor(0);
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public float getLength(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLength(), string);
        }

        public float getInterval(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getInterval(), string);
        }

        public void setXValue(double d) {
            this.mXValue = d;
        }

        public void setYValue(double d) {
            this.mYValue = d;
        }

        public void setLineWidth(float f, String string) {
            this.setLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public void setLength(float f, String string) {
            this.setLength((float)SGUtilityText.convertToPoint(f, string));
        }

        public void setInterval(float f, String string) {
            this.setInterval((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean hasValidXValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mXAxis : SGAxisBreakElement.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidYValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGAxisBreakElement.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getYValue();
            return sGAxis.isValidValue(d);
        }

        public void setInnerColor(Color color) {
            this.setColor(color);
        }

        public Object copy() {
            AxisBreakSymbol axisBreakSymbol = new AxisBreakSymbol();
            axisBreakSymbol.setMagnification(this.mMagnification);
            axisBreakSymbol.setProperties(this.getProperties());
            axisBreakSymbol.setLocation(this.getX(), this.getY());
            axisBreakSymbol.mTempXAxis = SGAxisBreakElement.this.mAxisElement.getConfigurationInCube(this.mXAxis);
            axisBreakSymbol.mTempYAxis = SGAxisBreakElement.this.mAxisElement.getConfigurationInCube(this.mYAxis);
            return axisBreakSymbol;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGAxisBreakElement.this.mDialog;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            SGIAxisElement sGIAxisElement = SGAxisBreakElement.this.mAxisElement;
            String string = sGIAxisElement.getAxisLocation(this.mXAxis);
            String string2 = sGIAxisElement.getAxisLocation(this.mYAxis);
            String string3 = "";
            string3 = string3 + this.mID + ": " + string + ", " + string2 + ", ";
            string3 = string3 + "( X=" + this.mXValue + ", Y=" + this.mYValue + " )";
            return string3;
        }

        private JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        private boolean createPopupMenu() {
            JPopupMenu jPopupMenu = this.mPopupMenu;
            jPopupMenu.setBounds(0, 0, 100, 100);
            jPopupMenu.add(new JLabel("  -- AxisBreak --"));
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Move to Front");
            SGUtility.addItem(jPopupMenu, this, "Move to Back");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Cut");
            SGUtility.addItem(jPopupMenu, this, "Copy");
            SGUtility.addItem(jPopupMenu, this, "Paste");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Delete");
            SGUtility.addItem(jPopupMenu, this, "Duplicate");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return true;
        }

        public SGTuple2f getLocation() {
            float f = this.mMagnification * this.mLocation.x + SGAxisBreakElement.this.mGraphRectX;
            float f2 = this.mMagnification * this.mLocation.y + SGAxisBreakElement.this.mGraphRectY;
            return new SGTuple2f(f, f2);
        }

        public void setLocation(float f, float f2) {
            float f3 = f - this.getX();
            float f4 = f2 - this.getY();
            this.mLocation.x = (f - SGAxisBreakElement.this.mGraphRectX) / this.mMagnification;
            this.mLocation.y = (f2 - SGAxisBreakElement.this.mGraphRectY) / this.mMagnification;
            this.create();
        }

        public void translate(float f, float f2) {
            this.setLocation(this.getX() + f, this.getY() + f2);
            this.setAxisValue();
            this.setDrawingElementsLocation();
        }

        private void drawBoundingBox(Graphics2D graphics2D) {
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setPaint(Color.BLACK);
            graphics2D.draw(this.getElementBounds());
        }

        private ArrayList getAnchorPointList() {
            ArrayList arrayList = this.getAnchorPointList(this.mCurve1);
            ArrayList arrayList2 = this.getAnchorPointList(this.mCurve2);
            ArrayList arrayList3 = new ArrayList();
            arrayList3.addAll(arrayList);
            arrayList3.addAll(arrayList2);
            return arrayList3;
        }

        private ArrayList getAnchorPointList(Shape shape) {
            ArrayList<Point2D> arrayList = new ArrayList<Point2D>();
            PathIterator pathIterator = shape.getPathIterator(null);
            ArrayList arrayList2 = SGUtilityJava2D.getSegmentList(pathIterator);
            Point2D point2D = (Point2D)arrayList2.get(0);
            Point2D point2D2 = (Point2D)arrayList2.get(arrayList2.size() - 1);
            Point2D.Float float_ = new Point2D.Float();
            ((Point2D)float_).setLocation((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
            arrayList.add(point2D);
            arrayList.add(point2D2);
            arrayList.add(float_);
            return arrayList;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (string.equals("Property")) {
                SGAxisBreakElement.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Copy") | string.equals("Cut") | string.equals("Paste") | string.equals("Delete") | string.equals("Duplicate") | string.equals("Move to Front") | string.equals("Move to Back")) {
                SGAxisBreakElement.this.notifyToListener(string);
            }
        }

        public boolean isValid() {
            return this.mValidFlag;
        }

        public void setValid(boolean bl) {
            this.mValidFlag = bl;
        }

        public boolean setDrawingElementsLocation() {
            float f = SGAxisBreakElement.this.calcLocation(this.mXValue, this.mXAxis, true);
            float f2 = SGAxisBreakElement.this.calcLocation(this.mYValue, this.mYAxis, false);
            if (Float.isNaN(f) | Float.isNaN(f2)) {
                this.setValid(false);
                return false;
            }
            this.setValid(true);
            this.setLocation(f, f2);
            return true;
        }

        public boolean setAxisValue() {
            double d = SGAxisBreakElement.this.calcValue(this.getX(), this.mXAxis, true);
            double d2 = SGAxisBreakElement.this.calcValue(this.getY(), this.mYAxis, false);
            this.mXValue = SGAxisBreakElement.this.getNumberInRangeOrder(d, this.mXAxis);
            this.mYValue = SGAxisBreakElement.this.getNumberInRangeOrder(d2, this.mYAxis);
            return true;
        }

        public String getTagName() {
            return "AxisBreakSymbol";
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            String string = "cm";
            String string2 = "pt";
            String string3 = SGIConstants.degree;
            element.setAttribute("XValue", Double.toString(this.mXValue));
            element.setAttribute("YValue", Double.toString(this.mYValue));
            element.setAttribute("XAxisPosition", SGAxisBreakElement.this.mAxisElement.getAxisLocation(this.mXAxis));
            element.setAttribute("YAxisPosition", SGAxisBreakElement.this.mAxisElement.getAxisLocation(this.mYAxis));
            element.setAttribute("Length", Float.toString(this.mLength * 0.035277776f) + string);
            element.setAttribute("Interval", Float.toString(this.mInterval * 0.035277776f) + string);
            element.setAttribute("Distortion", Float.toString(this.mDistortion));
            element.setAttribute("Angle", Float.toString(this.mAngle / ((float)Math.PI / 180)) + string3);
            element.setAttribute("LineWidth", Float.toString(this.mLineWidth) + string2);
            element.setAttribute("Horizontal", Boolean.toString(this.mForHorizontalAxisFlag));
            element.setAttribute("LineColor", SGUtilityText.getColorString(this.mLineColor));
            element.setAttribute("InnerColor", SGUtilityText.getColorListString(this.getColorList()));
            return true;
        }

        public boolean readProperty(Element element) {
            SGAxisBreakSymbol.AxisBreakSymbolProperties axisBreakSymbolProperties = this.readProperty_(element);
            if (axisBreakSymbolProperties == null) {
                return false;
            }
            return this.setProperties(axisBreakSymbolProperties);
        }

        public SGAxisBreakSymbol.AxisBreakSymbolProperties readProperty_(Element element) {
            String string = null;
            Number number = null;
            Color color = null;
            Boolean bl = null;
            ArrayList arrayList = null;
            string = element.getAttribute("XAxisPosition");
            if (string.length() == 0) {
                return null;
            }
            int n = SGAxisBreakElement.this.mAxisElement.getConfigurationInCube(string);
            SGAxis sGAxis = SGAxisBreakElement.this.mAxisElement.getAxisInCube(n);
            if (sGAxis == null) {
                return null;
            }
            string = element.getAttribute("YAxisPosition");
            if (string.length() == 0) {
                return null;
            }
            int n2 = SGAxisBreakElement.this.mAxisElement.getConfigurationInCube(string);
            SGAxis sGAxis2 = SGAxisBreakElement.this.mAxisElement.getAxisInCube(n2);
            if (sGAxis2 == null) {
                return null;
            }
            string = element.getAttribute("XValue");
            if (string.length() == 0) {
                return null;
            }
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return null;
            }
            double d = number.doubleValue();
            if (!sGAxis.isValidValue(d)) {
                return null;
            }
            string = element.getAttribute("YValue");
            if (string.length() == 0) {
                return null;
            }
            number = SGUtilityText.getDouble(string);
            if (number == null) {
                return null;
            }
            double d2 = number.doubleValue();
            if (!sGAxis2.isValidValue(d2)) {
                return null;
            }
            string = element.getAttribute("Length");
            if (string.length() == 0) {
                return null;
            }
            number = SGUtilityText.getLengthInPoint(string);
            if (number == null) {
                return null;
            }
            float f = number.floatValue();
            string = element.getAttribute("Interval");
            if (string.length() == 0) {
                return null;
            }
            number = SGUtilityText.getLengthInPoint(string);
            if (number == null) {
                return null;
            }
            float f2 = number.floatValue();
            string = element.getAttribute("Distortion");
            if (string.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string);
            if (number == null) {
                return null;
            }
            float f3 = number.floatValue();
            string = element.getAttribute("Angle");
            if (string.length() == 0) {
                return null;
            }
            number = SGUtilityText.getFloat(string, SGIConstants.degree);
            if (number == null) {
                return null;
            }
            float f4 = number.floatValue() * ((float)Math.PI / 180);
            string = element.getAttribute("LineWidth");
            if (string.length() == 0) {
                return null;
            }
            number = SGUtilityText.getLengthInPoint(string);
            if (number == null) {
                return null;
            }
            float f5 = number.floatValue();
            string = element.getAttribute("Horizontal");
            if (string.length() == 0) {
                return null;
            }
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return null;
            }
            boolean bl2 = bl;
            string = element.getAttribute("LineColor");
            if (string.length() == 0) {
                return null;
            }
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return null;
            }
            Color color2 = color;
            string = element.getAttribute("InnerColor");
            if (string.length() == 0) {
                return null;
            }
            arrayList = SGUtilityText.getColorList(string);
            if (arrayList == null) {
                return null;
            }
            ArrayList arrayList2 = arrayList;
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = new AxisBreakSymbolWithAxesProperties();
            axisBreakSymbolWithAxesProperties.setXValue(d);
            axisBreakSymbolWithAxesProperties.setYValue(d2);
            axisBreakSymbolWithAxesProperties.mXAxis = sGAxis;
            axisBreakSymbolWithAxesProperties.mYAxis = sGAxis2;
            axisBreakSymbolWithAxesProperties.setLength(f);
            axisBreakSymbolWithAxesProperties.setInterval(f2);
            axisBreakSymbolWithAxesProperties.setDistortion(f3);
            axisBreakSymbolWithAxesProperties.setAngle(f4);
            axisBreakSymbolWithAxesProperties.setLineWidth(f5);
            axisBreakSymbolWithAxesProperties.setHorizontal(bl2);
            axisBreakSymbolWithAxesProperties.setLineColor(color2);
            axisBreakSymbolWithAxesProperties.setColor(arrayList2);
            axisBreakSymbolWithAxesProperties.setVisible(true);
            return axisBreakSymbolWithAxesProperties;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public boolean commit() {
            SGProperties sGProperties = this.getProperties();
            if (sGProperties == null) {
                return false;
            }
            if (!sGProperties.equals(this.mTemporaryProperties)) {
                this.setChanged(true);
            }
            if (!this.create()) {
                return false;
            }
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGAxisBreakElement.this.repaint();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            if (!this.create()) {
                return false;
            }
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGAxisBreakElement.this.repaint();
            return true;
        }

        public boolean preview() {
            if (!this.create()) {
                return false;
            }
            if (!this.setDrawingElementsLocation()) {
                return false;
            }
            SGAxisBreakElement.this.repaint();
            return true;
        }

        public SGProperties getMemento() {
            return this.getProperties();
        }

        public boolean setMemento(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public boolean isUndoable() {
            return this.mUndoManager.isUndoable();
        }

        public boolean isRedoable() {
            return this.mUndoManager.isRedoable();
        }

        public boolean initPropertiesHistory() {
            return this.mUndoManager.initPropertiesHistory();
        }

        public boolean setMementoBackward() {
            if (!this.mUndoManager.setMementoBackward()) {
                return false;
            }
            this.create();
            this.setDrawingElementsLocation();
            return true;
        }

        public boolean setMementoForward() {
            if (!this.mUndoManager.setMementoForward()) {
                return false;
            }
            this.create();
            this.setDrawingElementsLocation();
            return true;
        }

        public boolean undo() {
            return this.setMementoBackward();
        }

        public boolean redo() {
            return this.setMementoForward();
        }

        public boolean updateHistory() {
            return this.mUndoManager.updateHistory();
        }

        public void initUndoBuffer() {
            this.mUndoManager.initUndoBuffer();
        }

        public boolean isChanged() {
            return this.mChangedFlag;
        }

        public void setChanged(boolean bl) {
            this.mChangedFlag = bl;
        }

        public void notifyToRoot() {
            SGAxisBreakElement.this.notifyToRoot();
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)sGProperties;
            Double d = axisBreakSymbolWithAxesProperties.getXValue();
            if (d == null) {
                return false;
            }
            this.mXValue = d;
            Double d2 = axisBreakSymbolWithAxesProperties.getYValue();
            if (d2 == null) {
                return false;
            }
            this.mYValue = d2;
            this.mXAxis = axisBreakSymbolWithAxesProperties.mXAxis;
            this.mYAxis = axisBreakSymbolWithAxesProperties.mYAxis;
            return true;
        }

        public SGProperties getProperties() {
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = new AxisBreakSymbolWithAxesProperties();
            if (!this.getProperties(axisBreakSymbolWithAxesProperties)) {
                return null;
            }
            return axisBreakSymbolWithAxesProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof AxisBreakSymbolWithAxesProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            AxisBreakSymbolWithAxesProperties axisBreakSymbolWithAxesProperties = (AxisBreakSymbolWithAxesProperties)sGProperties;
            axisBreakSymbolWithAxesProperties.setXValue(this.mXValue);
            axisBreakSymbolWithAxesProperties.setYValue(this.mYValue);
            axisBreakSymbolWithAxesProperties.mXAxis = this.mXAxis;
            axisBreakSymbolWithAxesProperties.mYAxis = this.mYAxis;
            return true;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }
    }

    public static class AxisProperties
    extends SGProperties {
        ArrayList visibleAxisBreakSymbolList = new ArrayList();

        AxisProperties() {
        }

        public void dispose() {
            this.visibleAxisBreakSymbolList.clear();
            this.visibleAxisBreakSymbolList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof AxisProperties)) {
                return false;
            }
            AxisProperties axisProperties = (AxisProperties)object;
            return axisProperties.visibleAxisBreakSymbolList.equals(this.visibleAxisBreakSymbolList);
        }
    }
}

