/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisBreakElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGraphElement;
import jp.riken.brain.ni.samuraigraph.base.SGIGridElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIShapeElement;
import jp.riken.brain.ni.samuraigraph.base.SGISignificantDifferenceElement;
import jp.riken.brain.ni.samuraigraph.base.SGIStringElement;
import jp.riken.brain.ni.samuraigraph.base.SGITimingLineElement;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupArrow;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSetInFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupString;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupTickLabel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDataPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGILegendDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISXYDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGLegendDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogVXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SGLegendElement
extends SGFigureElement
implements SGILegendElement,
SGIStringConstants,
CaretListener,
ActionListener,
SGIMovable,
SGISelectable,
SGILegendDialogObserver {
    private SGIGraphElement mGraphElement = null;
    private SGIAxisElement mAxisElement = null;
    private ArrayList mLegendList = new ArrayList();
    private SGAxis mXAxis = null;
    private SGAxis mYAxis = null;
    private float mLegendX = 0.0f;
    private float mLegendY = 0.0f;
    private float mLegendWidth = 0.0f;
    private float mLegendHeight = 0.0f;
    private float mFontSize;
    private int mFontStyle;
    private String mFontName;
    private Color mStringColor;
    private float mSymbolSpan;
    private float mFrameLineWidth;
    private Color mFrameLineColor;
    private Color mBackgroundColor;
    private boolean mLegendVisibleFlag = true;
    private boolean mFrameVisibleFlag = true;
    private boolean mLegendTransparentFlag = true;
    private SGProperties mTemporaryProperties = null;
    private JPopupMenu mPopupMenu = new JPopupMenu();
    private SGLegendDialog mLegendDialog;
    private SGPropertyDialogSXYData mSXYDataDialog;
    private SGPropertyDialogVXYData mVXYDataDialog;
    private JTextField mTextField = new JTextField();
    public static final String MENUCMD_HIDE = "Hide";
    private boolean mStartFlag = true;
    private boolean mSelectedFlag = false;
    private static final float MARGIN_HORIZONTAL = 6.0f;
    private static final float MARGIN_VERTICAL = 6.0f;
    private static final float marginTop = 6.0f;
    private static final float marginBottom = 6.0f;
    private static final float marginLeft = 6.0f;
    private static final float marginRight = 6.0f;
    private static final float spaceDataAndString = 6.0f;
    private static final float spaceLegend = 6.0f;
    private ElementGroupSetInLegend mFocusedGroup = null;
    private Point mLegendLocation = null;

    public SGLegendElement() {
        this.initEditField();
        if (!this.init()) {
            throw new Error();
        }
    }

    private boolean init() {
        this.setLegendVisible(true);
        this.setFontName("Serif");
        this.setFontSize(16.0f);
        int n = SGUtilityText.getFontStyle("Plain");
        if (n == -1) {
            return false;
        }
        this.setFontStyle(n);
        this.setStringColor(SGDefaultValues.LEGEND_STRING_COLOR);
        this.setFrameVisible(true);
        this.setFrameLineWidth(0.5f);
        this.setFrameLineColor(SGDefaultValues.LEGEND_FRAME_COLOR);
        this.setBackgroundColor(SGDefaultValues.LEGEND_BACKGROUND_COLOR);
        this.setBackgroundTransparent(false);
        this.setDataWidth(42.519688f);
        this.createPopupMenu();
        return true;
    }

    public void dispose() {
        super.dispose();
        this.mLegendDialog.dispose();
        this.mLegendDialog = null;
        this.mAxisElement = null;
        this.mFocusedGroup = null;
        this.mGraphElement = null;
        if (this.mSXYDataDialog != null) {
            this.mSXYDataDialog.dispose();
            this.mSXYDataDialog = null;
        }
        if (this.mVXYDataDialog != null) {
            this.mVXYDataDialog.dispose();
            this.mVXYDataDialog = null;
        }
        this.mTextField = null;
        this.mPopupMenu = null;
        this.mBackgroundColor = null;
        this.mFontName = null;
        this.mFrameLineColor = null;
        this.mLegendList.clear();
        this.mLegendList = null;
    }

    private boolean createPopupMenu() {
        JPopupMenu jPopupMenu = this.mPopupMenu;
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Legend --"));
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, MENUCMD_HIDE);
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, this, "Property");
        return true;
    }

    public String toString() {
        return new String("SGLegendElement");
    }

    public String getClassDescription() {
        return "Legend";
    }

    public boolean addData(SGData sGData, String string) {
        if (this.mGraphElement == null || sGData == null) {
            throw new Error("mGraphElement==null || data==null");
        }
        super.addData(sGData, string);
        ElementGroupSetInLegend elementGroupSetInLegend = this.createGroupSet(sGData, string);
        this.createAllDrawingElements();
        if (this.mStartFlag) {
            this.onStartup(sGData);
        }
        this.updateSymbolsVisibleAroundFocusedObjects();
        return true;
    }

    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        if (this.mGraphElement == null || sGData == null) {
            throw new Error("mGraphElement==null || data==null");
        }
        super.addData(sGData, string, sGProperties);
        ElementGroupSetInLegend elementGroupSetInLegend = this.createGroupSet(sGData, string);
        if (!elementGroupSetInLegend.setWholeProperties(sGProperties)) {
            throw new Error();
        }
        this.createAllDrawingElements();
        if (this.mStartFlag) {
            this.onStartup(sGData);
        }
        this.updateSymbolsVisibleAroundFocusedObjects();
        return true;
    }

    private ElementGroupSetInLegend createGroupSet(SGData sGData, String string) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.createLegendElement(sGData, string);
        if (elementGroupSetInLegend == null) {
            return null;
        }
        elementGroupSetInLegend.setMagnification(this.mMagnification);
        this.mLegendList.add(elementGroupSetInLegend);
        return elementGroupSetInLegend;
    }

    private void onStartup(SGData sGData) {
        float f = this.getGraphRectX() + this.getGraphRectWidth() - this.mMagnification * this.getLegendWidth();
        float f2 = this.getGraphRectY();
        this.setLegendLocation(f, f2);
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        this.mXAxis = sGAxis;
        this.mYAxis = sGAxis2;
        this.createDataDialog(sGData);
        this.createAllDrawingElements();
        this.mStartFlag = false;
    }

    private void createDataDialog(SGData sGData) {
        if (sGData instanceof SGISXYTypeData | sGData instanceof SGISXYTypeMultipleData) {
            if (this.mSXYDataDialog == null) {
                this.mSXYDataDialog = new SGPropertyDialogSXYData(this.mDialogOwner, true);
            }
        } else if (!(sGData instanceof SGVXYData) || this.mVXYDataDialog == null) {
            // empty if block
        }
    }

    private SGPropertyDialog showDataDialog(ElementGroupSetInLegend elementGroupSetInLegend) {
        Window window = null;
        if (elementGroupSetInLegend instanceof ElementGroupSetInLegendSXY) {
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)elementGroupSetInLegend;
            window = this.mSXYDataDialog;
        }
        window.setLocation(this.mDialogOwner.getLocation());
        ((SGPropertyDialog)window).addPropertyDialogObserver(elementGroupSetInLegend);
        ((SGPropertyDialog)window).setDialogProperty();
        ((SGPropertyDialog)window).setColorButtonBorder(true);
        elementGroupSetInLegend.prepare();
        ((SGPropertyDialog)window).setVisible(true);
        ((SGPropertyDialog)window).removeAllPropertyDialogObserver();
        this.notifyToRoot();
        return window;
    }

    private ElementGroupSetInLegend createLegendElement(SGData sGData, String string) {
        int n;
        Object object;
        SGAxis sGAxis;
        Object object2;
        Object object3;
        Object object4;
        ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = null;
        if (!(sGData instanceof SGISXYTypeData) && !(sGData instanceof SGISXYTypeMultipleData)) {
            return null;
        }
        elementGroupSetInLegendSXY = new ElementGroupSetInLegendSXY();
        elementGroupSetInLegendSXY.setName(string);
        if (sGData instanceof SGISXYTypeData || sGData instanceof SGVXYData || sGData instanceof SGISXYTypeMultipleData) {
            object4 = this.mAxisElement;
            SGAxis sGAxis2 = object4.getAxisInPlane(0);
            object3 = object4.getAxisInPlane(1);
            object2 = object4.getAxisInPlane(2);
            sGAxis = object4.getAxisInPlane(3);
            object = null;
            SGAxis sGAxis3 = null;
            if ("Left-Bottom".equals("Left-Bottom")) {
                object = sGAxis2;
                sGAxis3 = object2;
            } else if ("Left-Bottom".equals("Left-Top")) {
                object = object3;
                sGAxis3 = object2;
            } else if ("Left-Bottom".equals("Right-Bottom")) {
                object = sGAxis2;
                sGAxis3 = sGAxis;
            } else if ("Left-Bottom".equals("Right-Top")) {
                object = object3;
                sGAxis3 = sGAxis;
            } else {
                return null;
            }
            elementGroupSetInLegendSXY.setXAxis((SGAxis)object);
            elementGroupSetInLegendSXY.setYAxis(sGAxis3);
        }
        object4 = this.mGraphElement.getDrawingElementList(sGData);
        if (sGData instanceof SGISXYTypeData || sGData instanceof SGISXYTypeMultipleData) {
            for (n = 0; n < ((ArrayList)object4).size(); ++n) {
                object3 = (SGDrawingElement)((ArrayList)object4).get(n);
                if (object3 instanceof SGDrawingElementErrorBar) {
                    ((SGElementGroupSet)elementGroupSetInLegendSXY).addDrawingElementGroup(4);
                    continue;
                }
                if (object3 instanceof SGDrawingElementLine) {
                    ((SGElementGroupSet)elementGroupSetInLegendSXY).addDrawingElementGroup(0);
                    continue;
                }
                if (object3 instanceof SGDrawingElementRectangle) {
                    ((SGElementGroupSet)elementGroupSetInLegendSXY).addDrawingElementGroup(2);
                    object2 = (ElementGroupBar)elementGroupSetInLegendSXY.getBarGroup();
                    sGAxis = elementGroupSetInLegendSXY.getXAxis();
                    object = null;
                    if (sGData instanceof SGISXYTypeData) {
                        object = ((SGISXYTypeData)((Object)sGData)).getXValueArray();
                    } else if (sGData instanceof SGISXYTypeMultipleData) {
                        object = ((SGISXYTypeMultipleData)((Object)sGData)).getXValueArray();
                    }
                    double d = Double.MAX_VALUE;
                    for (int i = 0; i < ((Object)object).length - 1; ++i) {
                        double d2 = Math.abs((double)(object[i + 1] - object[i]));
                        if (!(d2 < d)) continue;
                        d = d2;
                    }
                    d = this.getNumberInRangeOrder(d, sGAxis);
                    ((SGElementGroupBar)object2).setWidthValue(d);
                    continue;
                }
                if (object3 instanceof SGDrawingElementSymbol) {
                    ((SGElementGroupSet)elementGroupSetInLegendSXY).addDrawingElementGroup(1);
                    continue;
                }
                if (object3 instanceof SGDrawingElementString) {
                    ((SGElementGroupSet)elementGroupSetInLegendSXY).addDrawingElementGroup(5);
                    continue;
                }
                throw new Error();
            }
        } else if (sGData instanceof SGVXYData) {
            for (n = 0; n < ((ArrayList)object4).size(); ++n) {
                object3 = (SGDrawingElement)((ArrayList)object4).get(n);
                if (!(object3 instanceof SGDrawingElementArrow)) {
                    throw new Error();
                }
                ((SGElementGroupSet)elementGroupSetInLegendSXY).addDrawingElementGroup(3);
            }
        } else {
            throw new Error("This data-type is not defined.");
        }
        n = this.mGraphElement.getVisibleInLegendFlag(sGData) ? 1 : 0;
        elementGroupSetInLegendSXY.setVisibleInLegend(n != 0);
        elementGroupSetInLegendSXY.initPropertiesHistory();
        return elementGroupSetInLegendSXY;
    }

    public ArrayList getDrawingElementList(SGData sGData) {
        return this.getLegendData(sGData).getDrawingElementList();
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        if (this.isSelected()) {
            arrayList.add(this);
        }
        return true;
    }

    public boolean hideSelectedObject(SGISelectable sGISelectable) {
        return true;
    }

    public String getDataName(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getLegendData(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.mName;
        }
        return null;
    }

    public boolean isDataVisible(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        return elementGroupSetInLegend.isVisible();
    }

    protected ElementGroupSetInLegend getLegendData(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            return elementGroupSetInLegend;
        }
        return null;
    }

    public ArrayList getVisibleFlagList(SGData sGData) {
        if (sGData == null) {
            return null;
        }
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        ElementGroupSetInLegend elementGroupSetInLegend = this.getLegendData(sGData);
        ArrayList arrayList2 = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
            boolean bl = sGElementGroup.isVisible();
            arrayList.add(new Boolean(bl));
        }
        return arrayList;
    }

    public SGAxis getXAxis(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.getXAxis();
        }
        return null;
    }

    public SGAxis getYAxis(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.getYAxis();
        }
        return null;
    }

    public SGAxis getZAxis(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.mZAxis;
        }
        return null;
    }

    public void setSelected(boolean bl) {
        this.mSelectedFlag = bl;
    }

    public boolean isSelected() {
        return this.mSelectedFlag;
    }

    public float getLegendX() {
        return this.mGraphRectX + this.mLegendX * this.mMagnification;
    }

    public float getLegendY() {
        return this.mGraphRectY + this.mLegendY * this.mMagnification;
    }

    public float getLegendWidth() {
        return this.mLegendWidth;
    }

    public float getLegendHeight() {
        return this.mLegendHeight;
    }

    public Point2D getLegendLocation() {
        Point2D.Float float_ = new Point2D.Float(this.getLegendX(), this.getLegendY());
        return float_;
    }

    public boolean setLegendLocation(float f, float f2) {
        this.mLegendX = (f - this.mGraphRectX) / this.mMagnification;
        this.mLegendY = (f2 - this.mGraphRectY) / this.mMagnification;
        return true;
    }

    public void setXValue(double d) {
        float f;
        SGAxis sGAxis = this.mXAxis;
        double d2 = this.calcValue(this.getComponent().getX(), sGAxis, true);
        if (d == (d2 = this.getNumberInRangeOrder(d2, sGAxis))) {
            f = this.mLegendX;
        } else {
            float f2 = this.calcLocation(d, sGAxis, true);
            f = (f2 - this.mGraphRectX) / this.mMagnification;
        }
        this.mLegendX = f;
        this.createAllDrawingElements();
    }

    public void setYValue(double d) {
        float f;
        SGAxis sGAxis = this.mYAxis;
        double d2 = this.calcValue(this.getComponent().getY(), sGAxis, false);
        if (d == (d2 = this.getNumberInRangeOrder(d2, sGAxis))) {
            f = this.mLegendY;
        } else {
            float f2 = this.calcLocation(d, sGAxis, false);
            f = (f2 - this.mGraphRectY) / this.mMagnification;
        }
        this.mLegendY = f;
        this.createAllDrawingElements();
    }

    public boolean hasValidXAxisValue(int n, Number number) {
        SGAxis sGAxis = n == -1 ? this.mXAxis : this.mAxisElement.getAxisInPlane(n);
        double d = number != null ? number.doubleValue() : this.getXValue();
        return sGAxis.isValidValue(d);
    }

    public boolean hasValidYAxisValue(int n, Number number) {
        SGAxis sGAxis = n == -1 ? this.mYAxis : this.mAxisElement.getAxisInPlane(n);
        double d = number != null ? number.doubleValue() : this.getYValue();
        return sGAxis.isValidValue(d);
    }

    public void translate(float f, float f2) {
        this.setLegendLocation(this.getLegendX() + f, this.getLegendY() + f2);
        this.createAllDrawingElements();
    }

    public double getXValue() {
        SGAxis sGAxis = this.mXAxis;
        double d = this.calcValue(this.getLegendX(), sGAxis, true);
        if (d == Double.NaN) {
            return d;
        }
        d = this.getNumberInRangeOrder(d, sGAxis);
        return d;
    }

    public double getYValue() {
        SGAxis sGAxis = this.mYAxis;
        double d = this.calcValue(this.getLegendY(), sGAxis, false);
        if (d == Double.NaN) {
            return d;
        }
        d = this.getNumberInRangeOrder(d, sGAxis);
        return d;
    }

    private boolean initEditField() {
        this.mTextField.setVisible(false);
        this.mTextField.addActionListener(this);
        this.mTextField.addCaretListener(this);
        return true;
    }

    public void setComponent(JComponent jComponent) {
        super.setComponent(jComponent);
        jComponent.add(this.mTextField);
    }

    public boolean clearFocusedObjects() {
        if (!super.clearFocusedObjects()) {
            return false;
        }
        if (this.mTextField.isVisible()) {
            this.terminateEditField();
        }
        this.clearFocusedGroup();
        return true;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDialog();
        return true;
    }

    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    private boolean createDialog() {
        SGLegendDialog sGLegendDialog;
        this.mLegendDialog = sGLegendDialog = new SGLegendDialog(this.mDialogOwner, true);
        return true;
    }

    protected SGProperties getCommonProperties() {
        LegendCommonProperties legendCommonProperties = new LegendCommonProperties();
        legendCommonProperties.x = this.mLegendX;
        legendCommonProperties.y = this.mLegendY;
        legendCommonProperties.visible = this.isLegendVisible();
        legendCommonProperties.frameLineVisible = this.isFrameLineVisible();
        legendCommonProperties.frameLineWidth = this.getFrameLineWidth();
        legendCommonProperties.frameLineColor = this.getFrameLineColor();
        legendCommonProperties.backgroundColor = this.getBackgroundColor();
        legendCommonProperties.transparent = this.isBackgroundTransparent();
        legendCommonProperties.fontName = this.getFontName();
        legendCommonProperties.fontSize = this.getFontSize();
        legendCommonProperties.fontStyle = this.getFontStyle();
        legendCommonProperties.stringColor = this.getStringColor();
        legendCommonProperties.symbolSpan = this.getSymbolSpan();
        legendCommonProperties.xAxis = this.mXAxis;
        legendCommonProperties.yAxis = this.mYAxis;
        return legendCommonProperties;
    }

    public SGProperties getDataProperties(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        if (elementGroupSetInLegend != null) {
            return elementGroupSetInLegend.getWholeProperties();
        }
        return null;
    }

    public SGProperties getProperties() {
        LegendCommonProperties legendCommonProperties = new LegendCommonProperties();
        legendCommonProperties = (LegendCommonProperties)this.getCommonProperties();
        return legendCommonProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof LegendCommonProperties)) {
            return false;
        }
        LegendCommonProperties legendCommonProperties = (LegendCommonProperties)sGProperties;
        return this.setCommonProperties(legendCommonProperties);
    }

    protected SGData getData(int n) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData = (SGData)this.mDataList.get(i);
            if (sGData.hashCode() != n) continue;
            return sGData;
        }
        return null;
    }

    private boolean setCommonProperties(LegendCommonProperties legendCommonProperties) {
        this.mLegendX = legendCommonProperties.x;
        this.mLegendY = legendCommonProperties.y;
        this.setLegendVisible(legendCommonProperties.visible);
        this.setFrameVisible(legendCommonProperties.frameLineVisible);
        this.setFrameLineWidth(legendCommonProperties.frameLineWidth);
        this.setFrameLineColor(legendCommonProperties.frameLineColor);
        this.setBackgroundColor(legendCommonProperties.backgroundColor);
        this.setBackgroundTransparent(legendCommonProperties.transparent);
        this.setFontName(legendCommonProperties.fontName);
        this.setFontSize(legendCommonProperties.fontSize);
        this.setFontStyle(legendCommonProperties.fontStyle);
        this.setStringColor(legendCommonProperties.stringColor);
        this.setDataWidth(legendCommonProperties.symbolSpan);
        this.mXAxis = legendCommonProperties.xAxis;
        this.mYAxis = legendCommonProperties.yAxis;
        return true;
    }

    private boolean createAllDrawingElements() {
        int n;
        float f;
        float f2;
        int n2;
        int n3;
        float f3 = this.mMagnification;
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        int n4 = arrayList.size();
        ElementGroupSetInLegend[] elementGroupSetInLegendArray = new ElementGroupSetInLegend[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            elementGroupSetInLegendArray[n3] = (ElementGroupSetInLegend)arrayList.get(n3);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            elementGroupSetInLegendArray[n3].createStringElement();
        }
        Rectangle2D[] rectangle2DArray = new Rectangle2D[n4];
        for (int i = 0; i < n4; ++i) {
            rectangle2DArray[i] = elementGroupSetInLegendArray[i].getStringBounds();
        }
        float[] fArray = new float[n4];
        for (int i = 0; i < n4; ++i) {
            fArray[i] = (float)rectangle2DArray[i].getHeight();
        }
        float f4 = 0.0f;
        for (int i = 0; i < n4; ++i) {
            float f5 = (float)rectangle2DArray[i].getWidth();
            if (!(f5 > f4)) continue;
            f4 = f5;
        }
        float f6 = this.getSymbolSpan();
        for (int i = 0; i < n4; ++i) {
            float f7 = elementGroupSetInLegendArray[i].getMaxDataElementWidth() / f3;
            if (!(f7 > f6)) continue;
            f6 = f7;
        }
        float f8 = f6 + f4 / f3 + 6.0f;
        double[] dArray = new double[n4];
        for (int i = 0; i < n4; ++i) {
            dArray[i] = elementGroupSetInLegendArray[i].getMaxDataElementHeight();
        }
        float[] fArray2 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            fArray2[i] = (float)Math.max(dArray[i], (double)fArray[i]);
        }
        Rectangle2D[] rectangle2DArray2 = new Rectangle2D[n4];
        float f9 = this.getLegendY() + f3 * 6.0f;
        float f10 = this.getLegendX() + f3 * 6.0f;
        float f11 = f3 * f8;
        for (n2 = 0; n2 < n4; ++n2) {
            float f12 = f9;
            f2 = fArray2[n2];
            rectangle2DArray2[n2] = new Rectangle2D.Float(f10, f12, f11, f2);
            f9 += f2 + f3 * 6.0f;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            elementGroupSetInLegendArray[n2].setRect(rectangle2DArray2[n2]);
        }
        float f13 = f3 * f6;
        for (int i = 0; i < n4; ++i) {
            f2 = (float)rectangle2DArray2[i].getX();
            float f14 = (float)rectangle2DArray2[i].getY();
            f = (float)elementGroupSetInLegendArray[i].getMaxDataElementHeight();
            Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f14, f13, f);
            elementGroupSetInLegendArray[i].setDrawingElementBounds(float_);
        }
        float f15 = 0.0f;
        for (n = 0; n < n4; ++n) {
            f15 += fArray2[n] / f3;
        }
        f15 += (float)(n4 - 1) * 6.0f;
        for (n = 0; n < n4; ++n) {
            elementGroupSetInLegendArray[n].createDrawingElement();
        }
        float f16 = this.getLegendX() + f3 * (6.0f + f6 + 6.0f);
        for (int i = 0; i < n4; ++i) {
            f = (float)rectangle2DArray2[i].getY() + 0.5f * (float)rectangle2DArray2[i].getHeight() - 0.5f * fArray[i];
            elementGroupSetInLegendArray[i].getStringElement().setLocation(f16, f);
        }
        this.mLegendWidth = 6.0f + f8 + 6.0f;
        this.mLegendHeight = 6.0f + f15 + 6.0f;
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        super.setGraphRect(f, f2, f3, f4);
        if (!this.terminateEditField()) {
            return false;
        }
        return this.createAllDrawingElements();
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.isLegendVisible()) {
            Cloneable cloneable;
            if (!this.mLegendTransparentFlag) {
                cloneable = this.getLegendRect();
                graphics2D.setPaint(this.getBackgroundColor());
                graphics2D.fill((Shape)((Object)cloneable));
            }
            cloneable = this.getVisibleTotallyLegendList();
            for (int i = 0; i < ((ArrayList)cloneable).size(); ++i) {
                ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)((ArrayList)cloneable).get(i);
                elementGroupSetInLegend.paintGraphics2D(graphics2D);
            }
            if (this.mFrameVisibleFlag & ((ArrayList)cloneable).size() != 0) {
                this.drawLegendFrameLines(graphics2D);
            }
            if (this.mSymbolsVisibleFlagAroundAllObjects & ((ArrayList)cloneable).size() != 0) {
                ArrayList arrayList = this.getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsChildObject(arrayList, graphics2D);
            }
            if (this.mSymbolsVisibleFlagAroundFocusedObjects & this.isSelected()) {
                ArrayList arrayList = this.getAnchorPointList();
                SGUtilityForFigureElement.drawAnchorAsFocusedObject(arrayList, graphics2D);
            }
        }
    }

    private void updateSymbolsVisibleAroundFocusedObjects() {
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        this.setSymbolsVisibleAroundFocusedObjects(arrayList.size() != 0);
    }

    private ArrayList getAnchorPointList() {
        ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
        Rectangle2D rectangle2D = this.getLegendRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        Point2D.Float float_ = new Point2D.Float(f, f2);
        Point2D.Float float_2 = new Point2D.Float(f, f2 + f4);
        Point2D.Float float_3 = new Point2D.Float(f + f3, f2);
        Point2D.Float float_4 = new Point2D.Float(f + f3, f2 + f4);
        arrayList.add(float_);
        arrayList.add(float_2);
        arrayList.add(float_3);
        arrayList.add(float_4);
        return arrayList;
    }

    private void drawLegendFrameLines(Graphics2D graphics2D) {
        if (graphics2D == null) {
            return;
        }
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        if (arrayList.size() == 0) {
            return;
        }
        graphics2D.setPaint(this.mFrameLineColor);
        graphics2D.setStroke(new BasicStroke(this.mMagnification * this.mFrameLineWidth, 0, 0));
        graphics2D.draw(this.getLegendRect());
    }

    public boolean contains(int n, int n2) {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getLegendX(), this.getLegendY(), this.mLegendWidth, this.mLegendHeight);
        return float_.contains(n, n2);
    }

    public boolean removeData(SGData sGData) {
        ElementGroupSetInLegend elementGroupSetInLegend = this.getElementGroupSet(sGData);
        this.mLegendList.remove(elementGroupSetInLegend);
        return super.removeData(sGData);
    }

    protected boolean removeGraph(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            if (!sGElementGroupSet.equals(this.mLegendList.get(i))) continue;
            this.mLegendList.remove(i);
            this.mDataList.remove(i);
            return true;
        }
        return false;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIAxisElement)) {
            if (sGIFigureElement instanceof SGIGraphElement) {
                SGIGraphElement sGIGraphElement = (SGIGraphElement)sGIFigureElement;
                bl = this.synchronizeToGraphElement(sGIGraphElement);
            } else if (!(sGIFigureElement instanceof SGIStringElement || sGIFigureElement instanceof SGILegendElement || sGIFigureElement instanceof SGIAxisBreakElement || sGIFigureElement instanceof SGISignificantDifferenceElement || sGIFigureElement instanceof SGITimingLineElement || sGIFigureElement instanceof SGIGridElement || sGIFigureElement instanceof SGIShapeElement)) {
                bl = sGIFigureElement.synchronizeArgument(this);
            }
        }
        return bl;
    }

    private boolean synchronizeToGraphElement(SGIGraphElement sGIGraphElement) {
        Object object;
        Object object2;
        SGData sGData;
        int n;
        ArrayList arrayList = sGIGraphElement.getDataList();
        if (arrayList.size() != this.mDataList.size()) {
            throw new Error("dataList.size() != this.mDataList.size()");
        }
        ArrayList<SGData> arrayList2 = new ArrayList<SGData>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        block0: for (n = 0; n < arrayList.size(); ++n) {
            sGData = (SGData)arrayList.get(n);
            for (int i = this.mDataList.size() - 1; i >= 0; --i) {
                SGData sGData2 = (SGData)this.mDataList.get(i);
                if (!sGData.equals(sGData2)) continue;
                object2 = (SGData)this.mDataList.remove(i);
                arrayList2.add((SGData)object2);
                object = (SGElementGroupSet)this.mLegendList.remove(i);
                arrayList3.add(object);
                continue block0;
            }
        }
        this.mDataList = arrayList2;
        this.mLegendList = arrayList3;
        for (n = 0; n < arrayList3.size(); ++n) {
            sGData = (SGData)arrayList2.get(n);
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList3.get(n);
            elementGroupSetInLegend.setXAxis(sGIGraphElement.getXAxis(sGData));
            elementGroupSetInLegend.setYAxis(sGIGraphElement.getYAxis(sGData));
            elementGroupSetInLegend.setZAxis(sGIGraphElement.getZAxis(sGData));
        }
        for (n = arrayList2.size() - 1; n >= 0; --n) {
            boolean bl;
            sGData = (SGData)arrayList2.get(n);
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList3.get(n);
            boolean bl2 = false;
            object2 = sGIGraphElement.getDataName(sGData);
            if (!((String)object2).equals(object = elementGroupSetInLegend.getName())) {
                elementGroupSetInLegend.setChanged(true);
            }
            elementGroupSetInLegend.setName((String)object2);
            boolean bl3 = sGIGraphElement.isDataVisible(sGData);
            if (bl3 != elementGroupSetInLegend.isVisible()) {
                this.setChanged(true);
            }
            elementGroupSetInLegend.setVisible(bl3);
            ArrayList arrayList4 = sGIGraphElement.getDrawingElementList(sGData);
            boolean bl4 = elementGroupSetInLegend.synchronizeDrawingElements(arrayList4);
            if (bl4) {
                bl2 = bl4;
            }
            if ((bl = sGIGraphElement.getVisibleInLegendFlag(sGData)) != elementGroupSetInLegend.isVisibleInLegend()) {
                bl2 = true;
            }
            elementGroupSetInLegend.setVisibleInLegend(bl);
            if (!bl2) continue;
            elementGroupSetInLegend.setChanged(true);
        }
        this.createAllDrawingElements();
        this.updateSymbolsVisibleAroundFocusedObjects();
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement) {
        throw new Error();
    }

    public boolean zoom(float f) {
        if (!super.zoom(f)) {
            return false;
        }
        if (!this.terminateEditField()) {
            return false;
        }
        ArrayList arrayList = this.getVisibleTotallyLegendList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
            elementGroupSetInLegend.zoom(f);
        }
        this.createAllDrawingElements();
        return true;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        Rectangle2D rectangle2D = this.getGraphRect();
        Rectangle2D rectangle2D2 = this.getLegendRect();
        if (rectangle2D2.getWidth() < Double.MIN_VALUE || rectangle2D2.getHeight() < Double.MIN_VALUE) {
            return true;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        arrayList.add(rectangle2D);
        if (this.isLegendVisible()) {
            arrayList.add(rectangle2D2);
        }
        Rectangle2D rectangle2D3 = SGUtility.createUnion(arrayList);
        float f = (float)(rectangle2D.getY() - rectangle2D3.getY());
        float f2 = (float)(rectangle2D3.getY() + rectangle2D3.getHeight() - (rectangle2D.getY() + rectangle2D.getHeight()));
        float f3 = (float)(rectangle2D.getX() - rectangle2D3.getX());
        float f4 = (float)(rectangle2D3.getX() + rectangle2D3.getWidth() - (rectangle2D.getX() + rectangle2D.getWidth()));
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        if (!this.isLegendVisible()) {
            return false;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        Rectangle2D rectangle2D = this.getLegendRect();
        if (rectangle2D.contains(n, n2)) {
            ArrayList arrayList = this.getVisibleTotallyLegendList();
            if (n3 == 1) {
                this.updateFocusedObjectsList((SGISelectable)this, mouseEvent);
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
                        Rectangle2D rectangle2D2 = elementGroupSetInLegend.getStringBounds();
                        if (!rectangle2D2.contains(n, n2) || !SwingUtilities.isLeftMouseButton(mouseEvent) || !this.isSelected()) continue;
                        this.showEditField(elementGroupSetInLegend);
                    }
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    this.mPopupMenu.show(this.getComponent(), n, n2);
                }
            } else if (n3 == 2) {
                for (int i = 0; i < arrayList.size(); ++i) {
                    ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(i);
                    ArrayList arrayList2 = elementGroupSetInLegend.mDrawingElementGroupList;
                    for (int j = arrayList2.size() - 1; j >= 0; --j) {
                        SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(j);
                        if (!sGElementGroup.isVisible()) continue;
                        SGDrawingElement[] sGDrawingElementArray = sGElementGroup.mDrawingElementArray;
                        for (int k = 0; k < sGDrawingElementArray.length; ++k) {
                            boolean bl;
                            if (!sGDrawingElementArray[k].isVisible() || !(bl = sGDrawingElementArray[k].contains(n, n2)) || !SwingUtilities.isLeftMouseButton(mouseEvent) || n3 != 2) continue;
                            elementGroupSetInLegend.onMouseClicked(mouseEvent);
                            this.showDataDialog(elementGroupSetInLegend);
                            return true;
                        }
                    }
                }
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    this.setPropertiesOfSelectedObjects();
                }
            }
            return true;
        }
        return false;
    }

    public ArrayList getPropertyDialogObserverList() {
        return this.getFocusedObjectsList();
    }

    public ArrayList getChildNodes() {
        return new ArrayList();
    }

    public SGPropertyDialog getPropertyDialog() {
        return this.mLegendDialog;
    }

    public String getFontName() {
        return this.mFontName;
    }

    public int getFontStyle() {
        return this.mFontStyle;
    }

    public float getFontSize() {
        return this.mFontSize;
    }

    public float getFontSize(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFontSize(), string);
    }

    public float getFrameLineWidth() {
        return this.mFrameLineWidth;
    }

    public float getFrameLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getFrameLineWidth(), string);
    }

    public Color getFrameLineColor() {
        return this.mFrameLineColor;
    }

    public Color getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public Color getStringColor() {
        return this.mStringColor;
    }

    public float getSymbolSpan() {
        return this.mSymbolSpan;
    }

    public float getSymbolSpan(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getSymbolSpan(), string);
    }

    public void setDataWidth(float f) {
        this.mSymbolSpan = f;
    }

    public void setSymbolSpan(float f, String string) {
        this.setDataWidth((float)SGUtilityText.convertToPoint(f, string));
    }

    private boolean showEditField(ElementGroupSetInLegend elementGroupSetInLegend) {
        this.mFocusedGroup = elementGroupSetInLegend;
        JTextField jTextField = this.mTextField;
        Rectangle2D rectangle2D = elementGroupSetInLegend.getStringBounds();
        float f = this.getMagnification() * this.getFontSize();
        int n = (int)(rectangle2D.getX() - (double)jTextField.getInsets().left);
        int n2 = (int)(rectangle2D.getY() - (double)(f / 2.0f));
        int n3 = (int)(rectangle2D.getWidth() + (double)f);
        int n4 = (int)(rectangle2D.getHeight() + (double)f);
        jTextField.setLocation(n, n2);
        jTextField.setSize(n3, n4);
        Font font = new Font(this.getFontName(), this.getFontStyle(), (int)f);
        jTextField.setFont(font);
        jTextField.setForeground(this.mStringColor);
        jTextField.setText(elementGroupSetInLegend.getName());
        jTextField.setVisible(true);
        jTextField.requestFocus();
        jTextField.setCaretPosition(0);
        return true;
    }

    private boolean isMoved() {
        boolean bl = (int)this.mLegendX == (int)this.mLegendLocation.getX();
        boolean bl2 = (int)this.mLegendY == (int)this.mLegendLocation.getY();
        boolean bl3 = !bl || !bl2;
        return bl3;
    }

    private boolean terminateEditField() {
        this.commitEdit();
        this.hideEditField();
        this.clearFocusedGroup();
        this.repaint();
        return true;
    }

    private boolean commitEdit() {
        char c;
        String string = this.mTextField.getText();
        if (string.length() == 0) {
            return false;
        }
        int n = 0;
        if (n < string.length() && ((c = string.charAt(n)) == ' ' || c == '\u3000')) {
            return false;
        }
        String string2 = this.mFocusedGroup.getName();
        String string3 = string;
        this.mFocusedGroup.setName(string3);
        this.createAllDrawingElements();
        if (!string2.equals(string3)) {
            this.mFocusedGroup.setChanged(true);
        }
        this.notifyChange();
        this.notifyToRoot();
        return true;
    }

    private boolean hideEditField() {
        this.mTextField.setText("");
        this.mTextField.setVisible(false);
        return true;
    }

    private boolean clearFocusedGroup() {
        this.mFocusedGroup = null;
        return true;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        Rectangle2D rectangle2D;
        if (!this.isLegendVisible()) {
            return false;
        }
        if (this.mTextField.isVisible()) {
            this.terminateEditField();
        }
        if ((rectangle2D = this.getLegendRect()).contains(mouseEvent.getX(), mouseEvent.getY())) {
            this.mLegendLocation = new Point((int)this.mLegendX, (int)this.mLegendY);
            this.mPressedPoint = mouseEvent.getPoint();
            this.setMouseCursor(13);
            return true;
        }
        this.clearFocusedGroup();
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (this.isSelected()) {
            int n = mouseEvent.getX() - this.mPressedPoint.x;
            int n2 = mouseEvent.getY() - this.mPressedPoint.y;
            this.translate(n, n2);
            this.mPressedPoint = mouseEvent.getPoint();
            if (!this.createAllDrawingElements()) {
                return false;
            }
        }
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        Rectangle2D rectangle2D;
        if (this.mLegendLocation != null && this.isMoved()) {
            this.mChangedFlag = true;
        }
        if ((rectangle2D = this.getLegendRect()).contains(mouseEvent.getPoint())) {
            this.setMouseCursor(12);
        } else {
            this.setMouseCursor(0);
        }
        return true;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    public boolean setChangedFocusedObjects() {
        SGProperties sGProperties;
        SGProperties sGProperties2;
        if (this.isSelected() && (sGProperties2 = this.mTemporaryProperties) != null && !(sGProperties = this.getProperties()).equals(sGProperties2)) {
            this.setChanged(true);
        }
        return true;
    }

    public Rectangle2D getLegendRect() {
        float f = this.mMagnification;
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getLegendX(), this.getLegendY(), f * this.mLegendWidth, f * this.mLegendHeight);
        return float_;
    }

    public boolean isResizable(double d, double d2) {
        Rectangle2D rectangle2D = this.getLegendRect();
        return !(d < rectangle2D.getWidth()) && !(d2 < rectangle2D.getHeight());
    }

    public void caretUpdate(CaretEvent caretEvent) {
        String string = this.mTextField.getText();
        Font font = new Font(this.getFontName(), this.getFontStyle(), (int)(this.getFontSize() * this.getMagnification()));
        Rectangle2D rectangle2D = font.getStringBounds(string, new FontRenderContext(null, false, false));
        double d = rectangle2D.getWidth();
        if (d > (double)this.mTextField.getWidth()) {
            this.mTextField.setSize((int)(rectangle2D.getWidth() + (double)(this.getMagnification() * this.getFontSize())), this.mTextField.getHeight());
        }
    }

    public boolean onDrawingElement(int n, int n2) {
        if (this.isLegendVisible() && this.getLegendRect().contains(n, n2)) {
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    public boolean setAxisElement(SGIAxisElement sGIAxisElement) {
        this.mAxisElement = sGIAxisElement;
        return true;
    }

    public boolean setGraphElement(SGIGraphElement sGIGraphElement) {
        this.mGraphElement = sGIGraphElement;
        return true;
    }

    public int getXAxisConfiguration() {
        return this.mAxisElement.getConfigurationInPlane(this.mXAxis);
    }

    public int getYAxisConfiguration() {
        return this.mAxisElement.getConfigurationInPlane(this.mYAxis);
    }

    public void setXAxisConfiguration(int n) {
        this.mXAxis = this.getAxis(n);
    }

    public void setYAxisConfiguration(int n) {
        this.mYAxis = this.getAxis(n);
    }

    private SGAxis getAxis(int n) {
        return this.mAxisElement.getAxisInPlane(n);
    }

    public void setVisible(boolean bl) {
        this.mLegendVisibleFlag = bl;
    }

    public boolean setLegendVisible(boolean bl) {
        this.setVisible(bl);
        return true;
    }

    public void setBackgroundTransparent(boolean bl) {
        this.mLegendTransparentFlag = bl;
    }

    public boolean setFrameVisible(boolean bl) {
        this.mFrameVisibleFlag = bl;
        return true;
    }

    public void setFrameLineWidth(float f) {
        this.mFrameLineWidth = f;
    }

    public void setFrameLineWidth(float f, String string) {
        this.setFrameLineWidth((float)SGUtilityText.convertToPoint(f, string));
    }

    public void setFrameLineColor(Color color) {
        this.mFrameLineColor = color;
    }

    public void setBackgroundColor(Color color) {
        this.mBackgroundColor = color;
    }

    public boolean setFontSize(float f) {
        this.setFont(this.getFontName(), this.getFontStyle(), f);
        return true;
    }

    public boolean setFontSize(float f, String string) {
        return this.setFontSize((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setFontStyle(int n) {
        this.setFont(this.getFontName(), n, this.getFontSize());
        return true;
    }

    public void setStringColor(Color color) {
        this.mStringColor = color;
    }

    public boolean setFontName(String string) {
        this.setFont(string, this.getFontStyle(), this.getFontSize());
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        this.mFontName = string;
        this.mFontStyle = n;
        this.mFontSize = f;
        this.createAllDrawingElements();
        return true;
    }

    private SGData getData(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = this.mLegendList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend2 = (ElementGroupSetInLegend)arrayList.get(i);
            if (!elementGroupSetInLegend2.equals(elementGroupSetInLegend)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public boolean isVisible() {
        int n;
        int n2 = this.mLegendVisibleFlag;
        int n3 = 0;
        ArrayList arrayList = this.mLegendList;
        for (n = 0; n < arrayList.size(); ++n) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList.get(n);
            boolean bl = elementGroupSetInLegend.isVisibleTotally();
            if (!bl) continue;
            n3 = 1;
            break;
        }
        n = n2 & n3;
        return n != 0;
    }

    public boolean isLegendVisible() {
        return this.isVisible();
    }

    public boolean isFrameLineVisible() {
        return this.mFrameVisibleFlag;
    }

    public boolean isBackgroundTransparent() {
        return this.mLegendTransparentFlag;
    }

    public Rectangle2D getRectOfGroup(SGElementGroup sGElementGroup) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
            for (int j = 0; j < arrayList.size(); ++j) {
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(j);
                if (!sGElementGroup2.equals(sGElementGroup)) continue;
                return elementGroupSetInLegend.mDataRect;
            }
        }
        return null;
    }

    public Rectangle2D getRectOfGroupSet(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            if (!sGElementGroupSet.equals(elementGroupSetInLegend)) continue;
            return elementGroupSetInLegend.mDataRect;
        }
        return null;
    }

    private ElementGroupLine getGroupLine(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupLine)) continue;
            return (ElementGroupLine)sGElementGroup;
        }
        return null;
    }

    private ElementGroupBar getGroupBar(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupBar)) continue;
            return (ElementGroupBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupSymbol getGroupSymbol(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupSymbol)) continue;
            return (ElementGroupSymbol)sGElementGroup;
        }
        return null;
    }

    private ElementGroupErrorBar getGroupErrorBar(ElementGroupSetInLegend elementGroupSetInLegend) {
        ArrayList arrayList = elementGroupSetInLegend.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupErrorBar)) continue;
            return (ElementGroupErrorBar)sGElementGroup;
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Object object = actionEvent.getSource();
        if (object.equals(this.mTextField)) {
            this.terminateEditField();
            return;
        }
        if (string.equals(MENUCMD_HIDE)) {
            this.setLegendVisible(false);
            this.repaint();
            this.setChanged(true);
            this.notifyToRoot();
            return;
        }
        if (string.equals("Property")) {
            this.setPropertiesOfSelectedObjects();
        }
    }

    public boolean commit() {
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.mChangedFlag = true;
        }
        this.mTemporaryProperties = null;
        this.createAllDrawingElements();
        this.repaint();
        this.notifyChange();
        return true;
    }

    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.createAllDrawingElements();
        this.repaint();
        this.notifyChange();
        return true;
    }

    public boolean preview() {
        this.createAllDrawingElements();
        this.repaint();
        this.notifyChange();
        return true;
    }

    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.createAllDrawingElements();
        this.notifyChange();
        return true;
    }

    public boolean isChanged() {
        if (super.isChanged()) {
            return true;
        }
        ArrayList arrayList = this.getVisibleLegendList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            if (!sGIUndoable.isChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean updateHistory() {
        return this.updateHistory(this.getVisibleLegendList());
    }

    protected ArrayList getVisibleLegendList() {
        ArrayList<ElementGroupSetInLegend> arrayList = new ArrayList<ElementGroupSetInLegend>();
        ArrayList arrayList2 = this.mLegendList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList2.get(i);
            if (!elementGroupSetInLegend.isVisible()) continue;
            arrayList.add(elementGroupSetInLegend);
        }
        return arrayList;
    }

    protected ArrayList getVisibleTotallyLegendList() {
        ArrayList<ElementGroupSetInLegend> arrayList = new ArrayList<ElementGroupSetInLegend>();
        ArrayList arrayList2 = this.mLegendList;
        for (int i = 0; i < arrayList2.size(); ++i) {
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)arrayList2.get(i);
            if (!elementGroupSetInLegend.isVisibleTotally()) continue;
            arrayList.add(elementGroupSetInLegend);
        }
        return arrayList;
    }

    protected ElementGroupSetInLegend getElementGroupSet(SGData sGData) {
        for (int i = 0; i < this.mDataList.size(); ++i) {
            SGData sGData2 = (SGData)this.mDataList.get(i);
            if (!sGData2.equals(sGData)) continue;
            ElementGroupSetInLegend elementGroupSetInLegend = (ElementGroupSetInLegend)this.mLegendList.get(i);
            return elementGroupSetInLegend;
        }
        return null;
    }

    protected SGData getData(SGElementGroupSet sGElementGroupSet) {
        for (int i = 0; i < this.mLegendList.size(); ++i) {
            SGElementGroupSet sGElementGroupSet2 = (SGElementGroupSet)this.mLegendList.get(i);
            if (!sGElementGroupSet2.equals(sGElementGroupSet)) continue;
            SGData sGData = (SGData)this.mDataList.get(i);
            return sGData;
        }
        return null;
    }

    public boolean createDataObject(Element element, SGData sGData) {
        if (!super.createDataObject(element, sGData)) {
            return false;
        }
        ElementGroupSetInLegend elementGroupSetInLegend = this.getGroupSetNewInstance(sGData);
        if (elementGroupSetInLegend == null) {
            return false;
        }
        this.mLegendList.add(elementGroupSetInLegend);
        int n = this.setProperty(element, elementGroupSetInLegend);
        if (n == 1) {
            return false;
        }
        this.createAllDrawingElements();
        this.mStartFlag = false;
        this.createDataDialog(sGData);
        return true;
    }

    protected ElementGroupSetInLegend getGroupSetNewInstance(SGData sGData) {
        ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = null;
        if (sGData instanceof SGISXYTypeData | sGData instanceof SGISXYTypeMultipleData) {
            elementGroupSetInLegendSXY = new ElementGroupSetInLegendSXY();
        }
        return elementGroupSetInLegendSXY;
    }

    private int setProperty(Element element, ElementGroupSetInLegend elementGroupSetInLegend) {
        SGData sGData = this.getData(elementGroupSetInLegend);
        int n = 1;
        if (sGData instanceof SGISXYTypeData | sGData instanceof SGISXYTypeMultipleData) {
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)elementGroupSetInLegend;
            n = this.setPropertyOfElementGroupSetInLegendSXY(element, elementGroupSetInLegendSXY, sGData);
        } else if (sGData instanceof SGVXYData) {
            // empty if block
        }
        return n;
    }

    private int setPropertyOfElementGroupSetInLegendSXY(Element element, ElementGroupSetInLegendSXY elementGroupSetInLegendSXY, SGData sGData) {
        Object object;
        SGIAxisElement sGIAxisElement = this.mAxisElement;
        String string = null;
        string = element.getAttribute("Name");
        if (string.length() == 0) {
            return 1;
        }
        String string2 = string;
        elementGroupSetInLegendSXY.setName(string2);
        string = element.getAttribute("XAxisPosition");
        if (string.length() == 0) {
            return 1;
        }
        int n = sGIAxisElement.getConfigurationInCube(string);
        string = element.getAttribute("YAxisPosition");
        if (string.length() == 0) {
            return 1;
        }
        int n2 = sGIAxisElement.getConfigurationInCube(string);
        elementGroupSetInLegendSXY.setXAxis(sGIAxisElement.getAxisInCube(n));
        elementGroupSetInLegendSXY.setYAxis(sGIAxisElement.getAxisInCube(n2));
        string = element.getAttribute("VisibleInLegend");
        if (string.length() == 0) {
            return 1;
        }
        Boolean bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return 1;
        }
        elementGroupSetInLegendSXY.setVisibleInLegend(bl);
        SGElementGroupSXY sGElementGroupSXY = null;
        NodeList nodeList = null;
        nodeList = element.getElementsByTagName("Line");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInLegendSXY.addDrawingElementGroup(0)) {
            return 1;
        }
        Element element2 = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInLegendSXY.getLineGroup();
        if (!sGElementGroupSXY.readProperty(element2)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("Symbol");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInLegendSXY.addDrawingElementGroup(1)) {
            return 1;
        }
        Element element3 = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInLegendSXY.getSymbolGroup();
        if (!sGElementGroupSXY.readProperty(element3)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("Bar");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInLegendSXY.addDrawingElementGroup(2)) {
            return 1;
        }
        Element element4 = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInLegendSXY.getBarGroup();
        if (!sGElementGroupSXY.readProperty(element4)) {
            return 1;
        }
        ElementGroupBar elementGroupBar = (ElementGroupBar)sGElementGroupSXY;
        float f = elementGroupBar.getRectangleWidth();
        if (f != 0.0f) {
            float f2 = f / this.mGraphRectWidth;
            object = elementGroupSetInLegendSXY.getXAxis();
            double d = ((SGAxis)object).getMaxValue();
            double d2 = ((SGAxis)object).getMinValue();
            double d3 = (d - d2) * (double)f2;
            d3 = this.getNumberInRangeOrder(d3, (SGAxis)object);
            elementGroupBar.setWidthValue(d3);
        }
        if (sGData instanceof SGISXYTypeData) {
            SGISXYTypeData sGISXYTypeData = (SGISXYTypeData)((Object)sGData);
            nodeList = element.getElementsByTagName("ErrorBar");
            if (nodeList.getLength() == 1) {
                if (sGISXYTypeData.isErrorValueHolding()) {
                    Element element5;
                    if (!elementGroupSetInLegendSXY.addDrawingElementGroup(4)) {
                        return 1;
                    }
                    object = (ElementGroupErrorBar)elementGroupSetInLegendSXY.getErrorBarGroup();
                    if (!((SGElementGroup)object).readProperty(element5 = (Element)nodeList.item(0))) {
                        return 1;
                    }
                    if (!((SGElementGroupErrorBar)object).setPropertiesOfDrawingElements()) {
                        return 1;
                    }
                }
            } else if (nodeList.getLength() == 0) {
                if (sGISXYTypeData.isErrorValueHolding()) {
                    if (!elementGroupSetInLegendSXY.addDrawingElementGroup(4)) {
                        return 1;
                    }
                    object = (ElementGroupErrorBar)elementGroupSetInLegendSXY.getErrorBarGroup();
                    if (!((SGElementGroupErrorBar)object).setPropertiesOfDrawingElements()) {
                        return 1;
                    }
                }
            } else {
                return 1;
            }
            if ((nodeList = element.getElementsByTagName("TickLabels")).getLength() == 1) {
                if (sGISXYTypeData.isStringArrayHolding()) {
                    Element element6;
                    if (!elementGroupSetInLegendSXY.addDrawingElementGroup(5)) {
                        return 1;
                    }
                    object = (ElementGroupTickLabels)elementGroupSetInLegendSXY.getTickLabelGroup();
                    if (!((SGElementGroup)object).readProperty(element6 = (Element)nodeList.item(0))) {
                        return 1;
                    }
                    if (!((SGElementGroupString)object).setPropertiesOfDrawingElements()) {
                        return 1;
                    }
                }
            } else if (nodeList.getLength() == 0) {
                if (sGISXYTypeData.isStringArrayHolding()) {
                    if (!elementGroupSetInLegendSXY.addDrawingElementGroup(5)) {
                        return 1;
                    }
                    object = (ElementGroupTickLabels)elementGroupSetInLegendSXY.getTickLabelGroup();
                    if (!((SGElementGroupString)object).setPropertiesOfDrawingElements()) {
                        return 1;
                    }
                }
            } else {
                return 1;
            }
        }
        elementGroupSetInLegendSXY.initPropertiesHistory();
        return 0;
    }

    public String getTagName() {
        return "Legend";
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("LegendVisible", Boolean.toString(this.mLegendVisibleFlag));
        element.setAttribute("XAxisPosition", this.mAxisElement.getAxisLocation(this.mXAxis));
        element.setAttribute("YAxisPosition", this.mAxisElement.getAxisLocation(this.mYAxis));
        element.setAttribute("XValue", Double.toString(this.getXValue()));
        element.setAttribute("YValue", Double.toString(this.getYValue()));
        element.setAttribute("FrameVisible", Boolean.toString(this.mFrameVisibleFlag));
        element.setAttribute("FrameLineWidth", Float.toString(this.mFrameLineWidth) + "pt");
        element.setAttribute("FrameLineColor", SGUtilityText.getColorString(this.mFrameLineColor));
        element.setAttribute("BackgroundColor", SGUtilityText.getColorString(this.mBackgroundColor));
        element.setAttribute("BackgroundTransparent", Boolean.toString(this.mLegendTransparentFlag));
        element.setAttribute("FontName", this.mFontName);
        element.setAttribute("FontSize", Float.toString(this.mFontSize) + "pt");
        element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.mFontStyle));
        element.setAttribute("StringColor", SGUtilityText.getColorString(this.mStringColor));
        element.setAttribute("SymbolSpan", Float.toString(this.mSymbolSpan * 0.035277776f) + "cm");
        return true;
    }

    public Element createElement(Document document) {
        return this.createThisElement(document);
    }

    public boolean readProperty(Element element) {
        LegendCommonProperties legendCommonProperties = this.readProperties(element);
        if (legendCommonProperties == null) {
            return false;
        }
        return this.setProperties(legendCommonProperties);
    }

    private LegendCommonProperties readProperties(Element element) {
        String string = null;
        Number number = null;
        Color color = null;
        Boolean bl = null;
        string = element.getAttribute("LegendVisible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl2 = bl;
        string = element.getAttribute("XAxisPosition");
        if (string.length() == 0) {
            return null;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis(string);
        string = element.getAttribute("YAxisPosition");
        if (string.length() == 0) {
            return null;
        }
        SGAxis sGAxis2 = this.mAxisElement.getAxis(string);
        string = element.getAttribute("XValue");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d = number.doubleValue();
        if (!sGAxis.isValidValue(d)) {
            return null;
        }
        float f = this.calcLocation(d, sGAxis, true);
        float f2 = (f - this.mGraphRectX) / this.mMagnification;
        string = element.getAttribute("YValue");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getDouble(string);
        if (number == null) {
            return null;
        }
        double d2 = number.doubleValue();
        if (!sGAxis2.isValidValue(d2)) {
            return null;
        }
        float f3 = this.calcLocation(d2, sGAxis2, false);
        float f4 = (f3 - this.mGraphRectY) / this.mMagnification;
        string = element.getAttribute("FrameVisible");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl3 = bl;
        string = element.getAttribute("FrameLineWidth");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getLengthInPoint(string);
        if (number == null) {
            return null;
        }
        float f5 = number.floatValue();
        string = element.getAttribute("FrameLineColor");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        Color color2 = color;
        string = element.getAttribute("BackgroundColor");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        Color color3 = color;
        string = element.getAttribute("BackgroundTransparent");
        if (string.length() == 0) {
            return null;
        }
        bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return null;
        }
        boolean bl4 = bl;
        string = element.getAttribute("FontName");
        if (string.length() == 0) {
            return null;
        }
        String string2 = string;
        string = element.getAttribute("FontSize");
        if (string.length() == 0) {
            return null;
        }
        number = SGUtilityText.getLengthInPoint(string);
        if (number == null) {
            return null;
        }
        float f6 = number.floatValue();
        string = element.getAttribute("FontStyle");
        if (string.length() == 0) {
            return null;
        }
        int n = SGUtilityText.getFontStyle(string);
        if (n == -1) {
            return null;
        }
        string = element.getAttribute("StringColor");
        if (string.length() == 0) {
            return null;
        }
        color = SGUtilityText.getColorFromString(string);
        if (color == null) {
            return null;
        }
        Color color4 = color;
        string = element.getAttribute("SymbolSpan");
        if (string.length() != 0) {
            number = SGUtilityText.getLengthInPoint(string);
            if (number == null) {
                return null;
            }
        } else {
            number = new Float(42.519688f);
        }
        float f7 = number.floatValue();
        LegendCommonProperties legendCommonProperties = new LegendCommonProperties();
        legendCommonProperties.visible = bl2;
        legendCommonProperties.x = f2;
        legendCommonProperties.y = f4;
        legendCommonProperties.frameLineVisible = bl3;
        legendCommonProperties.frameLineWidth = f5;
        legendCommonProperties.frameLineColor = color2;
        legendCommonProperties.backgroundColor = color3;
        legendCommonProperties.transparent = bl4;
        legendCommonProperties.fontName = string2;
        legendCommonProperties.fontSize = f6;
        legendCommonProperties.fontStyle = n;
        legendCommonProperties.stringColor = color4;
        legendCommonProperties.symbolSpan = f7;
        legendCommonProperties.xAxis = sGAxis;
        legendCommonProperties.yAxis = sGAxis2;
        return legendCommonProperties;
    }

    public static class LegendCommonProperties
    extends SGProperties {
        float x;
        float y;
        boolean visible;
        boolean frameLineVisible;
        float frameLineWidth;
        Color frameLineColor;
        String fontName;
        float fontSize;
        int fontStyle;
        Color stringColor;
        Color backgroundColor;
        boolean transparent;
        float symbolSpan;
        SGAxis xAxis;
        SGAxis yAxis;

        public void dispose() {
            this.frameLineColor = null;
            this.fontName = null;
            this.stringColor = null;
            this.stringColor = null;
            this.xAxis = null;
            this.yAxis = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof LegendCommonProperties)) {
                return false;
            }
            LegendCommonProperties legendCommonProperties = (LegendCommonProperties)object;
            if (legendCommonProperties.x != this.x) {
                return false;
            }
            if (legendCommonProperties.y != this.y) {
                return false;
            }
            if (legendCommonProperties.visible != this.visible) {
                return false;
            }
            if (legendCommonProperties.frameLineVisible != this.frameLineVisible) {
                return false;
            }
            if (legendCommonProperties.frameLineWidth != this.frameLineWidth) {
                return false;
            }
            if (!legendCommonProperties.frameLineColor.equals(this.frameLineColor)) {
                return false;
            }
            if (!legendCommonProperties.fontName.equals(this.fontName)) {
                return false;
            }
            if (legendCommonProperties.fontSize != this.fontSize) {
                return false;
            }
            if (legendCommonProperties.fontStyle != this.fontStyle) {
                return false;
            }
            if (!legendCommonProperties.stringColor.equals(this.stringColor)) {
                return false;
            }
            if (!legendCommonProperties.backgroundColor.equals(this.backgroundColor)) {
                return false;
            }
            if (legendCommonProperties.transparent != this.transparent) {
                return false;
            }
            return legendCommonProperties.symbolSpan == this.symbolSpan;
        }

        public String toString() {
            String string = new String("[");
            string = string + new String("x=" + this.x + ", ");
            string = string + new String("y=" + this.y + ", ");
            string = string + new String("visible=" + this.visible + ", ");
            string = string + new String("frameLineVisible=" + this.frameLineVisible + ", ");
            string = string + new String("frameLineWidth=" + this.frameLineWidth + ", ");
            string = string + new String("frameLineColor=" + this.frameLineColor + ", ");
            string = string + new String("fontName=" + this.fontName + ", ");
            string = string + new String("fontSize=" + this.fontSize + ", ");
            string = string + new String("fontStyle=" + this.fontStyle + ", ");
            string = string + new String("stringColor=" + this.stringColor + ", ");
            string = string + new String("innerColor=" + this.backgroundColor + ", ");
            string = string + new String("transparent=" + this.transparent + ", ");
            string = string + new String("]");
            return string;
        }
    }

    class ElementGroupTickLabels
    extends SGElementGroupTickLabel
    implements ILegendElement {
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();

        ElementGroupTickLabels() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setFont("Serif", SGUtilityText.getFontStyle("Plain"), 16.0f);
            Float f = SGElementGroupTickLabel.getTickLabelAngleFromName("Horizontal");
            if (f == null) {
                return false;
            }
            this.setAngle(f.floatValue());
            this.setColor(SGDefaultValues.TICK_LABEL_COLOR);
            return true;
        }

        public boolean createDrawingElementInLegend() {
            return true;
        }

        public float getPreferredWidth() {
            return 0.0f;
        }

        public float getPreferredHeight() {
            return 0.0f;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 0;
        }
    }

    class ElementGroupErrorBar
    extends SGElementGroupErrorBar
    implements ILegendElement {
        private static final float DEFAULT_ERROR_BAR_HEIGHT = 10.0f;
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();

        ElementGroupErrorBar() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            this.setHeadSize(7.0866146f);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Transverse Line");
            if (n == null) {
                return false;
            }
            this.setHeadType(n);
            this.setLineWidth(1.0f);
            Integer n2 = SGDrawingElementErrorBar.getErrorBarStyleFromName("Bothsides");
            if (n2 == null) {
                return false;
            }
            this.setErrorBarStyle(n2);
            this.setColor(SGDefaultValues.ERROR_BAR_COLOR);
            return true;
        }

        public float getPreferredWidth() {
            return this.getMagnification() * this.getHeadSize();
        }

        public float getPreferredHeight() {
            float f;
            float f2;
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)this.mGroupSet;
            SGElementGroupSymbol sGElementGroupSymbol = elementGroupSetInLegendSXY.getSymbolGroup();
            SGElementGroupBar sGElementGroupBar = elementGroupSetInLegendSXY.getBarGroup();
            float f3 = 0.0f;
            if (sGElementGroupSymbol.isVisible() | sGElementGroupBar.isVisible()) {
                f2 = sGElementGroupSymbol.isVisible() ? ((ILegendElement)((Object)sGElementGroupSymbol)).getPreferredHeight() : 0.0f;
                f = sGElementGroupBar.isVisible() ? ((ILegendElement)((Object)sGElementGroupBar)).getPreferredHeight() : 0.0f;
                f3 = f2 > f ? f2 : f;
            } else {
                f3 = 10.0f;
            }
            f2 = this.getMagnification();
            f = 1.2f * f2 * f3;
            float f4 = f2 * this.getHeadSize();
            return f + 2.0f * f4;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            float f;
            SGTuple2f sGTuple2f = new SGTuple2f();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f2 = this.getMagnification();
            float f3 = f2 * SGLegendElement.this.getSymbolSpan();
            sGTuple2f.x = f = (float)rectangle2D.getX() + 0.5f * (float)rectangle2D2.getWidth();
            sGTuple2f2.x = f;
            float f4 = f2 * this.getHeadSize();
            float f5 = (float)rectangle2D.getY() + 0.5f * f4;
            float f6 = (float)rectangle2D2.getHeight() - f4;
            int n = this.getErrorBarStyle();
            switch (n) {
                case 1: {
                    sGTuple2f.y = f5 + f6;
                    sGTuple2f2.y = f5;
                    break;
                }
                case 3: {
                    sGTuple2f.y = f5 + f6;
                    sGTuple2f2.y = f5 + 0.5f * f6;
                    break;
                }
                case 2: {
                    sGTuple2f.y = f5 + 0.5f * f6;
                    sGTuple2f2.y = f5;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            return this.setLocation(new SGTuple2f[]{sGTuple2f}, new SGTuple2f[]{sGTuple2f2});
        }
    }

    class ElementGroupArrow
    extends SGElementGroupArrow
    implements ILegendElement {
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();

        protected ElementGroupArrow() {
        }

        public float getPreferredWidth() {
            return this.getMagnification() * SGLegendElement.this.getSymbolSpan();
        }

        public float getPreferredHeight() {
            return 0.0f;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            float f = this.getPreferredWidth();
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX() + 0.1f * f;
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            sGTuple2f2.x = sGTuple2f.x + 0.8f * f;
            sGTuple2f2.y = sGTuple2f.y;
            return this.setLocation(new SGTuple2f[]{sGTuple2f}, new SGTuple2f[]{sGTuple2f2});
        }
    }

    class ElementGroupSymbol
    extends SGElementGroupSymbol
    implements ILegendElement {
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();

        protected ElementGroupSymbol() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Circle");
            if (n == null) {
                return false;
            }
            this.setType(n);
            this.setSize(8.503938f);
            this.setColor(SGDefaultValues.SYMBOL_BODY_COLOR);
            this.setLineWidth(1.0f);
            this.setLineColor(SGDefaultValues.SYMBOL_LINE_COLOR);
            return true;
        }

        public float getPreferredWidth() {
            return this.getDataElementSize();
        }

        public float getPreferredHeight() {
            return 1.2f * this.getDataElementSize();
        }

        private float getDataElementSize() {
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            if (sGDrawingElementArray != null) {
                if (sGDrawingElementArray.length == 0) {
                    return 0.0f;
                }
                SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[0];
                Rectangle2D rectangle2D = sGDrawingElementSymbol2D.getElementBounds().getBounds2D();
                return (float)rectangle2D.getHeight();
            }
            return 0.0f;
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f = (float)rectangle2D.getX() + 0.5f * (float)rectangle2D2.getWidth();
            float f2 = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f = new SGTuple2f(f, f2);
            return this.setLocation(new SGTuple2f[]{sGTuple2f});
        }
    }

    class ElementGroupBar
    extends SGElementGroupBar
    implements ILegendElement {
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();

        protected ElementGroupBar() {
            this.init();
        }

        private void init() {
            this.setVisible(false);
            this.setBaselineValue(0.0);
            this.setColor(SGDefaultValues.BAR_COLOR);
            this.setEdgeLineWidth(0.5f);
            this.setEdgeLineColor(SGDefaultValues.BAR_LINE_COLOR);
        }

        public float getPreferredWidth() {
            ElementGroupSetInLegendSXY elementGroupSetInLegendSXY = (ElementGroupSetInLegendSXY)this.mGroupSet;
            Rectangle2D rectangle2D = elementGroupSetInLegendSXY.mDrawingString.getElementBounds();
            return (float)rectangle2D.getHeight();
        }

        public float getPreferredHeight() {
            return this.getPreferredWidth();
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 1;
        }

        public boolean createDrawingElementInLegend() {
            float f;
            float f2 = f = this.getPreferredWidth();
            this.setWidth(f2);
            this.setHeight(f);
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            float f3 = (float)rectangle2D.getX() + 0.5f * ((float)rectangle2D2.getWidth() - f2);
            float f4 = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f = new SGTuple2f(f3, f4);
            this.setLocation(new SGTuple2f[]{sGTuple2f});
            return true;
        }

        protected boolean initDrawingElement(int n) {
            super.initDrawingElement(n);
            this.setHorizontal(true);
            return true;
        }

        protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
            super.initDrawingElement(sGTuple2fArray);
            this.setHorizontal(true);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            if (this.mDrawingElementArray == null) {
                return true;
            }
            if (sGTuple2fArray.length != this.mDrawingElementArray.length) {
                throw new IllegalArgumentException();
            }
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                sGDrawingElementBar2D.setLocation(sGTuple2fArray[i].x, sGTuple2fArray[i].y);
            }
            return true;
        }
    }

    class ElementGroupLine
    extends SGElementGroupLine
    implements ILegendElement {
        private Rectangle2D mBoundsRect = new Rectangle2D.Float();

        protected ElementGroupLine() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            Integer n = SGDrawingElementLine.getLineTypeFromName("Solid");
            if (n == null) {
                return false;
            }
            this.setLineType(n);
            this.setColor(SGDefaultValues.LINE_COLOR);
            return true;
        }

        public float getPreferredWidth() {
            return this.getMagnification() * SGLegendElement.this.getSymbolSpan();
        }

        public float getPreferredHeight() {
            return this.getMagnification() * this.getLineWidth();
        }

        public void setDataElementBounds(Rectangle2D rectangle2D) {
            this.mBoundsRect = rectangle2D;
        }

        public int getNumberOfPoints() {
            return 2;
        }

        public boolean createDrawingElementInLegend() {
            Rectangle2D rectangle2D = SGLegendElement.this.getRectOfGroupSet(this.mGroupSet);
            Rectangle2D rectangle2D2 = this.mBoundsRect;
            SGTuple2f sGTuple2f = new SGTuple2f();
            sGTuple2f.x = (float)rectangle2D.getX();
            sGTuple2f.y = (float)rectangle2D.getY() + 0.5f * (float)rectangle2D.getHeight();
            SGTuple2f sGTuple2f2 = new SGTuple2f();
            sGTuple2f2.x = sGTuple2f.x + (float)rectangle2D2.getWidth();
            sGTuple2f2.y = sGTuple2f.y;
            return this.setLocation(new SGTuple2f[]{sGTuple2f, sGTuple2f2});
        }
    }

    class ElementGroupSetInLegendSXY
    extends ElementGroupSetInLegend
    implements SGISXYDataDialogObserver {
        protected SGPropertyDialogSXYData mDialog = null;
        private int mSelectedTabIndex = -1;

        protected ElementGroupSetInLegendSXY() {
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        public int getSelectedTabIndex() {
            return this.mSelectedTabIndex;
        }

        public boolean isLineVisible() {
            return this.getLineGroup().isVisible();
        }

        public float getLineWidth() {
            return this.getLineGroup().getLineWidth();
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public int getLineType() {
            return this.getLineGroup().getLineType();
        }

        public Color getLineColor() {
            return this.getLineGroup().getColor(0);
        }

        public boolean setLineVisible(boolean bl) {
            this.getLineGroup().setVisible(bl);
            return true;
        }

        public boolean setLineWidth(float f) {
            return this.getLineGroup().setLineWidth(f);
        }

        public boolean setLineWidth(float f, String string) {
            return this.setLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setLineType(int n) {
            return this.getLineGroup().setLineType(n);
        }

        public boolean setLineColor(Color color) {
            return this.getLineGroup().setColor(color);
        }

        public boolean isSymbolVisible() {
            return this.getSymbolGroup().isVisible();
        }

        public int getSymbolType() {
            return this.getSymbolGroup().getType();
        }

        public float getSymbolSize() {
            return this.getSymbolGroup().getSize();
        }

        public float getSymbolSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolSize(), string);
        }

        public float getSymbolLineWidth() {
            return this.getSymbolGroup().getLineWidth();
        }

        public float getSymbolLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolLineWidth(), string);
        }

        public Color getSymbolInnerColor() {
            return this.getSymbolGroup().getColor(0);
        }

        public Color getSymbolLineColor() {
            return this.getSymbolGroup().getLineColor();
        }

        public boolean setSymbolVisible(boolean bl) {
            this.getSymbolGroup().setVisible(bl);
            return true;
        }

        public boolean setSymbolType(int n) {
            return this.getSymbolGroup().setType(n);
        }

        public boolean setSymbolSize(float f) {
            return this.getSymbolGroup().setSize(f);
        }

        public boolean setSymbolSize(float f, String string) {
            return this.setSymbolSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setSymbolLineWidth(float f) {
            return this.getSymbolGroup().setLineWidth(f);
        }

        public boolean setSymbolLineWidth(float f, String string) {
            return this.setSymbolLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setSymbolInnerColor(Color color) {
            return this.getSymbolGroup().setColor(color);
        }

        public boolean setSymbolLineColor(Color color) {
            return this.getSymbolGroup().setLineColor(color);
        }

        public boolean isBarVisible() {
            return this.getBarGroup().isVisible();
        }

        public double getBarBaselineValue() {
            return this.getBarGroup().getBaselineValue();
        }

        public float getBarWidth() {
            return this.getBarGroup().getRectangleWidth();
        }

        public double getBarWidthValue() {
            return this.getBarGroup().getWidthValue();
        }

        public float getBarEdgeLineWidth() {
            return this.getBarGroup().getEdgeLineWidth();
        }

        public float getBarEdgeLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getBarEdgeLineWidth(), string);
        }

        public Color getBarInnerColor() {
            return this.getBarGroup().getColor(0);
        }

        public Color getBarEdgeLineColor() {
            return this.getBarGroup().getEdgeLineColor();
        }

        public boolean setBarVisible(boolean bl) {
            this.getBarGroup().setVisible(bl);
            return true;
        }

        public boolean setBarBaselineValue(double d) {
            return this.getBarGroup().setBaselineValue(d);
        }

        public boolean setBarWidth(float f) {
            return this.getBarGroup().setRectangleWidth(f);
        }

        public boolean setBarWidthValue(double d) {
            return this.getBarGroup().setWidthValue(d);
        }

        public boolean setBarEdgeLineWidth(float f) {
            return this.getBarGroup().setEdgeLineWidth(f);
        }

        public boolean setBarEdgeLineWidth(float f, String string) {
            return this.setBarEdgeLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setBarInnerColor(Color color) {
            return this.getBarGroup().setColor(color);
        }

        public boolean setBarEdgeLineColor(Color color) {
            return this.getBarGroup().setEdgeLineColor(color);
        }

        public boolean hasValidBaselineValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGLegendElement.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getBarBaselineValue();
            return sGAxis.isValidValue(d);
        }

        public boolean isErrorBarHolding() {
            return this.getErrorBarGroup() != null;
        }

        public boolean isErrorBarVisible() {
            return this.getErrorBarGroup().isVisible();
        }

        public int getErrorBarHeadType() {
            return this.getErrorBarGroup().getHeadType();
        }

        public float getErrorBarHeadSize() {
            return this.getErrorBarGroup().getHeadSize();
        }

        public float getErrorBarHeadSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarHeadSize(), string);
        }

        public Color getErrorBarColor() {
            return this.getErrorBarGroup().getColor(0);
        }

        public float getErrorBarLineWidth() {
            return this.getErrorBarGroup().getLineWidth();
        }

        public float getErrorBarLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarLineWidth(), string);
        }

        public int getErrorBarStyle() {
            return this.getErrorBarGroup().getErrorBarStyle();
        }

        public boolean setErrorBarVisible(boolean bl) {
            this.getErrorBarGroup().setVisible(bl);
            return true;
        }

        public boolean setErrorBarHeadType(int n) {
            this.getErrorBarGroup().setHeadType(n);
            return true;
        }

        public boolean setErrorBarHeadSize(float f) {
            this.getErrorBarGroup().setHeadSize(f);
            return true;
        }

        public boolean setErrorBarHeadSize(float f, String string) {
            return this.setErrorBarHeadSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setErrorBarColor(Color color) {
            return this.getErrorBarGroup().setColor(color);
        }

        public boolean setErrorBarLineWidth(float f) {
            this.getErrorBarGroup().setLineWidth(f);
            return true;
        }

        public boolean setErrorBarLineWidth(float f, String string) {
            return this.setErrorBarLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setErrorBarStyle(int n) {
            this.getErrorBarGroup().setErrorBarStyle(n);
            return true;
        }

        public boolean isTickLabelHolding() {
            return this.getTickLabelGroup() != null;
        }

        public boolean isTickLabelVisible() {
            return this.getTickLabelGroup().isVisible();
        }

        public String getTickLabelFontName() {
            return this.getTickLabelGroup().getFontName();
        }

        public int getTickLabelFontStyle() {
            return this.getTickLabelGroup().getFontStyle();
        }

        public float getTickLabelFontSize() {
            return this.getTickLabelGroup().getFontSize();
        }

        public float getTickLabelFontSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getTickLabelFontSize(), string);
        }

        public Color getTickLabelColor() {
            return this.getTickLabelGroup().getColor(0);
        }

        public boolean isTickLabelHorizontal() {
            return this.getTickLabelGroup().getAngle() == 0.0f;
        }

        public boolean setTickLabelVisible(boolean bl) {
            this.getTickLabelGroup().setVisible(bl);
            return true;
        }

        public boolean setTickLabelFontName(String string) {
            return this.getTickLabelGroup().setFontName(string);
        }

        public boolean setTickLabelFontStyle(int n) {
            return this.getTickLabelGroup().setFontStyle(n);
        }

        public boolean setTickLabelFontSize(float f) {
            return this.getTickLabelGroup().setFontSize(f);
        }

        public boolean setTickLabelFontSize(float f, String string) {
            return this.setTickLabelFontSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setTickLabelColor(Color color) {
            return this.getTickLabelGroup().setColor(color);
        }

        public boolean setTickLabelHorizontal(boolean bl) {
            float f = bl ? 0.0f : 0.5235988f;
            return this.getTickLabelGroup().setAngle(f);
        }

        protected boolean onMouseClicked(MouseEvent mouseEvent) {
            SGElementGroup sGElementGroup = this.getElementGroupAt(mouseEvent.getX(), mouseEvent.getY());
            int n = -1;
            if (sGElementGroup instanceof ElementGroupLine) {
                n = 0;
            } else if (sGElementGroup instanceof ElementGroupSymbol) {
                n = 1;
            } else if (sGElementGroup instanceof ElementGroupBar) {
                n = 2;
            } else if (sGElementGroup instanceof ElementGroupErrorBar) {
                n = 3;
            } else if (sGElementGroup instanceof ElementGroupTickLabels) {
                n = 4;
            }
            this.mSelectedTabIndex = n;
            return true;
        }

        public boolean addDrawingElementGroup(int n) {
            SGElementGroup sGElementGroup = null;
            if (n == 0) {
                sGElementGroup = new ElementGroupLine();
            } else if (n == 2) {
                sGElementGroup = new ElementGroupBar();
            } else if (n == 1) {
                sGElementGroup = new ElementGroupSymbol();
            } else if (n == 3) {
                sGElementGroup = new ElementGroupArrow();
            } else if (n == 4) {
                sGElementGroup = new ElementGroupErrorBar();
            } else if (n == 5) {
                sGElementGroup = new ElementGroupTickLabels();
            } else {
                throw new Error();
            }
            this.addDrawingElementGroup(sGElementGroup);
            return true;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public boolean commit() {
            SGLegendElement.this.updateSymbolsVisibleAroundFocusedObjects();
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getWholeProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.setChanged(true);
            }
            this.mTemporaryProperties = null;
            if (!SGLegendElement.this.createAllDrawingElements()) {
                return false;
            }
            SGLegendElement.this.repaint();
            SGLegendElement.this.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setWholeProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            if (!SGLegendElement.this.createAllDrawingElements()) {
                return false;
            }
            SGLegendElement.this.repaint();
            SGLegendElement.this.notifyChange();
            return true;
        }

        public boolean preview() {
            SGLegendElement.this.updateSymbolsVisibleAroundFocusedObjects();
            if (!SGLegendElement.this.createAllDrawingElements()) {
                return false;
            }
            SGLegendElement.this.repaint();
            SGLegendElement.this.notifyChange();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return this.mDialog;
        }

        public int getXAxisConfiguration() {
            return SGLegendElement.this.mAxisElement.getConfigurationInPlane(this.getXAxis());
        }

        public int getYAxisConfiguration() {
            return SGLegendElement.this.mAxisElement.getConfigurationInPlane(this.getYAxis());
        }

        public void setXAxisConfiguration(int n) {
            this.mXAxis = this.getAxis(n);
        }

        public void setYAxisConfiguration(int n) {
            this.mYAxis = this.getAxis(n);
        }

        private SGAxis getAxis(int n) {
            return SGLegendElement.this.mAxisElement.getAxisInPlane(n);
        }

        boolean synchronizeDrawingElements(ArrayList arrayList) {
            boolean bl = false;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(i);
                ArrayList arrayList2 = null;
                if (sGDrawingElement instanceof SGDrawingElementErrorBar) {
                    arrayList2 = this.getErrorBarGroups();
                } else if (sGDrawingElement instanceof SGDrawingElementLine) {
                    arrayList2 = this.getLineGroups();
                } else if (sGDrawingElement instanceof SGDrawingElementSymbol) {
                    arrayList2 = this.getSymbolGroups();
                } else if (sGDrawingElement instanceof SGDrawingElementBar) {
                    arrayList2 = this.getBarGroups();
                } else if (sGDrawingElement instanceof SGDrawingElementString) {
                    arrayList2 = this.getTickLabelGroups();
                }
                if (arrayList2 == null) continue;
                for (int j = 0; j < arrayList2.size(); ++j) {
                    SGProperties sGProperties;
                    SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(j);
                    SGDrawingElement sGDrawingElement2 = sGElementGroup.getDrawingElement();
                    SGProperties sGProperties2 = sGDrawingElement.getProperties();
                    if (!sGProperties2.equals(sGProperties = sGDrawingElement2.getProperties())) {
                        bl = true;
                    }
                    sGElementGroup.setProperty(sGDrawingElement);
                }
            }
            return bl;
        }
    }

    abstract class ElementGroupSetInLegend
    extends SGElementGroupSetInFigureElement
    implements ActionListener,
    SGIUndoable,
    SGIDataPropertyDialogObserver {
        protected Rectangle2D mDataRect = null;
        protected SGDrawingElementString2DExtended mDrawingString = null;
        protected SGProperties mTemporaryProperties = null;

        protected ElementGroupSetInLegend() {
        }

        private boolean isVisibleTotally() {
            return this.isVisible() & this.isVisibleInLegend();
        }

        private boolean createStringElement() {
            String string = this.mName;
            SGDrawingElementString2DExtended sGDrawingElementString2DExtended = new SGDrawingElementString2DExtended(string, SGLegendElement.this.mFontName, SGLegendElement.this.mFontStyle, SGLegendElement.this.mFontSize);
            sGDrawingElementString2DExtended.setColor(SGLegendElement.this.mStringColor);
            sGDrawingElementString2DExtended.setMagnification(this.mMagnification);
            this.mDrawingString = sGDrawingElementString2DExtended;
            return true;
        }

        private boolean paintString(Graphics2D graphics2D) {
            if (this.mDrawingString != null) {
                this.mDrawingString.paintElement(graphics2D);
            }
            return true;
        }

        private SGDrawingElementString2D getStringElement() {
            return this.mDrawingString;
        }

        private Rectangle2D getStringBounds() {
            if (this.mDrawingString == null) {
                return null;
            }
            Rectangle2D rectangle2D = this.getStringElement().getElementBounds();
            return rectangle2D;
        }

        private Rectangle2D getRect() {
            return this.mDataRect;
        }

        private void setRect(Rectangle2D rectangle2D) {
            this.mDataRect = rectangle2D;
        }

        public float getMaxDataElementWidth() {
            float f = 0.0f;
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ILegendElement iLegendElement = (ILegendElement)arrayList.get(i);
                float f2 = iLegendElement.getPreferredWidth();
                if (!(f2 > f)) continue;
                f = f2;
            }
            return f;
        }

        public double getMaxDataElementHeight() {
            double d = 0.0;
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ILegendElement iLegendElement;
                double d2;
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup.isVisible() || !((d2 = (double)(iLegendElement = (ILegendElement)arrayList.get(i)).getPreferredHeight()) > d)) continue;
                d = d2;
            }
            return d;
        }

        void setDrawingElementBounds(Rectangle2D rectangle2D) {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup.isVisible()) continue;
                ILegendElement iLegendElement = (ILegendElement)arrayList.get(i);
                iLegendElement.setDataElementBounds(rectangle2D);
            }
        }

        private boolean createDrawingElement() {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ILegendElement iLegendElement = (ILegendElement)arrayList.get(i);
                iLegendElement.createDrawingElementInLegend();
            }
            return true;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            ElementGroupSymbol elementGroupSymbol;
            ElementGroupLine elementGroupLine;
            ElementGroupErrorBar elementGroupErrorBar;
            graphics2D.setPaint(SGLegendElement.this.mStringColor);
            this.paintString(graphics2D);
            ElementGroupBar elementGroupBar = SGLegendElement.this.getGroupBar(this);
            if (elementGroupBar != null && elementGroupBar.isVisible()) {
                elementGroupBar.paintElement(graphics2D);
            }
            if ((elementGroupErrorBar = SGLegendElement.this.getGroupErrorBar(this)) != null && elementGroupErrorBar.isVisible()) {
                elementGroupErrorBar.paintElement(graphics2D);
            }
            if ((elementGroupLine = SGLegendElement.this.getGroupLine(this)) != null && elementGroupLine.isVisible()) {
                elementGroupLine.paintElement(graphics2D);
            }
            if ((elementGroupSymbol = SGLegendElement.this.getGroupSymbol(this)) != null && elementGroupSymbol.isVisible()) {
                elementGroupSymbol.paintElement(graphics2D);
            }
        }

        protected abstract boolean onMouseClicked(MouseEvent var1);

        boolean addDrawingElementGroup(SGElementGroup sGElementGroup) {
            sGElementGroup.mGroupSet = this;
            ILegendElement iLegendElement = (ILegendElement)((Object)sGElementGroup);
            sGElementGroup.initDrawingElement(iLegendElement.getNumberOfPoints());
            if (!sGElementGroup.setPropertiesOfDrawingElements()) {
                return false;
            }
            sGElementGroup.setMagnification(this.mMagnification);
            this.mDrawingElementGroupList.add(sGElementGroup);
            return true;
        }

        abstract boolean synchronizeDrawingElements(ArrayList var1);

        public String getTagName() {
            return "";
        }

        public boolean writeProperty(Element element) {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            SGLegendElement.this.createAllDrawingElements();
            SGLegendElement.this.notifyChange();
        }

        public SGProperties getProperties() {
            ElementGroupSetInLegendProperties elementGroupSetInLegendProperties = new ElementGroupSetInLegendProperties();
            if (!this.getProperties(elementGroupSetInLegendProperties)) {
                return null;
            }
            return elementGroupSetInLegendProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetInLegendProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            ElementGroupSetInLegendProperties elementGroupSetInLegendProperties = (ElementGroupSetInLegendProperties)sGProperties;
            SGIAxisElement sGIAxisElement = SGLegendElement.this.mAxisElement;
            elementGroupSetInLegendProperties.xAxis = sGIAxisElement.getConfigurationInCube(this.getXAxis());
            elementGroupSetInLegendProperties.yAxis = sGIAxisElement.getConfigurationInCube(this.getYAxis());
            elementGroupSetInLegendProperties.zAxis = sGIAxisElement.getConfigurationInCube(this.getZAxis());
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ElementGroupSetInLegendProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            ElementGroupSetInLegendProperties elementGroupSetInLegendProperties = (ElementGroupSetInLegendProperties)sGProperties;
            SGIAxisElement sGIAxisElement = SGLegendElement.this.mAxisElement;
            this.setXAxis(sGIAxisElement.getAxisInCube(elementGroupSetInLegendProperties.xAxis));
            this.setYAxis(sGIAxisElement.getAxisInCube(elementGroupSetInLegendProperties.yAxis));
            this.setZAxis(sGIAxisElement.getAxisInCube(elementGroupSetInLegendProperties.zAxis));
            return true;
        }

        public boolean setMementoBackward() {
            if (!super.setMementoBackward()) {
                return false;
            }
            SGLegendElement.this.createAllDrawingElements();
            SGLegendElement.this.notifyChange();
            return true;
        }

        public boolean setMementoForward() {
            if (!super.setMementoForward()) {
                return false;
            }
            SGLegendElement.this.createAllDrawingElements();
            SGLegendElement.this.notifyChange();
            return true;
        }

        public void notifyToRoot() {
            SGLegendElement.this.notifyToRoot();
        }

        class ElementGroupSetInLegendProperties
        extends SGElementGroupSetInFigureElement.ElementGroupSetPropertiesInFigureElement {
            int xAxis;
            int yAxis;
            int zAxis;

            ElementGroupSetInLegendProperties() {
            }

            public boolean equals(Object object) {
                if (!(object instanceof ElementGroupSetInLegendProperties)) {
                    return false;
                }
                ElementGroupSetInLegendProperties elementGroupSetInLegendProperties = (ElementGroupSetInLegendProperties)object;
                if (!super.equals(object)) {
                    return false;
                }
                if (elementGroupSetInLegendProperties.xAxis != this.xAxis) {
                    return false;
                }
                if (elementGroupSetInLegendProperties.yAxis != this.yAxis) {
                    return false;
                }
                return elementGroupSetInLegendProperties.zAxis == this.zAxis;
            }
        }
    }

    static interface ILegendElement {
        public float getPreferredWidth();

        public float getPreferredHeight();

        public void setDataElementBounds(Rectangle2D var1);

        public boolean createDrawingElementInLegend();

        public int getNumberOfPoints();
    }
}

