
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.util.ArrayList;

/**
 * A wrapper class of Component.
 *
 */
public class SGComponentGroupElement implements SGIDisposable
{

	// A component.
	private Component mComponent;


	// The list of component group.
	private ArrayList mComponentGroupList = new ArrayList();


	/**
	 * Construct this object with an instance of Component class.
	 * @param com - Component to be set
	 */
	public SGComponentGroupElement( Component com )
	{
		this.mComponent = com;
	}


	/**
	 * Add a component group to this object.
	 * @param group - a group to be added
	 */
	public void addComponentGroup( SGComponentGroup group )
	{
		this.mComponentGroupList.add( group );
	}


	/**
	 * Set the component enabled.
	 * Only when all component groups this instance holds are enabled,
	 * the component is set enabled.
	 * @param b - enable flag
	 */
	public void setEnabled( final boolean b )
	{
		boolean flag = b;
		ArrayList list = this.mComponentGroupList;
		for( int ii=0; ii<list.size(); ii++ )
		{
			SGComponentGroup group = (SGComponentGroup)list.get(ii);
			flag &= group.isEnabled();
		}

		this.mComponent.setEnabled(flag);
	}


	/**
	 * Returns a Component object.
	 * @return a Component for this object
	 */
	public Component getComponent()
	{
		return this.mComponent;
	}


	/**
	 * 
	 *
	 */
	public void dispose()
	{
		this.mComponent = null;
		if( this.mComponentGroupList!=null )
		{
			this.mComponentGroupList.clear();
			this.mComponentGroupList = null;
		}
	}
}

