
package jp.riken.brain.ni.samuraigraph.base;

import java.util.ArrayList;

import javax.swing.ButtonGroup;
import javax.swing.JToggleButton;


/**
 *
 * @author  kuromaru
 */
public class SGSingleAxisSelectionPanel extends SGAxisSelectionPanel
{

	// The radio button with no selection.
	private JToggleButton mNoAxisSelectionButton = new JToggleButton();


	/**
	 * The default constructor.
	 */
    public SGSingleAxisSelectionPanel()
    {
    	super();
        this.initProperty();
    }

    
	private void initProperty()
	{
		// add to a ButtonGroup
		ButtonGroup bg = new ButtonGroup();
		bg.add( this.mTopButton );
		bg.add( this.mBottomButton );
		bg.add( this.mLeftButton );
		bg.add( this.mRightButton );
		bg.add( this.mNoAxisSelectionButton );

		// add to a controller
		this.mController.add( this.mTopLine );
		this.mController.add( this.mBottomLine );
		this.mController.add( this.mLeftLine );
		this.mController.add( this.mRightLine );
	}

	private SGExclusiveAccessController mController = new SGExclusiveAccessController();


	protected void updateImage()
	{
		this.mAxisImagePanel.setTopSelected( this.isTopSelected() );
		this.mAxisImagePanel.setBottomSelected( this.isBottomSelected() );
		this.mAxisImagePanel.setLeftSelected( this.isLeftSelected() );
		this.mAxisImagePanel.setRightSelected( this.isRightSelected() );
		this.repaint();
	}


	protected void updateButtons()
	{
		final boolean top = this.isTopSelected();
		final boolean bottom = this.isBottomSelected();
		final boolean left = this.isLeftSelected();
		final boolean right = this.isRightSelected();
		if( top | bottom | left | right )
		{
			this.mTopButton.setSelected( top );
			this.mBottomButton.setSelected( bottom );
			this.mLeftButton.setSelected( left );
			this.mRightButton.setSelected( right );
		}
		else
		{
			this.mNoAxisSelectionButton.setSelected(true);
		}
	}


	/**
	 * 
	 * @return
	 */
	public int getAxisConfiguration()
	{
		int config = -1;
		if( this.mNoAxisSelectionButton.isSelected() == false )
		{
			if( this.isTopSelected() )
			{
				config = SGIAxisElement.AXIS_HORIZONTAL_2;
			}
			else if( this.isBottomSelected() )
			{
				config = SGIAxisElement.AXIS_HORIZONTAL_1;
			}
			else if( this.isLeftSelected() )
			{
				config = SGIAxisElement.AXIS_PERPENDICULAR_1;
			}
			else if( this.isRightSelected() )
			{
				config = SGIAxisElement.AXIS_PERPENDICULAR_2;
			}
		}

		return config;
	}



	/**
	 * 
	 * @param holderList
	 * @return
	 */
	public boolean setSelected( ArrayList holderList )
	{
		final int num = holderList.size();
		if( num==0 )
		{
			return false;
		}

		ArrayList axisList = new ArrayList( num );
		for( int ii=0; ii<num; ii++ )
		{
			SGISingleAxisHolder l
				= (SGISingleAxisHolder)holderList.get(ii);
			axisList.add( new Integer( l.getAxisConfiguration() ) );
		}

		Integer axis0 = (Integer)axisList.get(0);
		Integer axis = axis0;

		if( num>1 )
		{
			for( int ii=1; ii<num; ii++ )
			{
				Integer axis1 = (Integer)axisList.get(ii);
				if( axis0.equals(axis1)==false )
				{
					axis = null;
					break;
				}
			}
		}


		// set selected button
		this.clearAll();
		if( axis!=null )
		{
			this.setSelected( axis.intValue() );
		}

		// update components and image
		this.updateButtons();
		this.updateImage();

		return true;
	}



	// set selected buttons with given configuration
	private boolean setSelected( final int config )
	{

		switch( config )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				this.setBottomSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				this.setTopSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_PERPENDICULAR_1 :
			{
				this.setLeftSelected(true);
				break;
			}

			case SGIAxisElement.AXIS_PERPENDICULAR_2 :
			{
				this.setRightSelected(true);
				break;
			}
						
			default :
			{
				throw new IllegalArgumentException("");
			}
		}

		return true;
	}


	/**
	 * Set the given line to be selected.
	 */
	protected void selectLine( Line l )
	{
		this.mController.select(l);
	}

}


