/*
 * 쐬: 2004/09/25
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;


/**
 * 
 * @author LANDAU
 *
 * ̐ꂽRg̑}ev[gύX邽
 * EBhE > ݒ > Java > R[h > R[hƃRg
 */
public abstract class SGAxisBreakSymbol extends SGDrawingElement
	implements SGIAxisBreakSymbolConstants, SGIDrawingElementConstants
{



	/**
	 * 
	 */
	protected SGTuple2f mLocation = new SGTuple2f();

	
	/**
	 * 
	 */
	protected float mLength;


	/**
	 * 
	 */
	protected float mInterval;


	/**
	 * 
	 */
	protected float mLineWidth;


	/**
	 * 
	 */
	protected float mAngle;


	/**
	 * Value in the range [-1,1]
	 */
	protected float mDistortion;


	/**
	 * 
	 */	
	protected Color mLineColor;


	/**
	 * 
	 */
	protected boolean mForHorizontalAxisFlag;


	/**
	 * 
	 *
	 */
	public SGAxisBreakSymbol()
	{
		super();
	}


	/**
	 * 
	 */
	protected SGAxisBreakSymbol(
		final float length,
		final float interval,
		final float dist,
		final float angle,
		final boolean horizontal )
	{
		this.setLength(length);
		this.setInterval(interval);
		this.setDistortion(dist);
		this.setAngle(angle);
		this.setForHorizontalAxisFlag(horizontal);
	}


	/**
	 * 
	 */
	public void dispose()
	{
		super.dispose();
		this.mLineColor = null;
		this.mLocation = null;
	}


	/**
	 * 
	 * @return
	 */
	public SGTuple2f getLocation()
	{
		return this.mLocation;
	}


	/**
	 *
	 */
	public float getX()
	{
		return this.getLocation().x;
	}


	/**
	 *
	 */
	public float getY()
	{
		return this.getLocation().y;
	}


	/**
	 * 
	 * @return
	 */
	public float getLength()
	{
		return this.mLength;
	}


	/**
	 * 
	 * @return
	 */
	public float getInterval()
	{
		return this.mInterval;
	}


	/**
	 * 
	 * @return
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}


	/**
	 * 
	 * @return
	 */
	public float getAngle()
	{
		return this.mAngle;
	}


	/**
	 * 
	 * @return
	 */
	public float getDistortion()
	{
		return this.mDistortion;
	}


	/**
	 * 
	 * @return
	 */
	public Color getLineColor()
	{
		return this.mLineColor;
	}


	/**
	 * 
	 * @return
	 */
	public boolean isForHorizontalAxis()
	{
		return this.mForHorizontalAxisFlag;
	}



	/**
	 * 
	 * @param x
	 * @param y
	 */
	public void setLocation( final float x, final float y )
	{
		this.mLocation.setValues(x,y);
	}


	/**
	 * 
	 * @param pos
	 */
	public void setLocation( final SGTuple2f pos )
	{
		this.mLocation = pos;
	}



	/**
	 * 
	 * @param value
	 */
	public void setLength( final float value )
	{
		if( value<0.0f )
		{
			new IllegalArgumentException("value<0.0f");
		}
		this.mLength = value;
	}


	/**
	 * 
	 * @param value
	 */
	public void setInterval( final float value )
	{
		if( value<0.0f )
		{
			new IllegalArgumentException("value<0.0f");
		}
		this.mInterval = value;
	}


	/**
	 * 
	 * @param value
	 */
	public void setLineWidth( final float value )
	{
		if( value<0.0f )
		{
			new IllegalArgumentException("value<0.0f");
		}
		this.mLineWidth = value;
	}





	/**
	 * 
	 * @param angle
	 */
	public void setAngle( final float angle )
	{
		float a = angle;
		if( a<-ANGLE_ABS_MAX )
		{
			a = - ANGLE_ABS_MAX;
		}
		if( ANGLE_ABS_MAX<a )
		{
			a = ANGLE_ABS_MAX;
		}

		this.mAngle = a;
	}


	/**
	 * 
	 * @param value
	 */	
	public void setDistortion( final float value )
	{
		this.mDistortion = value;
	}


	/**
	 * 
	 * @param color
	 */
	public void setLineColor( final Color color )
	{
		if( color==null )
		{
			new IllegalArgumentException("color==null");
		}
		this.mLineColor = color;
	}


	/**
	 * 
	 * @param flag
	 */
	public void setForHorizontalAxisFlag( final boolean flag )
	{
		this.mForHorizontalAxisFlag = flag;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		
		if( ( element instanceof SGAxisBreakSymbol ) == false ) return false;

		super.setProperty( element );
		
		SGAxisBreakSymbol abs = (SGAxisBreakSymbol)element;

		this.setLength( abs.getLength() );
		this.setInterval( abs.getInterval() );
		this.setDistortion( abs.getDistortion() );
		this.setAngle( abs.getAngle() );
		this.setForHorizontalAxisFlag( abs.isForHorizontalAxis() );
		this.setLineWidth( abs.getLineWidth() );
		this.setLineColor( abs.getLineColor() );

		return true;
	}



	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{

		if( ( p instanceof AxisBreakSymbolProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		AxisBreakSymbolProperties ap = (AxisBreakSymbolProperties)p;

		final Float len = ap.getLength();
		if( len==null )
		{
			return false;
		}
		this.mLength = len.floatValue();
		
		
		final Float interval = ap.getInterval();
		if( interval==null )
		{
			return false;
		}
		this.mInterval = interval.floatValue();
		
		
		final Float dist = ap.getDistortion();
		if( dist==null )
		{
			return false;
		}
		this.mDistortion = dist.floatValue();


		final Float angle = ap.getAngle();
		if( angle==null )
		{
			return false;
		}
		this.mAngle = angle.floatValue();


		final Boolean horizontal = ap.isHorizontal();
		if( horizontal==null )
		{
			return false;
		}
		this.mForHorizontalAxisFlag = horizontal.booleanValue();


		final Float lw = ap.getLineWidth();
		if( lw==null )
		{
			return false;
		}
		this.mLineWidth = lw.floatValue();
		
		
		final Color lc = ap.getLineColor();
		if( lc==null )
		{
			return false;
		}
		this.mLineColor = lc;


		return true;

	}



	/**
	 * 
	 * @return
	 */
	public SGProperties getProperties()
	{
		final AxisBreakSymbolProperties p = new AxisBreakSymbolProperties();
		if( this.getProperties(p) == false )
		{
			return null;
		}
		return p;
	}


	/**
	 * 
	 * @param p
	 * @return
	 */
	public boolean getProperties( final SGProperties p )
	{
		if( ( p instanceof AxisBreakSymbolProperties ) == false )
		{
			return false;
		}

		if( super.getProperties(p) == false )
		{
			return false;
		}

		final AxisBreakSymbolProperties dp = (AxisBreakSymbolProperties)p;
		dp.setLength( this.mLength );
		dp.setInterval( this.mInterval );
		dp.setDistortion( this.mDistortion );
		dp.setAngle( this.mAngle );
		dp.setHorizontal( this.mForHorizontalAxisFlag );
		dp.setLineWidth( this.mLineWidth );
		dp.setLineColor( this.mLineColor );

		return true;
	}




	/**
	 * Property of Axis Break Symbol.
	 */
	public static class AxisBreakSymbolProperties extends SGDrawingElement.DrawingElementProperties
	{

		private float mX = 0.0f;
		private float mY = 0.0f;
		private float mLength = 0.0f;
		private float mInterval = 0.0f;
		private float mDistortion = 0.0f;
		private float mAngle = 0.0f;
		private float mLineWidth = 0.0f;
		private Color mLineColor = null;
		private boolean mHorizontal = true;


		/**
		 * 
		 */
		public AxisBreakSymbolProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof AxisBreakSymbolProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			AxisBreakSymbolProperties p = (AxisBreakSymbolProperties)obj;
			if( this.mX!=p.mX ) return false;
			if( this.mY!=p.mY ) return false;
			if( this.mLength!=p.mLength ) return false;
			if( this.mInterval!=p.mInterval ) return false;
			if( this.mDistortion!=p.mDistortion ) return false;
			if( this.mAngle!=p.mAngle ) return false;
			if( this.mLineWidth!=p.mLineWidth ) return false;
			if( this.mLineColor.equals(p.mLineColor) == false ) return false;
			if( this.mHorizontal!=p.mHorizontal ) return false;

			return true;
		}


		public Float getX()
		{
			return new Float( this.mX );
		}

		public Float getY()
		{
			return new Float( this.mY );
		}

		public Float getLength()
		{
			return new Float( this.mLength );
		}

		public Float getInterval()
		{
			return new Float( this.mInterval );
		}

		public Float getDistortion()
		{
			return new Float( this.mDistortion );
		}

		public Float getAngle()
		{
			return new Float( this.mAngle );
		}

		public Boolean isHorizontal()
		{
			return Boolean.valueOf( this.mHorizontal );
		}

		public Float getLineWidth()
		{
			return new Float( this.mLineWidth );
		}

		public Color getLineColor()
		{
			return this.mLineColor;
		}


		public boolean setX( final float x )
		{
			this.mX = x;
			return true;
		}

		public boolean setY( final float y )
		{
			this.mY = y;
			return true;
		}

		public boolean setLength( final float value )
		{
			if( value<0.0f )
			{
				new IllegalArgumentException("value<0.0f");
			}
			this.mLength = value;
			return true;
		}

		public boolean setInterval( final float value )
		{
			if( value<0.0f )
			{
				new IllegalArgumentException("value<0.0f");
			}
			this.mInterval = value;
			return true;
		}

		public boolean setDistortion( final float value )
		{
			if( value<0.0f )
			{
				new IllegalArgumentException("value<0.0f");
			}
			this.mDistortion = value;
			return true;
		}

		public boolean setAngle( final float value )
		{
			if( value<0.0f )
			{
				new IllegalArgumentException("value<0.0f");
			}
			this.mAngle = value;
			return true;
		}

		public boolean setHorizontal( final boolean b )
		{
			this.mHorizontal = b;
			return true;
		}

		public boolean setLineWidth( final float value )
		{
			if( value<0.0f )
			{
				new IllegalArgumentException("value<0.0f");
			}
			this.mLineWidth = value;
			return true;
		}

		public boolean setLineColor( final Color cl )
		{
			if( cl==null )
			{
				new IllegalArgumentException("cl==null");
			}
			String str = SGUtilityText.getColorString(cl);
			if( str==null )
			{
				new IllegalArgumentException("str==null");
			}
			this.mLineColor = cl;
			return true;
		}

	}



}
